default GameManager = GameManagerClass()

init 0 python:

    def getWeekdays():
        return ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]

    def getDaytimes():
        return ["Morning", "Midday", "Afternoon", "Evening", "Night"]

    class GameManagerClass:

        def __init__(self, start_weekday_index = 2, start_daytime_index = 0):
            self.current_weekday_index = start_weekday_index
            self.current_daytime_index = start_daytime_index

        ### 
        ### Unset all dynamic bubble layouts
        def unset_bubbles_layouts(self):
            delete_layouts = []
            for image_tag, layout in dynamic_bubble.dynamic_properties.items():
                delete_layouts.append(CharactersManager.getCharacterClassByName(image_tag, 'SceneInfo'))

            for characterSceneInfo in delete_layouts:
                characterSceneInfo.unset_bubble_layout()

            # just to be sure all is reset
            unset_all_dynamic_bubbles()

        def getTimeString(self):
            return self.getWeekdayName() + " - " + self.getDaytimeName()

        def getWeekdayName(self, weekday_index = None):
            if weekday_index == None:
                weekday_index = self.current_weekday_index
            weekdays = getWeekdays()
            return weekdays[weekday_index]

        def getDaytimeName(self, daytime_index = None):
            if daytime_index == None:
                daytime_index = self.current_daytime_index
            daytimes = getDaytimes()
            return daytimes[daytime_index]

        def next_daytime(self):
            if self.current_daytime_index == 4:
                self.current_daytime_index = 0
            else:
                self.current_daytime_index += 1

            # reduce annoyances
            dadCorruption.set_annoyance_change(-1)
            dadCorruption.change_value()

            diegoCorruption.set_annoyance_change(-1)
            diegoCorruption.change_value()