init -1:
    ## Bubble layouts
    define allowed_sprite_position_left = 'left'        # mostly ethan
    define allowed_sprite_position_farleft = 'farleft'  
    define allowed_sprite_position_middle = 'middleleft'
    define allowed_sprite_position_farright = 'farright'  # default for single NPC
    define allowed_sprite_position_farright_toleft = 'farrighttoleft' # TODO FREDENC-138
    define allowed_sprite_position_right = 'right'   # for a secound NPC

    define bubble_properties_bottomleft = 'bottom_left'
    define bubble_properties_bottomright = 'bottom_right'
    define bubble_properties_topleft = 'top_left'
    define bubble_properties_topright = 'top_right'
    define bubble_properties_thought = 'thought'
    define allowed_bubble_properties = [bubble_properties_bottomleft, bubble_properties_bottomright, bubble_properties_topleft, bubble_properties_topright, bubble_properties_thought]


init python:
    class CharacterBubbleSettingClass:
        def __init__(self, charid):
            self.charid = charid
            self.bubble_layout = None # for the currently set bubble layout

        def set_bubble_layout_by_position(self, position=allowed_sprite_position_left, style='default', properties=False, dx=0, dy=0):
            '''
                dx, dy - offset!
            '''
            character_class = CharactersManager.getCharacterClassByName(self.charid)
            used_bubble_layout = bubbles_layout(position, style, properties, dx, dy)
            self.set_bubble_layout(used_bubble_layout)

        def set_bubble_layout(self, defined_layout):
            if config.developer:
                assert isinstance(defined_layout, dict), "entry must be a dictionary"

                # area prüfen
                assert "area" in defined_layout, "defined_layout must have key 'area'"
                assert isinstance(defined_layout["area"], list), "'area' must be a list"
                assert len(defined_layout["area"]) == 4, "'area' must contain exactly 4 values"
                assert all(isinstance(v, int) for v in defined_layout["area"]), "all values in 'area' must be integers"

                # properties prüfen
                assert "properties" in defined_layout, "defined_layout must have key 'properties'"
                assert defined_layout["properties"] in allowed_bubble_properties, (
                    f"'properties' must be one of bottom_left, bottom_right, top_left, top_right, thought, not {defined_layout['properties']}"
                )
            character_class = CharactersManager.getCharacterClassByName(self.charid)
            self.bubble_layout = defined_layout
            set_dynamic_bubble(character_class, defined_layout)

        ### 
        ### Toggle the current bubble layout: if it's thinking turn it back to speacking and vice versa
        ### if no current bubble layout is set it throws an error
        def toggle_thinking(self):
            if config.developer:
                assert isinstance(self.bubble_layout, dict), "The bubble layout needs to be set before toggle_thinking can be used"

            character_class = CharactersManager.getCharacterClassByName(self.charid)
            used_bubble_layout = self.bubble_layout

            if used_bubble_layout.get('properties_old', None):
                used_bubble_layout['properties'] = used_bubble_layout.get('properties_old', None)
                del(used_bubble_layout['properties_old'])
            else:
                old_properties = used_bubble_layout.get('properties', None)
                used_bubble_layout.update({'properties_old' : old_properties})
                used_bubble_layout['properties'] = bubble_properties_thought

            self.bubble_layout = used_bubble_layout
            set_dynamic_bubble(character_class, self.bubble_layout)


        def unset_bubble_layout(self):
            self.bubble_layout = None
            character_class = CharactersManager.getCharacterClassByName(self.charid)
            unset_dynamic_bubble(character_class)


    def bubbles_layout(position, style='default', properties=False, dx=0, dy=0):
        '''
            dx, dy - offset!
        '''
        layouts = {
            allowed_sprite_position_left: {
                'default': {
                    "area": [
                        400,
                        45,
                        560,
                        225
                    ],
                    "properties": bubble_properties_bottomleft
                },
                'large': {
                    "area": [
                        400,
                        0,
                        640,
                        315
                    ],
                    "properties": bubble_properties_bottomleft
                }
            },
            allowed_sprite_position_farleft: {
                'default': {
                    "area": [
                        100,
                        45,
                        560,
                        225
                    ],
                    "properties": bubble_properties_bottomleft
                },
                'large': {
                    "area": [
                        400,
                        0,
                        640,
                        315
                    ],
                    "properties": bubble_properties_bottomleft
                }
            },
            allowed_sprite_position_middle: {
                'default': {
                    "area": [
                        600,
                        45,
                        560,
                        225
                    ],
                    "properties": bubble_properties_bottomleft
                },
                'large': {
                    "area": [
                        600,
                        0,
                        640,
                        315
                    ],
                    "properties": bubble_properties_bottomleft
                }
            },
            allowed_sprite_position_farright: {
                'default': {
                    "area": [
                        1060,
                        45,
                        560,
                        225
                    ],
                    "properties": bubble_properties_bottomright
                },
                'large': {
                    "area": [
                        880,
                        0,
                        640,
                        315
                    ],
                    "properties": bubble_properties_bottomright
                }
            },
            allowed_sprite_position_farright_toleft: {
                'default': {
                    "area": [
                        1300,
                        45,
                        560,
                        225
                    ],
                    "properties": bubble_properties_bottomleft
                },
                'large': {
                    "area": [
                        980,
                        0,
                        640,
                        315
                    ],
                    "properties": bubble_properties_bottomleft
                }
            },
            allowed_sprite_position_right: {
                'default': {
                    "area": [
                        560,
                        45,
                        560,
                        225
                    ],
                    "properties": "bottom_right"
                },
                'large': {
                    "area": [
                        480,
                        0,
                        640,
                        315
                    ],
                    "properties": "bottom_right"
                }
            }
        }

        if config.developer == True:
            assert isinstance(style, str), "style needs to be a string"
            assert (style in ['default', 'large']), style + " is not an existing style"
            assert isinstance(dx, int), "dx needs to be an integer"
            assert isinstance(dy, int), "dy needs to be an integer"
            
            if properties:
                assert isinstance(properties, str), "properties needs to be a string"
                assert (properties in allowed_bubble_properties), properties + " is not an allowed properties value"

        if layouts[position][style]:
            layout = layouts[position][style]
            area = layout["area"][:]

            # Offset anwenden
            area[0] += dx  # x verschieben
            area[1] += dy  # y verschieben
            layout["area"] = area

            if properties:
                layout['properties'] = properties

            return layout
        else:
            return None