define show_debug = True

init -500 python:
    import datetime
    import os

    def logevent(event_description):
        log_path = os.path.join(config.basedir, "customlog.txt")  # Log-Datei im Hauptverzeichnis des Spiels

        with open(log_path, "a", encoding="utf-8") as log_file:
            log_file.write(f"{datetime.datetime.now()} - {event_description}\n")

    # If an object doesn't have an attribute add it set to value.
    #
    # obj       - the object
    # attrName  - the attribute name to check
    # value     - the value if the attribute is not known
    #
    def condAddAttr(obj, attrName, value):
        if not hasattr(obj, attrName):
            setattr(obj, attrName, value)

