﻿init python:

    config.has_autosave = False
    config.has_quicksave = False
    config.autosave_on_quit = False
    config.autosave_on_choice = False

define menu = nvl_menu

    # The color of a menu choice when it isn't hovered.
    #style.nvl_menu_choice.idle_color = "#ccccccff"

    # The color of a menu choice when it is hovered.
    #style.nvl_menu_choice.hover_color = "#ffffffff"

    # The color of the background of a menu choice, when it isn't
    # hovered.
    #style.nvl_menu_choice_button.idle_background = "#00000000"

#what_outlines=[(3, "#ffffff",0,0)]
#what_outlines= [(3, "#ffffff", 0, 0)]

define S = Character("You", color='#ffffff', what_prefix='"', what_suffix='"')
define A = Character("Artemis", color='#ffffff', what_prefix='"', what_suffix='"')

#Prisoners
define GP = Character("Gruff Prisoner", color='#ffffff', what_prefix='"', what_suffix='"')
define CP = Character("Chatty Prisoner", color='#ffffff', what_prefix='"', what_suffix='"')
define IP = Character("Idle Prisoner", color='#ffffff', what_prefix='"', what_suffix='"')
define PP = Character("Puny Prisoner", color='#ffffff', what_prefix='"', what_suffix='"')
define QP = Character("Quiet Prisoner", color='#ffffff', what_prefix='"', what_suffix='"')

#Wardens
define W = Character("Warden", color='#ffffff', what_prefix='"', what_suffix='"')
#Officers
define CO = Character("Cheerful Officer", color='#ffffff', what_prefix='"', what_suffix='"')
define DO = Character("Droning Officer", color='#ffffff', what_prefix='"', what_suffix='"')
define SO = Character("Serious Officer", color='#ffffff', what_prefix='"', what_suffix='"')

#nurse
define N = Character("Prison Nurse", color='#ffffff', what_prefix='"', what_suffix='"')

#others
define R = Character("Television Reporter", color='#ffffff', what_prefix='"', what_suffix='"')
define G = Character("Governor", color='#ffffff', what_prefix='"', what_suffix='"')
define F = Character("Family Member", color='#ffffff', what_prefix='"', what_suffix='"')
define H = Character("Tense Actor", color='#ffffff', what_prefix='"', what_suffix='"')
define E = Character("Curt Actor", color='#ffffff', what_prefix='"', what_suffix='"')

#NVL
define n = Character("", kind=nvl, color='#000000')
define S2 = Character("You", kind=nvl, color='#ffffff')
define A3 = Character("Artemis", kind=nvl, color='#ffffff')

image white = "#ffffff"

define flash = Fade(0.5, 0.1, 0.5, color="#FFFFFF")

transform artemiscentre:
    xalign 0.5 yalign -0.06 zoom 0.35

transform prisonerleft:
    yalign 0.0

transform prisonerright:
    yalign 0.0

transform wardencentre:
    xalign 0.5 yalign 0.0 zoom 0.4

transform bounceup:
    easein 0.2 yoffset -10
    easein 0.2 yoffset 0

transform bounceuplong:
    easein 0.2 yoffset -10
    easein 0.2 yoffset 0
    easein 0.2 yoffset -8
    easein 0.2 yoffset 0

transform bounceupbig:
    easein 0.2 yoffset -15
    easein 0.2 yoffset 0

transform bouncedown:
    easein 0.2 yoffset 10
    easein 0.2 yoffset 0

transform bouncedownlong:
    easein 0.2 yoffset 10
    easein 0.2 yoffset 0
    easein 0.2 yoffset 8
    easein 0.2 yoffset 0

transform bouncedownbig:
    easein 0.2 yoffset 15
    easein 0.2 yoffset 0

transform sideswayleft:
    easein 0.2 xoffset 10
    easein 0.3 xoffset -10
    easein 0.2 xoffset 0

transform sideswayright:
    easein 0.2 xoffset -10
    easein 0.3 xoffset 10
    easein 0.2 xoffset 0

transform dissolve2:
    alpha 0
    linear 0.5 alpha 1

layeredimage artemis:

    group body:
        attribute body default:
            "artemis body"
        
        attribute naked:
            "body nude"

    group eye:
        attribute e1 default:
            "e1"

        attribute e2:
            "e2"

        attribute e3:
            "e3"

        attribute e4:
            "e4"

    group brows:
        attribute b1 default:
            "b1"

        attribute b2:
            "b2"

        attribute b3:
            "b3"

    group mouth:
        attribute m1 default:
            "m1"

        attribute m2:
            "m2"

        attribute m3:
            "m3"

        attribute m4:
            "m4"

        attribute m5:
            "m5"

    group blush:
        attribute nothing default:
            "nothing"
        
        attribute blush:
            "blush"
    
    group bruises:
        attribute nothing default:
            "nothing"

        attribute bruises:
            "bruises"

    group doom:
        attribute nothing default:
            "nothing"
        
        attribute bodydoom:
            "artemis body doom"

    group sweat:
        attribute nothing default:
            "nothing"

        attribute sweat:
            "sweat"

label start:
    default prisonrape = False
    default prisonassault = False
    default overhear = False
    default firsttime = False
    default meetnurse = False

    $ symp = 0
    $ perp = 0
    $ bys = 0

    stop music

    $ quick_menu = False
    scene black
    
    centered "{color=#ffffff}This game is intended for players 18 years of age and older.\nScenes may contain physical, mental, and sexual violence.\n\nPlayer discretion is advised.{/color}"

    $ quick_menu = True

    #play music "audio/Ludum Dare 30 - 05.ogg" fadein 1.0

    label scene1:
        #HOW COME THERE ARE FOUR PRISONERS HERE IN THIS CELL WHEN SWAPPING IS A PLOT POINT LATER???

        scene jail cell

        n "When you peer into the cell, your eyes gradually adjust to the darkness."

        n "As the shadows give way to a dim light, you see a tangle of bodies. Your spine tingles with the natural revulsion of walking into an illicit scene."
        
        n "In front of you huddle four men, three standing with one kneeling between them."

        n "The look on their faces ranges from shock to glee."

        menu (nvl=True):
            "Look closer.":
                nvl clear 
                n "The man in the middle catches your eye."
                n "He kneels between the other three with his mouth parted. In the dim lighting, his lips look glossy, like they're wet."
                n "Though the others have their jumpsuits on, their clothes are rumpled and clearly sporting bulges."
                n "It doesn't take a genius to figure out why."
                nvl clear
                jump scene1a
            "Look away.":
                nvl clear
                n "A glimpse is enough to know what's going on. You turn your head away from the sordid scene, made uncomfortable by their shameless natures."
                n "Surely there must be some dignity these men have held onto, if nothing else."
                n "Especially the one in the middle, with his mouth open."
                nvl clear
                jump scene1a

    label scene1a:

        show artemis bodydoom e1 b3 m1 at artemiscentre zorder 10

        show prisoner2 zorder 3:
            xzoom -1 xalign 0.5 yalign 0.27 zoom 0.45
        show prisoner1 zorder 4:
            xalign 1.0 yalign 0.27 zoom 0.35
        show prisoner4 zorder 5:
            xzoom -1 xalign 0.0 yalign 0.27 zoom 0.35

        S "What's going on here?"

        "The men turn to their leader, who glances at your uniform before speaking."

        show prisoner4 at bouncedown

        GP "Nothing, officer."

        S "Then what are you doing with him?"

        GP "We're just socializing."

        GP "Isn't that right? Tell him we're having a good time together."

        show artemis bodydoom e2 b3 m1 -blush sweat at bounceup

        "He wrenches the kneeling man upright, forcing him to stand."

        show artemis e1 b3 m1

        QP "Um..."

        GP "You know how to talk. Weren't you using your mouth just now?"

        show artemis m3

        QP "It's nothing."

        show artemis e2 m1

        QP "We're not doing anything."

        GP "See, that's what he says."

        show prisoner1 at bouncedownlong

        "There's a muffled chuckle from one of the other prisoners."
        "You ignore him, choosing to turn your eyes away from the scene. Whatever's happening, you don't need to be a part of it."

        S "It's lights out right now. As long as you don't disturb the other inmates, it's none of my business."
        
        "Before you leave, something in you gives pause. The prisoner's eyes are haunted."

        S "He's doing it willingly, right?"

        show prisoner4 at bouncedown

        GP "Of course he is. Why wouldn't he be?"

    label scene2:

        window show

        scene jail hall with fade

        "Every day at five in the morning, you get up before the sun rises."
        "You put on your work clothes and drive to the prison, down a stretch of road with no traffic."
        "When you arrive, you go through security first. Then you clock in."
        "By six, you're waking up the prisoners for breakfast."

        scene cafeteria with fade

        "Each of the inmates has a file. You've seen all sorts of criminals, every kind of crime."
        "The violence doesn't stop once they're behind bars. The way it happens just changes."
        "From breaking up petty squabbles to restraining violent assaults, what's important is to stay out of things that don't concern you."
        "Don't borrow money, use drugs, or pick fights. Stay out of the gangs and resist being bribed. Keep out of trouble and work hard, and it'll be like any other job."
        "No one grows up wanting to become a prison guard but the pay is good and the hours are solid."
        "They say this place has a way of warping anyone who steps inside, but it's how you make a living."
        #you were never good with people to begin with.
        #Since the day you started, it's become harder to trust people.

        show warden with dissolve:
            zoom 0.35 xalign 0.5 yalign -0.05

        CO "Morning."

        S "Hey."

        show warden at bounceup

        "Your shift partner yawns."

        CO "Did anyone give you trouble while you were getting them out?"

        S "No, it was as usual."

        CO "That's good. In our line of work, you take what you can get."

        scene cafeteria

        show prisoner3 zorder 20:
            xalign 0.9 yalign -0.5 zoom 0.275
        show prisoner2 zorder 30:
            xzoom -1 xalign 0.05 yalign -0.5 zoom 0.275
        show prisonergroup zorder 10:
            xalign 0.49 yalign -1.5 zoom 0.275
        with dissolve

        "The two of you look out into the mess hall, where the prisoners are lining up for food."
        "The men file up in an orderly line, with their orange jumpsuits and white sneakers. No shoelaces, only velcro."
        "The cafeteria workers, in their masks and hairnets, spoon oatmeal and beans onto their trays."

        $ menu = renpy.display_menu

        menu:
            "From afar, it's hard to tell which is the oatmeal and which is the beans."

            "Observe them.":

                "The inmates group together, sitting at tables while they shovel food into their mouths."
                "Their meals are nothing remarkable. Barely enough to feel full, but at least one tray contains all five food groups and the full range of essential vitamins."
                "Even if none of them are fresh."
                "The staff get better meals, and you always have the option of bringing in food from outside. You don't let the prisoners see you eat, though."
                "Inmate or staff, everyone has to watch their back here. Last night proves as much."
                "At an all-men's prison, people turn to anything for release. Anything and anyone."
                "Incidents between inmates are an open secret. If you were to get upset, or even worse, traumatized, then you wouldn't be working here."
                "Stiff upper lip, everyone's got to get by somehow."

                jump scene2a
            "Talk to the officer.":

                hide prisoner3
                hide prisoner2
                hide prisonergroup

                show warden:
                    zoom 0.35 xalign 0.5 yalign -0.05
                with dissolve

                S "Any inmates in our ward getting out soon?"

                CO "Not for a while."
                CO "One guy was scheduled for a parole hearing next month, but the court's pushing it back."
                CO "No idea what'll happen to his case now."

                S "That's too bad. Can't his lawyer try to do something?"

                show warden at bounceuplong

                CO "Honey, his lawyer's some pro bono attorney who wishes he was working for a millionaire."
                CO "No one cares that much."

                S "You're right, I suppose."

                "You've heard the courts are backed up, but it's like that everywhere. There's a staffing shortage in the system, not enough funds to hire new people."
                "Too much money spent on cushy lifestyles for criminals, half the public cries. Not enough money spent on humane conditions, the other half yells back."
                "The big cases get plastered all over the news, so everyone has an opinion these days."
                "Now you have to do twelve hour shifts without overtime. Really wears on you after a while."
                #"It's true that inmates have television in their cells these days,"
                jump scene2a
    
    label scene2a:

        hide warden
        hide prisoner3
        hide prisoner2

        show prisonergroup zorder 10:
            xalign 0.49 yalign 0.0 zoom 0.5
        with dissolve

        "Laughter from a table catches your attention."

        show prisonergroup at bounceuplong

        CP "Did you hear those noises last night?"
        CP "You know, the {i}sounds{/i}."

        IP "Yeah, they're really stimulating, aren't they?"
        IP "I didn't mind adding to the sounds myself. Just me and my right hand."

        CP "He sounded like he was enjoying it too."

        show prisonergroup at bounceup

        CP "Hey, there he is. Why don't we ask him?"

        hide prisonergroup

        show artemis at artemiscentre
        with dissolve

        "The inmate from last night arrives to jeers and catcalls."
        "He sits alone, his shoulders hunched, as others call for him from across the room."

        hide artemis

        show prisoner3 zorder 20:
            xalign 0.9 yalign -0.5 zoom 0.275
        show prisoner2 zorder 30:
            xzoom -1 xalign 0.05 yalign -0.5 zoom 0.275
        show prisonergroup zorder 10:
            xalign 0.49 yalign -1.5 zoom 0.275
        with dissolve

        show prisoner2 at bounceup

        IP "Had fun last night?"

        show prisoner3 at bounceup

        CP "Let me have a piece of that next time!"

        hide prisoner3
        hide prisoner2
        hide prisonergroup

        show warden:
            zoom 0.35 xalign 0.5 yalign -0.05
        with dissolve

        CO "What are you looking at? Don't tell me you want him too."

        S "What? No."
        S "I was just curious. He was making trouble last night, but I left him to it."
        S "Who is he?"

        CO "That's Artemis."
        CO "The moment he came here, I thought to myself, {i}that one's going to be someone's prison bitch{i}."

        show warden at sideswayright

        CO "I was right. Pretty gross, don't you think?"

        "The officer leers at him from across the room. You'd expect a middle-aged woman like her to be pushed around, but her demeanour is hard."
        "Legend has it that she was once attacked by an inmate. A real violent fight, her body thrown to the ground with the wind knocked out of her."
        "Without hesitation, she got up and hit him with her baton until he stopped moving."
        "Since then, people respect her. Prisoner or staff, everyone knows she's not one to cross."

        show warden at bounceupbig

        CO "Hey, stop harassing him!"
        CO "Focus on your food, breakfast ends in five! If you don't eat, you don't get anything until lunch!"
        CO "You have work next, so you'll need the energy!"

        "Your eyes linger on the prisoners as you leave the canteen."

    label scene3:

        scene workroom

        show prisoner4:
            zoom 0.35 xalign 0.5 yalign -0.1
        with fade

        "After breakfast, the inmates are sent to work."
        #"Some, for bad behaviour, are put back in their cells. It's at least better than solitary confinement, since they're supervised the entire time, until the bars close behind them."
        "No one makes money, of course. The wages are barely enough to buy a pack of ramen at the commissary."
        "Most of the earnings go to the upkeep of the prison. Government funding alone isn't enough, so a private company stepped in."
        "At the time, some locals protested. They showed up with signs and a catchy slogan: {i}Free our prisons! Prisons should stay free!{/i}."
        "Now it's just how things are, in order to help the prisoners give back to society."

        show prisoner4 at bounceuplong

        DO "Come on, folks, these boxes won't package themselves! Get to it!"
        DO "{i}Fitzroy's Organic Juice, an orchard in every sip...{/i}"

        show prisoner4 at bouncedown

        DO "Am I right or am I right?!"

        "The deal was signed with Fitzroy Foods, allowing them to become the sole provider of prison meals. That the company was creating jobs for prisoners was just a sweetener."

        hide prisoner4

        show prisoner3 zorder 20:
            xzoom -1 xalign 0.15 yalign -0.1 zoom 0.35
        show prisoner2 zorder 30:
            xalign 0.85 yalign -0.1 zoom 0.35
        with dissolve

        "Inmates stand in rows, each one with a box in front of him. Today, they're packaging drinks."
        
        show prisoner3 at sideswayleft

        "The first inmate takes the juice and lines them up. Then he passes the bottles on to the next person, who wraps them with plastic."

        show prisoner2 at sideswayright

        "A final prisoner seals the container shut."
        "Like this, a team of three can package sixty juice boxes in an hour. A machine could do better, but that's saying the obvious."
        "No one working here will ever complain about keeping the prisoners occupied for an hour or two."

        show prisoner3 at bouncedown

        IP "Here. Watch the boxes, they're loose."

        show prisoner2 at bouncedown

        PP "Thanks."

        IP "No problem, friend."

        "You watch the inmates work, standing by the side so you don't get in the way. Though your presence is keenly felt, the men do their best to ignore you."

        show prisoner3 at bouncedown

        IP "Pass me that."

        show prisoner2 at bouncedown

        PP "Okay."

        show prisoner3 at bounceupbig

        IP "I can't take it anymore! I can't!"

        show prisoner3 at bounceuplong

        IP "Any more of this and I'll snap. They'll regret messing with me!"

        show prisoner2 at bounceup

        PP "What are you talking about?!"
        
        IP "Nothing."

        show prisoner2 at sideswayright
        
        PP "Then don't lose it on me. Jesus Christ..."
        
        #IP "Look! {i}Twelve vitamins in every sip!{/i}"
        #IP "What do we need vitamins for?! Who knows what's in there, they're trying to turn us into sheeple!"
        #IP "The commissary is full of Fitzroy products! What are we supposed to buy with our shit wages?! 
        #IP "Anything they make you drink, you have to spit it out!"
        
        #PP "Calm down!"

        PP "Just shut up and do your work, I don't want any officers coming by."
        PP "You're ruining this for the rest of us."

        IP "I'm not. Just look at {i}him{/i}."

        #let me have it then. my knees hurt i need the vitamins. but you see theyre LYING we have no other options cant you understand that?! cant you?! and staff run over to pull him away and through the door

        hide prisoner3
        hide prisoner2

        show artemis e1 b1 m1 at artemiscentre zorder 10:
            xalign 0.26
        
        show prisoner4 zorder 1:
            xalign 0.74 yalign 0.1 zoom 0.37
        with dissolve

        "The prisoner glances around the room to where Artemis is sitting. He's working slower than any other inmate."
        "An officer is leaning over him with one hand on his shoulder."

        show prisoner4 at sideswayright

        DO "See here, the bottles are out of place."
        DO "You have to put them in order so they fit. Let me do one for you."

        show artemis e3 b3 m3

        A "Okay, thanks."

        hide artemis
        hide prisoner4

        show prisoner3 zorder 20:
            xzoom -1 xalign 0.15 yalign -0.1 zoom 0.35
        show prisoner2 zorder 30:
            xalign 0.85 yalign -0.1 zoom 0.35
        with dissolve

        "You stand there, baton in hand, feeling useless and irritable. With nothing better to do, you turn to the chatty prisoners and glare."

        show prisoner3 at bounceup
        show prisoner2 at bounceup

        S "No talking! Eyes on your work."
        S "I'll watch to make sure you're doing it properly."

        "They look down at the boxes with matching expressions of discontent before their hands start moving again."
        "You don't let it deter you. If you don't monitor the inmates properly, you'll be the one written up."

    label scene3a:
        scene jail hall

        n "That night, the prisoners settle into their cells. As you close the iron bars behind them, you get a glimpse of their quarters."
        n "There's not much to look at. Only the bunk, the sink, and the toilet. Sometimes a writing desk for the lucky few with a larger room."
        n "No walls, no rooms. With each cell holding two men, there's no privacy inside or outside. There will always be someone to witness their lowest moments, how far a person can fall."
        n "It's no wonder they run Scared Straight programs for the kids to see."
        n "{i}Don't be bad or you'll end up like them.{/i} Many a child has gone back to the straight and narrow from the sight."
        n "Then there are people like the superintendant, who is your boss' boss. He likes to tell people how he decided to work here because of a Scared Straight trip in sixth grade."
        n "\"I just knew,\" he once said, \"that someone had to help them. It might as well be me.\""

        nvl clear
        
        n "\"Hello? Hello, hello, anyone out there?\""
        n "{i}Clang! Clang... Clang... Thump...{/i}"

        n "The prison is loud at night. There's always someone screaming, as if they're suffering from night terrors. Then there are the banging noises, the footsteps, the radio, and strange sounds you can't explain."

        n "\"Shut the fuck up!\""
        n "\"You shut the fuck up! I'll kill you!\""
        n "\"Today on Channel 9, a five-year old crashed his mom's car while taking it on a joyride, but not before driving a full eighty kilometres...\""
        n "{i}Clang... Thump! Thump... Clang! Thump...{/i}"
        n "\"I said, hurry up and do it!\""
        n "\"Oh, yes... Keep going...\""
        
        nvl clear
        
        n "Distantly, you can hear noises of a different sort, which make you feel mildly disgusted when you catch on. You wrinkle your nose but some part of you can't help but listen closer."
        n "Even now, you can't forget the sight of Artemis on his knees, surrounded by the men. It fills you with a pitch black unease."
        n "Fooling around with his cellmates is no good. You hope this isn't a nightly occurrence, if he's sneaking people into the room."
        n "The other officers must turn a blind eye, thinking that at least the prisoners have someone to vent their frustrations on."
        n "You swallow."
        n "What happens between the prisoners has nothing to do with you. Unlike them, you're on the outside looking in."
        #n "Only a few hours left until your shift ends and you can sleep. You really need the break."
        #n "Even so, that night you toss and turn, unable to sleep."

        nvl clear

    label scene5:

        scene jail cell

        "Another day begins as you head to work poorly rested."
        "The inmates are restless today. Men shake the bars, hurling harsh words at anyone that gets too close. Insults and curses build up, threatening to explode."
        "It's still better than the alternative, a quiet morning where no one makes a sound. On those days, the chances of finding a dead body are higher than you'd like."
        #"With some concern, you notice that the inmates are particularly rowdy today"

        S "Come on, get up. It's time for breakfast."

        show artemis e1 b3 m1 bruises at artemiscentre zorder 10 with dissolve

        "You unlock Artemis' cell, and he comes stumbling out."

        show artemis e4 m3

        A "My cellmate... he's still asleep."

        show artemis m1

        A "He says not to bother him."

        S "What happened to you?"

        show artemis e3 b3 m1
        
        A "Nothing."

        show artemis at bouncedown

        "He's limping as he walks. You take him by the shoulder and pull up the sleeve."
        "There are marks on his skin, all the way up his arm to where his jumpsuit covers the rest. Some appear to be fresh, while others fade into a mottled purple."

        S "Looks bad."

        show artemis e2 b2 m1

        "Artemis frowns at you before wrenching his arm away."

        show artemis e2 b1 m5 sweat

        A "I'm fine."

        S "I didn't ask how you were. Do you want to make an incident report?"

        show artemis e1 b1 m1 sweat
        
        A "Will it help?"
        
        S "It's my job to offer you the chance to file one."

        menu:

            "He avoids your gaze, standing in silence. After a while, it becomes clear he won't answer."

            "Let him go.":

                S "Fine. If this is what you want, then keep doing it."

                show artemis e2 b2

                A "Don't tell me what to do."

                scene jail hall

                show prisoner3 zorder 20:
                    xalign 0.9 yalign -0.5 zoom 0.275
                show prisoner4 zorder 30:
                    xzoom -1 xalign 0.05 yalign -0.5 zoom 0.275
                show prisonergroup zorder 10:
                    xalign 0.49 yalign -1.5 zoom 0.275
                with fade

                "With a wan look, Artemis makes his way down the hall. You notice that he's walking funny."
                "You're not the only one who's caught on either, judging by the sneers he gets."

                show prisonergroup at bouncedownlong

                PP "So it's true, you really are a bitch."

                CP "If you like it rough, you know where to find me!"

                show prisoner3 at bouncedown

                IP "Wait until I get my hands on you, I'll buy you from him. How much do you think you're worth?"

                "Even the officer passing by sees him and scoffs."

                show prisoner4 at bouncedown

                DO "Earned that limp last night, did you?"

                "Though their words are crude, you feel as if there's truth in them."
                "After all, Artemis doesn't complain. All he does is stare ahead of himself, not even denying it."
                "You've seen how he is with the inmates. If you were in his shoes, you wouldn't act like that."
                "You wouldn't take it lying down. Or rather, does he take it on all fours?"

                show prisoner4 at bounceup

                DO "Hey, what are you making a face about?"

                S "It's nothing."

                DO "Alright, have a good shift. I don't envy you, dealing with the morning crowd."

                hide prisoner4 with dissolve

                "He claps you on the shoulder and walks off."
                "Artemis has disappeared too. You're glad he's gone, because the sight of him made you nervous."
                "Any longer and you might've started to look for his other bruises. They must be all over his body."
                #"Thinking about it makes your heart rate speed up."
                #"God, you're such a bad person for thinking that. You won't do it again."

                jump scene8

            "Take him to the nurse.":

                S "You should still see someone for your injuries."

                show artemis e4 b2 m3
                
                A "I don't need to."
                
                S "I'm telling you to. Follow me."

                show artemis e2 b2 m1

                "With those words, you turn away. Though you half-thought he wouldn't, Artemis follows."
                #keeping your grip on his wrist. your fingers covering the bruises

                scene doctors office

                show artemis e1 b3 m1 bruises sweat at artemiscentre zorder 10:
                    xzoom -1 xalign 0.15 yalign -0.2

                show nurse:
                    xalign 0.85 yalign 0.0 zoom 0.4
                
                with fade

                "The two of you arrive at the nurse's office."
                "Here, the inmates get treated for any illness or injury that arises. In your line of work, you've seen a lot."
                "Most people have been hurt at least once. Though the prison tries to catch weapons and other dangerous items, anything can be used to harm someone."
                "There was one prisoner who choked out his cellmate with a bedsheet. After that, the prison had to look into banning bed items entirely."

                show nurse at bounceup
                
                N "Hello there."

                show artemis bodydoom

                "The nurse greets you with a raised eyebrow. Pulling Artemis over, you lift his arm to show the bruises."

                N "Oh dear, what happened to you?"

                show artemis e3 b3 m3

                A "Nothing."

                N "If you won't tell me what's wrong, I can't do anything for you. You'll have to let it heal by itself."
                N "Unless you want to go into protective custody, which I'm sure could be arranged."

                show artemis m1 at artemiscentre:
                    xzoom -1 xalign 0.15 yalign -0.2
                    sideswayright

                "Artemis's face turns red. He shakes his head quickly, not wanting to be sent to solitary confinement."

                N "What are you even here for, then?"

                S "I was the one who took him here. Sorry if it's an inconvenience."

                "You feel like you have done Artemis a disservice, dragging him to the nurse for nothing. If everyone came complaining of being roughed up, the line would stretch across the prison."
                "Prison isn't supposed to be comfortable. Anyone who can't stay out of trouble will toughen up soon enough."

                S "I'll keep an eye on him from now on. Make sure he doesn't come back."

                show nurse at bouncedown

                N "You do that."
                N "How many years do you have left of your sentence, sweetie?"

                show artemis e1 b3 m1

                A "I don't know."

                S "How can you not know?"

                show artemis e2 b2 m1

                A "It can't be that much."

                "That doesn't answer the question. Frowning, you rest one hand on your hip, over the baton."

                S "Come on, there's no reason to hide, unless what you did was that bad."

                show artemis m3

                A "No."

                show artemis e1 b3 m1

                A "The lawyer... he never came. I don't know how it's supposed to work without a lawyer."

                S "Then find a new lawyer."

                show artemis b1 m2

                A "Right, because that's so easy."

                #"Don't they have volunteer lawyers? He just has to ask for one, so you don't understand it."

                hide nurse
                with dissolve

                menu:
                    
                    "As you turn to escort him out, you pause at the door."

                    "\"You should thank me.\"":
                        
                        show artemis e2 b2 m1

                        "He looks at you with his brow furrowed. It's clear that he wants to say, {i}for what?{/i}"
                        "Sourly, his mouth moves."
                        
                        show artemis m5

                        A "Thank you."

                        show artemis m1

                        S "You're welcome."

                        hide artemis with dissolve
                        
                        "After you send him back, you decide not to write an incident report. It'll only get tossed out with all the rest."

                        $ meetnurse = True

                jump scene8
                
    label scene8:

        scene field with fade

        "The inmates are on their noon break. Free time lasts for an hour, during which men run laps around the compound."
        "You can see their red faces and hear the panting breaths. Some prisoners hang back, unable to continue, while others keep pace with the stragglers just to harass them."
        "The air is hot and dry, making for a painfully sweaty experience. You often find yourself wishing there was wind, but instead, each year has been the hottest on record."
        "It seems even a comfortable temperature is too much to ask for. Thank goodness the offices are air-conditioned, even if you can't say the same for the cells."
        #"It's grueling work. Then there are the men twice their size, leering at them while doing the rounds."

        show warden:
            zoom 0.35 xalign 0.5 yalign -0.05
        with dissolve

        S "Glad we're not out there running. They must be really bored."

        CO "What else is there to do? All the work goes to us."
        CO "They act like they're the only ones having a hard time, but that attitude is why they're here."
        CO "Forget about us or the victims, the universe is only out to get them."

        show warden at bouncedown

        CO "You want a smoke?"

        S "Sure."

        "She hands you a cigarette before continuing on. Some of the prisoners watch enviously."

        CO "The other day, I had to deal with an overdose, and you know what I was thinking the entire time?"
        CO "{i}This is making me late for my son's recital. Couldn't he have done it on someone else's shift?{/i}"

        show warden at bouncedownlong

        CO "I don't even care if that makes me sound like a terrible person. They're dragging us down in here."

        "You nod in understanding."

        S "It pays the bills, at least."

        CO "I can't afford shit."

        "As smoke trails into the air, you focus on the taste of the cigarette in your mouth. Even ashes are more palatable than everything else today."

        S "Well, I tell myself it's not my problem. None of this is."
        S "The way the world works, someone has to be them and someone has to be us."
        S "That's all."

        show warden at bouncedown

        CO "Still wish I knew what it'd be like before I joined. Now I'm too used to the job to leave."
        CO "Get out while you can because it doesn't get better."
        CO "Unless you're careful, you'll end up like me someday."

        #CO "I would've taken the women's prison across the state, but this one paid better."

        #CO "Listen, my kid's birthday is next week so I'm off on Friday."
        #CO "Sorry for making you deal with this by yourself." 

        #S "It's okay, you should enjoy your time with family."
        #S "How old are they turning?"

        #CO "Eight."

        #S "Well, enjoy. Tell them happy birthday from me."

        #CO "Sure, sure."

        #"You hope she still cares deep down, because sometimes you find it hard to."

        hide warden

        show prisonergroup zorder 10:
            xalign 0.49 yalign 0.0 zoom 0.5
        with dissolve

        "Your idle chatter distracts you from the commotion on the field."

        show prisonergroup at sideswayleft

        "A large inmate shoves a smaller one to the ground. As you turn your head, he gets on top of him and smacks his face. The other men laugh as they pass by."
        "After a while, the big one gets bored and leaves."

        hide prisonergroup with dissolve

        menu:

            "Your eyes follow him as he walks away, rounding the corner to stop in the shadows."

            "Investigate.":

                show prisoner1 zorder 20:
                    xzoom -1 xalign 0.15 yalign -0.1 zoom 0.35
                show prisoner3 zorder 30:
                    xalign 0.85 yalign -0.1 zoom 0.35
                with dissolve

                "Another man is waiting for him while leaning against the fence."

                IP "How much for one night?"

                GP "Thirty dollars. No, make that fifty."

                show prisoner1 at bounceuplong

                GP "He's not worth much but at least he's tight down there."

                IP "Fine."
                IP "This doesn't mean anything. I just miss my girlfriend, okay?"

                GP "Do it from behind and you can pretend you're with anyone you want."

                #GP "Men, women, we all have asses."
                #GP "Depends on what you're going to do with him."

                #GP "You're paying for his looks."
                
                #As long as it's still tight, who cares?"
                #IP "You do you, buddy. I, for one, miss my girlfriend Kate from Canada."

                "They fall quiet as you pass by."

                $ overhear = True

                jump scene9

            "Tell them off.":

                show prisoner1 zorder 20:
                    xzoom -1 xalign 0.15 yalign -0.1 zoom 0.35
                show prisoner3 zorder 30:
                    xalign 0.85 yalign -0.1 zoom 0.35
                with dissolve

                "You stride forward, catching the prisoners in the middle of their conversation."

                S "What are you doing there? Stay where I can see you."
                #S "That's right, keep it moving! Stop hanging around, there's nothing to see!"

                hide prisoner1 with dissolve

                "The inmates glance at each other before walking away in opposite directions."
                "You hear one of them mutter to himself under his breath."

                show prisoner3 at bouncedown

                IP "This better be worth it."

                S "What better be worth it?"

                IP "Nothing."

                S "Then think before you speak."

                show prisoner3 at bounceupbig

                "He shoulder checks you."

                IP "Watch it, officer. You think you're so cool, but you're not."

                "Your right eye twitches. As least he'll be behind bars soon."

                #"Deals happen a lot. Sometimes drugs, sometimes items from the commissary, sometimes trinkets sent by people back home."
                #"You tend to give them the space to do it. It's not like they can do much otherwise."
                #"You join in with shouting orders, but it's not like the inmates ever listen. Instead, they give you the stink eye."

                jump scene9

    label scene9:

        scene jail hall

        show prisoner3 zorder 20:
            xzoom -1 xalign 0.15 yalign -0.1 zoom 0.35
        show prisoner1 zorder 30:
            xalign 0.85 yalign -0.1 zoom 0.35
        with fade

        "As you finish closing for the night, you lead the inmates into their cells and lock the doors."
        "Two stragglers walk up to you. You recognize them as the prisoners who were talking earlier."

        show prisoner1 at bounceup

        "The gruff prisoner jerks his chin up at you."

        #"There are always hiding places in prison, where inmates can duck in for private time. Sometimes that's sex, other times drug deals and weapon smuggling. Gangs get involved, too."

        GP "Hey, officer. Let me and this guy switch cells for the night."

        S "Why should I do that?"

        GP "My cellmate keeps whimpering in his sleep. You know him, the cute one."
        GP "If you don't move me, I'm going to beat him up."

        "Seeing the look on your face, he repeats his words."

        GP "I'm going to get him real bad. Bad enough that he'll need to go to the nurse."

        show prisoner3
    
        menu:

            IP "As for me, I swear I won't lay a hand on him. Scout's honour."

            "Agree.":
                
                if overhear == True:
                    "Artemis is in that cell too. From what the inmates were whispering about, he's already been sold."
                    "This has to be better for him. He's already used to it, so surely he knows what to do."
                    "At least if he stays still and remains quiet, it'll be over soon. What they've agreed on has nothing to do with you."
                
                else: 
                    "Artemis is in that cell too. You have a suspicion about what the switch is for, but there's nothing you can do about it."
                    "Either way, he's in for an unpleasant night. You don't want to bring him to the nurse, so at least you can pretend you didn't know."
                    "You don't take orders from inmates, but right now, you nod your head."

                S "Only for tonight, and it won't happen again."

                show prisoner1 at bouncedownlong
                
                GP "Of course not, officer."
                jump scene9a
            
            "Refuse.":

                if overhear == True:
                    "Artemis is in that cell too. From what the inmates were whispering about, you know what will happen."
                    "As a correctional officer, you have to refuse. Prisoners can't be threatening you however they want."
                
                else: 
                    "Artemis is in that cell too. You have a suspicion about what the switch is for, and it disgusts you."
                    "If it happens, the responsibility will fall on you for letting them break the rules."

                S "I won't move you or him. That's against the protocol here."
                S "Don't try anything funny tonight. There are guards on duty and you'll be punished for it."

                "The inmate gives you a chilling smile. His companion narrows his eyes at you."

                show prisoner1 at bouncedown

                GP "No funny business you say, but this place's full of funny business."
                GP "I'll remember you, officer."
                jump scene9b

    label scene9a:

        scene jail cell

        show prisoner3 zorder 30:
            xalign 0.85 yalign -0.1 zoom 0.35
        with fade

        S "Come with me."

        "The inmate trails behind as you walk him to the cell. Unlocking the door, he steps inside."

        show artemis e2 b3 m1 at artemiscentre:
            xalign 0.15 xzoom -1 yalign -0.45 zoom 0.9
        with dissolve

        "Artemis, who is sitting on the cot, shrinks in on himself."

        show artemis e3 b1 m3

        A "What's he doing here?"

        S "He's switching cells for the night. Don't worry about it."

        show prisoner3 at bouncedown

        IP "That's right, listen to what the officer says. I'll take good care of you."

        show artemis e1 b3 m1 bodydoom

        "Artemis' eyes go wide as the man slings an arm over his shoulders."

        IP "Thanks, officer. You can leave now."

        "Guilt churns within you. The moment you leave, Artemis will be left to his own devices."
        "Something bad will happen."
        "You tell yourself it'll only be bad for him, and has nothing to do with you."
        "They're criminals. They don't deserve your sympathy. Whatever they've done to other people must be worse."
        #"Isn't that the point of prison, to punish them?" protag never learned about deterrence and rehab :/

        "The cell clicks shut with you on the other side."

        scene jail hall

        n "Nighttime fills the ward with the sound of crying and laughing."
        n "You fix a button on your uniform, feeling as if everyone can see the unease on your face. No excuses for what you've done, but it wasn't like you could do anything else."
        
        n "\"Alright, your daddy let me have you for the night. Will you be good?\""

        n "\"Yes... What do you want me to do?\""

        # Artemis acts creepy and servile like ok I'll be yours for tonight I can share / what do you want me to do
        #n  "No, not yet! Don't go in dry, I'm not ready! Please, if you're not going to use a condominium, then at least..."

        n "\"A chuckle comes from behind the bars.\""
        
        n "\"Suck me off first. Get on your knees and make my dick wet.\""

        n "\"Okay.\""

        nvl clear

        n "You strain your eyes to make out the shadows on the wall, and swear you can see him kneeling down."
        n "Lewd noises fill the air, with low, guttural moans layering over each other. In the cell next door, an inmate whistles."

        n "\"Give it to him good!\""

        n "\"Shut up, asshole!\""

        n "\"Mmph, mmm...\""

        n "Before long, their moans and grunts get increasingly louder. You force your footsteps to go past them, and they don't even pause."
        #n "Your heart is jumping out of your chest. Nothing has affected you like this before."

        nvl clear

        n "\"Come on, we don't have all night. I want to fuck you.\""

        n "They settle onto the cot, and the bed starts to creak with movement. You lose track of whose limbs are where, because the prisoner engulfs Artemis in his larger body."

        n "\"Nnn... ah...\""

        n "\"You like that, you little bitch? Fucking take it, then.\""

        n "The heavy slapping causes the walls to shake. You are teetering on the edge of a cliff as you watch. Resentment, dark and oily, fills you."
        n "Artemis isn't moving. He's not resisting, and he even sounds like he likes it."
        n "He shouldn't be allowed to sound like that."

        nvl clear

        n "\"Please... please...\""

        n "\"Please what?\""

        n "\"It hurts...\""

        n "\"What? I didn't hear that.\""

        n "\"You're crushing me!\""

        n "\"Am I, now?\""
        n "\"I bought you and now I own you. If you're unhappy about it, then stop being a slut.\""
        n "\"Who gave you the right to be here, huh?\""

        show jail hall at vpunch

        n "A sharp crack cuts through the air."
        n "Then, silence."

        nvl clear 
        n "After that, the panting and huffing starts up again, and the bars shake with their fucking."
        n "All the way until morning."

        nvl clear

        $ prisonrape = True
        jump scene10

    label scene9b:

        scene jail cell

        show prisoner1 zorder 30:
            xalign 0.85 yalign -0.1 zoom 0.35
        with fade

        "You take the men back to their original cells. When you open the door, the inmate walks inside without a second look."

        show artemis e2 b3 m1 at artemiscentre:
            xalign 0.15 xzoom -1 yalign -0.45 zoom 0.9
        with dissolve
        
        "Artemis glances between the two of you, but says nothing."

        S "You shouldn't be putting yourself into dangerous situations. It'll only end badly for you."

        show artemis e2 b1 m3

        A "Why are you telling me that now?"

        S "I don't know. Have a good night."

        "The cell clicks shut with you on the other side."

        scene jail hall

        n "As you stand on patrol, you can hear the gruff prisoner's voice echo down the hall. He's talking to Artemis."

        n "\"I'm in a bad mood today.\""

        n "\"Oh. Why is that?\""

        n "\"It doesn't matter. Come here and sit on my lap.\""

        n "There's a silence, as if the air itself is still."
        n "Then, all hell breaks loose."

        nvl clear

        show jail hall with vpunch

        n "\"Get off me! Please, it hurts!\""

        n "\"Good.\""

        show jail hall with vpunch

        n "\"I was going to have a nice night all alone, but some asshole had to stop me from moving cells.\""

        show jail hall with vpunch

        n "\"You're stuck with me now, so let's teach him that actions have consequences.\""

        show jail hall with vpunch
        
        n "\"Hey, officer! You watching?!\""

        n "A cry rends through the air, punctuated by sounds of pain."

        nvl clear

        show warden:
            zoom 0.35 xalign 0.5 yalign -0.05

        CO "You two, what's going on here?!"

        show warden at bounceup

        CO "Jesus Christ! Someone separate them and call the nurse!"
        CO "Shit, he got him bad. Right when the doors were locked too..."
        
        "You take a deep breath and remain where you are, standing across from the scene with your arms at your side."
        "Somewhere in you, you must've known this would happen."

        nvl clear

        $ prisonassault = True
        jump scene10
    
    label scene10:

        if prisonrape == True:

            scene cafeteria

            show prisoner1 zorder 20:
                xalign 0.93 yalign -0.5 zoom 0.275
            show prisoner2 zorder 30:
                xzoom -1 xalign 0.05 yalign -0.5 zoom 0.275
            show prisonergroup zorder 10:
                xalign 0.49 yalign -1.5 zoom 0.275

            "The next day, you see Artemis sobbing and limping into the mess hall."
            "People turn their heads to look. Some prisoners whisper to each other under their breaths, disgust on their faces. Others smirk with a predatory glint in their eyes."

            show prisoner2 at bouncedown

            CP "You hear them go at it last night? What a beast!"

            show prisonergroup at bouncedownlong

            PP "Do you think he'll let us have a turn next time?"

            CP "Are you kidding? Just go ask his pimp."

            show prisoner1 at bounceup

            GP "Hey, bitch! Had fun?"

            hide prisoner2
            hide prisonergroup

            show artemis e3 b3 m1 bruises at artemiscentre:
                xalign 0.15 xzoom -1 yalign -0.6 zoom 0.85
            with dissolve

            "His shout echoes throughout the room, making Artemis flinch."
            "Though the officers turn a blind eye to many things, the commotion is too large now."

            hide prisoner1
            show warden:
                zoom 0.3 xalign 0.93 yalign -0.3
            with dissolve

            CO "My god, what happened to you?!"
            
            "She grabs his arm, forcing him to show the bruises on his neck and face."
            "He has a black eye and bloody cheek. The sight is enough to make your blood run cold."

            show warden at bounceup

            CO "Speak up. Tell me what's going on."

            show artemis e3 b3 m3 sweat bodydoom

            A "Nothing..."

            hide artemis with dissolve

            "Artemis' legs give out from under him. The officer curses."

            CO "You're going to the nurse, and we'll figure out what to do with you after."
            CO "Come with me now."

        else:

            scene cafeteria

            show prisoner1 zorder 20:
                xalign 0.93 yalign -0.5 zoom 0.275
            show prisoner2 zorder 30:
                xzoom -1 xalign 0.05 yalign -0.5 zoom 0.275
            show prisonergroup zorder 10:
                xalign 0.49 yalign -1.5 zoom 0.275
            with fade

            "The next day, Artemis doesn't appear in the cafeteria. As breakfast is being served, you hear the inmates whisper amongst themselves."

            show prisoner2 at bouncedown

            CP "A fight broke out last night. I heard he got taken away."
            CP "Do you think he was trying something with his cellmate?"

            show prisonergroup at bouncedownlong

            PP "Lover's quarrel gone wrong, I bet."

            GP "Heh."

            show prisoner1 at bounceup

            "The gruff prisoner stands up, staring you in the eye from across the room."

            menu:

                GP "Going to lock me up in solitary too, officer?"

                "Threaten him.":

                    S "I'll make sure you're in there next time."

                    show prisoner1 at bounceuplong

                    "He turns his head away with a half-laugh, his eyebrows pulling together."

                    GP "I said I'd do it, didn't I?"
                    GP "He got taken away by the guards. When he gets out, I'll tell him it was you who helped me."
                    GP "Well, no hard feelings. At least I get the cell to myself for a while."

                    jump scene10a
                "Remain silent.":
                    GP "I knew you wouldn't be able to say anything."

                    "You flinch from his words, unable to deny them."
                    "He has the look of a man with nothing to lose. A prisoner with a life sentence, so nothing you do can hurt him."
                    "As much as you want to punish him, he might not care about what happens."
                
                    jump scene10a
        
    label scene10a:

        hide prisoner1
        hide prisoner2
        hide prisonergroup
        hide artemis
        hide warden
        with dissolve

        "The inmates eventually disperse, but not without a commotion. You work with the other officers to send them along."
        "It strikes you that you could've prevented this. If only you'd put Artemis in the protective custody ward so he wouldn't be around anyone."
        "No, you can't think like that."
        "You'd never be able to separate him forever. He'd be moved back to his cell eventually, where he'd have to give them what they want."

        "All these thoughts go through your head, draining your body of any feeling at all."
        "The inmates could do their time peacefully, but who really does? Well-behaved people don't go to prison in the first place."

    label scene11:
        scene jail hall

        show warden:
            zoom 0.35 xalign 0.5 yalign -0.05
        with fade

        CO "Goddamn, how does that boy keep getting into trouble?"

        show warden at sideswayright

        CO "Just look at the state of him. Now I'll have to file a report."

        if prisonrape == True:

            S "He's going to end up in solitary, isn't he?"

            CO "It's for his own good."

        "Her voice is fierce."

        CO "It's disgusting what they do to each other. I would never lay my hands on an inmate, or anyone else for that matter."

        S "I thought you didn't care about them."

        CO "When did I say that?"
        CO "We're all they have in here. Of course I feel responsible."

        "She looks to the side, her jaw set. You feel a twinge of betrayal."
        "If you'd known how she felt, you would've said something earlier. Now you seem like a worse person than her."

        S "I'll write the report for you. Say he's been on good behavior until now, make it a one-time incident."
        S "The sooner he gets parole, the better."

        CO "No, don't go that far. If he didn't break the law in the first place, he wouldn't have these problems."

        show warden at bouncedown

        CO "Do you think the victims care if he's living a comfortable life?"
        CO "Justice isn't in our hands, so don't go messing with it."

        #S "He can't be in here forever."

        "She fixes you with a stern look."

        CO "The inmates will get their rights back when they leave. It's up to them to decide what kind of life they want after they're out."
        CO "I'll worry more about my own family, thank you very much, and hope my son never ends up like them."

        window hide

    label scene12:

        scene sky

        if prisonrape == True:
            n "{i}At approximately 6:45 AM in the morning, Inmate 12 entered the cafeteria with heavy bruising. He was brought to the nurse, where it was determined that he had been assaulted in his cell.{/i}"
            n "{i}When questioned, he refused to speak.{/i}"
        
        else:
            n "{i}At approximately 9:45 PM at night, Inmate 12 was assaulted by his cellmate. A dispute arose, which is believed to have been escalated by Inmate 12.{/i}"
            n "{i}On-shift officers broke up the scene. Reasonable use of force was needed to restrain both individuals.{/i}"

        n "{i}It is recommended that Inmate 12 be moved to solitary confinement.{/i}"

        n "The report was short. Brief. To the point, because not everyone needs to know everything. All the officers on the scene signed off on it."
        n "{i}An altercation,{/i} you called it. {i}Incident. Event. Act of violence.{/i}"
        n "{i}Reason unknown.{/i}"
        #n "Your solutions have never been perfect."

        nvl clear

        n "Outside, the sky is no longer grey like concrete and peeling paint. Beyond the prison walls, it's a bright blue."
        n "How different a change in perspective makes. If the inmates could see what you do now, would they have thought twice before ending up here?"
        n "You'll never know. You won't ask either, in case you don't like the answer."

        nvl clear

    label scene13:

        scene jail cell

        R "Is the world becoming more unsafe? A recent survey shows that citizens believe crime is rising across the nation."
        R "Calls for stronger enforcement have increased, and our very own governor is answering the cry."
        
        G "Community service and all that crap? I don't believe it. You wouldn't either, if you knew who in our society is really hurting."
        G "Families can't take their kids out on the streets anymore. Not when there could be anyone out there."
        G "Our communities don't feel safe. In fact, they aren't."
        G "If bad people with bad intentions want to play hardball, then so will I. We're going to put the fear of enforcement back into them."

        show prisoner3:
            xalign 0.5 yalign -0.1 zoom 0.35
        with fade

        "The inmate leans back in his seat and turns off the TV."

        PP "Hey, officer, what do you think they'll do?"

        show prisoner3 at bounceup

        PP "Not that it'll affect us, since we're already locked up in here."

        S "Don't ask me."

        #PP "Too bad. Aren't you guys supposed to know people out there?"

        "He scoffs at you from the other side of the bars. You pretend you don't see him do it."
        "Another day on watch duty. The same as always, you're supervising the prisoners as they serve their time."
        "Here he is in his cell, watching a show and talking to you when he's bored. It's like nothing happened at all."
        #He must be happy that Artemis is in solitary and he isn't. He inmates responsbile got off scot-free. Funny how it works out that way."

        S "Sounds like there'll be a lot more of you soon. It'd be nice if everyone got what they deserved."

        PP "Not me, though. I'll be out before that happens."
        PP "I've been working hard. The other day, I saved enough to get ramen from the commissary."
        PP "If you add cheese and hot sauce, it's a good meal. The best we can get in here."
        PP "That night, we had a feast in my cell."

        #PP "You add the noodles to hot water and the cheese slices from the cafeteria, milk if you can get it."

        show prisoner3 with hpunch

        "The prisoner's voice grates in your ears. You snap your baton against the bars, where it makes a loud crack."

        S "Can't you be quiet already?"

        PP "What the fuck, you can't make me stop talking in my own cell!"

        S "I can stop you from doing anything I don't want."

        "His fists clench, the muscles in his arms pulling up. Your own does too, as you meet him eye-for-eye."

        show prisoner3 at sideswayright

        PP "This is why I can't stand you guys."
        PP "When I get out, I'm going to have nothing to do with you. This place will just be a bad memory..."

        S "Good luck with that."

        show prisoner3 at sideswayright

        PP "You don't need to tell me that I'll end up back here. I already know."

        #S "I'd rather you didn't, actually."

        #PP "So overpriced, did you know that?"

        #S "That's what work is for. Then you'll have all the ramen you want."
        
        #PP "You think I'd be here if I had a family?"

        #S "Lots of people are."

        #"The prisoner shrugs, pulling a face."

        #PP "Lucky them."
        #PP "I don't even have a girlfriend. That's one of my goals when I get out, to find a nice lady who'll accept me."
        #PP "Someone who'll see through this, you know? That's my type, officer!"

    label scene14:

        scene jail hall

        show prisoner4 zorder 10:
            zoom 0.35 xalign 0.5 yalign -0.05
        with dissolve

        "As you head outside, your body is heavy and your mind even more so."
        "Someone slaps you on the back hard enough to make you stumble. You turn around, ready to confront them."

        show prisoner4 at bounceup

        DO "Whoa, careful! It's just me."
        DO "I heard what happened with the inmates. Bad luck that it was on your shift, but nice job handling it."

        "He leans in closer, his voice lowering to a whisper."

        DO "About the report you wrote, in case I have to do one in the future. I'm sure it's nothing, but just wondering..."
        DO "About what happened, what did you call it?"

        "{i}Rape.{/i} The word hangs in the air, tightening between the two of you."

        S "Altercation. I also used incident."

        DO "Well, both of those are true. So, did you see anything good?"

        "Artemis' pained face flashes in your mind. You fight through the charge that runs through you, and shake your head."
        
        #The two of you aren't close, other than sharing the same shift once in a while."

        S "I don't know what you mean. Besides, everything happened too quickly."

        DO "That's okay, I wasn't asking about anything in particular."
        
        "His hand is warm where it clasps your shoulder."

        DO "As long as you know I'm here for you. You know that, right?"
        DO "It's the prisoners who can't control themselves, but at least we can enjoy the show."
        #DO "I've seen how Artemis acts. He's their prison bitch."
        #DO "Even I've noticed his {i}behaviors{/i}."

        "That's right. No matter what, guards will always back up guards, and inmates will always cover for their own."
        "You can't imagine how it could be any other way."

        S "A prisoner was talking to me earlier. He thinks it's unfair to be locked up here, eating commissary noodles."

        DO "Can you believe that? As if he doesn't know his own position."

        "It feels good to have someone understand. The prisoners don't listen, but you can find people who do."

        #"He smiles when he says it, but there's contempt in his eyes. Both of you are polite enough not to say it out loud."

        show realwarden zorder 1:
            zoom 0.25 xalign 0.2 yalign 3.0
        with dissolve

        "Suddenly, the officer straightens up and looks to the side."

        DO "Hello, sir. I was just about to leave."

        W "Get going, then."

        "The warden looks at you."

        W "As for you, we need to talk."

        S "Okay."

        hide prisoner4

        show realwarden:
            zoom 0.35 xalign 0.5 yalign -0.05
        with dissolve

        "You think he'll lead you to his office, but instead, the warden finds an empty corner to stand in. The two of you duck your heads as inmates walk by."

        W "I got your report."

        "Sweat beads at the top of your lip. Salty and bitter, you swallow it down with your saliva."

        if prisonrape == True:

            "You didn't write about your own involvement. He can't know you were the one who switched the cells."
        
        else:

            "You didn't write about your own involvement. It's not your fault the prisoner assaulted Artemis because you wouldn't switch the cells."

        $ menu = renpy.display_menu

        menu:

            "He looks at you expectantly, waiting for what you have to say."

            "Explain yourself.":
                $ bys += 1

                S "It's all on paper, but I can talk about whatever you want."
                S "Personally, I think Artemis got involved with bad people. Not that I know the details, since he won't tell us anything."
                #S "Maybe there were drugs involved. He could've done something to piss him off."
                #S "If only I could've stopped them..."
                #S "I didn't know, okay? If I knew, I could've..."
                #They plan things without us knowing. It's the law of the jungle in here.

                #"It's not like the problem isn't being dealt with. It is, so there's no harm in keeping yourself out of it."
                #"If you stay here, you can stop it from happening again. Because it will happen again, and you'll be there, and..."
                #"Next time, you'll know what to do."

                "Your voice falters at the end. The warden licks his lips."

                W "You don't need to continue. These things happen, and I'm not going to look into it."
                jump scene14a
            
            "Say nothing.":
                #S "Artemis was going to..."

                S "There's nothing I can say, sir. I sent in everything we know."
                S "I can only hope this doesn't reflect badly on me, as an officer who was there..."

                "Your voice falters at the end. The warden licks his lips."

                W "No need to elaborate. These things happen, and I'm not going to lose good staff over it."
                jump scene14a

    label scene14a: 

        S "Really?" 

        W "Yes."
        W "Even locked up, men have desires. It's better that they get it out of their systems quietly."
        W "I'm trying to run a functioning prison, not the next news headline. Can't do anything if outsiders come in and start sweeping the place."
        #W "That's no good for us and no good for them. Then where will they go?"
        
        #"You worry he doesn't believe that."

        "Your shoulders go slack. He doesn't want this to be a problem any more than you do."

        "The warden is a lifer, after all. He's been at the prison for years, longer than some inmates."
        "The environment must've rubbed off on him, because he has the same blunt stare. Like he's looking through bars."

        #W "Integrity is important to have, but easy to lose."

        #"The warden makes as if he'll clasp his hands, but instead, he touches your shoulder."

        W "Don't worry about it. You handled it well."
        W "Let's wait until Artemis finishes solitary and everyone calms down. The time alone will do him good."

        S "You're right."
        S "It's the inmates' choice on how they choose to spend their time, and who they choose to spend it with."
        S "This'll be forgotten in a week."

    label scene16:

        scene solitary

        "The solitary ward is cold in the winter and hot in the summer. It's either freezing or blistering, with fluorescent lights in the halls and a state-of-the-art lock system."
        "You nod to the officer on duty. Takes a special kind of person to guard this place."

        show prisoner2:
            zoom 0.35 xalign 0.5 yalign -0.05
        with dissolve

        #Serious Officer
        SO "You're the next one, then? Good, I was getting tired of this place."

        S "I'm here to take him back, actually."

        SO "He's finished his time in solitary confinement?"

        S "That's right."

        SO "Tell him he was a model prisoner. Great behaviour and everything."

        hide prisoner2 with dissolve

        "You walk past him without responding."
        "The door is locked with a deadbolt. There's a narrow slot for food, the three sparse meals that prisoners gets each day."
        "When you peer into the cell, Artemis is sitting on the ground. He's thinner now, with a pallid cast to his skin."
        "His hair hangs over his face, and a twinge of guilt goes through you at the bruises fading into yellow and green."

        show artemis e3 bruises at artemiscentre
        with dissolve

        S "Artemis."

        show artemis e2

        "Artemis lifts his head but says nothing."

        S "Are you..."

        "{i}Okay?{/i}"

        S "... Ready to leave?"

        show artemis e2 b3 m3

        A "You're taking me back there?"

        S "Well, your solitary confinement is over."

        show artemis e3 b3 m1

        A "I don't want to go."

        S "You have to."

        "You meet eyes with Artemis through the slot in the door. He clutches his arms, hugging himself as he shakes his head."
        "The way he's holding himself matches the scratch marks there. You've never seen an inmate doing well after solitary, but your stomach still sinks."
        "Prolonged isolation will drive anyone mad. The psychological effects include depression, anxiety, psychosis, and suicidality."
        "Still, he could've had the same problems before. You don't know him well enough to say."

        S "Just get up. I've never heard of an inmate who wanted to stay in solitary."

        show artemis e3 b3 m1 bodydoom at sideswayright

        A "Like you don't know what's waiting for me outside..."

        menu:

            "An uncomfortable air envelops the both of you, bringing with it the guilt you've tried to shake."
            
            "Coax him out.":
                $ symp += 1

                show artemis e2 b1 m1

                S "When you put it that way, I feel responsible for what happened. It's fine now."

                "You'd like to say more, but there's nothing you can say. Any kind words die in your throat before they can see the light of day."
                "{i}Sorry{/i} is too much and too little all at once. You might feel better after saying it, but it's not about whether you can breathe easier."
                "You can't express what you don't believe, so you can only hope Artemis understands."

                A "Liar."

                S "I'm not lying. The warden promised he'd do something."

                show artemis e1 b1 m3

                A "You shouldn't have told the warden, that'll just make it worse for me..."

                if prisonrape == True:
                    S "You collapsed in front of the entire cafeteria, of course he'd find out."
                
                else:
                    S "You were yelling in the middle of night, of course he'd find out."

                S "Just get up, okay? You're not helping your situation by staying here."
                S "You'll have to face the others someday. What's the worst that could happen?"

                show artemis e2 b2 m1

                A "Who knows."
                
                "Silently, he stands up and follows you out."

                jump scene17
            
            "Force him out.":

                S "If you don't believe me, that's your problem."
                S "Now stand up. I don't have the time to deal with you."

                show artemis e2 b1 m3 at bounceup

                A "Let go of me!"

                "Harshly, you grab his arm and tug him out."
                "His face turns resigned, like he can't even muster the energy to struggle."
                "That's right. In a place like this, he should think the worst of everyone. It's the only way to survive."
                "Someone like him, no wonder he keeps getting hurt all the time."

                jump scene17

    label scene17:

        scene cafeteria

        show prisoner3 zorder 20:
            xalign 0.9 yalign -0.5 zoom 0.275
        show prisoner4 zorder 30:
            xzoom -1 xalign 0.05 yalign -0.5 zoom 0.275
        show prisonergroup zorder 10:
            xalign 0.49 yalign -1.5 zoom 0.275
        with dissolve

        CP "Look who's back. Baby, I missed you!"

        IP "They treat you well in solitary?"

        PP "He looks like shit."

        hide prisoner3
        hide prisoner4
        hide prisonergroup
        show artemis at artemiscentre
        with dissolve

        "Artemis stares ahead with no response. The only indication he's heard is the cafeteria tray that shakes in his hands."
        "Today's breakfast is scrambled eggs and fruit. The eggs remain congealed on his plate, but his apple stutters to the edge, where it threatens to roll off."
        "As it drops onto the ground, another inmate picks it up, shines it on his shirt, and takes a bite."

        hide artemis
        show warden:
            zoom 0.35 xalign 0.5 yalign -0.05
        with dissolve

        CO "So, he's back."

        S "He sure is."

        CO "He doesn't look too bad, all things considered."
        CO "I just hope it wasn't too early to take him out. Want to guess how soon until another incident happens again?"
        CO "If it gets bad enough, we might have to send him to solitary permanently."

        S "You think that'll be better for him?"

        CO "It's not about him. It's better for the others not to be around his kind of presence."

        S "That's an ugly thing to say."

        CO "Do you think I like it any more than you do?"

        show warden at bouncedown

        "Silence falls between the two of you. She lifts one hand to scratch the back of her neck."
        
        CO "You know what's the most important thing about working here?"
        CO "Doing what's necessary."
        CO "Not what makes you feel good, or what people on the outside think is right. They don't know shit."
        CO "Do what you have to, even if you'll always be the bad guy."

        "She has a point. There was an officer before, a rookie who quit in his first week on the job."
        "He had ideas about fixing the place. Thought he could walk in and change everything, like he had some kind of saviour complex."
        "Whatever he expected, it wasn't reality."
        #The inmates, the staff, even how the prison was run.

        S "I get it, so don't lecture me like I don't. You don't have to worry about me."

        CO "See, that's why you're one of the best partners I've ever had."
        CO "Don't be so hard on yourself. You'll drive yourself insane that way, and without accomplishing anything either."
        
        S "If only you knew, then you might not say that."
        #S "It'll end up the same either way, so what's the point?"

        "An emptiness sits within you like a pit of tar. Weighing you down the longer you stand there."
        "Sinking into the concrete, disappearing inside."

        show warden at bouncedown

        CO "Okay, well, I'm going to my sister's wedding this weekend."
        CO "For a while, we were afraid she wouldn't find anyone, but look at her now. Getting her life together!"
        CO "She met him at work calling tech support. Funny, right, the IT guy?"
        CO "I met him once, and he's nice enough."

        "Looking over, you see the gruff prisoner put his arm around Artemis."

        S "Congratulations to her."

        CO "God, I wish."

        #S "Small mercies, I guess."

    label scene18:

        scene jail hall

        n "\"It's just you and me now, Artemis. You and me.\""
        n "\"We've got a lot to make up for.\""

        n "The noises have started up again at night. They stopped while Artemis was gone, but now they're back."
        n "You never used to pay much attention to the night shift. It was always background static, nothing that mattered enough to listen to."
        n "Inmates talking, screaming, groaning, wheezing... You're starting to be able to tell prisoners' moans apart, and that makes goosebumps go up your back."
        n "You missed Artemis. It must be that everyone else did too."

        nvl clear

        n "His cellmate has him down on the bed, fucking him relentlessly. They don't stop when you walk by, or when you shine the flashlight over. Not even when the other inmates start cursing at them."
        n "As light hits them, someone in another cell starts to laugh. Another pulls his pants down. The prisoners are getting off on the front row seat."

        n "\"What did I... even do?\""

        n "\"Nothing. You just happened to be here.\""
        n "\"If you want to blame someone, blame your mother for giving birth to you.\""

        n "Why are you frozen in place? Why won't you do anything?"
        n "You never seem to get your feet to move in time."

        nvl clear

        n "In the end, people can get used to anything."
        n "No, not that they {i}can{/i}. They will."
        n "Hit them the first time, and they'll cry. Hit them the fifth, and they'll brace themselves the moment you start to swing."
        n "Hit them the first time, and you'll stay awake all night. Hit them the fifth, and you won't even remember their faces when you go home."
        n "The truth is, you want to know what it's like to fuck Artemis too."

        nvl clear

    label scene19:

        scene field 
        show prisoner1:
            xalign 0.5 yalign -0.1 zoom 0.35
        with fade

        GP "Stop watching us, will you?"

        show prisoner1 at bounceup

        GP "If you want something to jerk off to, use this."

        "He throws a magazine at you."
        "It's a porno rag, the paper tattered and stained. You hold it with two fingers away from you."
        "The cover girl looks like Artemis, at least if you squint. She has the same face shape."

        GP "Look, she's got double Ds and a nice ass. I'd love to meet her in real life."
        GP "Too bad there's no women in prison. We have to settle for closing our eyes and doing Artemis from behind."

        S "I'm throwing this in the trash."

        GP "Do whatever you want."

        "He raises his hands, refusing to take it back."

        #if prisonrape == True:
            #GP "I know you want to fuck Artemis too. If that's all, then something can be arranged."
            
        #else:
            #GP "Because of you, my friend didn't get a turn with him. I lost out fifty dollars, and now Artemis will have to earn it back."

        GP "Don't feel bad for the kid."
        GP "He needs to toughen up. If he didn't want my attention, he'd better get buff and ugly."

        show prisoner1 at bounceuplong

        GP "Artemis was fifty dollars before, but I'll lower it to forty in case solitary fucked him up."
        #It's like a slut discount.

        S "Why are you telling me this?"

        #"He spits on the ground. A sinking feeling goes through you that the inmates don't respect you at all."

        GP "In case you're interested."

        "Your mouth opens but nothing comes out."
        "That night plays in your head over and over again, bringing with it a shiver that slithers up your spine."
        "If you had nothing to lose..."

        S "No."
        S "Don't test me. If something happens to him again, I'll make sure you'll be the one sent to solitary."

        GP "If you wanted me there, you would've done it already."

        #GP "If you were on this side of the bars, I'd make you into my second bitch."

        if prisonrape == True:
            GP "Scared that I'll tell everyone you were the one who switched the cells?"

        else:
            GP "Scared that I'll tell everyone you sat by and watched as I had my way with him?"

        show prisoner1 with vpunch

        "You take a step forward and clock him across the face."

        GP "Hah! I'd hit you back but that's too easy."
        GP "Whatever happens next, it's your own guilty conscience, officer."

        #GP "But fine, I was just asking."

        S "I'd like to see you try to hurt me."

        #"Bad idea. Something must show on your face, because he's not scared at all."

        GP "Then it's too bad we can't get along."
        GP "Just remember, you can have Artemis any time you want. You wouldn't be the only one."

    label scene20:

        scene jail hall

        n "Every week, the prisoners get to make a call. They can spend up to one hour on the phone, the connection fee being two dollars and fifty cents."
        n "Then it's fifty cents for each minute. Raise the price to one dollar for long-distance, which could be anywhere from the next city to the nearest border. There's a chart that lists every region, but no one looks at it much."
        n "Some things you can't put a price on."
        n "The men stand in line waiting for their turn on the phones. They speak while huddled in stalls, each one separated by a plastic divider."
        n "You can hear them in every kind of conversation there is. Even an lifetime wouldn't be enough for what they have to say."

        nvl clear

        n "\"She can drop out if she wants. What do you mean, you don't want her to end up like me?\""
        n "\"I miss you so much, sweetheart. It's hard being strong, but I'm doing it for you... All for you...\""
        n "\"Fuck you, you lying bastard! I never agreed to be the fall guy! You said I'd be safe!\""        
        n "\"It doesn't matter about school, I'd rather she still be alive when I get out of prison!\""
        n "\"Hello? Yes, it's me. Everything's good. I found a way to make money in here.\""

        nvl clear

        n "There's a reason why you try not to listen in on their conversations. When people show you their lowest moments, you can only look the other way."
        n "Rock bottom is a state of mind, and you've seen chasms too deep to dig your way back up."
        n "No wonder prison life is ordinary to you now."

        nvl clear

        show artemis at artemiscentre
        with dissolve

        S "Do you need the phone?"

        show artemis e1 b1 m2

        A "No."

        S "You're just watching, then?"

        show artemis at sideswayright

        "Artemis shifts his weight, still staring at the men on their phones. His gaze catches on one prisoner."

        show artemis e4 b1 m3

        A "I'm waiting for my cellmate to finish. What do you want?"

        S "Nothing, I'm still on duty."
        S "You're listening in on people's private conversations, you know."

        show artemis e2 b2 m2

        A "It's not my fault there's no privacy in here."

        S "At least get in line to make your own call."

        show artemis e1 b1 m1

        A "It doesn't matter. There's no one I need to talk to."

        "To someone who leads a normal life, it's impossible to imagine not having anyone."
        "No family or friends, no lovers, not even a stranger willing to reach out a hand. Then again, there are people in the world who live like that."
        "If Artemis is ever freed, what does he have to look forward to?"

        S "Fine, do whatever you want. Your life is hard enough without having to worry about other people."
        S "As long as you remember that you're being punished, so don't expect anyone to be on your side."

        show artemis e3 b1 m1 at sideswayright

        A "If you can say that, then why..."

        show artemis e3 b3 m1

        A "Never mind."

        "You don't know what he wanted to ask, but your answer wouldn't be pretty no matter what."
        "Not that you were ever good with words, and now your actions too. You wanted to make up for letting him get hurt, but all you've done is cover it up."
        "You came here thinking you'll do the job and not let it affect you, but everyone has their limits."

        S "Listen, you should come with me."

        show artemis e2 b1 m1

        A "What?"

        S "You're standing in the way. If you're just here to pass the time, I can find us somewhere better."

        show artemis e2 b2 m1

        A "Then I'll go back to my cell."

        S "No, you'll be unsupervised."

        show artemis e2 b1 m1 at bouncedown

        "You reach out, and he flinches."

        #S "I want to be there for you. Personally."
        S "I promise I won't let the inmates bother you anymore. They can try all they want, but I'll stop them."

        show artemis e4 b1 m1

        A "It's your fault they hurt me in the first place."

        S "That's right, it's like the prisoners run this place more than the staff do."
        S "If they're good enough, why aren't I?"
        #Why don't you... with me too...

        show artemis bodydoom sweat e3 b3 m1

        $ menu = renpy.display_menu

        menu:

            A "No."

            "Insist.":

                S "Just let me do it."

                #S "Treat me like everyone else."

                show artemis sweat bodydoom e2 b2 m1

                A "I see. You're no different from the rest of them."

                S "No, that's not what I meant."

                show artemis sweat bodydoom e2 b2 m4

                A "But it is."

                #S "I'm glad we've come to an understanding."

                "He lets you touch him. You rub his shoulder in a friendly gesture, using your thumb to dig deep and work out the tension."
                "Silently, Artemis grabs your arm. His fingers dig into your sleeve."
                
                "You lead him somewhere private."

                jump scene23

            "Relent.":

                S "Whatever you're thinking, I didn't mean it."

                "But you did. You must have, for Artemis to be looking at you like that."
                "You step back, the sweat on your back cooling. The side of your neck itches."

                S "I had my chance earlier, but I said no, see? He asked if I wanted to pay for you."
                S "You were forty dollars."

                show artemis e2 b1 m5

                A "Are you serious?"

                S "Yes."

                show artemis e2 b2 m1

                A "Okay. Do you want me to thank you for doing that?"

                "The force of his words catch you by surprise. You thought he'd be glad, but instead, he sounds..."
                "Upset? Hurt? Angry?"
                "Like a deer on a highway moments before collision, its eyes looking into yours. A second stretches into a lifetime, going a hundred miles an hour."

                S "This isn't... I wasn't..."
                S "Forget about it, can we start over?"

                "You wait, not having the courage to say anything more. Artemis doesn't move."

                show artemis e3 b3 m1 at bouncedown

                A "I want to go back to solitary."

                S "We don't put people in solitary without a reason."

                show artemis e4 b3 m1

                A "Then what reason do you need?"

                "{i}Hurt yourself or someone else.{/i} There it is, the crash, and both of you know it."

                S "Nothing. This conversation is over, okay?"
                S "We can't keep talking about this."

                show artemis e3 b3 m1

                A "Okay, sure."

                hide artemis with dissolve

                "When the tension becomes too much to bear, you let him wander off. You grit your teeth, your molars gnashing against each other. Pain erupts in your jaw."
                "His disgust stays with you for the rest of the day."

                jump scene24

    label scene23:

        scene jail cell

        show artemis e2 sweat bodydoom at artemiscentre
        with fade

        "You take him to an empty cell, ignoring the sidelong glances from inmates passing by."
        "The door has rusted hinges that creak when you let Artemis in, revealing a room with the distinct smell of damp."
        "Along this side of the ward, some cells were deemed uninhabitable. Renovations are scheduled for next year, subject to funding."
        "Until then, the room remains empty. No one is particularly motivated for a new project right now."
        
        #"The prison is waiting for someone to go in and fix it, but the state hasn't sent anyone yet."
        #"Even outsiders coming in to do construction puts everyone on edge."

        S "It's alright, make yourself comfortable."

        #He tenses, then relaxes. You rub his arm too, then reluctantly, you let him go.

        show artemis e1 b1 m1 bodydoom

        menu:

            "Ignoring the way his eyes go dull, you close the door."

            "Advance on him.":
                $ perp += 1

                hide artemis

                n "For a moment, you stand with your legs locked in place. Your mind races, with thoughts of right and wrong going out the window."
                n "What difference will it be, whether you force him or not, when he's already used to it? It's happened before, and everybody knows."
                n "Tension builds up in the air between you. Artemis' face looks red. Your breath catches."
                n "Just watching makes you feel bad for him, but sort of good too."
                n "You tell yourself that if you let him make the first move, then it doesn't count. When it comes to taking what you want, it's every man for himself."

                nvl clear

                n "\"Come on, Artemis, ease up. I want this.\""

                # n "\"You're all the same...\""

                n "Artemis' expression is unreadable. There must be a draft, because he holds himself stiffly, like his limbs are made of wood."
                n "You watch him lick his lips, and a shiver runs through you."
                n "He falls to his knees as you open your pants. The wet floor leaves marks on his jumpsuit while he shifts in place."
                n "You can feel yourself stirring, even as a suffocating sensation fills your lungs. Artemis puts a hand on your cock and takes it in his grasp."
                n "See, that wasn't too hard."

                nvl clear

                n "The walls seem to be closing in. It's too cramped with the two of you in here, but you can't imagine being anywhere else. Not when Artemis starts to blow you."
                n "You focus your gaze on nothing in particular, shuddering as Artemis' tongue glides over your length. Even that isn't enough, so you grab his hair and push him down."
                n "Artemis, used to rough treatment, doesn't even flinch."

                n "\"Okay, good. Yes...\""

                n "You think about doing it all the way, but you don't have enough time. Instead, you listen to the wet noises as Artemis pleasures you with his mouth. He redoubles his efforts as you fuck him."
                n "It feels good. Too good. Good enough to wipe your mind blank, not even to make you feel bad."

                nvl clear

                n "When you're done, he spits your cum onto the ground, where it splatters against the concrete."
                n "As you stagger back, you watch him wipe away tears from the corners of his eyes."
                
                n "You pretend you don't see him do it."
                
                n "After all, no one wants to feel like the bad guy."

                #you don't enjoy feeling like you're the bad guy here

                nvl clear

                $ firsttime = True

                jump scene24

    label scene24:

        $ quick_menu = False
        scene black
        
        centered "{color=#ffffff}To be continued...{/color}"

        return