using RimWorld;
using Verse;

namespace Xoa
{
	public class XoaHelper
	{
		public static readonly GeneDef geneXoaBody = DefDatabase<GeneDef>.GetNamed("Xoa_TinyBody");
		public static readonly GeneDef geneTimeDivider = DefDatabase<GeneDef>.GetNamed("Xoa_TimeDivider");
		public static readonly GeneDef geneSlimyBody = DefDatabase<GeneDef>.GetNamed("Xoa_SlimyBody");

		public static readonly HediffDef BiteHediff = DefDatabase<HediffDef>.GetNamed("XoaBiteGiver");

		public static readonly LifeStageDef lifeStageXoaAdult = DefDatabase<LifeStageDef>.GetNamed("XoaAdult");
		public static readonly LifeStageDef lifeStageXoaChild = DefDatabase<LifeStageDef>.GetNamed("XoaChild");

		public static bool IsXoaSized(Pawn pawn) => pawn.RaceProps.Humanlike && pawn.genes != null && pawn.genes.HasGene(geneXoaBody);
		public static bool IsXoaMind(Pawn pawn) => pawn.RaceProps.Humanlike && pawn.genes != null && pawn.genes.HasGene(geneTimeDivider);
		public static bool IsXoaSlime(Pawn pawn) => pawn.RaceProps.Humanlike && pawn.genes != null && pawn.genes.HasGene(geneSlimyBody);
	}
}
