using HarmonyLib;
using RimWorld;
using Verse;
using Verse.AI;

namespace Xoa
{
  [HarmonyPatch(typeof(MentalBreakWorker), "CommonalityFor")]
  public static class MentalBreakWorker__CommonalityFor
  {
   [HarmonyPostfix]
   public static void Postfix(MentalBreakWorker __instance, ref float __result, ref Pawn pawn)
	{
		MentalBreakDef def = __instance.def;
		if (pawn.genes != null && def.mentalState != null && def.mentalState.category == MentalStateCategory.Malicious && XoaHelper.IsXoaMind(pawn))
		{
			__result *= 999999;
		}
	}
  }
}
