using HarmonyLib;
using RimWorld;
using System.Linq;
using Verse;

namespace Xoa
{
  [HarmonyPatch(typeof(Pawn_GeneTracker), "Notify_GenesChanged")]
  public static class Pawn_GeneTracker__Notify_GenesChanged
  {
   [HarmonyPostfix]
   public static void Postfix(Pawn_GeneTracker __instance, GeneDef addedOrRemovedGene)
   {
    bool dirty = false;
    Pawn pawn = __instance.pawn;
    if (addedOrRemovedGene == XoaHelper.geneXoaBody && pawn.gender != Gender.Female) // mtf
    {
     pawn.gender = Gender.Female;
     if (pawn.story.bodyType == BodyTypeDefOf.Male)
     {
      pawn.story.bodyType = BodyTypeDefOf.Female;
     }
     dirty = true;
     }

    if (dirty)
    {
     // reselect head if current head is now incompatible
     if (pawn.story.headType.gender != Gender.None && pawn.story.headType.gender != pawn.gender)
     {
      if (!pawn.story.TryGetRandomHeadFromSet(DefDatabase<HeadTypeDef>.AllDefs.Where(x => x.randomChosen)))
      {
       Log.Warning("Couldn't find an appropriate head after changing pawn gender.");
      }
     }

    // remove beard if appropriate
    if (!pawn.style.CanWantBeard && pawn.style.beardDef != BeardDefOf.NoBeard)
    {
     pawn.style.beardDef = BeardDefOf.NoBeard;
    }

    pawn.Drawer.renderer.SetAllGraphicsDirty();
   }
  }
 }

}
