using HarmonyLib;
using RimWorld;
using Verse;
using System.Linq;

namespace Xoa
{
	[HarmonyPatch(typeof(Pawn_GeneTracker), "Notify_GenesChanged")]
	public static class Pawn_geneTracker__Notify_GenesChanged
	{
		[HarmonyPostfix]
		public static void Postfix(Pawn_GeneTracker __instance, GeneDef addedOrRemovedGene)
		{
			Pawn pawn = __instance.pawn;
			BodyPartRecord jawRecord = pawn.def.race.body.AllParts.First((BodyPartRecord x) => x.def.defName == "Jaw");
			if (addedOrRemovedGene == XoaHelper.geneSlimyBody)
			{
				if (XoaHelper.IsXoaSlime(pawn))
				{
					pawn.health.AddHediff(XoaHelper.BiteHediff, jawRecord);
				}
				else
				{

					Hediff hediff = pawn.health.hediffSet.hediffs.FirstOrDefault((Hediff x) => x.def == XoaHelper.BiteHediff );
					pawn.health.RemoveHediff(hediff);
				}
			}
		}
	}
}
