/* ************************************************** NEW JAVASCRIPT ************************************************** */
// --****** GLOBAL VARIABLES
var AppendCompany = 'other...';
// --****** GLOBAL VARIABLES
$(document).ready(function(){
	$("form").submit(function(){
		// return false;
	});
	$("#company_id").append("<option>"+AppendCompany+"</option>");
	$("#pullout_id").append("<option>"+AppendCompany+"</option>");
	$("#delete_company").click(function(){
		var Company = $("#company_id option:selected");
		RemoveCompany(Company.val(), Company.text(), Company);
	});
	$("#delete_pullout").click(function(){
		var Pullout = $("#pullout_id option:selected");
		RemovePulloutType(Pullout.val(), Pullout.text(), Pullout);
	});
	OnCompanyChange(); // --****** ON COMPANY CHANGE CHECK IF NEW ENTRY OR NOT
	OnPulloutChange(); // --****** ON PULLOUT CHANGE CHECK IF NEW ENTRY OR NOT
	GetVenueNameDate(); // --****** GET THE VENUE NAME AND DATE & TIME
	CheckTransactionId(); // --****** GET THE TICKET INFO BY TRANS ID
	
	$("a#dialog").serboy(); // --****** ACTIVATE DIALOG
	// --****** INPUT TEXT FOR ADDING NEW COMPANY
	$("#new_company").keydown(function(e){
		var key = e.charCode || e.keyCode || 0;
		if(key == 13) {
			var Company = $(this).val();
			var Validate = ValidateNewCompany(Company);
			if (Validate) {
				AddNewCompany();
				return true;
			} else {
				$(this).parent().find("span.error").remove();
				$(this).after("<span class='error'>Please check your company</span>");
				return false;
			}
		}
	});
	// --****** FOR ADDING NEW COMPANY, "ADD" BUTTON EVENT
	$("#Button1").click(function(){
		var Company = $("#new_company");
		var Validate = ValidateNewCompany(Company.val());
		if (Validate) {
			AddNewCompany();
			return true;
		} else {
			Company.parent().find("span.error").remove();
			Company.after("<span class='error'>Please check your company</span>");
			return false;
		}
	});
	// --****** INPUT TEXT FOR ADDING NEW PULLOUT TYPE
	$("#new_pullout").keydown(function(e){
		var key = e.charCode || e.keyCode || 0;
		if(key == 13) {
			var Pullout = $(this).val();
			var Validate = ValidateNewCompany(Pullout);
			if (Validate) {
				AddNewPulloutType();
				return true;
			} else {
				$(this).parent().find("span.error").remove();
				$(this).after("<span class='error'>Please check your pullout type</span>");
				return false;
			}
		}
	});
	// --****** FOR ADDING NEW PULLOUT TYPE, "ADD" BUTTON EVENT
	$("#Button2").click(function(){
		var Pullout = $("#new_pullout");
		var Validate = ValidateNewCompany(Pullout.val());
		if (Validate) {
			AddNewPulloutType();
			return true;
		} else {
			Pullout.parent().find("span.error").remove();
			Pullout.after("<span class='error'>Please check your pullout type</span>");
			return false;
		}
	});
	
	$("#AddTransID").click(function(){
		var Table = $(this).parent().parent().parent().parent();
		var BottomTr = $(this).parent().parent();
		var Input = Table.find('input#transid');
		
		if(Input.length > 0) {
			alert("Please check your Transaction ID");
		} else {
			BottomTr.before('<tr class="content">'+
						'<td class="content_input">'+
						'<input type="text" id="transid" name="transid" />'+
						'</td>'+
						'<td class="content_data_blank" colspan=5></td>'+
						'</tr>'
					);
			CheckTransactionId(); // --****** GET THE TICKET INFO BY TRANS ID
		}
	});
	// --****** EVENT FOR SELECT OPTION EVENT
	$("#event_id").change(function(){
		CheckIfThereisAlreadyTransactionMade();
		var Event = parseInt($(this).val());
		GetVenueNameDate(Event);
	});
	$("#include_printing").click(function(){
		var Parent = $(this).parent().parent().parent();
		if($(this).is(':checked')) {
			Parent.find('tr.remarks').toggle('slow');
		} else {
			Parent.find('tr.remarks').toggle('slow');
		}
	});
	GetVenueNameDate($("#event_id").val()); // --****** SET THE VENUE AND DATE&TIME
	// GetTicketInfoByTransactionId(44532);
});
// --****** EVENT FOR INPUT TEXT TRANSACTION ID
function CheckTransactionId() {
	$("#transid").blur(function(){
		var Done = $('#table_data').find('tr.done');
		var DoneAlready = 0;
		var transId = $(this).val();
		if(Done.length > 0) {
			var FindExisting = Done.find('span.trans_id');
			FindExisting.each(function(){
				if(transId == $(this).html() || transId == $(this).text()) {
					DoneAlready = 1;
				}
			});
		}
		
		if(isNaN(transId) || (transId < 0)) {
			$("td.content_data_blank").empty();
			$("td.content_data_blank").html("Please check your transaction ID.");
		} else if(DoneAlready > 0) {
			$("td.content_data_blank").empty();
			$("td.content_data_blank").html("Your transaction number is already exists... Please try another one.");
		} else {
			GetTicketInfoByTransactionId(transId);
		}
	});
}
// --****** EVENT FOR COMPANY SELECT OPTION
function OnCompanyChange() {
	$("#company_id").change(function(){
		var Selected = $(this).find("option:selected");
		var Parent = $(this).parent();
		if(Selected.text() == AppendCompany) {
			$(this).val('--empty--').attr('selected', 'selected');
			$("a[rel=Company]").trigger('click');
		} else if(Selected.text() != "--empty--") {
			$("#delete_company").css({"display": "inline"});
		}
	});
}
// --****** EVENT FOR PULLOUT SELECT OPTION
function OnPulloutChange() {
	$("#pullout_id").change(function(){
		var Selected = $(this).find("option:selected");
		var Parent = $(this).parent();
		if(Selected.text() == AppendCompany) {
			$(this).val('--empty--').attr('selected', 'selected');
			$("a[rel=Pullout]").trigger("click");
		} else if(Selected.text() != "--empty--") {
			$("#delete_pullout").css({"display": "inline"});
		}
	});
}
// --****** GET THE URL
function GetUrl(Counter) {
	var PageURL = window.location.href;
	var Controller = PageURL.split('/');
	var ReturnURL = "";
	for (var i = 0; i < Controller.length; i++) 
	{
		if(i <= Counter) {
			ReturnURL += Controller[i] + '/';
		}
	}
	return ReturnURL;
}
// --****** REMOVE COMPANY FROM DROPDOWN
function RemoveCompany(Value, Text, Company) {
	var URLController = GetUrl(3);
	var Parent = $("#company_id").parent();
	$.ajax({
		type: "POST",
		url: URLController + "remove_company",
		data: {"Value": Value, "Text": Text},
		// dataType: "json",
		cache: false,
		beforeSend: function() {
			Parent.find('.loading').remove();
			$("#company_id").css({"display": "none"});
			$("#delete_company").css({"display": "none"});
			Parent.append('<img src="'+GetUrl(2)+'system/application/views/images/imahe/loading15.gif" class="loading"/>');
		},
		success: function(msg) {
			Parent.find('.loading').remove();
			Company.remove();
			Company.val('--empty--').attr('selected', 'selected');
			$("#company_id").css({"display": "inline"});
			$("#delete_company").css({"display": "none"});
		},
		error: function(msg) {
			Parent.find('.loading').remove();
			$("#company_id").css({"display": "inline"});
		}
	});
}
// --****** REMOVE PULLOUT TYPE FROM DROPDOWN
function RemovePulloutType(Value, Text, Pullout) {
	var URLController = GetUrl(3);
	var Parent = $("#pullout_id").parent();
	$.ajax({
		type: "POST",
		url: URLController + "removePulloutType",
		data: {"Value": Value, "Text": Text},
		// dataType: "json",
		cache: false,
		beforeSend: function() {
			Parent.find('.loading').remove();
			$("#pullout_id").css({"display": "none"});
			$("#delete_pullout").css({"display": "none"});
			Parent.append('<img src="'+GetUrl(2)+'system/application/views/images/imahe/loading15.gif" class="loading"/>');
		},
		success: function(msg) {
			Parent.find('.loading').remove();
			Pullout.remove();
			Pullout.val('--empty--').attr('selected', 'selected');
			$("#pullout_id").css({"display": "inline"});
			$("#delete_pullout").css({"display": "none"});
		},
		error: function(msg) {
			Parent.find('.loading').remove();
			$("#pullout_id").css({"display": "inline"});
		}
	});
}
// --****** GET THE TICKET INFO BY TRANSACTION ID
function GetTicketInfoByTransactionId(transId) {
	var URLController = GetUrl(3);
	var eventId = parseInt($("#event_id").val());
	var Parent = $("input#transid").parent().parent();
	$.ajax({
		type: "POST",
		url: URLController + "getTicketInfoByTransId",
		data: {"trans_id": transId, "event_id": eventId},
		cache: false,
		beforeSend: function() {
			$("td.content_data_blank").remove();
			Parent.append('<td class="content_data_blank" colspan=5></td>');
			$("td.content_data_blank").empty();
			$("td.content_data_blank").html("Please wait...");
		},
		success: function(msg) {
			var CountRecord = 0;
			$("td.content_data_blank").remove();
			Parent.append(msg);
			
			$("td.content_data").each(function(){
				CountRecord = parseInt(CountRecord) + 1;
				$(this).removeClass("content_data");
				$(this).addClass("content_data_finished");
				$(this).parent().addClass('done');
			});

			if(CountRecord == 5) {
				Parent.find("td.content_input").find('input').remove();
				Parent.find("td.content_input").append('<span class="trans_id">'+transId+'</span>');
				$('#gen_report').css({'visibility': 'visible'});
				$('#reset_frm').css({'visibility': 'visible'});
				var QTY = Parent.find('td.qty');
				var Amount = Parent.find('td.amount');
				if(QTY.hasClass('content_data_finished')) {
					var txtqty = new String ($("#totalqty").val());
					var qty = new String (QTY.text());
					var totalqty = Number(txtqty) + Number(qty);
					
					$("#totalqty").val(totalqty);
					$("#no_of_tickets").val(totalqty);
				} if(Amount.hasClass('content_data_finished')) {
					var txtamount = new String ($("#totalamount").val());
					var amount = new String (Amount.text());
					var totalamount = Number(txtamount) + Number(amount);
					
					$("#totalamount").val(totalamount)
				}
			}
		},
		error: function(msg) {
			$("td.content_data_blank").remove();
			Parent.append('<td class="content_data_blank" colspan=5></td>');
			$("td.content_data_blank").empty();
			$("td.content_data_blank").html("Code#1. An error occured please try again later.");
		}
	});
}
// --****** VALIDATE NEW COMPANY FIRST
function ValidateNewCompany(TextBox) {
	var ValidateNewCompany = false;
	var pregMatch = /^[A-Za-z0-9\/ \-'\.\*\:\;]*[A-Za-z0-9'\.\*\:\;][A-Za-z0-9\/ \-'\.\*\:\;]*$/;
	
	if (!TextBox.match(pregMatch)) {
		ValidateNewCompany = false;
	} else {
		ValidateNewCompany = true;
	}
	return ValidateNewCompany;
}
// --****** ADD NEW COMPANY
function AddNewCompany() {
	var URLController = GetUrl(3);
	var Company = $("#new_company");
	var ExistingCompany = $("#company_id").children('option');;
	var checker = false;
	
	ExistingCompany.each(function(){
		if($(this).text() +"=="+ Company.val()) {
			checker = false;
		} else {
			checker = true;
		}
	});
	
	if(!checker) {
		$.ajax({
			type: "POST",
			url: URLController + "addNewCompany",
			data: {"company": Company.val()},
			// dataType: "json",
			cache: false,
			beforeSend: function() {
			
			},
			success: function(msg) {
				// alert(msg);
				var Selected = $("#company_id").find("option:contains('"+AppendCompany+"')");

				Selected.before('<option value="'+msg+'">'+Company.val()+'</option>');
				$('img[rel=close]').trigger('click');
			},
			error: function(msg) {
				Company.parent().find("span.error").remove();
				Company.after("<span class='error'>Code#1. An error occured please try again later!</span>");
			}
		});
	} else {
		Company.parent().find("span.error").remove();
		Company.after("<span class='error'>Company already exists!</span>");
	}
}
// --****** ADD NEW PULLOUT TYPE
function AddNewPulloutType() {
	var URLController = GetUrl(3);
	var Pullout = $("#new_pullout");
	var ExistingPullout = $("#pullout_id").children('option');;
	var checker = false;
	
	ExistingPullout.each(function(){
		if($(this).text() +"=="+ Pullout.val()) {
			checker = false;
		} else {
			checker = true;
		}
	});
	
	if(!checker) {
		$.ajax({
			type: "POST",
			url: URLController + "addNewPulloutType",
			data: {"pullout": Pullout.val()},
			// dataType: "json",
			cache: false,
			beforeSend: function() {
			
			},
			success: function(msg) {
				// alert(msg);
				var Selected = $("#pullout_id").find("option:contains('"+AppendCompany+"')");

				Selected.before('<option value="'+msg+'">'+Pullout.val()+'</option>');
				$('img[rel=close]').trigger('click');
			},
			error: function(msg) {
				Pullout.parent().find("span.error").remove();
				Pullout.after("<span class='error'>Code#1. An error occured please try again later!</span>");
			}
		});
	} else {
		Pullout.parent().find("span.error").remove();
		Pullout.after("<span class='error'>Pullout type already exists!</span>");
	}
}
// --****** GET VENUE NAME AND DATE & TIME
function GetVenueNameDate(Event) {
	var URLController = GetUrl(3);
	CheckIfThereisAlreadyTransactionMade();
	var Event = parseInt(Event);
	if(Event > 0) {
		$.ajax({
			type: "POST",
			url: URLController + "GetVenueNameDateTime",
			data: {"event": Event},
			dataType: "json",
			cache: false,
			beforeSend: function() {
				$("span.venue_name").empty();
				$("span.venue_datetime").empty();
			},
			success: function(msg) {
				$("span.venue_name").html(msg.venue);
				$("#hid_vname").val(msg.venue2);
				$("span.venue_datetime").html(msg.datetime);
				
				var d = new Date(msg.datetime);
				var curr_date = d.getDate();
				var curr_month = d.getMonth() + 1; //Months are zero based
				var curr_year = d.getFullYear();
				
				$("#hid_vdate").val(msg.datetime2);
			},
			error: function(msg) {
				$("span.venue_name").empty();
				$("span.venue_datetime").empty();
			}
		});
	}
}
function CheckIfThereisAlreadyTransactionMade() {
	var Done = $('#table_data').find('tr.done');
	var BottomTr = $('#table_data').find('tr.bottom');
	var Input = $('#table_data').find('tr.content').find('td.content_input').find('input#transid');
	
	if(Done.length > 0) {
		var answer = confirm("Are you sure you want to change the event. \n If you change this the transaction you made will be clear.")
		if (answer){
			Done.remove();
			var URLController = GetUrl(3);
			$.post(URLController + "ClearTempData"); // --****** CLEAR THE TEMP DATA
			if(Input.length <= 0) {
				BottomTr.before('<tr class="content">'+
					'<td class="content_input">'+
					'<input type="text" id="transid" name="transid" />'+
					'</td>'+
					'<td class="content_data_blank" colspan=5></td>'+
					'</tr>'
				);
				CheckTransactionId(); // --****** GET THE TICKET INFO BY TRANS ID
			}
			$("#totalqty").val('');
			$("#totalamount").val('');
			$("#no_of_tickets").val('');
			$('#gen_report').css({'visibility': 'hidden'});
			$('#reset_frm').css({'visibility': 'hidden'});
			$('#transid').val('');
			$('td.content_data_blank').empty();
		}
	}
}
/* ************************************************** NEW JAVASCRIPT ************************************************** */	