<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="index, follow">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="description" content="SM Tickets Queue">
    <meta name="author" content="SM Tickets">
    <title>SM Tickets Queue</title>
	
	<!-- CSS / Stylesheet -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" integrity="sha256-NuCn4IvuZXdBaFKJOAcsU2Q3ZpwbdFisd5dux4jkQ5w=" crossorigin="anonymous" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha256-916EbMg70RQy9LHiGkXzG8hSg9EdNy97GazNG/aiY1w=" crossorigin="anonymous" />
	<!-- CSS - END -->
	
	<style>
		html, body {
			width: 100%;
			height: 100%;
		}
		#center-all {
			position: fixed;
			top: 30%;
			transform:translateY(-50%);
			left: 50%;
			transform:translateX(-50%);
			z-index:1031;
		}
	</style>
	
	
</head>

<body>	
	<div class="container-fluid" id="main_container" style="background-color:gray;">
		<div class="text-center" id="center-all">
			<!--<span class="fa fa-spinner fa-pulse fa-3x fa-fw" aria-hidden="true" ></span>-->
			<div class="row">
				<h1 class="visible-lg" style="color:white;"><?php echo $event['event_title']; ?></h1>
				<h2 class="visible-md" style="color:white;"><?php echo $event['event_title']; ?></h2>
				<h3 class="visible-sm visible-xs" style="color:white;"><?php echo $event['event_title']; ?></h3>
			</div>
			<div class="row">
				<div class="col-md-8 col-md-offset-2 col-sm-10 col-sm-offset-1">
					<div class="form-group">
					  <input type="text" class="form-control input-lg text-center" name="ticket_id" id="ticket_id" placeholder="INPUT TICKET ID" autocomplete="off" />
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-sm-6 col-sm-offset-3 col-xs-10 col-xs-offset-1">
					<div class="form-group">
						<button class="btn btn-block btn-lg btn-danger" id="btn_submit" type="button" disabled>SUBMIT</button>
					</div>
				</div>
			</div>
		</div>
	</div>
	
	
	<!-- JS Scripts -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js" integrity="sha256-hwg4gsxgFZhOsEEamdOYGBf13FyQuiTwlAQgxVSNgt4=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha256-U5ZEeKfGNOja007MMD3YBI0A3OSZOQbeG6z2f2Y0hu8=" crossorigin="anonymous"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/mouse0270-bootstrap-notify/3.1.7/bootstrap-notify.min.js" integrity="sha256-LlN0a0J3hMkDLO1mhcMwy+GIMbIRV7kvKHx4oCxNoxI=" crossorigin="anonymous"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.bootstrapvalidator/0.5.3/js/bootstrapValidator.min.js" integrity="sha256-PbFF1Mdg86urwOYXWNJPP4z5Ge9KLp6KXX1NURQY8Ho=" crossorigin="anonymous"></script>
	<!-- JS End -->
	
	<script>
		$(document).ready(function(){
			
			var regExp = /[a-z]/i;
			
			fixed_frame_height("#main_container");
			
			$("body").on("keyup keypress change", "#ticket_id", function(e){
				$(this).val($(this).val().replace(/\s+/g, '').trim());					
				
				var value = String.fromCharCode(e.which) || e.key;

				if (regExp.test(value)) {
					e.preventDefault();
					return false;
				}
				
				if($(this).val() == ''){
					$("#btn_submit").prop("disabled",true);
				}else{
					$("#btn_submit").prop("disabled",false);
				}
			});
			
			$("body").on("click", "#btn_submit", function(e){
				id = $("#ticket_id").val();
				// console.log(id);
				if(id != ''){
					$.post("<?php echo base_url(); ?>queue/check_ticket/"+id+"/<?php echo $event['event_id'];?>",function(data){
						console.log(data);
						if(data == true){
							notify("fa fa-check-circle","Success!","Please wait to download your queue voucher.","success");
							// popup = window.open('<?php echo base_url(); ?>queue/view_voucher/'+id+'/<?php echo $event['event_id'];?>', '_blank');
							window.location = '<?php echo base_url(); ?>queue/view_voucher/'+id+'/<?php echo $event['event_id'];?>';
							$("#ticket_id").val("");
							$("#btn_submit").prop("disabled",true);
						}else{
							notify("fa fa-times-circle","Error!","Ticket id is incorrect. Please try again.","danger");
							$("#ticket_id").val("");
							$("#btn_submit").prop("disabled",true);
						}
					});
				}else{
					notify("fa fa-exclamation-circle","Warning!","Please input ticket id.","warning");
				}
			});
	
		});
		
		function fixed_frame_height(id){
			// id -> id name of the container
			$(id).css({ height: ($(window).innerHeight()) });
			$(window).resize(function(){
				$(id).css({height: ($(window).innerHeight())});
			});
		}
		
		
		function notify(icon_,title_,message_,type_){
			$.notify({
				//options
				icon: icon_,
				title: '<strong>'+title_+'</strong>',
				message: message_,
			},{
				//settings
				type: type_,
				offset: {
					y: 75
				},
				allow_dismiss: false,
				newest_on_top: true,
				delay: 2000,
				timer: 1000,
				placement: {
					from: "top",
					align: "center"
				}
			});
		}
	</script>
</body>
</html>