<?php

class Events extends Controller {

	function Events()
	{
		parent::Controller();	
		$this->load->model('events_model', 'events');
		$this->load->model('venue_model', 'venue');
		$this->load->model('sections_model', 'sections');
		$this->load->model('prices_model', 'prices');
		$this->load->model('promos_model', 'promos');
		date_default_timezone_set('Asia/Manila');
	}
	
	function index()
	{
		$this->home();
	}
	
	function home(){
		$data['site_title'] = "SMTICKETS - Home";
		
		
		
		
		
		// $hot_events = $this->events->get_hot_events_2(10);
		
		$hot_events_string = $this->events->getEventIDs();
		
		// $hot_events_string = false;
		
		// echo "<pre>";
		// print_r($hot_events_string);
		// echo "</pre>";
		// die();
		

		// if($hot_events){
			
			// if(isset($hot_events["selection_count"])){
				// $hot_events_string =  $hot_events["event_id"];
			// }else{
				// foreach($hot_events as $hot_event){
					// $hot_events_string = $hot_events_string . " " . $hot_event["event_id"];
				// }
			// }
		// }
	
		// echo "hot_events_string: " . $hot_events_string;
		// die();
		
		
		// $hot_events_string = "3813 3751 3511 3636 3637 3588 " . str_replace("3511","",$hot_events_string);
		$data['hot_events'] = trim($hot_events_string);
		$data['new_events'] = $this->events->get_new_events(12);
		$data['just_announced'] = $this->events->get_just_announced_events(12);

		$this->load->view('home',$data);
		//$this->load->view('maintenance');
	}
	
	
	function hotEVents(){
		
		$hot_events = $this->events->get_hot_events_2(12);
		echo $hot_events;
		die();
	}
	
	function home2(){
		$data['site_title'] = "SMTICKETS - Home";
		$data['new_events'] = $this->events->get_new_events(12);
		
		$this->load->view('home2',$data);
	}
	
	function listing($category=false){		

		$data['hot_events'] = "";
		$data["events"] = $this->events->getEventsForListing($category);
		$this->load->view('event_listing',$data);
	}
	
	function search($match=false){	
		$data['hot_events'] = "";	
		$data["events"] = $this->events->getEventsForListing(false,$match);
		$this->load->view('event_listing',$data);
	}

	function venue($venue_id=false) {
		$data['hot_events'] = "";
		$data["events"] = $this->events->getEventsForListing(false,false,false,$venue_id);
		$this->load->view('event_listing',$data);
	}
	
	function venue_events($venue_id=false,$limit=false) {
		$data['hot_events'] = "";
		$data["element"] = json_encode($this->events->getEventsForVenue($venue_id,$limit));
			
		print_r($data["element"]);
		
		
	}

	function venue_count($limit=false) {
	
	
		/* echo "<pre>";
		print_r(json_encode($this->events->get_venue_count($limit)));
		echo "</pre>";
		die(); */
		$data['hot_events'] = "";
		$result = json_encode($this->events->get_venue_count($limit));
		print_r($result);
	}
	
	function view($event_id = false,$referrer = false ){
				
		$data['referrer'] = $referrer;
		
		$data['hot_events'] = "";
		if ($event_id=="undefined") {
			$this->load->view("error_page");
		}else{
			$data['site_title'] = $this->config->item("site_title");		
			$data["event"] = $this->events->get($event_id);
		
			if($data["event"]){
					$data["event"]['event_venue_name'] = $this->venue->get($data["event"]['event_venue_id']); 
					$data["sections"] = $this->sections->get($event_id);	
					$data["prices"] = $this->prices->get($event_id);
					
					if(!$data["event"]["convenience_charge"]){
						$data["event"]["convenience_charge"] = 0;
					}
					
				$data["event_siblings"] = $this->get_events_by_long_title($data["event"]["event_long_title"],1);
			}else{
				redirect(base_url());
			}
			
			
			
			
			
			$this->load->view('event_page',$data);
		}
	}
	
	function open(){
		
		$event_id =  $this->input->get_post("id");
		$referrer =  $this->input->get_post("ref");
		
		$this->view($event_id,$referrer);
	}
	
	
	function get_events_by_parent($event_id = false) {
	
		$data['hot_events'] = "";
	
		echo json_encode(	$this->events->get_events_by_parent($event_id)	);
		die();

	}
	
	function get_events_by_long_title($event_long_title = false,$json=false) {
	
		$data['hot_events'] = "";
	if($json){
		return json_encode(	$this->events->get_events_by_long_title($event_long_title)	);
		
	}else{
		return $this->events->get_events_by_long_title($event_long_title);
	}
		

	}
	
	
	function registration(){
		$data['hot_events'] = "";
		$data['site_title'] = $this->config->item("site_title");		
		$this->load->view('registration',$data);
	}
	
	function view_article_1() {
	
		$this->load->view('article_page_1');
	
	}
	function view_article_2() {
	
		$this->load->view('article_page_2');
	
	}
	function view_article_3() {
	
		$this->load->view('article_page_3');
	
	}
	
	function view_article_4(){

		$this->load->view('article_page_4');
	}
	
	
/* 	function get_promos(){
		
		$event_id =  $this->input->get_post("event_id");
		$price_id =  $this->input->get_post("price_id");
		
		if(!trim($event_id)){
			$event_id = "x";
		}
		
		if(!trim($price_id)){
			$price_id = "x";
		}
		
		$promos = $this->promos->get_promos($event_id,$price_id);
		
		// echo "<pre>";
		// print_r($promos);
		// echo "</pre>";

		// $js_array = '[';
		// foreach($promos as $promo){
			// $js_array = $js_array . '[' . $promo["price_id"]  . ' , ' . $promo["ticket_type_id"]  . ' , ' . $promo["event_id"]  . ' , "' . $promo["pin_set"]  . '" , "' . $promo["usage"]  . '"],';
		// }
		// $js_array = $js_array . "]";	
		return $promos;
	}
		 */
	function getEventIDs(){		
		$eventIDs = $this->events->getEventIDs();
		$events = false;
		foreach($eventIDs as $ID){
			$events = $events . $ID . " ";
		}
			return 	$events;
	}
	
	//FOR AJAX  CALLS ++++++++++++++++++++++++++++++++++
	function getEventDatesbyLongTitle(){
		$long_title = $this->input->get_post("long_title");
		$event_array = $this->events->getEventsForListing(false,false,urlencode($long_title));
		echo json_encode($event_array);	
	}
	
	function getEventsforQuickBuy(){
		
			$all_events = $this->events->getEventsForListing();
	
			// echo "<option selected='selected'>select event..</option>";
				// foreach($all_events as $e){
					// $event_id = $e['event_id'];
					// $event_title = $e['event_title'];
					// $event_long_title = $e['event_long_title'];
					// echo "<option event_id='$event_id' event_long_title='$event_long_title'>$event_title</option>";
				// }
				
				echo json_encode($all_events);
	}
	
	function check_promo(){
		
		$promo_code = $this->input->post("promo_code");
		echo $promo_code;
		
		echo "success";
	}
	
}

/* End of file welcome.php */
/* Location: ./system/application/controllers/welcome.php */