<?php 

  // $url = 'https://10.141.23.46:22633/'; 
 $url = BASE_URL();


// include pdf libraries
require(APPPATH.'/libraries/lib_pdf/fpdf/fpdf.php');

class PDF extends fpdf
{
	var $width_col_r = 220;
	//Page header
	

	//********************************* STYLES ******************************************
	
	function coloredHeaderCell($text,$x,$y,$length = false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','',7);
		$this->SetTextColor(255, 255, 255);
		$this->SetFillColor(95,95,95);
		if(!$length){
		$length = 261;
		}
		$this->Cell($length,10,$text,0,0,'C',1);
	}
	
	function boldText($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',8);
		$this->SetTextColor(0, 0, 0);
		if(!$allign){
		$allign = 'L';;
		}
		$this->MultiCell(100,10,$text,'',$allign);	
	}		
	
	function Header1($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',12);
		$this->SetTextColor(0, 0, 0);
		if(!$allign){
		$allign = 'L';;
		}
		$this->MultiCell(220,10,$text,'',$allign);	
	}
	
	function Header1L($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',14);
		$this->SetTextColor(0, 0, 0);
		if(!$allign){
		$allign = 'L';;
		}
		$this->MultiCell(210,10,$text,'',$allign);	
	}
	
	function Header1B($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',14);
		$this->SetTextColor(0, 0, 0);
		if(!$allign){
		$allign = 'R';;
		}
		$this->MultiCell(392,10,$text,'',$allign);	
	}
	
	function Header2($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',10);
		$this->SetTextColor(0, 0, 0);
		if(!$allign){
		$allign = 'L';;
		}
		$this->MultiCell(220,10,$text,'',$allign);	
	}
	
	function SubHeader1($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','',7);
		$this->SetTextColor(0, 0, 0);
		
		if(!$allign){
		$allign = 'L';;
		}
		$this->MultiCell(220,10,$text,'',$allign);
	}	
	
	function SubHeader1B($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',9);
		$this->SetTextColor(0, 0, 0);
		
		if(!$allign){
		$allign = 'L';;
		}
		$this->MultiCell(220,10,$text,'',$allign);
	}
	
	function SubHeader2($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','',7);
		$this->SetTextColor(0, 0, 0);
		
		if(!$allign){
		$allign = 'R';;
		}
		$this->MultiCell(250,10,$text,'',$allign);
	}
	
	function SubHeader3($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','',7);
		$this->SetTextColor(0, 0, 0);
		
		if(!$allign){
		$allign = 'R';;
		}
		$this->MultiCell(362,10,$text,'',$allign);
	}
	
	function SubHeader4($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',7);
		$this->SetTextColor(0, 0, 0);
		
		if(!$allign){
		$allign = 'L';;
		}
		$this->MultiCell(220,10,$text,'',$allign);
	}
	
	//*************************************************************************************

	function Header()
	{

	// voucher
	// $this->SetTextColor(95, 95, 95);
	// $this->SetXY(165,37);
	// $this->SetFont('Arial','B',25);
	// $this->Cell(100,20,'CLAIM TICKET VOUCHER',0,0,'C');
	
	//Logo

	// $this->Image('resources/images/logo.jpg',480,10,100);
	
	
	
	}
	
	//Page footer
	function Footer()
	{
		$this->SetTextColor(255, 255, 255);
		//Position at 1.5 cm from bottom
		$this->SetY(-15);
		//Arial italic 8
		$this->SetFont('Arial','I',8);
		//Page number
		$this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
		
	}


}

//Instantiation of inherited class
$pdf=new PDF('P', 'pt', 'Letter');
$pdf->AliasNbPages();
$pdf->SetAutoPageBreak(true,0);	

foreach($tickets as $ticket) {
	$pdf->AddPage('P','Letter');
	
	// Ticket Document Background Image - Size: 612x792 @ 72 ppi //
	$pdf->Image($this->config->item('smtickets_image_link').'images/ticket_bg.jpg',0,0,612);
	
	// $items is list holder of item nodes
	if(isset($ticket['item']['@attributes'])){
		$items[] = $ticket['item'];
	} else {
		$items  = $ticket['item'];
	}
	
	foreach($items as $item) {
		
		$type = $item['@attributes']['type'];
		if(isset($item['@content'])) {
			$content = $item['@content'];
		}
				
		$format = '';
		if(isset($item['@attributes']['format'])) {
			$format = $item['@attributes']['format'];
		}			

		$x = $item['@attributes']['x'];
		$y = $item['@attributes']['y'];
		
		// $w = 0;
		if(isset($item['@attributes']['w'])) {
			$w= $item['@attributes']['w'];
		}
			
		// $h = 0;
		if(isset($item['@attributes']['h'])) {
			$h = $item['@attributes']['h'];
		}
		
		$align = '';
			if(isset($item['@attributes']['align'])) {
			$align= $item['@attributes']['align'];
		}
		
		if($type == "textarea"){
			switch($y){
				case 32: $pdf->Header2($content,10,590,'C'); break;
				case 38: $pdf->SubHeader1($content,10,600,'C'); break;
				case 42: $pdf->SubHeader1($content,10,620,'C'); break;
				case 46: $pdf->SubHeader1($content,10,630,'C'); break;
				case 60: $pdf->Header1($content,10,650); break; //Name of the Event	
				case 73: $pdf->Header1($content,10,673); $pdf->Header1L($content,40,310); break; // Name of the Section
				case 86: $pdf->Header1($content,10,696); $pdf->Header1L($content,40,333); break; // Name of the Seat
				case 112: $pdf->SubHeader1($content,240,696); break;
				case 116: $pdf->SubHeader1($content,240,704); break;
				case 117: $pdf->Header1($content,10,719); $pdf->Header1L($content,40,356); break; //Ticket Price
				case 124: $pdf->SubHeader2($content,10,369); break;
				case 129: $pdf->SubHeader2($content,10,379);
			}
			if(($y == 68) and ($align == "R")){
				$pdf->SubHeader1B($content,10,662,'R'); //Section ID
			}
			if(($y == 81) and ($align == "R")){
				$pdf->SubHeader1B($content,10,685,'R'); //Seat ID
			}
			if(($y == 94) and ($align == "L")){
				$pdf->SubHeader1($content,10,709);
				$pdf->SubHeader1($content,10,346);
			}
			if(($y == 99) and ($align == "R")){
 
				$pdf->Header1($content,10,719,'R'); //Transaction ID
			}
			
		}
		
		if(($type == 'image') and (@GetImageSize($content))) {
			if($y == 3){
				// Event Ticket Logo - Size: 340x180 @ 72 ppi //
				if (empty($format)) {
					$pdf->Image($content, 10, 100, 340, 180);
				} else {
					$pdf->Image($content, 10, 100, 340, 180, $format);
				}
			}
			if($y == 94){
				// QR Code Image - Size: 80x80 @ 72 ppi //
				if (empty($format)) {
					$pdf->Image($content, 270, 300, 80, 80);
				} else {
					$pdf->Image($content, 270, 300, 80, 80, $format);
				}
			}
			if($y == 144.5){
				// Event Ticket Logo LGU - Size: 362x101 @ 72 ppi //
				if (empty($format)) {
					$pdf->Image($content, 240, 590, 362, 101);
				} else {
					$pdf->Image($content, 240, 590, 362, 101, $format);
				}
			}
			if($y == 195){
				// Bar Code Image - Size: 232x25 @ 72 ppi //
				if (empty($format)) {
					$pdf->Image($content, 370, 696, 232, 25);
				} else {
					$pdf->Image($content, 370, 696, 232, 25, $format);
				}
			}
		}
	}	
		
		
		$pdf->SubHeader1('SECTION',10,300);
		$pdf->SubHeader1('ROW - SEAT',10,323);

		// Right Side Sponsor Ad - Size: 242x288 @ 72 ppi //
		$pdf->Image($this->config->item('smtickets_image_link').'images/sponsor_ad.jpg',360,100,242,288);
		
		// Marketing Ad - Size: 592x114 @ 72 ppi //
		$pdf->Image($this->config->item('smtickets_image_link').'images/marketing_ad.jpg',10,398,592,114);
		
		$pdf->ColoredHeaderCell('Terms and Conditions - Print at Home Ticketing',10,520,592); 
		
		$long_text = "The barcode only allows one entry per scan. Unauthorized duplication or sale of this ticket may prevent your admittance to the event. Keep this ticket in a safe place as you would money or regular tickets. SM tickets is not responsible for any inconvenience caused by anauthorized duplication. In the event that duplicate copies appear, the facility reservers the right to refuse entry to all ticket holders and may credit the original purchaser the face value which will constitute full renumeration. The event date and time is subject to change without notice.";
		
		$pdf->SetXY(10,530);
		$pdf->SetFont('Arial','',8);
		$pdf->SetTextColor(0, 0, 0);
		$pdf->SetFillColor(255, 255, 255);
		$pdf->MultiCell(592,10,$long_text,'','J',1);
		
		$pdf->SubHeader1('EVENT',10,640);
		$pdf->SubHeader1('SECTION',10,663);
		$pdf->SubHeader1('ROW - SEAT',10,686);
		$pdf->SubHeader1('TRANSACTION ID',10,709,'R');

		$pdf->SubHeader3('Buyers Information:',240,725,"L");
		$pdf->SubHeader3('Name: __________________________ Address:_______________________________ TIN:_________________',240,735,"L");
		$pdf->SubHeader3('THIS DOCUMENT IS NOT VALID FOR CLAIM OF INPUT TAX',240,745);
		$pdf->SubHeader3('THIS INVOICE/RECEIPT SHALL BE VALID FOR FIVE(5) YEARS FROM THE DATE OF PERMIT TO USE',240,755);
		
		//SECTION PRICE
		if (isset($testmode) && $testmode) {
			$price = $items[15]['@content'];
		}else{
			$price = $items[14]['@content'];
		}
		
		//sales breakdown 
		$price = floatval(preg_replace("/[^-0-9\.]/","",$price));
		$net = $price;
		$percent = $event->tax * 100;
				
		$basic = $net / (($percent + 100)/ 100);
		$totalTax = $basic * $event->tax;
				
				
		$pdf->SubHeader4('BASIC',10,736);
		$pdf->SubHeader4(number_format($basic,2),10,736,'R');
		$pdf->SubHeader4($percent . '% AMUSEMENT TAX',10,744);
		$pdf->SubHeader4(number_format($totalTax,2),10,744,'R');
		$pdf->SubHeader4('TICKET PRICE',10,752);
		$pdf->SubHeader4(number_format($net,2),10,752,'R');	 
		
	
}		
			

	$pdf->Output();
$pdf->Close();










