<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Ticksections_model extends Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $sections = 'sections se';
	var $prices = 'prices pc';
	var $tickets = 'tickets ti';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	function Ticksections_model()
	{
		parent::Model();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_venue
	 *
	 * @access	public
	 */
	function get($section_id)
	{
		$this->db->where('section_id', $section_id);
		$query = $this->db->getwhere($this->sections);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
		function get_latest_section($seatplan_id = false)
	{

		$this->db->order_by('section_id', 'desc'); 
		$this->db->limit(1);
		$this->db->where('section_seatplan_id', $seatplan_id);
		$query = $this->db->get($this->sections);
		return $query->row();
	}
	
	
	/**
	 * get_sections
	 *
	 * @access	public
	 */
	function get_sections($seatplan_id)
	{
		$this->db->where('section_seatplan_id', $seatplan_id);
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
		return $query->result();
	}
	
	function get_section_ids_array($seatplan_id)
	{
		$this->db->select('section_id'); 
		$this->db->where('section_seatplan_id', $seatplan_id);
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections)->result();
		$arr_sid = array();
		foreach($query as $section) {
			$arr_sid[] = $section->section_id;
		}
		// return $query->result_array();
		return $arr_sid;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_section_type
	 *
	 * @access	public
	 */
	function get_section_type($sections)
	{
		/*$this->db->where('section_seatplan_id', $seatplan_id);
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
		return $query->result();*/
		
		$sections = unserialize($sections);
		
		//print_array($sections);
		
		if (is_array($sections))
		{
			$section = $this->get($sections[0]);
			return $section->section_type;
		}
		else
			return false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_sections_dropdown
	 *
	 * @access	public
	 */
	function get_sections_dropdown($seatplan_id)
	{
		$this->db->where('section_seatplan_id', $seatplan_id);
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->section_id] = $r->section_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	//Get all used sections
	function get_unique_sections_dropdown($seatplan_id=false, $used=false)
	{
		
		$this->db->where('section_seatplan_id', $seatplan_id);		
		if($used)
		$this->db->where_not_in('section_id', $used);
 		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->section_id] = $r->section_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_available_tickets
	 *
	 * @access	public
	 */
	function get_available_tickets($sections)
	{
		$this->db->select('sum(section_available) as total_available');
		$this->db->where_in('section_id', unserialize($sections));
		$query = $this->db->getwhere($this->sections);
		//echo $this->db->last_query();
		
		$row = $query->row();
		return $row->total_available;
	}
	
	function get_seat_type($sections, $unserialize = false)
	{
		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (is_array($arr_sections))
		{
			$section = $this->get($arr_sections[0]);
			// if (count($section) > 0) {
				return $section->section_type;
			// } else { return false; }
		}
		else
			return false;
	}
	
	
	function get_ticket_availability_sections($sections, $seatplan_id = false, $unserialize = false)
	{
		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (empty($arr_sections)) { return array(); }
		
		foreach($arr_sections as $section_id) {
			$price_section_info['used'][$section_id] = 0;
			$price_section_info['capacity'][$section_id] = 0;
			$price_section_info['available'][$section_id] = 0;
			$price_section_info['available_db'][$section_id] = 0;
			$price_section_info['reserved'][$section_id] = 0;
			$price_section_info['type'][$section_id] = "";
		}
		
		// get capacity and default availability
		$this->db->select('section_id, section_capacity, section_type, section_available');
		$this->db->where_in('section_id', $arr_sections);
		$this->db->where('section_seatplan_id', $seatplan_id);
		
		$query = $this->db->getwhere($this->sections);

		// filter out non-existingg section_id
		$arr_sections = array();
		foreach($query->result() as $row) {
			$section_id = $row->section_id;
			$arr_sections[] = $section_id;
			$capacity = $row->section_capacity;
			$price_section_info['capacity'][$section_id] = $capacity;
			
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] = $capacity; 
			$price_section_info['type'][$section_id] = $row->section_type; 
			$price_section_info['available_db'][$section_id] = $row->section_available;
		}
		
		if (!empty($arr_sections)) {
			// get taken value
			$this->db->select('ticket_section_id, count(ticket_id) as taken');
			$this->db->where_in('ticket_section_id', $arr_sections);
			$this->db->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			$this->db->group_by('ticket_section_id');
			$query = $this->db->getwhere($this->tickets);
			
			foreach($query->result() as $row) {
				$section_id = $row->ticket_section_id;
				$count_used = $row->taken;
				$price_section_info['used'][$section_id] = $count_used;
				$total_capacity = $price_section_info['capacity'][$section_id];
				$price_section_info['available'][$section_id] = $total_capacity - $count_used;
			}

			// get ticket count of reserved seats
			$this->db->select('ticket_section_id, count(ticket_id) as reserved');
			$this->db->where_in('ticket_section_id', $arr_sections);
			$this->db->where_in('ticket_status', array('reserved'));
			$this->db->group_by('ticket_section_id');
			$query = $this->db->getwhere($this->tickets);
			
			foreach($query->result() as $row) {
				$section_id = $row->ticket_section_id;
				$count_reserved = $row->reserved;
				$price_section_info['reserved'][$section_id] = $count_reserved;
			}
			return $price_section_info;
		} else {
			return array();
		}

	}

	function get_ticket_availability($sections, $seatplan_id = false, $unserialize = false, $breakdown = false) {
		$ret = $this->get_ticket_availability_sections($sections, $seatplan_id, $unserialize);
		
		if (empty($ret)) { 
			return array(
					'total_capacity' => 0
					, 'total_used' => 0
					, 'total_reserved' => 0
					, 'total_available' => 0
					, 'total_available_db' => 0
					, 'type' => 'N/A'
				); 
		}

		$type = current($ret['type']);

		if ($breakdown) {
			$section_info = $ret;
		}
		
		$section_info['total_capacity'] = array_sum($ret['capacity']);
		$section_info['total_used'] = array_sum($ret['used']);
		$section_info['total_reserved'] = array_sum($ret['reserved']);
		$section_info['total_available'] = array_sum($ret['available']);
		$section_info['total_available_db'] = array_sum($ret['available_db']);
		$section_info['type'] = $type; 

		return $section_info;
	}
		// --------------------------------------------------------------------
	
	/**
	 * get_section_names
	 *
	 * @access	public
	 */
	function get_section_names($seatplan_id)
	{	
		$array = array();
		
		$this->db->where('section_seatplan_id', $seatplan_id);
		$query = $this->db->get($this->sections);
			
		$result = $query->result();

		if ($result)
		{
			foreach($result as $r)
				$array[$r->section_id] = $r->section_name;

			return $array;
		}
		else
			return false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_selected_section_names
	 *
	 * @access	public
	 */
	function get_selected_section_names($seatplan_id, $sections)
	{	
		$array = array();
		
		if (!$sections)
		{
			return false;
		}
		
		$this->db->where('section_seatplan_id', $seatplan_id);
		$query = $this->db->get($this->sections);
			
		$result = $query->result();

		if ($result)
		{
			// transform result to csv
			$sections = unserialize($sections);

			if ($sections) 
			{
				foreach($result as $r)
				{
					if (in_array($r->section_id, $sections))
						$array[$r->section_id] = $r->section_name;
				}
				
				return $array;
			}
			else
				return false;
		}
		else
			return false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add($seatplan_id)
	{
		$fields = array(
			'section_code'				=> $this->input->post('section_code'),
			'section_name'				=> $this->input->post('section_name'),
			'section_type'				=> $this->input->post('section_type'),
			'section_seatplan_id'		=> $seatplan_id,
			'section_capacity'			=> $this->input->post('section_capacity'),
			'section_stage_location'	=> $this->input->post('section_stage_location'),
			'section_available'			=> $this->input->post('section_capacity'),
			'section_coords'			=> $this->input->post('section_coords'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('sections');
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($section_id)
	{
		$fields = array(
			'section_code'				=> $this->input->post('section_code'),
			'section_name'				=> $this->input->post('section_name'),
			'section_type'				=> $this->input->post('section_type'),
			'section_capacity'			=> $this->input->post('section_capacity'),
			'section_stage_location'	=> $this->input->post('section_stage_location'),
			'section_available'			=> $this->input->post('section_available'),
			'section_coords'			=> $this->input->post('section_coords'),
		);
		
		// update db
		$this->db->where('section_id', $section_id);
		$this->db->update($this->sections, $fields);
		//echo $this->db->last_query();
		return true;
	}
	
	// --------------------------------------------------------------------


	/**
	 * generate section name
	 *
	 */
	function exec_query($querystring)
	{
		$query = $this->db->query($querystring);
				$row = $query->row();
	
	return $row->section_name;
	}
	
	function generate_section_name($section_id)
	{	
		$section_name = false;
		$new_section_name = false;
		$highest_section_name = false;	
		$increment = false;
		
		$section_name = $this->exec_query("SELECT section_name FROM (`sections` se)
										WHERE section_id = " . $section_id);
		
		if(substr($section_name,-2, -1) == "-")
		{
			$highest_section_name = $this->exec_query("SELECT section_name FROM (`sections` se)
									WHERE `section_name` LIKE '". substr($section_name,0,-3) ."%'
									ORDER BY section_name DESC
									LIMIT 1");
																		
			$increment = substr($highest_section_name,-1);
			$increment = $increment + 1;
			
		$new_section_name = substr($section_name,0,-2) . "-" . $increment;
		// $new_seatplan_name =  $counter + 1;
		//echo $new_section_name;
		}
		else
		{
			$highest_section_name = $this->exec_query("SELECT section_name FROM (`sections` se)
									WHERE `section_name` LIKE '". $section_name ."%'
									ORDER BY section_name DESC
									LIMIT 1");
				
				if(substr($highest_section_name,-2,-1) == "-")
				{
					$increment = substr($highest_section_name,-1);
					$increment = $increment + 1;
					$new_section_name = substr($highest_section_name,0,-2) . "-" . $increment;
				}
				else
				{
					$new_section_name = $section_name . "-1";
				}
		}
		return $new_section_name;
	}
	
	/**
	 * copy section function
	 *
	 */
	function copy_section($section_id)
	{	
		$section_new_name = $this->generate_section_name($section_id);
		
		// copy the duplicated section into sections db
		
		$new_section_id = $this->db->insert_id();
		$sql = "insert into sections(section_seatplan_id, section_code, section_name, section_type, section_stage_location, section_seat_config, 
									 section_row_from, section_row_to, section_row_increment, section_col_from, section_col_to,
									 section_col_increment, section_row_aisles, section_col_aisles, section_capacity,
									 section_available) 
									 SELECT section_seatplan_id, section_code, '". $section_new_name . "', section_type, section_stage_location, section_seat_config,
									 section_row_from, section_row_to, section_row_increment, section_col_from, section_col_to,
									 section_col_increment, section_row_aisles, section_col_aisles, section_capacity,
									 section_available
									 FROM sections
									 WHERE section_id = " .  $section_id;
		$this->db->query($sql, array($new_section_id, $section_id));
		return $new_section_id;
	}
	// --------------------------------------------------------------------
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_seats
	 *
	 */
	function edit_seats($section_id)
	{
		// reconstruct the array
		foreach ($this->input->post('seat') as $seat_row => $seat_cols)
		{
			foreach ($seat_cols as $seat_col)
			{
				$values = explode('|', $seat_col);
				$seat_config[$seat_row]['C'.$values[0]] = $seat_row.'|C'.$seat_col;
			}
		}

		$fields = array(
			'section_seat_config'		=> serialize($seat_config),
			'section_row_from'			=> $this->input->post('row_from'),
			'section_row_to'			=> $this->input->post('row_to'),
			'section_row_increment'		=> $this->input->post('row_increment'),
			'section_col_from'			=> $this->input->post('col_from'),
			'section_col_to'			=> $this->input->post('col_to'),
			'section_col_increment'		=> $this->input->post('col_increment'),
			'section_row_aisles'			=> $this->input->post('row_aisles'),
			'section_col_aisles'			=> $this->input->post('col_aisles'),
		);
		
		// update db
		$this->db->where('section_id', $section_id);
		$this->db->update($this->sections, $fields);
		//echo $this->db->last_query();
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_seat_names
	 *
	 */
 	function edit_seat_names($section_id)
	{
		$rheads = $this->input->post('row_heads');
		$cheads = $this->input->post('col_heads');
		// echo '<pre>';
		// print_r($cheads);
		// echo '</pre>';
		// die();
 		// echo '<pre>';
		// print_r($this->input->post('seat'));
		// echo '</pre>';
		// die();
		// reconstruct the array
		foreach ($this->input->post('seat') as $seat_row => $seat_cols)
		{
			foreach ($seat_cols as $seat_key => $seat_col)
			{
				if ($seat_col)
				{
				// echo $seat_col;
				// die();
					 
					$row = preg_replace('/[^0-9]/', '', $seat_row);
					$col = preg_replace('/[^0-9]/', '', $seat_col);
					// $col = explode('|', $seat_cols);
					// $col = preg_replace('/[^0-9]/', '', $seat_cols);
 					 
 					// echo '<pre>';
					// print_r($seat_key);
					// echo '</pre>';
					// echo $row;
					 	
					// die();
					
					
					$rhead = $rheads[$row];
					$chead = $cheads[$seat_key];
 					// echo '<pre>';
					// print_r($seat_col);
					// echo '</pre>';
					// die();
					
					$seat_col = "$rhead|$chead"; 
					// echo $chead;
					// die();
					
					$seat_config[$seat_row]['C'.$seat_key] = "$seat_row|C$seat_key|$seat_col";
				}
			}
		}
		// print_array($seat_config); exit;
		$fields['section_seat_config'] = serialize($seat_config);
		
		// update db
		$this->db->where('section_id', $section_id);
		$this->db->update($this->sections, $fields);
		//echo $this->db->last_query();
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_seat_heads
	 *
	 */
	function edit_seat_heads($section_id)
	{
		$heads = array(
			'col_heads' => $this->input->post('col_heads'),
			'row_heads' => $this->input->post('row_heads'),
		);
	
		// update db
		$fields['section_seat_heads'] = serialize($heads);
		$this->db->where('section_id', $section_id);
		$this->db->update($this->sections, $fields);
		//echo $this->db->last_query();
		return true;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * update_available
	 *
	 * @access	public
	 */
	function update_available($section_id, $type, $count)
	{
		// get last available tickets
		$this->db->select('section_available');
		$this->db->where('section_id', $section_id);
		$query = $this->db->getwhere($this->sections);
		$row = $query->row();
		
		$new_available = ($type == 'increase') ? $row->section_available += $count : $row->section_available -= $count;
		
		// update last available tickets
		$this->db->where('section_id', $section_id);
		$this->db->update($this->sections, array('section_available' => $new_available));
		
		return true;
	}
	
	
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($section_id)
	{
		$this->db->delete('sections', array('section_id' => $section_id));
		
		return true;
	}



}
// END sections_model.php
/* Location: ./application/models/sections_model.php */	

