<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Tickprices_model extends Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';
	var $events = 'events e';	
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	function Tickprices_model()
	{
		parent::Model();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_prices
	 *
	 * @access	public
	 */
	function get_prices($event_id = false)
	{
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	function get_prices_compact($event_id = false)
	{
		$this->db->select('pc.price_name, pc.price_sections, pc.price_price');
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
		function get_used_sections($event_id = false,$price_id=false)
	{
		$this->db->select('pc.price_sections');
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}	
		if ($price_id)
		{
			$this->db->where('pc.price_id <>', $price_id);
		}
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		$query = $this->db->get($this->prices);

		//echo $this->db->last_query();
		$UsedSections = $query->result();		
		
		
		$newArr = array();
		$arrayMerge = array();
		foreach ($UsedSections as $value)
		  {
			$newArr[] = unserialize($value->price_sections);
		  }
		  for($i=0;$i< count($newArr);$i++){			  
		  $arrayMerge = array_merge($arrayMerge,$newArr[$i]);
		  
		  }
		return $arrayMerge;
	}	
	
	
	function get_prices_tiny($event_id = false)
	{
		$this->db->select('pc.price_name');
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_price_id
	 *
	 * @access	public
	 */
	function get_price_id($event_id, $section_id)
	{
		$this->db->where('price_event_id', $event_id);
		$query = $this->db->get($this->prices);
		$prices = $query->result();
		foreach ($prices as $price)
		{
			$sections = unserialize($price->price_sections);
			if (in_array($section_id, $sections))
			{
				return $price->price_id;
			}
		}
		return false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_prices
	 *
	 * @access	public
	 */
	function count_prices($event_id = false)
	{
	$this->db->count_all_results();
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		
		
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query;
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * get_price_category
	 *
	 * @access	public
	 */
	function get($price_id)
	{
		$this->db->where('price_id', $price_id);
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$query = $this->db->getwhere($this->prices);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_price_category
	 *
	 * @access	public
	 */
	function get2($price_id)
	{
		$this->db->where('price_event_id', $price_id);
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$query = $this->db->getwhere($this->prices);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_prices_dropdown
	 *
	 * @access	public
	 */
	function get_prices_dropdown()
	{
		$query = $this->db->get($this->prices);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->price_id] = $r->price_name . ' (' . $r->price_price . ')';
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_prices_dropdown_for_promo($event_id = false)
	{
		$this->db->where('price_event_id', $event_id);
		$query = $this->db->get($this->prices);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->price_id] = $r->price_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_serial_number
	 *
	 * @access	public
	 */
	function get_serial_number($price_id)
	{
		// get last serial number
		$this->db->select('price_serial_last');
		$this->db->where('price_id', $price_id);
		$query = $this->db->getwhere($this->prices);
		$row = $query->row();
		
		$next_serial_number = $row->price_serial_last += 1;
		
		// update last serial number
		$this->db->where('price_id', $price_id);
		$this->db->update($this->prices, array('price_serial_last' => $next_serial_number));
		
		return $next_serial_number;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add($event_id)
	{
		$fields = array(
			'price_event_id'	=> $event_id,
			'price_name'		=> $this->input->post('price_name'),
			'price_price'		=> $this->input->post('price_price'),
			'price_package'		=> $this->input->post('price_package'),
			'price_sections'	=> serialize($this->input->post('price_sections')),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('prices');
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($price_id)
	{
		$fields = array(
			'price_name'		=> $this->input->post('price_name'),
			'price_price'		=> $this->input->post('price_price'),
			'price_package'		=> $this->input->post('price_package'),
			'price_sections'	=> serialize($this->input->post('price_sections')),
		);
		
		// update db
		$this->db->where('price_id', $price_id);
		$this->db->update($this->prices, $fields);
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($price_id)
	{
		$this->db->delete('prices', array('price_id' => $price_id));
		
		return true;
	}

	function get_array($event_id = 0)
	{
		$result = array();

		if ($event_id > 0)
		{
			$this->db->where('pc.price_event_id', $event_id);
			// $this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
			$this->db->order_by('pc.price_price', 'desc'); 
			$query = $this->db->get($this->prices);
			
			// transform result into an associative array
			foreach($query->result() as $r)
			{
				$result[$r->price_id] = $r->price_name . ' (' . $r->price_price . ' pesos)';
				}
		}
		return $result;
	}
	
	function get_selected_price_names($event_id, $prices)
	{	
		$array = array();
		
		if (!$prices)
		{
			return false;
		}
		
		$this->db->where('price_event_id', $event_id);
		$query = $this->db->get('prices');
			
		$result = $query->result();

		if ($result)
		{
			// transform result to csv
			$prices = unserialize($prices);

			if ($prices) 
			{
				foreach($result as $r)
				{
					if (in_array($r->price_id, $prices))
						$array[$r->price_id] = $r->price_name;
				}
				
				return $array;
			}
			else
				return false;
		}
		else
			return false;
	}
	

}
// END prices_model.php
/* Location: ./application/models/prices_model.php */		

