<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Tickets_model extends Model
{
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	function Tickets_model()
	{
		parent::Model();
		$this->load->model('parser_model', 'parser');
	}

	// --------------------------------------------------------------------

	function getSelectedSeatsBysession($session = false, $ticket_type = false){
		
		$url_parameter = false;
		
		if($session){
		$url_parameter = "?sessionid=$session";
		}
		
		if($session && $ticket_type){
		$url_parameter = "?sessionid=$session&tickettypeid=$ticket_type";
		}
		
		$tickets_array = $this->parser->parse("transaction","nt_get_all_selected_seats",$url_parameter);
		
		if(array_key_exists("ticket_info",$tickets_array)){
			return $tickets_array["ticket_info"];
		}else{
			return false;
		}
		
	}
	

	
	function select_seat($event_id, $section_id, $ticket_type, $system_row, $system_col, $row, $seat,$priceID,$session){
		
		// echo "$event_id, $section_id, $ticket_type, $system_row, $system_col, $row, $seat,$priceID,$session";
		// die();
		
		$url_parameter = false;
		
		if($session){
		$url_parameter = "/$event_id/$section_id/$ticket_type/$system_row/$system_col/$row/$seat/$priceID/$session";
		}
		
		$result = $this->parser->parse("transaction","nt_select_seat",$url_parameter);	
		
		if(array_key_exists("result",$result)){
			return $result["result"];
		}else{
			return false;
		}

	}
	
			
	function unselect_seat($ticketID,$sectionID){
		
		$url_parameter = false;
		$url_parameter = "/$ticketID/$sectionID";
		
		$result = $this->parser->parse("transaction","nt_unselect_seat",$url_parameter);	

		return $result["result"];
	}
	


	function update_session_for_selected_seats($old_session,$new_session){
		$url_parameter = "/$old_session/$new_session";
		
		
		// die($url_parameter);
		// $this->parser->parse("transaction","nt_replace_session_for_selected_seats",$url_parameter);	
		$this->parser->parse("transaction","nt_replace_session_for_selected_seats",$url_parameter);	
	}
	
	
	function unsellect_all_by_session($session,$section_id = false){
		
		$url_parameter = "/$session";
		
		if($section_id){
			$url_parameter = $url_parameter . "/$section_id";
		}
		
		$this->parser->parse("transaction","nt_unsellect_all_by_session",$url_parameter);	
	}
	
	function countTicketsByUsername($username, $event_id){
		$url_parameter = "?username=$username&eventid=$event_id";
		$ticket_count = $this->parser->parse("generic_mod","countTicketsByUsername",$url_parameter);
		return $ticket_count["result"];
	}

	function get_amount_by_ticket_type(	$price_id, $ticket_type	){
		$url_parameter = "?priceid=$price_id&ticket_type=$ticket_type";
		$price_details = $this->parser->parse("generic_mod","nt_computePricebyticketType",$url_parameter);	
		
		
		return $price_details;
	}
	
	function get_ticket_type_detail( $ticket_type_id	){
		$url_parameter = "?ticket_type_id=$ticket_type_id";
		$ticket_type_details = $this->parser->parse("generic_mod","get_ticket_type_detail",$url_parameter);	
		return $ticket_type_details;
	}
	
	
	}

// END Sections_model.php
/* Location: ./application/models/Sections_model.php */	