<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Ticket_Types_Model extends Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';	
	var $ticket_types = 'ticket_types tt';	
	var $events = 'events e';		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	function ticket_types_model()
	{
		parent::Model();
	}
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_type
	 *
	 * @access	public
	 */
	function get($ticket_type_id)
	{
		$this->db->where('ticket_type_id', $ticket_type_id);
		$query = $this->db->getwhere($this->ticket_types);
	
		return $query->row();
		
	}	
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_types
	 *
	 * @access	public
	 */
 	function get_ticket_types()
	{
		$this->db->order_by('ticket_type_group, ticket_type_id');
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}
	
	function get_ticket_types_b()
	{
		$this->db->order_by('ticket_type_group, ticket_type_id');
		$this->db->where('ticket_type_active', 1);
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}


	
	function get_ticket_type_list()
	{
		$this->db->order_by('ticket_type_name, ticket_type_group, ticket_type_id');
		$this->db->where('ticket_type_active', 1);
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_types_dropdown
	 *
	 * @access	public
	 */
	function get_ticket_types_dropdown()
	{
		// $this->db->order_by('ticket_type_group');
		$this->db->order_by('ticket_type_id');
		$this->db->where('ticket_type_active', 1); 
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_ticket_types_details($event_ticket_types )
	{
		$this->db->order_by('ticket_type_id');
		$this->db->where_in('ticket_type_id', $event_ticket_types);
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_ticket_types_discount($id)
	{
		$this->db->order_by('ticket_type_id');
		$this->db->where('ticket_type_id', $id);
		$query = $this->db->get($this->ticket_types);
		$result = $query->row();
		return array($result->ticket_type_discount,$result->ticket_type_discount_type);

	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add()
	{
		$fields = array(
			'ticket_type_code'			=> $this->input->post('ticket_type_code'),
			'ticket_type_name'			=> $this->input->post('ticket_type_name'),
			'ticket_type_discount_type'	=> $this->input->post('ticket_type_discount_type'),
			'ticket_type_discount'		=> $this->input->post('ticket_type_discount'),
			'ticket_type_group'			=> $this->input->post('ticket_type_group'),
			'ticket_type_active'		=> $this->input->post('ticket_type_active'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('ticket_types');
		
		return true;
	}		
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($ticket_type_id)
	{
		$fields = array(
			'ticket_type_code'			=> $this->input->post('ticket_type_code'),
			'ticket_type_name'			=> $this->input->post('ticket_type_name'),
			'ticket_type_discount_type'	=> $this->input->post('ticket_type_discount_type'),		
			'ticket_type_discount'		=> $this->input->post('ticket_type_discount'),
			'ticket_type_group'			=> $this->input->post('ticket_type_group'),					
			'ticket_type_active'		=> $this->input->post('ticket_type_active'),					
			'ticket_type_promo'			=> $this->input->post('ticket_type_promo'),					
		);
		
		// update db
		$this->db->where('ticket_type_id', $ticket_type_id);
		$this->db->update($this->ticket_types, $fields);
		
		return true;
	}		
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($ticket_type_id)
	{
		$this->db->delete('ticket_types', array('ticket_type_id' => $ticket_type_id));
		
		return true;
	}	
	
	function array_info($ticket_types) {
		$result = array();
		if (count($ticket_types) > 0) {
			$this->db->where_in('ticket_type_id', $ticket_types);
			$query = $this->db->get($this->ticket_types);
			foreach($query->result() as $row) {
				$result[$row->ticket_type_id] = $row->ticket_type_name . " (". $row->ticket_type_code . ")" ;
			}
		}
		/*
		if (count($result) > 0) {}
		else {$result["x"] = "--not available--";}
		*/
		return $result;
	}
	
	function get_ticket_types_dropdown_promo($ticket_types = false)
	{
		// $this->db->order_by('ticket_type_group');
		$this->db->order_by('ticket_type_id');
		$this->db->where('ticket_type_active', 1); 
		
		if($ticket_types)
		$this->db->where_in('ticket_type_id', unserialize($ticket_types));
		
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_ticket_types_dropdown_sort()
	{
		// $this->db->order_by('ticket_type_group');
		$this->db->order_by('ticket_type_name');
		$this->db->where('ticket_type_active', 1); 
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_ticket_types_seller()
	{
	
		if($this->session->userdata('user_type') != 'Admin'){
			$this->db->where('ticket_type_group', 0);
		}
		
		$this->db->order_by('ticket_type_group, ticket_type_id');
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}
}
// END Ticket_Types_Model.php
/* Location: ./application/models/Ticket_Types_Model.php */		
