<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Sections_model extends Model
{
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	function Sections_model()
	{
		parent::Model();
		$this->load->model('parser_model', 'parser');
	}

	// --------------------------------------------------------------------
	
	

	function get($event_id = false){
		
		$url_parameter = false;
		
		if($event_id){
		$url_parameter = "?eventid=$event_id";
		}
		
		$venue_array = $this->parser->parse("generic","nt_GetSectionsforAllActiveEvents",$url_parameter);

	
		return $venue_array["section_info"];
	}
	
	function get_ads() {
	
		$url_parameter = "/";

		$event_array = $this->parser->parse("generic_mod","nt_getAds",$url_parameter);
	
		if(array_key_exists("ad_info",$event_array)){
		$event_array = $event_array['ad_info'];
		}else{
			$event_array = array();
		}
		
		
		// echo "<pre>";
		// print_r($event_array);
		// echo "</pre>";
		// die(); 

		return $event_array;
	
	}
	
	function getSectionSeats($section_id = false,$event_id = false){
		
		if($section_id || $event_id){
		$url_parameter = "?";
		if($section_id){
		$url_parameter = "?sectionid=$section_id";
		}
		
		if($event_id){
		$url_parameter = "?eventid=$event_id";
		}
			
		}else{
			$url_parameter = false;
		}
		
		
		$seat_array = $this->parser->parse("generic","nt_GetSectionsforAllActiveEvents_2",$url_parameter);
		

			
		if(array_key_exists("section_info",$seat_array)){
			
			// if(array_key_exists("event_id",$seat_array["section_info"])){
				// return array($seat_array["section_info"]);
					
			// }else{
			return $seat_array["section_info"];
			// }
			
		}else{
			return array();
		}

	}	
	
	

	
	function getUsedSeats($section_id = false,$event_id = false){
		
		if($section_id || $event_id){
		$url_parameter = "?";
			if($section_id){
			$url_parameter = "?sectionid=$section_id";
			}
			
			if($event_id){
			$url_parameter = "?eventid=$event_id";
			}
			
		}else{
			$url_parameter = false;
		}
		
		$seat_array = $this->parser->parse("generic","nt_getusedSectionInfoforAllactiveEvents",$url_parameter);
	
		
		
		if(array_key_exists("section_info_used",$seat_array)){
			

			// if(array_key_exists("section_id",$seat_array["section_info_used"])){
				// return array($seat_array["section_info_used"]);
					
			// }else{
			return $seat_array["section_info_used"];
			// }
			
		}else{
			return array();
		}

	}
	

	
	
 
	function getSeatSummary($event_id){
		
	$all_seats = $this->getSectionSeats(false, $event_id);
	$used_seats = $this->getUsedSeats(false,$event_id);


	// echo "<pre>";

	// print_r($all_seats);
	// echo "</pre>";
	// die();
	
	
	
	
	
		$sections = array();
		
		if( array_key_exists("section_id",$all_seats)){
			$all_seats = array($all_seats);
		}
		
		foreach($all_seats as $section){
			
			// echo "<pre>";
			// print_r($all_seats);
			// echo "</pre>";
			// die();
			
			$x = array();
			

			$x["section_id"] = $section['section_id'];
			$x["section_capacity"] = $section['section_capacity'];
			$x["section_used_count"] = $this->getUsedSeatQty($used_seats,$section['section_id']);
			$x["section_available_count"] = $x["section_capacity"] - $x["section_used_count"];	
			$seat_summary[] = $x;
		}

		return $seat_summary;
	}
	


	
	function getUsedSeatQty($used_seats,$section_id){
		
		$used_seat_qty = 0;

		// echo "<pre>";
		// print_r($used_seats);
		// echo "</pre>"
		// die();
		
		if($used_seats){
					if(array_key_exists("section_id",$used_seats)){
						$used_seats = array($used_seats);
					}	
						
					
					foreach($used_seats as $used_seat){
						
					if($used_seat["section_id"] == $section_id){
							$used_seat_qty = $used_seat["usedTicketCount"];
						}
					}
		}

		
		return $used_seat_qty;
	}
	
	function getUsedSeats_2($section_id = false,$event_id = false,$date = false){
		
		if($section_id || $event_id){
		$url_parameter = "?";
			if($section_id){
			$url_parameter = "?sectionid=$section_id";
			}
			
			if($event_id){
			$url_parameter = "?eventid=$event_id";
			}
			
			if($date){
				$url_parameter = $url_parameter . "&date=$date";
			}
			
		}else{
			$url_parameter = false;
		}
		
		$seat_array = $this->parser->parse("generic","nt_getusedSectionInfoforAllactiveEvents_2",$url_parameter);
	
		
		
		if(array_key_exists("section_info_used",$seat_array)){
			

			// if(array_key_exists("section_id",$seat_array["section_info_used"])){
				// return array($seat_array["section_info_used"]);
					
			// }else{
			return $seat_array["section_info_used"];
			// }
			
		}else{
			return array();
		}

	}
	
	function getSeatSummary_3($event_id,$date=false){
		
	$all_seats = $this->getSectionSeats(false, $event_id);
	$used_seats = $this->getUsedSeats_2(false,$event_id,$date);


	// echo "<pre>";

	// print_r($all_seats);
	// echo "</pre>";
	// die();
	
	
	
	
		$sections = array();
		
		if( array_key_exists("section_id",$all_seats)){
			$all_seats = array($all_seats);
		}
		
		foreach($all_seats as $section){
			
			// echo "<pre>";
			// print_r($all_seats);
			// echo "</pre>";
			// die();
			
			$x = array();
			

			$x["section_id"] = $section['section_id'];
			$x["section_capacity"] = $section['section_capacity'];
			$x["section_used_count"] = $this->getUsedSeatQty($used_seats,$section['section_id']);
			$x["section_available_count"] = $x["section_capacity"] - $x["section_used_count"];	
			$seat_summary[] = $x;
		}

		return $seat_summary;
	}

	function getSeatSummary_2($event_id,$date=false){
		
	$all_seats = $this->getSectionSeats(false, $event_id);
	


	// echo "<pre>";

	// print_r($all_seats);
	// echo "</pre>";
	// die();
	if($date){
		$used_seats = $this->getUsedSeats_2(false,$event_id,$date);
	}
	
	
	
	
		$sections = array();
		
		if( array_key_exists("section_id",$all_seats)){
			$all_seats = array($all_seats);
		}
		
		foreach($all_seats as $section){
			
			// echo "<pre>";
			// print_r($all_seats);
			// echo "</pre>";
			// die();
			
			$x = array();
			

			$x["section_id"] = $section['section_id'];
			$x["section_capacity"] = $section['section_capacity'];
			if($date){
				$x["section_used_count"] = $this->getUsedSeatQty($used_seats,$section['section_id']);
				$x["section_available_count"] = $x["section_capacity"] - $x["section_used_count"];	
			}else{
				$x["section_used_count"] = $x["section_capacity"] - $section['section_available'];
				$x["section_available_count"] =  $section['section_available'];	
			}
			
			
			$seat_summary[] = $x;
		}

		return $seat_summary;
	}

	function get_ads2() {
	
		$url_parameter = "/";

		// $event_array = $this->parser->parse("generic_mod","nt_getAds",$url_parameter);
		
		$event_array = file_get_contents($this->config->item("url_base")."/generic_mod/nt_getAds");
	
		

		// $obj = simplexml_load_string($event_array);
	
		// if(array_key_exists("ad_info",$event_array)){
		// $event_array = $event_array['ad_info'];
		// }else{
			// $event_array = array();
		// }
		
		
		// echo "<pre>";
		// print_r($event_array);
		// echo "</pre>";
		// die(); 

		return $event_array;
	
	}
}

// END Sections_model.php
/* Location: ./application/models/Sections_model.php */	