<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class PrintOut_model extends Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';

	var $paid_status = array('paid','paid_online');

	function PrintOut_model()
	{
		parent::Model();
	}

	
	function setTicketPrintDate($transaction_id)
	{
		// update the tickets table		
		$changes = array(
			'ticket_date_printed'	=> date('Y-m-d H:i:s'),
		);
		
		// update the status of the tickets
		$this->db->where('ticket_status', 'paid');
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update($this->tickets, $changes);
		
		return true;
	}

	function transaction_done($transaction_id)
	{
		// update the transactions table
		$this->db->where_in('transaction_status', $this->paid_status);
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update($this->transactions, array('transaction_status' =>'done'));
		
		// update the tickets table		
		$changes = array(
			'ticket_status' => 'done',
		);

		// update the status of the tickets
		$this->db->where_in('ticket_status', $this->paid_status);
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update($this->tickets, $changes);
		
		
		return ($this->identify_transaction_userid($transaction_id));
	}


	function identify_transaction_userid($transaction_id) {
		$user_id = 0;
		
		$this->db->select("transaction_user_id");
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get("transactions");
		if ($query->num_rows() > 0) {
		   $row = $query->row(); 
		   $user_id = $row->transaction_user_id;
		}
		
		return $user_id;
	}
}