<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Payments_model extends Model
{
	var $payments = 'payments p';	
	var $payment_types = 'payment_types pt';	
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	function Payments_model()
	{
		parent::Model();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_payment_types
	 *
	 * @access	public
	 */
 	function get_payments($transaction_id)
	{
		$this->db->where('payment_transaction_id', $transaction_id);
		$this->db->join($this->payment_types, 'payment_payment_type_id=payment_type_id','left');
		$query = $this->db->get($this->payments);
		return $query->result();
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
 	function add($transaction_id, $payment_type_id, $payment_amount)
	{
		$fields = array(
			'payment_transaction_id'	=> $transaction_id,
			'payment_payment_type_id'	=> $payment_type_id,
			'payment_amount'			=> prep_amount($payment_amount),
		);

		// insert to db
		$this->db->set($fields);
		$this->db->insert('payments');
	}	
 	
	function add_totalpay_backend($transaction_id, $payment_details, $payment_amount, $payment_amount_type = 'tickets')
	{
		$count = count($payment_details);
		if ($count == 1) {
			$payment_type_id = $payment_details[0]->payment_type_id;
		}
		else {
			$payment_type_id = 0;
		}
		
		$fields = array(
			'total_transaction_id'	=> $transaction_id,
			'total_payment_type_id'	=> $payment_type_id,
			'total_amount'			=> prep_amount($payment_amount),
			// 'total_amount_type'		=> $payment_amount_type,
			'total_multiple_payment' => $count,
		);

		// insert to db
		$this->db->set($fields);
		$this->db->insert('total_amount');
	}	
}
// END payments_model.php
/* Location: ./application/models/payments_model.php */		