<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Payment_types_model extends Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';	
	var $payment_types = 'payment_types pt';	
	var $events = 'events e';		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	function Payment_types_model()
	{
		parent::Model();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_payment_types
	 *
	 * @access	public
	 */
 	function get_payment_types()
	{
		$this->db->where('payment_type_active', '1');
		$this->db->order_by('payment_type_order');
		$query = $this->db->get($this->payment_types);
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_payment_types_dropdown
	 *
	 * @access	public
	 */
	function get_payment_types_dropdown($type = false)
	{
		if ($type) $this->db->where('payment_type_type', $type);
		$this->db->where('payment_type_active', '1');
		$this->db->order_by('payment_type_order');
		$this->db->order_by('payment_type_name');
		$query = $this->db->get($this->payment_types);
			
		$result = $query->result();

		if ($result)
		{
			// enable line below if empty drop down value is required
			// $array[] = '';
			
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->payment_type_id] = $r->payment_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_payment_type_categories
	 *
	 * @access	public
	 */
	function get_payment_type_categories()
	{
		$this->db->group_by('payment_type_type');
		$this->db->where('payment_type_active', '1');
		$query = $this->db->get($this->payment_types);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[] = $r->payment_type_type;
			}
			return $array;
		}
		else
		{
			return false;
		}
	}	
	
	function get_payment_type_id_by_categories($category = '')
	{
		// $this->db->group_by('payment_type_type');
		$this->db->where('payment_type_active', '1');
		$this->db->where('payment_type_order', '100');
		$this->db->where('payment_type_type', $category);
		$query = $this->db->get($this->payment_types);
		if ($query->num_rows() > 0)
		{
		$result = $query->row();
			return $result->payment_type_id;
		}
		else
		{
			return false;
		}
	}	
}
// END payment_types_model.php
/* Location: ./application/models/payment_types_model.php */		