<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Customers_model extends Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches o';
	var $customers = 'customers c';
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	function Costumers_model()
	{
		parent::Model();
	}
	// --------------------------------------------------------------------
	
	/**
	 * get
	 *
	 * @access	public
	 */
	function get($customer_id)
	{
		$this->db->where('customer_id', $customer_id);
		$query = $this->db->getwhere($this->customers);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_by_mobile
	 *
	 * @access	public
	 */
	function get_by_mobile($mobile)
	{
		$this->db->where('customer_mobile', $mobile);
		$query = $this->db->getwhere($this->customers);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_costumers
	 *
	 * @access	public
	 */
	function get_customers($searchkey=array(),$offset=false,$limit=20)
	{
		$this->db->select('customer_id,customer_username,customer_firstname,customer_lastname,customer_age_bracket,customer_gender,customer_nationality,customer_marital_status');
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);

		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				switch ($key)
				{
					case 'name':
						$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  					$this->db->where($key, $value);
						break;
				}
			}
		}

		
		$query = $this->db->get($this->customers);
		
		return $query->result();
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add()
	{
		$fields = array(
			'customer_firstname'		=> $this->input->post('customer_firstname'),
			'customer_middlename'		=> $this->input->post('customer_middlename'),
			'customer_lastname'			=> $this->input->post('customer_lastname'),
			'customer_age_bracket'		=> $this->input->post('customer_age_bracket'),
			'customer_gender'			=> $this->input->post('customer_gender'),
			'customer_nationality'		=> $this->input->post('customer_nationality'),
			'customer_marital_status'	=> $this->input->post('customer_marital_status'),
			'customer_address1'			=> $this->input->post('customer_address1'),
			'customer_address2'			=> $this->input->post('customer_address2'),
			'customer_city'				=> $this->input->post('customer_city'),
			'customer_zip'				=> $this->input->post('customer_zip'),
			'customer_phone'			=> $this->input->post('customer_phone'),
			'customer_fax'				=> $this->input->post('customer_fax'),
			'customer_mobile'			=> $this->input->post('customer_mobile'),
			'customer_email'			=> $this->input->post('customer_email'),
			'customer_website'			=> $this->input->post('customer_website'),
			'customer_work_address1'	=> $this->input->post('customer_work_address1'),
			'customer_work_address2'	=> $this->input->post('customer_work_address2'),
			'customer_work_city'		=> $this->input->post('customer_work_city'),
			'customer_work_zip'			=> $this->input->post('customer_work_zip'),
			'customer_work_phone'		=> $this->input->post('customer_work_phone'),	
			'customer_work_fax'			=> $this->input->post('customer_work_fax'),		
			'customer_work_mobile'		=> $this->input->post('customer_work_mobile'),		
			'customer_work_email'		=> $this->input->post('customer_work_email'),		
			'customer_work_website'		=> $this->input->post('customer_work_website'),		
			'customer_notes'			=> $this->input->post('customer_notes'),		
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('customers');
		
		return true;
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($customer_id)
	{
		$fields = array(
			'customer_firstname'		=> $this->input->post('customer_firstname'),
			'customer_middlename'		=> $this->input->post('customer_middlename'),
			'customer_lastname'			=> $this->input->post('customer_lastname'),
			'customer_age_bracket'		=> $this->input->post('customer_age_bracket'),
			'customer_gender'			=> $this->input->post('customer_gender'),
			'customer_nationality'		=> $this->input->post('customer_nationality'),
			'customer_marital_status'	=> $this->input->post('customer_marital_status'),
			'customer_address1'			=> $this->input->post('customer_address1'),
			'customer_address2'			=> $this->input->post('customer_address2'),
			'customer_city'				=> $this->input->post('customer_city'),
			'customer_zip'				=> $this->input->post('customer_zip'),
			'customer_phone'			=> $this->input->post('customer_phone'),
			'customer_fax'				=> $this->input->post('customer_fax'),
			'customer_mobile'			=> $this->input->post('customer_mobile'),
			'customer_email'			=> $this->input->post('customer_email'),
			'customer_website'			=> $this->input->post('customer_website'),
			'customer_work_address1'	=> $this->input->post('customer_work_address1'),
			'customer_work_address2'	=> $this->input->post('customer_work_address2'),
			'customer_work_city'		=> $this->input->post('customer_work_city'),
			'customer_work_zip'			=> $this->input->post('customer_work_zip'),
			'customer_work_phone'		=> $this->input->post('customer_work_phone'),	
			'customer_work_fax'			=> $this->input->post('customer_work_fax'),		
			'customer_work_mobile'		=> $this->input->post('customer_work_mobile'),		
			'customer_work_email'		=> $this->input->post('customer_work_email'),		
			'customer_work_website'		=> $this->input->post('customer_work_website'),		
			'customer_notes'			=> $this->input->post('customer_notes'),		
		);
		
		// update db
		$this->db->where('customer_id', $customer_id);
		$this->db->update($this->customers, $fields);
		
		return true;
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * quick_add
	 *
	 */
	function quick_add()
	{
		$i =& $this->input;
		
		// check first if customer is existing
		$customer = $this->get_by_mobile($this->input->post('customer_mobile'));
	
		// if existing customer, just update firstname and lastname
		if (!empty($customer))
		{			
			if ($i->post('customer_firstname')) $fields['customer_firstname'] = $i->post('customer_firstname');
			if ($i->post('customer_lastname')) $fields['customer_lastname'] = $i->post('customer_lastname');
			if ($i->post('customer_age_bracket')) $fields['customer_age_bracket'] = $i->post('customer_age_bracket');
			if ($i->post('customer_gender')) $fields['customer_gender'] = $i->post('customer_gender');
			if ($i->post('customer_marital_status')) $fields['customer_marital_status'] = $i->post('customer_marital_status');
			if ($i->post('customer_address1')) $fields['customer_address1'] = $i->post('customer_address1');
			if ($i->post('customer_address2')) $fields['customer_address2'] = $i->post('customer_address2');
			if ($i->post('customer_city')) $fields['customer_city'] = $i->post('customer_city');
			if ($i->post('customer_zip')) $fields['customer_zip'] = $i->post('customer_zip');
			if ($i->post('customer_nationality')) $fields['customer_nationality'] = $i->post('customer_nationality');
			if ($i->post('customer_phone')) $fields['customer_phone'] = $i->post('customer_phone');
			if ($i->post('customer_fax')) $fields['customer_fax'] = $i->post('customer_fax');
			if ($i->post('customer_email')) $fields['customer_email'] = $i->post('customer_email');
			if ($i->post('customer_website')) $fields['customer_website'] = $i->post('customer_website');
			// if ($i->post('customer_notes')) $fields['customer_notes'] = $i->post('customer_notes');
			
			// update db
			$fields['customer_mobile'] = $i->post('customer_mobile');
			$this->db->where('customer_mobile', $i->post('customer_mobile'));
			$this->db->update($this->customers, $fields);
			
			return $customer->customer_id;
		}
		
		// if new customer, insert to db
		else
		{
			$fields = array(
				'customer_firstname'		=> $i->post('customer_firstname'),
				'customer_lastname'			=> $i->post('customer_lastname'),
				'customer_age_bracket'		=> $i->post('customer_age_bracket'),
				'customer_gender'			=> $i->post('customer_gender'),
				'customer_marital_status'	=> $i->post('customer_marital_status'),
				'customer_address1'			=> $i->post('customer_address1'),
				'customer_address2'			=> $i->post('customer_address2'),
				'customer_city'				=> $i->post('customer_city'),
				'customer_zip'				=> $i->post('customer_zip'),
				'customer_nationality'		=> $i->post('customer_nationality'),
				'customer_phone'			=> $i->post('customer_phone'),
				'customer_fax'				=> $i->post('customer_fax'),
				'customer_mobile'			=> $i->post('customer_mobile'),
				'customer_email'			=> $i->post('customer_email'),
				'customer_website'			=> $i->post('customer_website'),	
				// 'customer_notes'			=> $i->post('customer_notes'),				
			);
			
			// insert to db
			$this->db->set($fields);
			$this->db->insert('customers');
			
			return $this->db->insert_id();
		}
	}
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($customer_id)
	{
		$this->db->delete('customers', array('customer_id' => $customer_id));
		
		return true;
	}	
	function prep_password($password)
	{
		return sha1($this->config->item('encryption_key').$password);
	}
	
}

// END costumers_model.php
/* Location: ./application/models/costumers_model.php */	