<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Util extends Controller {
  
  function Util()
	{
		parent::Controller();	

		$this->load->library('user_agent');
	}
	
	function index()
	{
		show_404();
	}
	
	function css($par1,$par2=false,$par3=false){
		
		if($par1 == "images"){
			$par1 = $par1 . "/" . $par2;
			if($par3){
				$par1 = $par1 ."/". $par3;
			}
		}
		
		$path = BASEPATH."application/views/resources/css/".$par1;
		
		$this->render_file($path);
	}
	
	function js($par1){
		
		$path = BASEPATH."application/views/resources/js/".$par1;
		
		$this->render_file($path);
	}
	
	function images($par1,$par2=false,$par3=false){
		
		if($par1 == "promo_modal"){
			$par1 = $par1 . "/" . $par2;
			if($par3){
				$par1 = $par1 ."/". $par3;
			}
		}
		
		$path = BASEPATH."application/views/resources/images/".$par1;
		
		$this->render_file($path);
	}
	
	function img($par1){
		$path = BASEPATH."application/views/resources/img/".$par1;
		
		$this->render_file($path);
	}
	
	function fonts($par1){
		$path = BASEPATH."application/views/resources/fonts/".$par1;
		readfile($path);
	}
	
	function downloads($par1){
		$path = BASEPATH."application/views/resources/downloads/".$par1;
		$this->download_file($path,$par1);
	}
	
	function render_file($path)
	{
		$ext = pathinfo($path, PATHINFO_EXTENSION);

		switch($ext){
			case "png": $stuff = "image/png"; $seconds_to_cache = 2592000; break;
			case "gif": $stuff = "image/gif"; $seconds_to_cache = 2592000; break;
			case "jpeg": $stuff = "image/jpeg"; $seconds_to_cache = 2592000; break;
			case "jpg": $stuff = "image/jpeg"; $seconds_to_cache = 2592000; break;
			case "css": $stuff = "text/css"; $seconds_to_cache = 604800; break;
			case "js": $stuff = "text/javascript"; $seconds_to_cache = 604800; break;		
		}
		
		$ts = gmdate("D, d M Y H:i:s", time() + $seconds_to_cache) . " GMT";
		
		$this->load->helper('file');
		$data = read_file($path);
		header("Content-Type: $stuff");
		header("Expires: $ts");
		header("Pragma: cache");
		header("Cache-Control: max-age=$seconds_to_cache");
		header('Last-Modified: '.gmdate('D, d M Y H:i:s', time()).' GMT');
		echo $data;

	}
	
	function download_file($path,$par1)
	{
		$ext = pathinfo($path, PATHINFO_EXTENSION);

		switch($ext){
			case "pdf": $stuff = "application/pdf";
			case "png": $stuff = "image/png"; 
			case "gif": $stuff = "image/gif";
			case "jpeg": $stuff = "image/jpeg";
			case "jpg": $stuff = "image/jpeg";
			case "css": $stuff = "text/css";
			case "js": $stuff = "text/javascript";		
		}		
		
		$this->load->helper('file');
		$data = read_file($path);
		header("Content-Type: $stuff");
		header("Content-Transfer-Encoding: Binary");
		header("Content-disposition: attachment; filename=".$par1);
		
		echo $data;

	}
	
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */