<?php

class Users extends Controller {

	function Users()
	{
		parent::Controller();	
		$this->load->model('events_model', 'events');
		$this->load->model('venue_model', 'venue');
		$this->load->model('sections_model', 'sections');
		$this->load->model('prices_model', 'prices');
		$this->load->model('users_model', 'user');
		$this->load->model('tickets_model', 'tickets');
		$this->load->library('user_agent');
	}
	
	function index()
	{
		// $this->home();
		show_404();
	}
	
	function view_login(){
		
		$this->load->view('header_revamp');
		$this->load->view('login_revamp');
		$this->load->view('footer_revamp');
		// $this->load->view("login_page");
		// $this->load->view("login_page_all");
	}
	
	function login(){

		$username = $this->input->post('username');
		$password = $this->input->post('password');

		$result = $this->user->login($username,$password,"SMTICKETS");	
		
		if(array_key_exists("accessCode",$result)){

			
			// Set session data
		
			$this->session->sess_create();
			
 			$this->session->set_userdata(array(
				'logged_in' 		=> true,
				'username' 			=> $username,
				'customer_id' 			=> $result['customer_id'],
				'email' 			=> $result["email"],
				'hash'				=> $result["accessCode"],
				'lasttimecheck'		=> microtime(true),
				'expiration'		=> $result["expiration"],			
				'mobile_number'		=> $result["mobile"]				
			)); 

			
		$this->tickets->update_session_for_selected_seats($this->input->cookie('sm_session'),$result["accessCode"]);
		set_cookie('sm_session', $result["accessCode"], $this->config->item("cookie_timeout"));

		echo json_encode(array(
				'username' 			=> $username,
				'session'			=> $result["accessCode"],
			));

		}else{
			echo 'failed';
		}
	}	
	
	function confirm($hashed_username = false, $username = false){

	$result = "failed";
	
		if($this->prep_password($username) == $hashed_username ){
			$result = $this->user->activate_user($hashed_username, $username);
		}

		if($result == "success"){
		redirect(base_url() . "users/view_login");
		}else{
		redirect(base_url());
		}
		
		
		
		// die();
	}	

	function validate_coupon() {
	
		$this->load->view('validate_coupon_form');
	
	}

	function logout($session){

		$result = $this->user->heartbeat("kill", $session, "SMTICKETS");
		$this->tickets->unsellect_all_by_session($session, $session_id=false);
		$this->session->sess_destroy();
		echo "success";
	}
	
	function heartbeat($mode,$session){
	
		$result = $this->user->heartbeat($mode, $session, "SMTICKETS");
		echo $result;
	}
	
	function view_reset_password() {
	
		// $this->load->view("reset_password_page");
		$this->load->view('header_revamp');
		$this->load->view('reset_password_page_revamp');
		$this->load->view('footer_revamp');
		// $this->load->view("reset_password_page_all");
	
	}
	
	function reset_password() {
	
		// $byear = $this->input->post('birth_year');
		// $bmonth = $this->input->post('birth_month');
		// $bday = $this->input->post('birth_day');	
		// $bdate = $byear."-".$bmonth."-".$bday;
		$username = $this->input->post('username');
		$email = $this->input->post('email');
		
		$url = $this->config->item("url_base").'/generic_mod/nt_Reset_password';
		$data = array(
					'user' => $username,
				   // 'bdate' => $bdate,
				   'email' => $email,
				);
		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);

		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
		$new_data["data"] = array('username'=>$username,
								'reset_key'=>trim(strip_tags($result))
							);
		
		$new_result = trim(strip_tags($result));
		if($new_result=="Invalid Key Pair [Data Sync]") {
			echo "The information you have entered is not valid. Please try again";
		}else{
			// $reset_url = $this->config->item("base"). "users/reset_your_password?rk=".$new_data["data"]["reset_key"]."&q=".$new_data["data"]["username"];		
			$reset_url = $this->config->item("base"). "users/reset_your_password/".$new_data["data"]["reset_key"]."/".$new_data["data"]["username"];		

			$this->send_reset_password_email($username,$email,$reset_url);
			echo "A reset link has been sent to your email. Please check your email for a reset link<br>To go back to home, please click <a href=".$this->config->item("base").">here</a>.";
		}
		           
	}
	
	function reset_your_password($reset_key=false, $username=false){
		
		// $rk = $this->input->get_post('rk');
		// $username = $this->input->get_post('q');

	
		$arr['data'] = array(
			'reset_key' => $reset_key,
			'username' => $username
		);

		// print_r($arr['data']);
		// die();
		
		// $this->load->view('update_password_page', $arr);
		// $this->load->view('update_password_all', $arr);
		$this->load->view('header_revamp');;
		$this->load->view('update_password_revamp', $arr);
		$this->load->view('footer_revamp');
	}
	
	function update_password() {
	
		$username = $this->input->get_post('user');
		
		
		// echo $username;
		// die();
		
		$reset_key= $this->input->get_post('rk');
		$new_password = $this->input->get_post('new_pass');
		$retyped_password = $this->input->get_post('retype_pass');
		
		$url = $this->config->item("url_base").'/generic/nt_Update_password';
		$data = array(
					'user' => $username,
				   'rk' => $reset_key,
				   'new_pass' => $new_password,
				   'retype_pass' => $retyped_password
				);
		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
		
		echo trim(strip_tags($result));
	
	}
	
	function register_user_online() {
	
		$this->load->view("register_online");
	
	}
	
	function register_user() {
		
			$byear = $this->input->post('birth_year');
			$bmonth = $this->input->post('birth_month');
			$bday = $this->input->post('birth_day');

			$customer_partycode = "ticketmaster";
			$this->load->helper('email');
			$customer_username = $this->input->post('username');
			$customer_firstname = $this->input->post('fname');
			$customer_middlename = $this->input->post('mname');
			$customer_lastname = $this->input->post('lname');
			$customer_password = $this->input->post('password');
			$customer_mobile_prefix = $this->input->post('mobile_prefix');
			$customer_mobile_number = $this->input->post('mobile_number');
			$customer_email = $this->input->post('email');
			$customer_adress_province = $this->input->post('province');
			$customer_adress_street = $this->input->post('home');
			$city = $this->input->post('city');
			$gender = $this->input->post('gender');
			$civil_status = $this->input->post('civil_status');
			
			if($this->input->post('dpa') == 1){
				$dpa = "1";
			}else{
				$dpa = "0";
			}
				
		$url = $this->config->item("url_base").'/register/Register_party_user';
		$data = array(
					'fname' => $customer_firstname,
				   'mname' => $customer_middlename,
				   'lname' => $customer_lastname,
				   'birth_year' => $byear,
				   'birth_month' => $bmonth,
				   'birth_day' => $bday,
				   'mobile_prefix' => $customer_mobile_prefix,
				   'mobile_number' => $customer_mobile_number,
				   'email' => $customer_email,
				   'username' => $customer_username,
				   'password' => $customer_password,
				   'province' => $customer_adress_province,
				   'home' => $customer_adress_street,
				   'city' => $city,
				   'gender' => $gender,
				   'civil_status' => $civil_status,
				   'dpa' => $dpa
				);

		// use key 'http' even if you send the request to https://...
		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);

		
		$hashed_username = $this->prep_password($customer_username);	
		
		// $confirmation_url = $this->config->item("base"). "users/confirm/$hashed_username/$customer_username";
		$confirmation_url = $this->config->item("base"). "/users/view_login";
		
		// $this->send_email_confirmation($customer_email,$confirmation_url);
		
		echo $result;
		
		
	}
	
	function register_online() {
		
			$byear = $this->input->post('birth_year');
			$bmonth = $this->input->post('birth_month');
			$bday = $this->input->post('birth_day');
			
			$customer_firstname = $this->input->get_post('customer_firstname');
			$customer_middle = $this->input->get_post('customer_middle');
			$customer_lastname = $this->input->get_post('customer_lastname');
			// $customer_birthdate = $byear . "-" . $bmonth . "-" . $bday;
			$customer_gender = $this->input->get_post('customer_gender');
			$customer_address = $this->input->get_post('customer_address');
			$customer_email = $this->input->get_post('customer_email');
			$customer_mobile = $this->input->get_post('customer_mobile');
			$tsize = $this->input->get_post('tsize');
			$ticketID = $this->input->get_post('ticketID');
			$branch = $this->input->get_post('branchID');
			$category = $this->input->get_post('categoryID');
			$event = $this->input->get_post('eventID'); 
			
			//---Static values for testing---//
			
			/* $byear = "1989";
			$bmonth = "09";
			$bday = "20";
			
			$customer_firstname = "firstname";//$this->input->get_post('customer_firstname');
			$customer_middle = "middlename";//$this->input->get_post('customer_middle');
			$customer_lastname = "laststname";//$this->input->get_post('customer_lastname');
			// $customer_birthdate = $byear . "-" . $bmonth . "-" . $bday;
			$customer_gender = "gender";//$this->input->get_post('customer_gender');
			$customer_address = "address";//$this->input->get_post('customer_address');
			$customer_email = "e-mail";//$this->input->get_post('customer_email');
			$customer_mobile = "09154272472";//$this->input->get_post('customer_mobile');
			$tsize = "XXXL";//$this->input->get_post('tsize');
			$ticketID = "No ID No Entry";//$this->input->get_post('ticketID');
			$branch = "Sanga";//$this->input->get_post('branchID');
			$category = "category";//$this->input->get_post('categoryID');
			$event = "event";//$this->input->get_post('eventID'); */
		
		$url = $this->config->item("url_base").'/generic_extra/nt_register_online';
		$data = array(
					'customer_firstname' => $customer_firstname,
				   'customer_middle' => $customer_middle,
				   'customer_lastname' => $customer_lastname,
				   'birth_year' => $byear,
				   'birth_month' => $bmonth,
				   'birth_day' => $bday,
				   'customer_mobile' => $customer_mobile,
				   'customer_email' => $customer_email,
				   'customer_address' => $customer_address,
				   'customer_gender' => $customer_gender,
				   'tsize' => $tsize,
				   'ticketID' => $ticketID,
				   'branchID' => $branch,
				   'categoryID' => $category,
				   'eventID' => $event
				);

		// use key 'http' even if you send the request to https://...
		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);

		echo $result;
	
	}
	
	function register(){
	
	
		// $this->load->view('sign_up');
		// $this->load->view('sign_up_all');
		$this->load->view('header_revamp');
		$this->load->view('sign_up_revamp');
		$this->load->view('footer_revamp');
	
	}
	
	function my_profile($result=false,$event_id=false){
	

		$data['site_title'] = $this->config->item("site_title");			
 
		$url_base = $this->config->item('url_base');
		$username = $this->session->userdata('username');
  
		//check if logged in
		if(!$username){
			redirect('');
		}
	// echo $username;
		//customer profile
		$xml = simplexml_load_file("$url_base/generic_mod/nt_ViewAPIuserbyUsername?username=$username");
		$data['x'] = json_decode( json_encode($xml) , 1);

		
		$customerid = $data['x']['user_info']['customer_id'];
		
		
		//customer transactions
		$xml = simplexml_load_file("$url_base/generic_mod/nt_GetCustomerTransactions?customerid=$customerid");
		$y = json_decode( json_encode($xml) , 1);

		$data['y'] = array();
		if( isset($y['errorMessage']))
		{
			 // list is empty.
		}else{
		
			if(!isset($y['event_info'][0])){
			
				foreach($y as $z){
					
					$data['y']['event_info'][0]['transaction_id'] = $z['transaction_id'];
					$data['y']['event_info'][0]['transaction_date'] = $z['transaction_date'];
					$data['y']['event_info'][0]['event_title'] = $z['event_title'];
					$data['y']['event_info'][0]['branch'] = $z['branch'];
					$data['y']['event_info'][0]['status'] = $z['status'];
					$data['y']['event_info'][0]['card_type'] = $z['card_type'];
				
				}

			}else{
			
				$data['y'] = $y;
			
			}

		}


		$data = array(
			'id' => $data['x']['user_info']['customer_id'],
			'firstname' => $data['x']['user_info']['customer_firstname'],
			'middlename' => $data['x']['user_info']['customer_middlename'],
			'lastname' => $data['x']['user_info']['customer_lastname'],
			'email' => $data['x']['user_info']['customer_email'],
			'mobile' => $data['x']['user_info']['customer_mobile'],
			'transactions' => $data['y']
		);
		
	if($result){
		$data["result"] = $result;
		$data["is_trans_active"] = "active";
		$data["is_profile_active"] = "";
	}else{
		$data["is_trans_active"] = "";
		$data["is_profile_active"] = "active";
	}
		
	if($event_id){
		$data["profile"] = $event_id;
	}
		
		// $this->load->view('profile_page', $data);
		
		// $this->load->view('profile_all', $data);
		$this->load->view('header_revamp');
		$this->load->view('profile_revamp', $data);
		$this->load->view('footer_revamp');
	
	}
	
	function print_at_home($transaction_id = false, $accesscode = false) {

		$parameters = $transaction_id.'/'.$accesscode;

		$this->load->model('parser_model', 'parser');
		$result = $this->parser->parse('generic_mod', 'get_barcode_for_ticket_printing/', $parameters);
			
		if ($result) {

			// $this->load->view('print_ticket_page', $result);
			// $this->load->view('print_ticket_page_all', $result);
			$this->load->view('header_revamp');
			$this->load->view('print_ticket_page_revamp', $result);
			$this->load->view('footer_revamp');

		}
		else {

			redirect(base_url());

		}	

	}

	function print_ticket() {

		$transaction_customer_id = $this->input->post('transaction_customer_id');
		$password = $this->input->post('password');
		$barcode = $this->input->post('barcode');
		$accesscode =  $this->input->post('accesscode');


		$url = $this->config->item("url_base").'/generic_mod/get_password_for_ticket_printing';
		$data = array(
			'transaction_customer_id' => $transaction_customer_id,
			'password' => $password,
			'accesscode' => $accesscode,
			'barcode' => $barcode
		);

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		// $result = file_get_contents($url, false, $context);

		$xml = file_get_contents($url, null, $context);
		
		$sxml = new SimpleXMLElement($xml);
		$result =  json_decode( json_encode($sxml) , 1);

		print_r(json_encode($result));	

	}

	function my_transactions(){
	
	
		$this->load->view('myTransactions');
	
	}
	
	function voucher($transaction_id=false){
// $transaction_id = $this->input->get_post('transactionid');

		/* parse_str($_SERVER['QUERY_STRING'],$_GET);
		$client_ip = $_SERVER['REMOTE_ADDR'];
		$filter = "10.";
		$filtered = substr($client_ip,0,strlen($filter));
		if ($filtered != $filter) {
		echo "$client_ip - $filtered <BR>";
		die("Invalid access");
		} */

		// force voucher type to be always all to avoid issue with generation of per ticket voucher
		$type = "all";
		$voucher_type = ($type == 'all') ? 'all' : 'one';
		$transaction_id = ($transaction_id) ? $transaction_id : 0;
		$data['voucher_type'] = $voucher_type;
		$transaction = $this->transactions->get($transaction_id);
		$data['transaction'] = $transaction;
		if(!$transaction)
		{ $this->error->promptError('ER:06:07');}

		$data['tickets'] = $this->tickets->get_tickets($transaction_id);
		// $data['ticket_terms'] = $file = file_get_contents(base_url() . '/resources/terms/ticket_terms.txt', true);
		if (count($data['tickets']) > 0)
		{
		$data['price'] = $this->prices->get($data['tickets'][0]->ticket_price_id);
		$data['event'] = $this->events->get($data['tickets'][0]->ticket_event_id);
		$payments = $this->payments->get_payments($transaction_id);

		$data['payment_type'] = (count($payments) > 0) ? $payments[0]->payment_type_name : 'Unknown Payment Type';
		$total_payment = 0;
		foreach($payments as $payment)
		$total_payment += $payment->payment_amount;
		$data['total_amount'] = $total_payment;
		$data['ticket_layout'] = $this->ticket_layouts->get($data['tickets'][0]->ticket_event_id);
		$data['bcode'] = $this->bcode->get_transaction_bcode($transaction_id);

		// display the page
		$this->load->view('1transaction_tickets', $data);
		}
		else{
		echo 'Ticket not found';
		}

	}
	
	function register_now(){
	
	
		$username = $this->input->post('username');
		$password = $this->input->post('password');
		$fname = $this->input->post('fname');
		$mname = $this->input->post('mname');
		$lname = $this->input->post('lname');
		$bdate = $this->input->post('bdate');
		$mobile = $this->input->post('mobile');
		$email = $this->input->post('email');
	
	
	
		// $username = 'laefool10';
		// $password = '123123';
		// $fname = 'jap';
		// $mname = 'l';
		// $lname = 'sy';
		// $bdate = '1988-10-10';
		// $mobile = '09112312316';
		// $email = 'asd@email.com';
	
	
	
		$content = http_build_query (array (
		'username' => $username,
		'pass' => $password,
		'fname' =>$fname,
		'mname' =>$mname,
		'lname' =>$lname,
		'bdate' =>$bdate,
		'mobile' =>$mobile,
		'email' =>$email,
		));

		$context = stream_context_create (array (
			'http' => array (	 
			'method' => 'POST',
			'header' => "Connection: close\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n",
			'content' => $content,
			)
		));
		
		$url_base = $this->config->item('url_base');
		$xml = file_get_contents("$url_base/generic_mod/nt_Register_party_user", null, $context);


		
		$xml = new SimpleXMLElement($xml);
		
		// $xml = simplexml_load_string($result);
		$result =  json_decode( json_encode($xml) , 1);
		
		// echo '<pre>';
	// print_r($result);
		// echo '</pre>';
	// die();
	
	
		if(isset($result['result'])){
		echo 'success';
		
		}else{
		
		echo $result['errorMessage'];
		}
	
	
	
	// echo $username;
	
	
	}
	
	function get_voucher(){
	

		$accessCode = $this->input->get_post('accesscode');
		$dynatoken = $this->input->get_post('dynatoken');
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		$transaction_id = $this->input->get_post('transactionid');

		if(!$appcode){
		$this->error->promptError('ER:01:03');
		}elseif(!$livetoken){
		$this->error->promptError('ER:01:04');
		}elseif(!$accessCode){
		$this->error->promptError('ER:01:06');
		}elseif(!$dynatoken){
		$this->error->promptError('ER:01:08');
		}else{
			
		$voucher = $this->tickets->getVoucherInfo($transaction_id);
			
		// $transaction = $this->transactions->get($transaction_id);
		$transaction_customer_id = $voucher[0]->transaction_customer_id;

		$sessionStatus = $this->error->checkTokens($appcode,$livetoken,$accessCode,$dynatoken,$transaction_customer_id);

		if($sessionStatus != 'valid'){
			if($sessionStatus[0] == "genericInvalidPair"){
			$this->error->promptError('ER:02:11');	
			}elseif($sessionStatus[0] == "genericExpired"){
			// die();
			$this->error->promptError('ER:02:13');
			}elseif($sessionStatus[1] == "transactionInvalidPair"){
			$this->error->promptError('ER:02:12');
			}elseif($sessionStatus[1] == "transactionExpired"){
			$this->error->promptError('ER:02:14');
			
			}elseif($sessionStatus[1] == "notOwner"){
			$this->error->promptError('ER:00:01');
			}else{
			$this->error->promptError('ER:02:02');
			}
		
		}else{

				// force voucher type to be always all to avoid issue with generation of per ticket voucher
				$type = "all";
				$voucher_type = ($type == 'all') ? 'all' : 'one';
				$transaction_id = ($transaction_id) ? $transaction_id : 0;
				
				$data['voucher_type'] = $voucher_type;						
				// $data['transaction'] = $voucher;
				if(!$voucher){ 
					$this->error->promptError('ER:06:07');
				}

				$data['tickets'] = $voucher;
				
				if(count($data['tickets']) > 0){
					$data['payment_type'] = $data['tickets'][0]->payment_type_name;

					// echo '<pre>';

					
					// display the page
					// $this->load->view('1transaction_tickets', $data);
					$this->load->view('ticket_voucher', $data);
				}else{
					echo 'Ticket not found';
				}
			}
					
		}		 
	}

	function profile(){
	
		
	
		$data['site_title'] = $this->config->item("site_title");			
 
		$url_base = $this->config->item('url_base');
		$username = $this->session->userdata('username');
  
		//check if logged in
		if(!$username){
			redirect('');
		}
	
		//customer profile
		$xml = simplexml_load_file("$url_base/generic_mod/nt_ViewAPIuserbyUsername?username=$username");
		$data['x'] = json_decode( json_encode($xml) , 1);

		$customerid = $data['x']['user_info']['customer_id'];
		
		
		//customer transactions
		$xml = simplexml_load_file("$url_base/generic_mod/nt_GetCustomerTransactions?customerid=$customerid");
		$y = json_decode( json_encode($xml) , 1);

		 
		 
		$data['y'] = array();
		if( isset($y['errorCode']))
		{
			 // list is empty.
		}else{
		
		
			if(!isset($y['event_info'][0])){
			
				foreach($y as $z){
					
					$data['y']['event_info'][0]['transaction_id'] = $z['transaction_id'];
					$data['y']['event_info'][0]['transaction_date'] = $z['transaction_date'];
					$data['y']['event_info'][0]['event_title'] = $z['event_title'];
					$data['y']['event_info'][0]['branch'] = $z['branch'];
					$data['y']['event_info'][0]['status'] = $z['status'];
				
				}
			
			
			}else{
			
				$data['y'] = $y;
			
			}
			
		
		
		}
		
		
		
		
		// echo '<pre>';
		// print_r($data['y']);
		// echo '</pre>';
		
		// die();		
 
		
		
		  
	
	
		$this->load->view('users_profile', $data);
	
	
	
	
	}
	
	function issue_tempo_session(){
		
		$session = $this->user->issue_tempo_session();
		echo $session;
	}
	
	function send_email($email = false,$reset_link = false){

		$this->load->library('email');
		$this->email->from('noreply@announcements.com', 'SMTICKETS');
		$this->email->to($email); 
		$this->email->subject('RESET PASSWORD');
		$message = "CONGRATULATIONS!\n\n Hi, \n This is your password reset link \n $reset_link";
		$this->email->message($message);
		$this->email->send();
	
	}
	
	function send_email_confirmation($email = false,$link = false){

		$this->load->library('email');
		$this->email->from('noreply@announcements.com', 'SMTICKETS');
		$this->email->to($email); 
		$this->email->subject('Email Activation');
		$message = "CONGRATULATIONS!\n\n Hi, \n Please click the link below to login your account. \n $link";
		$this->email->message($message);
		$this->email->send();
	
	}

	function send_reset_password_email($username = false,$email=false,$reset_url=false ){

		$url = $this->config->item("url_base").'/email/send_reset_password_email';
		$data = array(
				'username' => $username,
				'email' => $email,
				'reset_url' => $reset_url,
		);
		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);

		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
		
		// echo "<pre>";
		// print_r($result);
		// echo "</pre>";
		// die();
		
		// $this->load->library('email');
		// $this->email->from('noreply@announcements.com', 'SMTICKETS');
		// $this->email->to($email); 
		// $this->email->subject('Email Activation');
		// $message = "CONGRATULATIONS!\n\n Hi	$username, \n This is your password reset link \n $reset_url";
		// $this->email->message($message);
		// $this->email->send();
	
	}

	function prep_password($password){
		return sha1($this->config->item('encryption_key').$password);
	}


	
	function view_voucher(	$transID , $token	){
		
		$url = $this->config->item("url_base") ."/reports/nt_Voucher/" . $transID . "/" . $token . "/voucher.pdf";
		
		// echo $url;
		// die();
		$content = file_get_contents(	$url	);
		if(	$content != "invalid access"	){
			header('Content-type: application/pdf');
			echo $content;
		}else{
			header("Location:" . base_url() . "/users/view_login" );
		}
	}
	

	function view_reservations(){

			
		$privatekey = "6LfrXhUUAAAAAE15xbPg-Og749VRE59Mu8Fc4I88";
		$response = $this->input->post("grecaptcharesponse");

								
		$url_1 = 'https://www.google.com/recaptcha/api/siteverify';
		$data_1 = array(
			'secret' => $privatekey,
			'response' => $response
		);
		$options_1 = array(
				'http' => array(
					'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
					'method'  => 'POST',
					'content' => http_build_query($data_1)
				),
			);

		$context_1  = stream_context_create($options_1);
		$result_1 = file_get_contents($url_1, false, $context_1);
			

		$resp = json_decode($result_1);
			
		if ($resp->success != 1) {
			$resp->{'is_valid'} = false;
			$resp->{'result'} = false;
		}else{
			$pcode = $this->input->get_post('pcode');
			if(!empty($pcode)){
				if(strlen($pcode)>=14){
					$arr = explode("-",$pcode);
					if(count($arr)==3){
						$resp->{'is_valid'} = true;
						$xml = simplexml_load_file( $this->config->item("url_base") . "/generic_mod/nt_get_reservations?pcode=$pcode");
						$reservation = json_decode( json_encode($xml) , 1);
		
						if(isset($reservation["event_info"])){
							$data["reservation"] = $reservation["event_info"];
						}else{
							$data["reservation"] = false;
						}
						
						// error_reporting(E_ERROR);
						// $resp->{'result'} = printf(file_get_contents($this->load->view("reservations_table", $data)));
						$resp->{'result'} = json_encode($data["reservation"]);
						
					}else{
						$resp->{'is_valid'} = false;
						$resp->{'result'} = false;
						// echo '<script>alert("Please Input a valid Reservation Code.");</script>';
						// $this->load->view("redeem_reservation");
					}
				}else{
					$resp->{'is_valid'} = false;
					$resp->{'result'} = false;
					// echo '<script>alert("Please Input a valid Reservation Code.");</script>';
					// $this->load->view("redeem_reservation");
				}
			}else{
				$resp->{'is_valid'} = false;
				$resp->{'result'} = false;
				// echo '<script>alert("Please Input the Reservation Code.");</script>';
				// $this->load->view("redeem_reservation");
			}		
		}
		
		echo json_encode($resp);
	}
	
	function reservations() {
		
		$t_id = $this->input->get_post('rid');
		$xml = simplexml_load_file( $this->config->item("url_base") . "/generic_mod/nt_get_reserved_tickets?t_id=$t_id");
		$transaction = json_decode( json_encode($xml) , 1);
		$trans = $transaction["reservation_info"];
		
		if(isset($trans[0])){
			
			$data["transactions"] = $trans;
		}else{
			 
			$trans2[0] = $trans; 
			$data["transactions"] = $trans2;
		}
		
		// echo "<pre>";
		// print_r($data["transactions"]);
		// echo "</pre>";
		// die();
		
		if($data["transactions"][0]['ticket_status'] == 'reserved'){
			//$this->load->view('reservation_page',$data);		
			// $this->load->view('reservation_all', $data);	
			$this->load->view('header_revamp');
			$this->load->view('reservation_revamp', $data);
			$this->load->view('footer_revamp');
		}else{
			redirect($this->config->item('base').'users/my_profile/failed');
		}
	
	
		
	
	}
	
	function print_online_tickets($eid = 0, $transaction_id = false, $barcode = false, $ticket_count = 0){
		//Log Entry
		$user_id = ($this->session->userdata('user_id')) ? $this->session->userdata('user_id') : '';
		$branch_id = ($this->session->userdata('user_branch_id')) ? $this->session->userdata('user_branch_id') : '';
		$referrer = (isset($_SERVER["HTTP_REFERER"])) ? $_SERVER["HTTP_REFERER"] : '';
		$details = (isset($_POST)) ? serialize($_POST) : '';
		//$action = 'Claim Online Tickets';
		
		$details = array(
			'log_date'				=> 	date("Y-m-d H:i:s"),
			//'log_action'			=>	$action,
			'log_uri'				=> 	$_SERVER["REQUEST_URI"],
			'log_user_id'			=> 	$user_id,
			'log_branch_id'			=>	$branch_id,
			//'log_ip_address'		=>	get_ip_address(),
			'log_ip_address'		=>	$this->input->ip_address(),
			'log_platform'			=>	$this->agent->platform(),
			'log_browser'			=>	$this->agent->browser(),
			'log_browser_version'	=>	$this->agent->version(),
			'log_agent_string'		=>	$this->agent->agent_string(),
			'log_referrer'			=> 	$referrer,
			'log_details'			=>	$details,
		);
		
		$fields = http_build_query(array('fields' => $details));
		
		$context = stream_context_create (array (
			'http' => array (	 
			'method' => 'POST',
			'header' => "Connection: close\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n",
			'content' => $fields,
			)
		));
		
		// $url_base = $this->config->item('url_base');
		// file_get_contents("$url_base/logs/log_in", null, $context);
		
		
		//PDF File
		$url = $this->config->item("url_base") ."/newtickets/print_online_tickets/" . $eid . "/" . $transaction_id . "/" . $barcode . "/" . $ticket_count . "/print_at_home_ticket.pdf";
		$content = file_get_contents($url);
		 
		
		if(	$content != "invalid access"	){
			header('Content-type: application/pdf');
			echo $content;
		}else{
			header("Location:" . base_url() . "/users/view_login" );
		}
	
	}
	
	function subscription_status(){
		
		$event_id = $this->input->post('eventid');
		$username = $this->input->post('username');
		
		$status = file_get_contents($this->config->item('url_base')."/transaction/get_subscription_status/".$event_id."/".$username);
		
		if($status > 0){
			echo 1;
		}else{
			echo 0;
		}
		
	}
	
	function subscription_update(){
		
		$event_id = $this->input->post('eventid');
		$username = $this->input->post('username');
		
		$status = file_get_contents($this->config->item('url_base')."/transaction/update_subscription_status/".$event_id."/".$username);
		
		if($status > 0){
			echo 1;
		}else{
			echo 0;
		}
		
	}
	
	function insert_agreement($username,$agree=FALSE){
		
		// $agree = $this->input->post("agree");
		
		$url = $this->config->item("url_base")."/transaction/insert_privacy_agreement/".$this->session->userdata('username')."/".$agree;
		$result = file_get_contents($url);
		
		echo $result;
	}
	
	
	
	
	
	
	
	}
/* End of file welcome.php */
/* Location: ./system/application/controllers/welcome.php */
