<?php

class Terms extends Controller {

	function Terms()
	{
		parent::Controller();	
		$this->load->model('events_model', 'events');
		$this->load->model('venue_model', 'venue');
		$this->load->model('sections_model', 'sections');
		$this->load->model('prices_model', 'prices');
		date_default_timezone_set('Asia/Manila');
	}
	
	function index()
	{
		$this->view_terms_and_conditions();
	}
	
	function view_terms_and_conditions(){
		$data['site_title'] = "SMTICKETS - Home";
		$data['new_events'] = $this->events->get_new_events(12);	
		// $this->load->view('terms_page',$data);
		// $this->load->view('terms_page_all',$data);
		
		if($this->session->userdata('logged_in') == true){
			$url = $this->config->item("url_base")."/transaction/check_privacy_agreement/".$this->session->userdata('username');
			$data['privacy'] = json_decode(file_get_contents($url));
		}else{
			$data['privacy'] = false;
		}
		
		$data['location'] = 'Home';
		
		$this->load->view('header_revamp');
		$this->load->view('terms_page_revamp',$data);
		$this->load->view('footer_revamp');
	}
	
	function dpa($edm=FALSE){
		
		$data['site_title'] = "SMTICKETS - Home";
		
		if(!$edm){
			$data['username'] = $this->session->userdata("username");
			
			$url = $this->config->item("url_base")."/transaction/check_privacy_agreement/".$this->session->userdata('username');
			$data['privacy'] = json_decode(file_get_contents($url));
			
			// print_r($data['privacy']);
			// die();
	
			$this->load->view('header_revamp');
			$this->load->view('terms_page_revamp_dpa',$data);
			$this->load->view('footer_revamp');
		}else{
			$this->load->helper('cookie');
			 $cookie = array(
 
				   'name'   => 'sm_overideReset',
		 
				   'value'  => 'email',
		 
				   'expire' => '3600',
		 
			   );
			set_cookie($cookie);
			
			redirect('users/view_login');
		}
		
		
	}
	
	function test(){
	
	
	echo 'test';
	}
}

/* End of file welcome.php */
/* Location: ./system/application/controllers/welcome.php */