<?php

class Queue extends Controller {

	function Queue()
	{
		parent::Controller();	
		$this->load->model('events_model', 'events');
		$this->load->model('venue_model', 'venue');
		$this->load->model('sections_model', 'sections');
		$this->load->model('prices_model', 'prices');
		$this->load->model('users_model', 'user');
		$this->load->model('tickets_model', 'tickets');
		$this->load->library('user_agent');
	}
	
	function index()
	{
		// show_404();
		$this->home(6503);	
	}
	
	function home($event_id=false){
		
		if($event_id){
			if($event_id == 6904)
			show_404();
			$data['event'] = $this->events->get($event_id);
			
			// echo "<pre>";
			// print_r($data['event']);
			// echo "</pre>";
			// die();
			
			if($data['event']){
				$this->load->view('queue_view',$data);
			}else{
				show_404();
			}
			
			
		}else{
			
			show_404();
			
		}
	}
	
	function view_voucher($ticket_id,$event_id){
		
		$url = $this->config->item("url_base") ."/queue/nt_Queue/" . $ticket_id . "/" . $event_id . "/voucher.pdf";
		$content = file_get_contents(	$url	);
		if(	$content != "invalid access"	){
			// header("Content-disposition: attachment; filename=voucher-".$ticket_id.".pdf");
			header('Content-type: application/pdf');
			echo $content;
		}else{
			header("Location:" . base_url() . "queue/home/".$event_id );
		}
	}
	
	function check_ticket($ticket_id,$event_id){
		
		$url = $this->config->item("url_base") ."/queue/nt_check_ticket/" . $ticket_id . "/" . $event_id . "/voucher.pdf";
		$content = file_get_contents(	$url	);
		
		echo $content;
	} 
	
	function oneokrock(){
		$this->home(6128);	
	}
	
	function elyxion(){
		$this->home(6503);	
	}
	
	
}
/* End of file welcome.php */
/* Location: ./system/application/controllers/welcome.php */