<?php

class Missuniverse2016 extends Controller {

	function Missuniverse2016()
	{
		parent::Controller();	
		$this->load->model('events_model', 'events');
		$this->load->model('venue_model', 'venue');
		$this->load->model('sections_model', 'sections');
		$this->load->model('prices_model', 'prices');
		date_default_timezone_set('Asia/Manila');
	}
	
	function index()
	{
		$this->view(4370);
	}
	
		
	function view_($event_id = false,$referrer = false ){
	
		$data['referrer'] = $referrer;
		
		$data['hot_events'] = "";
		if ($event_id=="undefined") {
			$this->load->view("error_page");
		}else{
			$data['e_url'] = json_decode(json_encode($this->events->get_url($event_id)));
			$event_url = $data['e_url']->event_url;	
			
			// echo "<pre>";
			// print_r($data['e_url']);
			// echo "</pre>";
			// die();
			if($event_url){
				redirect(base_url()."event/".$event_url);
			}else{
				redirect(base_url()."events/view_/".$event_id);
			}
		
			
			
		}
	}

	function view_slug($event_url = false,$referrer = false ){
	
		$data['referrer'] = $referrer;
		
		$data['hot_events'] = "";
		if ($event_url=="undefined") {
			$this->load->view("error_page");
		}else{
			$data['e_id'] = json_decode(json_encode($this->events->get_id($event_url)));
			$event_id = $data['e_id']->event_id;
			$data['site_title'] = $this->config->item("site_title");		
			$data["event"] = $this->events->get($event_id);
			$data["seo"] = $this->events->get_seo($event_id);	
			// die($event_id);
				
				
			// if($event_id == "10"){
			
			// echo $event_id;
			// echo "<pre>";
			// print_r($data['event_id']);
			// echo "</pre>";
			// die();
			// }
			
			
			
			if($data["event"]){
					$data["event"]['event_venue_name'] = $this->venue->get($data["event"]['event_venue_id']); 
					$data["sections"] = $this->sections->get($event_id);	
					$data["prices"] = $this->prices->get($event_id);
					
					if(!$data["event"]["convenience_charge"]){
						$data["event"]["convenience_charge"] = 0;
					}
					
				$data["event_siblings"] = $this->get_events_by_long_title($data["event"]["event_long_title"],1);
			}else{
				redirect(base_url());
			}
			
			// $this->load->view('event_page',$data);
			// $this->load->view('event_all',$data);
			$this->load->view('header_event_revamp',$data);
			$this->load->view('event_revamp',$data);
			$this->load->view('footer_revamp');
		}
	}
	
	function view($event_id = false,$referrer = false ){
	
		$data['referrer'] = $referrer;
		
		$data['hot_events'] = "";
		if ($event_id=="undefined") {
			$this->load->view("error_page");
		}else{
			$data['site_title'] = $this->config->item("site_title");		
			$data["event"] = $this->events->get_sp($event_id);
			$data["seo"] = $this->events->get_seo($event_id);
				
			// die($event_id);
				
				
			// if($event_id == "10"){
			
			// echo $event_id;
			// echo "<pre>";
			// print_r($this->events->get($event_id));
			// echo "</pre>";
			// die();
			// }
			
			
			// /* Access Code for the Event */ //
			$data['event_access_code'] = '65thMissUPHL'; 
			// $data['event_access_code'] = '65thMissUMNL'; 
			
			if($data["event"]){
					$data["event"]['event_venue_name'] = $this->venue->get($data["event"]['event_venue_id']); 
					$data["sections"] = $this->sections->get($event_id);	
					$data["prices"] = $this->prices->get($event_id);
					
					if(!$data["event"]["convenience_charge"]){
						$data["event"]["convenience_charge"] = 0;
					}
					
				$data["event_siblings"] = $this->get_events_by_long_title($data["event"]["event_long_title"],1);
			}else{
				redirect(base_url());
			}
			
			// $this->load->view('event_page',$data);
			// $this->load->view('event_all',$data);
			$this->load->view('mu/header_mu',$data);
			$this->load->view('mu/event_mu',$data);
			$this->load->view('mu/footer_mu');
		}
	}
	
	
	function get_events_by_parent($event_id = false) {
	
		$data['hot_events'] = "";
	
		echo json_encode(	$this->events->get_events_by_parent($event_id)	);
		die();

	}
	
	function get_events_by_long_title($event_long_title = false,$json=false) {
	
		$data['hot_events'] = "";
	if($json){
		return json_encode(	$this->events->get_events_by_long_title($event_long_title)	);
		
	}else{
		return $this->events->get_events_by_long_title($event_long_title);
	}
		

	}
		
	
	//FOR AJAX  CALLS ++++++++++++++++++++++++++++++++++
	function getEventDatesbyLongTitle(){
		$long_title = $this->input->get_post("long_title");
		
			
		$parameters = Array(
				'venue' => false,
				'category' => false,
				'match' => false,
				'long_title' => urlencode($long_title)
				);
				
		$event_array = $this->events->getEventsForListing($parameters);
		echo json_encode($event_array);	
	}
	
	function getEventsforQuickBuy(){
		
			$all_events = $this->events->getEventsForListing();
			echo json_encode($all_events);
	}
	
	
		
	function getEventlistings(){
		$event_listings = $this->events->getEventIDs();
		echo $data["event_listings"] = json_encode($event_listings);	
	}
	
	
	
	
	function check_promo(){
		
		$promo_code = $this->input->post("promo_code");
		echo $promo_code;
		
		echo "success";
	}
	
	function getLastDateModified(){
		echo $lastDateModified = $this->events->getLastDateModified();
	}

	function getRemainingSeat($section_id){

		$url = $this->config->item("url_base") . "/generic_mod/getRemainingSeat/" . $section_id;
		$result = file_get_contents($url);
		
		$result = new SimpleXMLElement($result);
		$result = json_encode($result);
		
		die($result);
	}
}

/* End of file welcome.php */
/* Location: ./system/application/controllers/welcome.php */