<?php

class Images extends Controller {

	function Images()
	{
		parent::Controller();	
		$this->load->model('events_model', 'events');
		$this->load->model('venue_model', 'venue');
		$this->load->model('sections_model', 'sections');
		$this->load->model('prices_model', 'prices');
		$this->load->model('users_model', 'user');
		$this->load->model('tickets_model', 'tickets');
		$this->load->library('user_agent');
	}
	
	function index()
	{
		show_404();
	}
	
	function cache($par1,$par2,$par3=false){
		if($par1 != "ads"){
			$par1 = $par1 . "/" . $par2;
			$par2 = $par3;
		}
		
		$path = $this->config->item("url_base")."/images/cache/".$par1."/".$par2;
		
		
		$seconds_to_cache = 2592000;
		$ts = gmdate("D, d M Y H:i:s", time() + $seconds_to_cache) . " GMT";
		header("Content-type:image/jpeg");
		header("Expires: $ts");
		header("Pragma: cache");
		header("Cache-Control: max-age=$seconds_to_cache");
		header('Last-Modified: '.gmdate('D, d M Y H:i:s', time()).' GMT');
		echo file_get_contents($path);
	}
	
	function cache_2($par,$par0,$par1,$par2,$par3=false){
		
		if($par1 != "ads"){
			$par1 = $par1 . "/" . $par2;
			$par2 = $par3;
		}
		
		// $f = $this->input->get_post('f');
		$w = $this->input->get_post('w');
		$h = $this->input->get_post('h');
		
		$path = $this->config->item("url_base")."/images/cache/".$par1."/".$par2;
		

		// $img = APPPATH.'/cache/'.$w.'x'.$h.;
		// $folder = APPPATH.'/cache/'.$w.'x'.$h;
		// $folder = APPPATH.'/cache/'.$w;
		
		// if($w && $h){
			$folder = APPPATH.'/cache/'.$par.'/'.$par0;
			// $folder = APPPATH.'/cache/'.$w."x".$h;
			// $folder = APPPATH.'/cache/'.$w;
			// $folder = APPPATH.'/cache/'.$f.'/'.$w;
		// }else{
			// $folder = APPPATH.'/cache/';
		// }
		
		$img = $folder.'/'.$par2;
		
		if (file_exists($img)) {
			// echo "The file $filename exists";
			$path_image = $img;
		} else {
			// echo "The file $filename does not exist";
			
			if($w && $h){
				$path_image = $this->process($w,$h,$par,$par0,$path,$par2);
			}else{
				$path_image = $path;
			}
			
		}
		
		$seconds_to_cache = 2592000;
		$ts = gmdate("D, d M Y H:i:s", time() + $seconds_to_cache) . " GMT";
		header("Content-type:image/jpeg");
		header("Expires: $ts");
		header("Pragma: cache");
		header("Cache-Control: max-age=$seconds_to_cache");
		header('Last-Modified: '.gmdate('D, d M Y H:i:s', time()).' GMT');
		echo file_get_contents($path_image);
	}
	
	function process($w,$h,$par,$par0,$path,$par2){
		
		// $folder = APPPATH.'/cache/'.$w;
		// $folder = APPPATH.'/cache/'.$w."x".$h;
		$folder = APPPATH.'/cache/'.$par.'/'.$par0;
		
		$img = $folder.'/'.$par2;
		
		if (file_exists($img)) {
			// echo "The file $filename exists";
			$path_image = $img;
			// die("EXISTS");	
		} else {
			// echo "The file $filename does not exist";
			
			if (!file_exists($folder) && !is_writable($folder)) {
				mkdir($folder, 0777, true);
			}
			
			file_put_contents($img, file_get_contents($path));
			
			$config['image_library'] = 'gd2';
			$config['source_image'] = $img;
			// $config['create_thumb'] = TRUE;
			$config['file_permissions'] = '0777';
			$config['maintain_ratio'] = TRUE;
			// $config['quality'] = '100';
			$config['width'] = $w;
			$config['height'] = $h;

			$this->load->library('image_lib', $config);

			$this->image_lib->resize();
			
			$path_image = $img;
			// die("CACHED");
			
		}
		return $path_image;
	}
	
	function process2(){
		
		// if($par1 != "ads"){
			// $par1 = $par1 . "/" . $par2;
			// $par2 = $par3;
		// }
		$f = $this->input->get_post('f');
		$w = $this->input->get_post('w');
		$h = $this->input->get_post('h');
		$path = $this->input->get_post('url');
		
		$name = explode("/",$path);
		
		// $folder = APPPATH.'/cache/'.$w;
		$folder = APPPATH.'/cache/'.$f.'/'.$w;
		
		
		if($name[3] == 'images'){
			
			if($name[5] == 'ads'){
				$par2 = $name[6];
			}else{
				$par2 = $name[7];
			}
			
		}else{
			die("N/A");
		}
		
		$img = $folder.'/'.$par2;

		// $img = APPPATH.'/cache/'.$w.'x'.$h.;
		// $folder = APPPATH.'/cache/'.$w.'x'.$h;
		
		
		if (file_exists($img)) {
			// echo "The file $filename exists";
			$path_image = $img;
			die("EXISTS");
		} else {
			// echo "The file $filename does not exist";
			
			if (!file_exists($folder) && !is_writable($folder)) {
				mkdir($folder, 0777, true);
			}
			
			file_put_contents($img, file_get_contents($path));
			
			$config['image_library'] = 'gd2';
			$config['source_image'] = $img;
			// $config['create_thumb'] = TRUE;
			$config['file_permissions'] = '0777';
			$config['maintain_ratio'] = TRUE;
			$config['quality'] = '100';
			$config['width'] = $w;
			$config['height'] = $h;

			$this->load->library('image_lib', $config);

			$this->image_lib->resize();
			
			$path_image = $img;
			die("CACHED");
		}
	}
	
	function remove_cache(){
		$dir = APPPATH.'/cache/';
		 if (is_dir($dir)) {
			$objects = scandir($dir);
			foreach ($objects as $object) {
				if ($object != "." && $object != "..") {
					if (filetype($dir."/".$object) == "dir"){
						$objects1 = scandir($dir."/".$object);
						foreach($objects1 as $object1){
							if ($object1 != "." && $object1 != "..") {
								if (filetype($dir."/".$object."/".$object1) == "dir"){
									$objects2 = scandir($dir."/".$object."/".$object1);
									foreach($objects2 as $object2){
										if ($object2 != "." && $object2 != "..") {
											if (filetype($dir."/".$object."/".$object1."/".$object2) == "dir"){
												rmdir($dir."/".$object."/".$object1);
											}else{	
												unlink   ($dir."/".$object."/".$object1."/".$object2);
											}
										}
									}
									reset($objects2);
									rmdir($dir."/".$object."/".$object1);
								}else{	
									unlink   ($dir."/".$object."/".$object1);
								}
							}
						}
						reset($objects1);
						rmdir($dir."/".$object); 
					}else{ 
						unlink   ($dir."/".$object);
					}
				}
			}
			reset($objects);
			rmdir($dir);
		}
		mkdir($dir, 0777, true);
	}
	
	function remove_folder($num){
		$dir = APPPATH.'/cache/'.$num.'/';
		 if (is_dir($dir)) {
			$objects = scandir($dir);
			foreach ($objects as $object) {
				if ($object != "." && $object != "..") {
					if (filetype($dir."/".$object) == "dir"){
						$objects1 = scandir($dir."/".$object);
						foreach($objects1 as $object1){
							if ($object1 != "." && $object1 != "..") {
								if (filetype($dir."/".$object."/".$object1) == "dir"){
									$objects2 = scandir($dir."/".$object."/".$object1);
									foreach($objects2 as $object2){
										if ($object2 != "." && $object2 != "..") {
											if (filetype($dir."/".$object."/".$object1."/".$object2) == "dir"){
												rmdir($dir."/".$object."/".$object1);
											}else{	
												unlink   ($dir."/".$object."/".$object1."/".$object2);
											}
										}
									}
									reset($objects2);
									rmdir($dir."/".$object."/".$object1);
								}else{	
									unlink   ($dir."/".$object."/".$object1);
								}
							}
						}
						reset($objects1);
						rmdir($dir."/".$object); 
					}else{ 
						unlink   ($dir."/".$object);
					}
				}
			}
			reset($objects);
			rmdir($dir);
		}
	}
	
	function APPPATH_echo(){
		echo APPPATH;
	}

}
/* End of file welcome.php */
/* Location: ./system/application/controllers/welcome.php */