<?php

class Generators extends Controller 
{
	/* NOTE: using a model class to handle dbproc causes 
		memory to run out and greatly affects 
		PDF generation based on XML generator
		
		Tested 100-200 ticket nodes for loading using
		initial output design for db storage and PDF generation
	*/
	
	// template for revised ticket layout
	// var $viewfile = "generator_xml_dynamic_resized_278x206-A";
	// var $viewfile = "generator_xml_dynamic_resized_278x206-B";
	// var $viewfile = "generator_xml_dynamic_resized_278x216-B";
	// var $viewfile = "generator_xml_dynamic_resized_278x216-B-20120326";
	var $viewfile = "generator_xml_dynamic_resized_288x216-C";
	
	// background image for ticket preview
	// var $ticket_bg_expanded  = 'application/views/images/ticket_bg_2012_resized_278x206.jpg';
	// var $ticket_bg_expanded  = 'application/views/images/ticket_bg_2012.jpg';
	var $ticket_bg_expanded  = 'application/views/images/ticket_bg_2013.png';

	function Generators()
	{
		parent::Controller();
		$this->output->set_header("Cache-Control: no-store, no-cache, must-revalidate");
		$this->output->set_header("Pragma: no-cache");
		$this->output->set_header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past
		$this->load->helper('generator');
		$this->load->model('generator_model', 'generator');
		$this->load->database('default');
	}
	
	function kamote() {

		echo "Kamote.";

	}

	// to generate ticket data format in xml format for db storage
	function newticket2db($count = 0) {

		$data["count"] = $count;
		$text = $this->load->view("generator_xml_4x3", $data, true);
		
		$valid = false;
		$insert_id = 0;
		$yearmonth = date('ym');
		if (!empty($text)) {
			$fields = array(
				'xml_yearmonth' => $yearmonth,
				'xml_content' => $text,
			);
			
			// build insert SQL
			$__isql = $this->db->insert_string("generator", $fields);
			$valid = $this->db->simple_query($__isql);
			$insert_id = $this->db->insert_id();
		}

		if (($valid) && ($insert_id > 0)) {
			// redirect("/printer/db2xml2pdf/$yearmonth/$insert_id");
			echo "Successfully created xml format <BR>";
			echo anchor("/printer/db2xml2pdf/$yearmonth/$insert_id","PDF Display - /printer/db2xml2pdf/$yearmonth/$insert_id","target=_blank");
		} else {
			// 404
			echo $__isql;
		}
	}
	
	// use this to display test xml output of new ticket layout
	function newticket($count = 0) {
		// for proper display of XML output on browser
		
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		
		$data["count"] = $count;
		$this->load->view("generator_xml_4x3",$data);
	}
	
	// use this to properly review stored XML data for printout
	function newticketFromDBReview($yearmonth = false, $id = false){
		if ($id) {} 
		else { die("Invalid access."); }
		// for proper display of XML output on browser
		$xmldata = "";
		if ($id && $yearmonth) {
			$this->db->where("xml_yearmonth", $yearmonth);
			$this->db->where("xml_id", $id);
			$query = $this->db->get("generator");
			
			foreach($query->result() as $row) {
				$xmldata = $row->xml_content;
			}
		}

		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		echo $xmldata;
		// $this->load->view("generator_xml_4x3");
		// $this->load->view($this->viewfile);
	}

	// use this to display test xml output of new ticket layout
	function eventSample($event_id = 0, $preview = false ) {

		$event_id = str_replace(".pdf", "", $event_id);
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;

		$count = 0;
		$data["count"] = $count;
		$data["preview"] = $preview;

		$this->load->model('prices_model', 'prices');
		$this->load->model('events_model', 'events');
		$this->load->model('sections_model', 'sections');
		$this->load->model('generator_model', 'generator');
		
		$useExpandedTicket = $this->config->item("enable_ticket_4x3");
		// start build of data

		// ticket layout
		$this->load->helper('xml');
		list($bgimage, $layout) = $this->generator->GetLayoutDetails($event_id);

		$this->load->helper('xml');

		$bgimage[0] = "";
		if ($preview) {
			// for barcode display
			if ($useExpandedTicket) {
				$bgimage[0] = BASEPATH.$this->ticket_bg_expanded;
			} else {
				$bgimage[0] = BASEPATH.'application/views/images/ticket_bg.jpg';
			}
		}

		$data["layout"] = $layout;
		$data["bgimage"] = $bgimage;

		// empty array of logo (not to be used for new ticket layout)
		$logo1 = array();


		// PREVIEW: Events
		$preview_prices = $this->prices->get_prices($event_id);

		$preview_priceprice = 5000;
		$preview_sectionname = 'PATRON VIP';
		$preview_row = "R";
		$preview_seat = "8";
			
		if (is_array($preview_prices)) {
			$preview_sectionname = $preview_prices[0]->price_name;
			$preview_priceprice = $preview_prices[0]->price_price;
			$preview_pricesections = $preview_prices[0]->price_sections;
		}
		
		// PREVIEW: Info
		$preview_eventcode = "EVENTCODE";
		
		$preview_events = $this->events->get($event_id);
		if(is_object($preview_events)) {
			$preview_eventcode = $preview_events->event_code;
			
			$preview_sections = $this->sections->get_sections($preview_events->event_seatplan_id);
			$preview_sectionseatconfig = "";
			foreach($preview_sections as $ps) {
				if(strpos($preview_pricesections,"\"$ps->section_id\"")>0) {
					$preview_sectionname = $ps->section_name;
					$preview_sectiontype = $ps->section_type;
					$preview_sectionseatconfig = $ps->section_seat_config;
					break;
				}
			}
			
			if ($preview_sectionseatconfig == "") {
				$preview_row = "ROW";
				$preview_seat = "SEAT";
			}
		}

		$tix_info[] = array (
			"tid" => 1,
			"evc" => strtoupper($preview_eventcode),
			"serial" => 1,
			"secname" => $preview_sectionname,
			"row" => $preview_row,
			"seat" => $preview_seat,
			"ttcode" => "RP",
			"paytype" => "CASH",
			"price" => $preview_priceprice,
			"termcode" => "SMMOA",
			"printer" => "TICKETSELLER",
			"arnum" => 0,
			"eid" => sprintf('%06s', $event_id),
			"bc_prefix" => sprintf('%04s', date("ym")),
			"bc_access" => sprintf('%06s', 1),		
		);
			; 
		$data["transaction"] = array(
			"id" => 1,
			"uid" => 1,
			"datetime" => date("Y-m-d H:i:s"),
			"tickets" => $tix_info,
		);
			// sample branch
		$data["branch"] = array(
				'city' => 'Pasay City',
				'tin' => '123-456-789-0000',
			);

		//for special event
		$data['price_id'] = 1;
		$data['event_id'] = $event_id;
		
		$this->load->view($this->viewfile,$data);
		// $this->load->view("generator_xml_dynamic",$data);
		// $this->load->view("generator_xml_dynamic_rev",$data);
		// $this->load->view("generator_xml_4x3.php",$data);
		// $this->load->view("generator_xml_dynamic_resized_278x206",$data);
		// $this->load->view("generator_xml_dynamic_resized_278x206-A",$data);
		// $this->load->view("generator_xml_dynamic_resized_278x206-B",$data);
	}

	function index(){
		$callparam = $_GET;
	
		//the path of the xml that will be converted to pdf
		$url = base_url()."generator/newticket";
		$this->load->library('HTTPCall');
		$this->httpcall->do_http_get_request($url,$callparam);

		$xmldata = $this->httpcall->rawoutput;
	
		$this->load->library('simplexml');  
		$content = $this->simplexml->xml_parse($xmldata, "&amp");
		$data['layout'] = $content['layout']['@attributes'];
		if(isset( $content['ticket'][0])){
			$data['tickets']  = $content['ticket'];
			
		} else {
			$data['tickets'][0]  = $content['ticket'];
		}
		

		$this->load->helper('file');
		$this->load->view('printer_xml2pdf',$data);

	}	

	// use this to display test xml output of new ticket layout
	function createXMLTickets($event_id = 0, $transaction_id = 0, $ticket_count = 0, $online_claim = false) {

		if ($ticket_count > 0) {
			// continue
		} else {
			show_404();
		}
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;

		$this->load->model('tickprices_model', 'prices');
		$this->load->model('payments_model', 'payments');
		$this->load->model('tickevents_model', 'events');
		$this->load->model('ticksections_model', 'sections');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('ticktickets_model', 'tickets');
		$this->load->model('branches_model', 'branches');


		list($bgimage, $layout) = $this->generator->GetLayoutDetails($event_id);
		$data["layout"] = $layout;
		$data["bgimage"] = $bgimage;

		// empty array of logo (not to be used for new ticket layout)
		$logo1 = array();

		$event = $this->events->get($event_id);
		if(is_object($event)) {
			$eventcode = $event->event_code;
		}


		$payments = $this->payments->get_payments($transaction_id);
		$payment_type = (count($payments) > 1) ? 'Multi' : $payments[0]->payment_type_code;

		$type = "paid";
		$ticketlist = $this->generator->get_paid_tickets_for_printing($transaction_id);
		$transaction = $this->transactions->get($transaction_id);

		/*echo "<pre>";
		print_r($ticketlist);
		echo "</pre>";
		die();*/

		if ($transaction->transaction_user_id == $this->config->item('online_seller_id')) {
			$isweb = 'WEB';
		}
		if ($ticket_count == count($ticketlist)) {
			// ticket count verified, please proceed to next step
		} else {
			// count mismatch
			show_404();
		}
				
		foreach($ticketlist as $tix) {
			// serial number
			$serial = 1;
			$serial_number = $this->prices->get_serial_number($tix->ticket_price_id);
			
			// per ticket price (discount aapplied)
			$ticket_price = 0;
			if ($tix->ticket_type_discount_type == 'Amount')
			{
				$ticket_price = ceil($tix->price_price - $tix->ticket_type_discount);
			}
            elseif ($tix->ticket_type_discount_type == 'Percentage')
			{
            	$ticket_price= ceil($tix->price_price - (($tix->price_price * $tix->ticket_type_discount)/100));
			}

			// acknowledgement number
			if ($tix->ticket_type_discount_type == 'Percentage' and $tix->ticket_type_discount == 100)
			{
				$receipt_number = 'COMPLIMENTARY';
			}
			else
			{
				if ($tix->ticket_acknowledgment_receipt > 0) { 
					$receipt_number = $tix->ticket_acknowledgment_receipt;
				}
				else {
					// get receipt number
					$receipt_number = $this->branches->get_last_receipt_number($tix->ticket_branch_id);
					
					// update transactions table
					$this->tickets->update_acknowledgment_receipt($tix->ticket_id, $receipt_number);
				}
			}

			$tix_info[] = array (
				"tid" => $tix->ticket_id,
				"evc" => strtoupper($eventcode),
				"serial" => $serial_number,
				"secname" => $tix->section_name,
				"row" => $tix->ticket_row,
				"seat" => $tix->ticket_seat,
				"ttcode" => $tix->ticket_type_code,
				"paytype" => strtoupper($payment_type),
				"price" => $ticket_price,
				"termcode" => $tix->terminal_code,
				"printer" => strtoupper($tix->username),
				"arnum" => $receipt_number,
				"eid" => sprintf('%06s', $tix->event_id),
				// "bc_prefix" => sprintf('%04s', $tix->sm_prefix),
				"bc_prefix" => sprintf('%04s', $tix->sm_prefix_alt),
				"bc_access" => sprintf('%04s', $tix->sm_code),
			);
			
			$data["branch"] = array(
					'city' => strtoupper($tix->branch_city),
					'tin' => $tix->branch_tin,
				);

				
			$price_id = $tix->price_id;
		}
		
		$data["transaction"] = array(
			"id" => $transaction->transaction_id,
			"uid" => $transaction->transaction_user_id,
			"datetime" => $transaction->transaction_date,
			"tickets" => $tix_info,
		);

		//for special event
		$data['price_id'] = $price_id;
		$data['event_id'] = $event_id;
		// $xmltext = $this->load->view("generator_xml_dynamic_rev", $data, true);
		$xmltext = $this->load->view($this->viewfile, $data, true);

		$valid = false;
		$insert_id = 0;
		$yearmonth = date('ym');
		$__isql = "";
		
		if (!empty($xmltext)) {
			$fields = array(
				'xml_yearmonth' => $yearmonth,
				'xml_content' => $xmltext,
				'xml_trans_id' => $transaction_id,
			);
			
			// build insert SQL
			$__isql = $this->db->insert_string("generator", $fields);
			$valid = $this->db->simple_query($__isql);
			$insert_id = $this->db->insert_id();
		}

		if (($valid) && ($insert_id > 0)) {
			if ($online_claim) {
				redirect("/ticktransactions/print_online/$transaction_id/$event_id/$yearmonth/$ticket_count/$insert_id");
			} else {
				redirect("/ticktransactions/done_rev/$transaction_id/$event_id/$yearmonth/$ticket_count/$insert_id/");
			}
			// echo anchor("/printer/db2xml2pdf/$yearmonth/$insert_id","PDF Display - /printer/db2xml2pdf/$yearmonth/$insert_id","target=_blank");
		} else {
			show_404();
			// echo $__isql;
		}

	}
}