	<?php

class Event extends Controller {

	function Event()
	{
		parent::Controller();	
		$this->load->model('events_model', 'events');
		$this->load->model('venue_model', 'venue');
		$this->load->model('sections_model', 'sections');
		$this->load->model('prices_model', 'prices');
		date_default_timezone_set('Asia/Manila');
	}
	
	function index()
	{
		redirect('');
		// $this->view(4370);
	}
	
	//===== List of Special Events =====//
	
	function missuniverse65thprelims(){
		$this->view_h(5359,'prelimsmsuphl');
	}
	
	function missuniverse65thdress(){
		$this->view_h(5360,'dressmsuphl');
	}
	
	function disney(){
		$this->view_h(5485,'1234');
	}
	
	function onechampionship(){
		$this->view_h(5487,'onechampionship');
	}
	
	function kidzania(){
		$this->view_core(5645,'kidzania','7473fc109a9152a82afac06a98d4eb488f62a949');
	}
	
	function katyperry(){
		$this->view_core(6299,'katyperry','f11359bea75d39b7ba7293333e9925d4da8240dd');
	}
	//=================================================//	
	
	// /* Event View Function */ //
	function view_core($event_id = false, $access_code = false, $access_hash = false, $views = false, $referrer = false ){
		
		$data['referrer'] = $referrer;
		
		$data['hot_events'] = "";
		if ($event_id=="undefined") {
			$this->load->view("error_page");
		}else{
			if($access_hash == sha1(md5($access_code))){
				$data['site_title'] = $this->config->item("site_title");		
				$data["event"] = $this->events->get($event_id);
				$data["seo"] = $this->events->get_seo($event_id);
			
			
				// /* Access Code for the Event */ //
				if($access_code){
					$data['event_access_code'] = $access_code; 
				}
			
				if(!$views){
					$views = "event_revamp";
				}
				
				if($data["event"]){
					$data["event"]['event_venue_name'] = $this->venue->get($data["event"]['event_venue_id']); 
					$data["sections"] = $this->sections->get($event_id);	
					$data["prices"] = $this->prices->get($event_id);
					
					if(!$data["event"]["convenience_charge"]){
						$data["event"]["convenience_charge"] = 0;
					}
					
					$data["event_siblings"] = $this->get_events_by_long_title($data["event"]["event_long_title"],1);
				}else{
					redirect(base_url());
				}
			
				$this->load->view('header_event_revamp',$data);
				$this->load->view($views,$data);
				$this->load->view('footer_revamp');
				
			}else{
				redirect(base_url());
			}
			
		}
	}
	
	function view($event_id = false,$referrer = false ){
	
		if($event_id == 'kidzania'){
			$event_id = 5645;
		}
		
		if($event_id == 'katyperry'){
			$event_id = 6299;
		}
		
		$data['referrer'] = $referrer;
		
		$data['hot_events'] = "";
		if ($event_id=="undefined") {
			$this->load->view("error_page");
		}else{
			$data['site_title'] = $this->config->item("site_title");		
			$data["event"] = $this->events->get($event_id);
			$data["seo"] = $this->events->get_seo($event_id);
				
			// die($event_id);
				
				
			// if($event_id == "10"){
			
			// echo $event_id;
			// echo "<pre>";
			// print_r($this->events->get($event_id));
			// echo "</pre>";
			// die();
			// }
			
			$bundle_event = array(4446,5301,4137,5165); //it will use views/bundle/script.php and views/bundle/js/main.js
			
			if(in_array($event_id,$bundle_event)){
				$data['bundle'] = 1;
			}else{
				$data['bundle'] = 0;
			}
			
			$data['pixel_events_v2'] = array(5485); //pixel_events_v2
			
			if($data["event"]){
					$data["event"]['event_venue_name'] = $this->venue->get($data["event"]['event_venue_id']); 
					$data["sections"] = $this->sections->get($event_id);	
					$data["prices"] = $this->prices->get($event_id);
					
					if(!$data["event"]["convenience_charge"]){
						$data["event"]["convenience_charge"] = 0;
					}
					
				$data["event_siblings"] = $this->get_events_by_long_title($data["event"]["event_long_title"],1);
			}else{
				redirect(base_url());
			}
			

			$url = $this->config->item("url_base") . "/transaction/update_availability/" . $event_id; 
			$xml = file_get_contents($url); //To update availability
			
			// $this->load->view('event_page',$data);
			// $this->load->view('event_all',$data);
			$this->load->view('header_event_revamp',$data);
			$this->load->view('event_revamp',$data);
			$this->load->view('footer_revamp');
		}
	}
	
	function view_h($event_id = false, $access_code = false, $views = false, $referrer = false){
		
		$data['referrer'] = $referrer;
		
		$data['hot_events'] = "";
		if ($event_id=="undefined") {
			$this->load->view("error_page");
		}else{
				$data['site_title'] = $this->config->item("site_title");		
				$data["event"] = $this->events->get($event_id);
				$data["seo"] = $this->events->get_seo($event_id);
			
			
				// /* Access Code for the Event */ //
				if($access_code){
					$data['event_access_code'] = $access_code; 
				}
			
				if(!$views){
					$views = "event_revamp";
				}
				
			// echo "<pre>";
			// print_r($data["event"]);
			// echo "</pre>";
			// die();
			
				$data['pixel_events_v2'] = array(4446); //pixel_events_v2
				
				if($data["event"]){
					$data["event"]['event_venue_name'] = $this->venue->get($data["event"]['event_venue_id']); 
					$data["sections"] = $this->sections->get($event_id);	
					$data["prices"] = $this->prices->get($event_id);
					
					if(!$data["event"]["convenience_charge"]){
						$data["event"]["convenience_charge"] = 0;
					}
					
					$data["event_siblings"] = $this->get_events_by_long_title($data["event"]["event_long_title"],1);
				}else{
					redirect(base_url());
				}
			
				$this->load->view('header_event_revamp',$data);
				$this->load->view($views,$data);
				$this->load->view('footer_revamp');				
			
		}
	}
	
	function view_sp($event_id = false, $access_code = false, $views = false, $referrer = false){
		
		$data['referrer'] = $referrer;
		
		$data['hot_events'] = "";
		if ($event_id=="undefined") {
			$this->load->view("error_page");
		}else{
				$data['site_title'] = $this->config->item("site_title");		
				$data["event"] = $this->events->get_sp($event_id);
				$data["seo"] = $this->events->get_seo($event_id);
			
			
				// /* Access Code for the Event */ //
				if($access_code){
					$data['event_access_code'] = $access_code; 
				}
			
				if(!$views){
					$views = "event_revamp";
				}
				
			// echo "<pre>";
			// print_r($data["event"]);
			// echo "</pre>";
			// die();
			
				$data['pixel_events_v2'] = array(4446); //pixel_events_v2
				
				if($data["event"]){
					$data["event"]['event_venue_name'] = $this->venue->get($data["event"]['event_venue_id']); 
					$data["sections"] = $this->sections->get($event_id);	
					$data["prices"] = $this->prices->get($event_id);
					
					if(!$data["event"]["convenience_charge"]){
						$data["event"]["convenience_charge"] = 0;
					}
					
					$data["event_siblings"] = $this->get_events_by_long_title($data["event"]["event_long_title"],1);
				}else{
					redirect(base_url());
				}
			
				$this->load->view('header_event_revamp',$data);
				$this->load->view($views,$data);
				$this->load->view('footer_revamp');				
			
		}
	}	
	
	function get_events_by_parent($event_id = false) {
	
		$data['hot_events'] = "";
	
		echo json_encode(	$this->events->get_events_by_parent($event_id)	);
		die();

	}
	
	function get_events_by_long_title($event_long_title = false,$json=false) {
	
		$data['hot_events'] = "";
		if($json){
			return json_encode(	$this->events->get_events_by_long_title($event_long_title)	);
		
		}else{
			return $this->events->get_events_by_long_title($event_long_title);
		}
		
	}
	
	function get_prices_per_date($event_id){
		
		$session_data = $this->input->get_post('data');
		
		$date=date_format(date_create($session_data),"m/d/Y");
		
		// echo $date; die();
		
		$price_dates = json_decode(json_encode($this->prices->get_price_dates($event_id,$date)));
		
			// echo $price_dates; die();
		
		if($price_dates){		
			$prices_id = unserialize($price_dates->price_event_date_price_id);	
		}
		
		echo json_encode($prices_id);
		
	}
}

/* End of file welcome.php */
/* Location: ./system/application/controllers/welcome.php */