<!DOCTYPE html>
<html lang="en">
<body>
    <?php 
    $category = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
    
    $ids = array_column($events, 'event_long_title');
    $ids = array_unique($ids);
    $array = array_filter($events, function ($key, $value) use ($ids) {
        return in_array($value, array_keys($ids));
    }, ARRAY_FILTER_USE_BOTH);
    ?>
    <div class="c-list">
        <div class="o-content-wrap">
            <div class="c-list__header c-list__header--option-4">
                <div class="c-list__header-col">
                    <h1 class="h1 h1--title"><?php if($category === "smvenue") { echo "SM Venue"; } else if($category === "arena") { echo "MOA Arena"; } else if($category === "othervenue") { echo "Other Venue"; } else if($category === "artsscience") { echo "Arts & Science"; } else if($category === "performingarts") { echo "Performing Arts"; } else if($category === "hoteltravel") { echo "Hotel & Travel"; } else { echo $category; } ?>
                    </h1>
                    <div class="o-field-wrap">
                        <label for="" class="o-label o-label--option-2">Select Month</label>
                        <select class="o-input-dropdown o-input-dropdown--option-2 o-input-dropdown--long" id="eventsFilterMonth">
                            <option value="" selected disabled hidden></option>
                            <option value="January">January</option>
                            <option value="February">February</option>
                            <option value="March">March</option>
                            <option value="April">April</option>
                            <option value="May">May</option>
                            <option value="June">June</option>
                            <option value="July">July</option>
                            <option value="August">August</option>
                            <option value="September">September</option>
                            <option value="October">October</option>
                            <option value="November">November</option>
                            <option value="December">December</option>
                        </select>
                    </div>
                </div>
                <div class="c-list__header-col c-list__header-col--2col">
                    <div class="o-field-wrap">
                        <label for="" class="o-label o-label--option-2">Show</label>
                        <select name="" class="o-input-dropdown o-input-dropdown--option-2" id="eventsFilterShow">
                            <option value="10" selected>10</option>
                            <option value="20">20</option>
                            <option value="30">30</option>
                            <option value="40">40</option>
                            <option value="40">50</option>
                            <option value="40">60</option>
                            <option value="40">70</option>
                            <option value="40">80</option>
                            <option value="40">90</option>
                        </select>
                    </div>
                    <div class="o-field-wrap">
                        <label for="" class="o-label o-label--option-2">Filter by</label>
                        <input type="text" class="o-input-field o-input-field--long" id="search_event">
                        <!-- <select name="" id="" class="o-input-dropdown o-input-dropdown--option-2 o-input-dropdown--long">
                            <option value="f1" selected="selected" >Filter 1</option>
                            <option value="f2">Filter 2</option>
                            <option value="f3">Filter 3</option>
                            <option value="f4">Filter 4</option>
                        </select> -->
                    </div>
                    <!-- <div class="o-input-group o-input-group--small o-form__col">
                    <span class="o-label">Mobile Phone</span>
                    <input type="number" class="o-input-field" placeholder="Enter your mobile number">
                </div> -->
                </div>
            </div>
            <div  id="event_listing_based_date">
                  <ul class="c-list__items c-list__items--listings" id="event_ul">
                    <?php 
                    if(empty($array)) {
                        echo '<li id="no_record">No matching records found</li>';
                    }
                    else {
                        foreach ($array as $event) {
                            $date_time = $event['event_date_time'];
                            $month = date("F",strtotime($date_time));?>
                            <li id="<?php echo $month ?>" class="event_li">
                                
                                <div><?php echo $event['event_long_title']?></div>
                                <?php 
                                    $b = [];
                                    foreach($events as $key => $value){
                                        if($value['event_long_title']==$event['event_long_title']){
                                         $b[]=$value['event_date_time'];
                                        }
                                    }
                                    $count = count($b);
                                    $min = min($b);
                                    $minMonth = date("M",strtotime($min));
                                    $minDate = date("d",strtotime($min));
                                    $minYear = date("Y",strtotime($min));
                                    $minDate = $minMonth . " " . $minDate . ", " . $minYear;
                                    if($count > 1) {
                                        $max = max($b);
                                        $maxMonth = date("M",strtotime($max));
                                        $maxDate = date("d",strtotime($max));
                                        $maxYear = date("Y",strtotime($max));
                                        $maxDate = $maxMonth . " " . $maxDate . ", " . $maxYear;
                                        $date = $minDate . " - " . $maxDate;
                                    } else {
                                        $date = $minDate;
                                    }
                                ?>
                                <div>
                                    <span class="o-date"><?php echo $date?></span>
                                </div>
                                <div><?php echo $event['event_venue_name']?></div>
                                <?php $event_id = $event['event_id'] ?>
                                <button class="o-button o-button--green o-button--green-small" onclick="displayLoading(); window.location='<?php echo base_url("events/view/$event_id") ?>'">Buy Tickets</button>
                            </li><?php 
                        } ?>
                    <?php }  ?>
                    <li id="no_record" style="display:none">No matching records found</li>
                </ul>
            </div>
            <ul class="c-pagination js-pagination" style="display: none">
                <li class="js-prev">Previous</li>
                <li class="js-page is-active">1</li>
                <li class="js-page">2</li>
                <li class="js-page">3</li>
                <li class="js-next">Next</li>
            </ul>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            triggerShow();
        });
    </script>
</body>
</html>