<?php
class Users_model extends CI_Model {

	public function login($username, $password, $partycode) {
		$login = $this->config->item('api_login');
		$url = $login . "?username=" . $username . "&password=" . $password . "&partycode=" . $partycode;
		try {
			$xml = simplexml_load_file($url);
		}
		//catch exception
		catch(Exception $e) {
		 	$xml = simplexml_load_file($url);
		}

		$arr = json_decode( json_encode($xml) , 1);
		return $arr;
	}

	public function forgotPassword($data) {
		$url = $this->config->item("api_forgotPassword");

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);

		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
		
		return $result;
		
		// $new_data["data"] = array('username'=>$username, 'reset_key'=>trim(strip_tags($result)));
		
		// $new_result = trim(strip_tags($result));
		// if($new_result=="Invalid Key Pair [Data Sync]") {
		// 	return "The information you have entered is not valid. Please try again";
		// }
		// else {
		// 	$this->sendResetPassword($username,$email,$reset_url);
		// 	return "A reset link has been sent to your email. Please check your email for a reset link.";
		// }
	}

	public function changePassword($newPassword) {
		$url = $this->config->item("api_changePassword");

	    $data = array(
			'username' => $_SESSION["username"],
		   	'new_pass' => $newPassword,
		   	'old_pass' => $_SESSION["password"]
		);

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);

		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
		
		$this->session->set_userdata('password', $newPassword);
		
		return $result;
	}

	public function updatePassword($data, $newPassword) {
		$url = $this->config->item("api_updatePassword");

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);

		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
		
		$this->session->set_userdata('password', $newPassword);
		
		return $result;
	}

	// function sendResetPassword($username = false,$email=false,$reset_url=false ) {
	// 	$url = $this->config->item("url_base").'/email/send_reset_password_email';
	// 	$data = array(
	// 			'username' => $username,
	// 			'email' => $email,
	// 			'reset_url' => $reset_url,
	// 	);
	// 	$options = array(
	// 		'http' => array(
	// 			'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
	// 			'method'  => 'POST',
	// 			'content' => http_build_query($data)
	// 		),
	// 	);

	// 	$context  = stream_context_create($options);
	// 	$result = file_get_contents($url, false, $context);
	// }

	public function userInfo($username) {
		$user_info = $this->config->item('api_userInfo');
		$url = $user_info . "?username=" . $username;
		try {
			$xml = simplexml_load_file($url);
		}
		//catch exception
		catch(Exception $e) {
		 	$xml = simplexml_load_file($url);
		}

		$arr = json_decode( json_encode($xml) , 1);
		return $arr;
	}

	public function userTransactions($customer_id) {
		$user_transac = $this->config->item('api_userTransaction');
		$url = $user_transac . "?customerid=" . $customer_id;
		try {
			$xml = simplexml_load_file($url);
		}
		//catch exception
		catch(Exception $e) {
		 	$xml = simplexml_load_file($url);
		}

		$arr = json_decode( json_encode($xml) , 1);

		if(array_key_exists("trans_info",$arr)) {
			$trans_info = $arr['trans_info'];
			if(!array_key_exists(0,$trans_info)) {
				$trans_info = array($trans_info);
			}
		}
		else {
			$trans_info = array();
		}
		return $trans_info;
	}

	function userVoucher($transID, $token) {
		$file_name = "voucher.pdf";
		$voucher = $this->config->item("api_voucher");
		$url =  $voucher . "/" . $transID . "/" . $token . "/voucher.pdf";
		$content = file_get_contents($url);
		if($content != "invalid access") {
			header('Content-Type: application/octet-stream');
			header("Content-Transfer-Encoding: Binary"); 
			header("Content-disposition: attachment; filename=\"".$file_name."\""); 
			readfile($content);
			echo $content;
		}
		else {
			header("Location:" . base_url() . "/users/profile" );
		}
	}
}