<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Transactions_model extends CI_Model
{
	function getSelectedTickets($data) {
		$url = $this->config->item('api_selectedTickets');

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
	
		$xml = new SimpleXMLElement($result);

		$arr =  json_decode( json_encode($xml) , 1);

		if(array_key_exists("ticket_info",$arr)) {
			$ticket_array = $arr['ticket_info'];
			if(!array_key_exists(0,$ticket_array)) {
				$ticket_array = array($ticket_array);
			}
		}
		else {
			$ticket_array = array();
		}
		return $ticket_array;
	}

	function addTickets($data) {
		$url = $this->config->item('api_addTickets');

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);

		return $result;
	}

	function checkPromo($event_id) {
		$url = $this->config->item('api_checkPromo');

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($event_id)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);

		return $result;
	}

	function availPromo($data) {
		$url = $this->config->item('api_availPromo');

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);

		return $result;
	}

	function addSeats($data) {
		$url = $this->config->item('api_addSeats');

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);

		return $result;
	}

	function unselectedTickets($data) {
		$url = $this->config->item('api_unselectedTickets');

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
	
		$xml = new SimpleXMLElement($result);

		$arr =  json_decode( json_encode($xml) , 1);

		return $arr;
	}

	function paymentRequest($data, $total_amount) {
		$url = $this->config->item('api_purchase');

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
	
		$xml = new SimpleXMLElement($result);

		$arr =  json_decode( json_encode($xml) , 1);

		$ref = $arr['trans_info']['referenceNumber'];

		$data2 = array(
			'referencenumber' => $ref,
		   	'paycode' => 'IPAY',
		   	'amount' => $total_amount
		);

		$url2 = $this->config->item('api_paymentDone');

		$options2 = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data2)
			),
		);

		$context2  = stream_context_create($options2);

		$result2 = file_get_contents($url2, null, $context2);
	

		$arr2 =  json_decode( json_encode($result2) , 1);

		return $arr2;
	}
}