<?php
class Events_model extends CI_Model {

	function getEventsTitle() {
		$url = $this->config->item('api_getEventsTitle');
		try {
			$xml = simplexml_load_file($url);
		}

		catch(Exception $e) {
		 	$xml = simplexml_load_file($url);
		}

		$arr = json_decode( json_encode($xml) , 1);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}
		return $event_array;
	}

	function getFeaturedEvents() {
		$url = $this->config->item('api_getFeaturedEvents');
		try {
			$xml = simplexml_load_file($url);
		}

		catch(Exception $e) {
		 	$xml = simplexml_load_file($url);
		}

		$arr = json_decode( json_encode($xml) , 1);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}
		return $event_array;
	}

	public function getEventsByVenue()
	{
		$url = $this->config->item('api_getEventsByVenue');
		try {
			$xml = simplexml_load_file($url);
		}

		catch(Exception $e) {
		 	$xml = simplexml_load_file($url);
		}

		$arr = json_decode( json_encode($xml) , 1);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}
		return $event_array;
	}

	public function getEventsByVenueCategory($venue_category)
	{
		$url = $this->config->item('api_getEventsByVenue');
		$data = array(
					'venue_category' => $venue_category
				);

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);

		$xml = new SimpleXMLElement($result);

		$arr =  json_decode( json_encode($xml) , 1);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}
		return $event_array;
	}

	public function getEventsByCategory($category)
	{
		$url = $this->config->item('api_getEventsByCategory');
		$data = array(
			'category' => $category
		);

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);

		$xml = new SimpleXMLElement($result);

		$arr =  json_decode( json_encode($xml) , 1);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}
		return $event_array;
	}

	public function getEventsByKey($key)
	{
		$url = $this->config->item('api_getEventsByKey');
		$data = array(
			'match' => $key
		);

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);

		$xml = new SimpleXMLElement($result);

		$arr =  json_decode( json_encode($xml) , 1);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}
		return $event_array;
	}

	function getEventsByID($event_id) {
		$events = $this->config->item('api_getEventsById');
		$url = $events . "?eventid=" . $event_id;
		try {
			$xml = simplexml_load_file($url);
		}

		catch(Exception $e) {
		 	$xml = simplexml_load_file($url);
		}

		$arr = json_decode( json_encode($xml) , 1);

				
		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
		}
		else {
			$event_array = array();
		}
		return $event_array;
	}

	public function getEventsByTitle($title)
	{
		$events = $this->config->item('api_getEventsByTitle');
		$url = $events . "?eventlongtitle=" . $title;
		try {
			$xml = simplexml_load_file($url);
		}

		catch(Exception $e) {
		 	$xml = simplexml_load_file($url);
		}

		$arr = json_decode( json_encode($xml) , 1);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}
		return $event_array;
	}

	public function getEventsByDate($date)
	{
		$events = $this->config->item('api_getEventsByDate');
		$url = $events . "?date=" . $date;
		try {
			$xml = simplexml_load_file($url);
		}

		catch(Exception $e) {
		 	$xml = simplexml_load_file($url);
		}

		$arr = json_decode( json_encode($xml) , 1);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}
		return $event_array;
	}
}