<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends CI_Controller {

	function index() {
		$this->profile();
	}

	function checkSession() {
		if(isset($_SESSION["accessCode"])) {  
		     echo '0';    
		}  
		else {  
		     echo '1';     
		}
	}

	function profile() {
		if(isset($_SESSION['accessCode'])) {
			$username = $_SESSION['username'];
			$id = $_SESSION['customer_id'];
			$result['user_info'] = $this->Users_model->userInfo($username);
			$result['user_transactions'] = $this->Users_model->userTransactions($id);

			$this->load->view('head');
			$this->load->view('header');
			$this->load->view('page-account', $result);
			$this->load->view('footer');
		}
		else {
			redirect(base_url());
		}
	}

	function profile2() {
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-account--resview2');
		$this->load->view('footer');
	}

	function profile3() {
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-account--resview3');
		$this->load->view('footer');
	}

	function register() {
		if(!isset($_SESSION['accessCode'])) {
			$this->load->view('head');
			$this->load->view('header');
			$this->load->view('page-register');
			$this->load->view('footer');
		}
		else {
			redirect(base_url());
		}
	} 

	function resetPassword($reset_key=false, $username=false) {
		if(!isset($_SESSION['accessCode'])) {
			$result['users'] = array(
				'reset_key' => $reset_key,
				'username' => $username
			);

			$this->load->view('head');
			$this->load->view('header');
			$this->load->view('page-reset-password', $result);
			$this->load->view('footer');
		}
		else {
			redirect(base_url());
		}
	} 

	function registration() {
		$customer_firstname = $this->input->post('fname');
		$customer_lastname = $this->input->post('lname');
		$customer_mobile_number = $this->input->post('mobile_number');
		$customer_email = $this->input->post('email');
		$customer_username = $this->input->post('username');
		$customer_password = $this->input->post('password');
		$customer_region = $this->input->post('region');
		$customer_city = $this->input->post('city');
		$customer_country = $this->input->post('country'); 
		$dpa = $this->input->post('dpa'); 

		$url = $this->config->item('api_registration');
		$data = array(
			'fname' => $customer_firstname,
		   	'lname' => $customer_lastname,
		   	'mobile_number' => $customer_mobile_number,
		   	'email' => $customer_email,
		   	'username' => $customer_username,
		   	'password' => $customer_password,
		   	'region' => $customer_region,
		   	'city' => $customer_city,
		   	'country' => $customer_country,
		   	'dpa' => $dpa
		);

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
	
		echo $result;
	} 

	function login() {
		$username = $this->input->post('username');
	    $password = $this->input->post('password');
		
	    $result = $this->Users_model->login($username, $password, "SMTICKETS");

	   	if(array_key_exists("accessCode",$result)) {
	    	$accessCode = $result["accessCode"];
	    	$dateTimeActivated = $result["dateTimeActivated"];
	    	$expiration =  $result["expiration"];
	    	$smsActive = $result["smsActive"];
	    	$email =  $result["email"];
	    	$customer_id = $result["customer_id"];
	    	$this->session->set_userdata('accessCode', $accessCode);
	    	$this->session->set_userdata('username', $username);
	    	$this->session->set_userdata('password', $password);
	    	$this->session->set_userdata('email', $email);
	    	$this->session->set_userdata('dateTimeActivated', $dateTimeActivated);
	    	$this->session->set_userdata('smsActive', $smsActive);
	    	$this->session->set_userdata('customer_id', $customer_id);
	    	$this->session->set_userdata('logged-in', 'logged-in');
			$msg['success'] = true;
	    }
	    else {
	    	$accessCode = $result["errorMessage"];
			$msg['success'] = false;
	    }
	    echo json_encode($msg);
	} 

	function forgotPassword() {
		$username = $this->input->post('resetUsername');
	    $email = $this->input->post('resetEmail');
    	$reset_url = base_url('users/resetPassword');

        $data = array(
    		'username' => $username,
    	   	'email' => $email,
    	   	'reset_url' => $reset_url
    	);

	    $result = $this->Users_model->forgotPassword($data);

	    echo json_encode($result);
	} 

	function changePassword() {
	    $newPassword = $this->input->post('newPassword');

	    $result = $this->Users_model->changePassword($newPassword);

	    echo json_encode($result);
	} 

	function updatePassword() {
	    $reset_key = $this->input->post('resetKey');
	    $username = $this->input->post('username');
	    $newPassword = $this->input->post('newPassword');

	    $data = array(
			'new_pass' => $newPassword,
		   	'reset_key' => $reset_key,
		   	'username' => $username
		);

	    $result = $this->Users_model->updatePassword($data, $newPassword);

	    echo json_encode($result);
	} 

	function logout() {
		$this->session->unset_userdata('accessCode');
		$this->session->unset_userdata('username');
		$this->session->unset_userdata('password');
		$this->session->unset_userdata('email');
		$this->session->unset_userdata('dateTimeActivated');
		$this->session->unset_userdata('smsActive');
		$this->session->unset_userdata('customer_id');
		$this->session->unset_userdata('logged-in');
		$this->session->sess_destroy();
		// $this->session->set_userdata('logged-in', 'logged-out');
		redirect(base_url());
	} 

	function voucher($transID, $token) {
	    $result = $this->Users_model->userVoucher($transID, $token);
		echo $result;
	}
}