<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Transactions extends CI_Controller {

	function index() {
		$this->success();
	}

	function success() {
		$result['events'] = $this->Events_model->getEventsByVenue();
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-purchase-status--success', $result);
		$this->load->view('footer');
	}

	function failed() {
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-purchase-status');
		$this->load->view('footer');
	} 

	function addTickets() {
		$event_id = $this->input->post('event_id');
		$section_type = $this->input->post('section_type');
		$section_id = $this->input->post('section_id');
		$price_id = $this->input->post('price_id');
		$ticket_type_id = $this->input->post('ticket_type_id');
		$qty = $this->input->post('qty');
		$session_id = $_SESSION['accessCode'];

		$data = array(
					'event_id' => $event_id,
					'section_type' => $section_type,
				   	'section_id' => $section_id,
				   	'price_id' => $price_id,
				   	'ticket_type_id' => $ticket_type_id,
				   	'session_id' => $session_id,
				   	'qty' => $qty
				);
		$result = $this->Transactions_model->addTickets($data);
		
		echo $result;
	}

	function addSeats() {
		$event_id = $this->input->post('event_id');
		$section_id = $this->input->post('section_id');
		$price_id = $this->input->post('price_id');
		$ticket_type_id = $this->input->post('ticket_type_id');
		$session_id = $_SESSION['accessCode'];
		$seats = $this->input->post('seats');
		$array = explode(",",$seats);
		$str = serialize($array);

		$data = array(
					'event_id' => $event_id,
				   	'section_id' => $section_id,
				   	'price_id' => $price_id,
				   	'ticket_type_id' => $ticket_type_id,
				   	'session_id' => $session_id,
				   	'seats' => $str
				);
		$result = $this->Transactions_model->addSeats($data);
		
		echo json_encode($result);
	}

	function getSeats() {
		// file_put_contents("resources/seats.json", '');
		$event_id = $this->input->post('event_id');
		$section_id = $this->input->post('section_id');
		$price = $this->input->post('price');
		$info = $this->Sections_model->getSectionSeats($section_id,$event_id);
		$column_aisles = $info[0]['column_aisles'];
		$row_aisles = $info[0]['row_aisles'];
		if($info[0]['stage'] == "Left") {
			$stage = 1;
		}
		else if($info[0]['stage'] == "Right") {
			$stage = 3;
		}
		else {
			$stage = 2;
		}

		$seat = $info[0]['seatlist']['seat'];
		$rows_2 = [];
		$row_col_ = array("row"=>0,"column"=>"");

		// echo '<pre>';
		// print_r($seat);
		// die();

		foreach($seat as $se) {
			$str1 = explode("|",$se);
			$rowval = substr($str1[0], 1);
			$seat_status = true;
			if($str1[4]==0) {
				$seat_status = false;
			}

			for ($x = $rowval; $x <= $info[0]['maxRow'] + count($row_aisles); $x++) {
				
				if(isset($grp_xrow[1])){
						$grow = $grp_xrow[1];
					}else{
						$grow = "";
					}
				
				if($str1[2]=="0") {
					$rows_ = array( "seat_name"=>null,"price"=>null,"isAvailable"=>$seat_status,"row_grp"=>$rowval,"row_ar"=>$str1[3], "seat"=>null);
				}
				else {
					$seat_details = "$str1[0]|$str1[1]|$str1[2]|$str1[3]";
					
					$seat_name = $str1[2].$str1[3];
					foreach($column_aisles as $col_a) {
						if($str1[3] > $col_a) {
							$str_col = $str1[3]- 1;
							$seat_name = $str1[2].$str_col;
							$seat_details = "$str1[0]|$str1[1]|$str1[2]|$str_col";
						}
					}
					
					$price = $price;
					$rows_ = array( "seat_name"=>$seat_name,"price"=>$price,"isAvailable"=>$seat_status,"row_grp"=>$rowval.$grow,"row_ar"=>$str1[3],"seat"=>$seat_details);
				}
			}
			array_push($rows_2,$rows_);
		}
	
		usort($rows_2, function($a, $b) {
			return $a['row_ar'] - $b['row_ar'];
		});
		$result = array();
		foreach ($rows_2 as $element) {
			$result[$element['row_grp']][] = $element;
		}

		$result_seats = [];
		for ($x = 0; $x <= $info[0]['maxRow']; $x++) {
			$row_col = array("row"=>$x-1,"column"=>$result[$x]);
			array_push($result_seats,$row_col);
		}

		$data[] = array('stage-pos'=>$stage,"max-col"=>$info[0]['maxCol'] + count($column_aisles),"max-row"=>$info[0]['maxRow']  + count($row_aisles),"column"=>array());


		for ($x = 0; $x <= $info[0]['maxRow']-1; $x++) {
			array_push($data,$result_seats[$x]);
		}
 
		// file_put_contents("resources/seats.json", json_encode($data));
		// die();
		
		$data['seats']= json_encode($data);
		
		$this->load->view('seats',$data);
	}

	// function selectedSeats() {
	// 	$event_id = $this->input->post('event_id');
	// 	$session_id = $_SESSION['accessCode'];

	// 	$data = array(
	// 		'event_id' => $event_id,
	// 	   	'session_id' => $session_id
	// 	);
	// 	$result = $this->Transactions_model->getTransactions($data);
	// 	echo json_encode($result);
	// }

	function unselectedTickets() {
		$ticket_id = $this->input->post('ticket_id');
		$section_id = $this->input->post('section_id');

		$data = array(
			'ticket_id' => $ticket_id,
		   	'section_id' => $section_id
		);
		$result = $this->Transactions_model->unselectedTickets($data);
		echo json_encode($result);
	}
	
	
	function payment_request() {
		$session_id = $_SESSION['accessCode'];
		$username = $_SESSION["username"];
		$email = $_SESSION["email"];
		$event_id = $this->input->post('event_id');
		$total_amount = $this->input->post('total_amount');
		$event_title = $this->input->post('event_title');
		$ticket_array = $this->input->post('ticket_array');
		$qty = $this->input->post('count');
		$trans_date = $this->input->post('date');
		$prod_desc = $event_title . "|" . $qty . "|". $trans_date ."|". $ticket_array;


		//initialize transaction
		$data = array(
			'event_id' => $event_id,
		   	'session_id' => $session_id
		);

		$url = $this->config->item('api_purchase');
		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
	
	 
		$xml = new SimpleXMLElement($result);

		$arr =  json_decode( json_encode($xml) , 1);

		$ref = $arr['trans_info']['referenceNumber'];

		$prod_desc = 


		//IPAY88
		
		
		//SANDBOX ------------------------------>>>>>
		// $data['merchant_code'] = 'PH00015';
		// $data['merchant_key'] = 'tUTvyJBcqz';
	
		
		/*


		
		$prod_desc
		$username  
		$email
		
		
		
		$data['payment_id'] = '1'; 
		$data['paycode'] = 'IPAY';
		$data['currency'] = 'PHP';
		$data['prod_desc'] = $prod_desc;
		$data['refno'] = $ref;
		$data['username'] = $username; 
		$data['email'] = $email; 
		$data['contact'] = 'xxxxxxxxxxx';
		$data['remark'] = '';
		$data['signature'] = $this->_prep_signature($data['merchant_key'], $data['merchant_code'], $ref, $totalamount, $data['currency']);
	 

		$this->load->view('payment_request_2', $data);
		
		*/



		//finalize
		$data2 = array(
			'referencenumber' => $ref,
		   	'paycode' => 'IPAY',
		   	'amount' => $total_amount
		);

		$url2 = $this->config->item('api_paymentDone');

		$options2 = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data2)
			),
		);

		$context2  = stream_context_create($options2);

		$result2 = file_get_contents($url2, null, $context2);

		$arr2 =  json_decode( json_encode($result2) , 1);
		
	    echo json_encode($arr2);
	}
	
	function response(){

	}
	
	function backend_response(){
		
	}
}