<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Events extends CI_Controller {

	function index() {
		$this->home();
	}

	function home() {
		$result['events'] = $this->Events_model->getEventsByVenue();
		$result['images'] = $this->Events_model->getFeaturedEvents();
		$events = $result['events'];
		$venues = array();

		if(isset($events)) {
			foreach($events as $x) {
				$arena['event_id'] = $x['event_id'];
				$arena['event_title'] = $x['event_title'];
				$arena['event_long_title'] = $x['event_long_title'];
				$arena['event_date_time'] = $x['event_date_time'];
				$arena['event_venue_category'] = $x['event_venue_category'];
				$arena['event_venue_name'] = $x['event_venue_name'];
				$arena['event_image'] = $x['event_image'];
				$venues[$x['event_venue_category']][] = $arena;
			}
		}
		// echo '<pre>';
		// print_r($venues['Other Venues']);
		// echo '</pre>';
		
		// die();
		
		$result['venues'] = $venues;
 		$this->load->view('head');
		$this->load->view('header', $result);
		$this->load->view('main-slider', $result); 
		$this->load->view('page-home');
		$this->load->view('footer');
	}

	function listing($venue_category=false) {
		if($venue_category === "arena") {
			$venue_category = "MOA Arena";
		} else if ($venue_category === "smvenue") {
			$venue_category = "SM Venue";
		} else if ($venue_category === "othervenue") {
			$venue_category = "Other Venue";
		} else {
			$venue_category;
		}


		$result['events'] = $this->Events_model->getEventsByVenueCategory($venue_category);

		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-event-listing', $result);
		$this->load->view('footer');
	} 

	function category($category) {
		if ($category === "") {
			$category = "";
		}

		$result['events'] = $this->Events_model->getEventsByCategory($category);
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-event-listing', $result);
		$this->load->view('footer');
	} 

	function search($key=false) {
		$result["result"] = $this->Events_model->getEventsByKey($key);

		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-search-results', $result);
		$this->load->view('footer');
	}

	function calendar() {
		$result['events'] = $this->Events_model->getEventsByVenue();
		$this->load->view('page-calendar', $result);
	}

	function view($event_id=false,$referrer = false) {
		if($event_id == 'kidzania') {
			$event_id = 5645;
		}
		
		if($event_id == 'email') {
			redirect("terms/dpa");
		}
		
		$data['referrer'] = $referrer;
		
		$data['hot_events'] = "";
		if ($event_id=="undefined") {
			$this->load->view("error_page");
		}
		else {
			$data["event"] = $this->Events_model->getEventsByID($event_id);
			
			$bundle_event = array(4446,5301,4137,5165); 
			
			if(in_array($event_id,$bundle_event)) {
				$data['bundle'] = 1;
			}
			else {
				$data['bundle'] = 0;
			}
			
			$data['pixel_events_v2'] = array(5485); 
			
			if($data["event"]) {
				if(isset($_SESSION['accessCode'])) {
					$parameters = array(
						'event_id' => $event_id,
					   	'session_id' => $_SESSION['accessCode']
					);
					$data["transactions"] = $this->Transactions_model->getSelectedTickets($parameters);
				}
				$data["sections"] = $this->Sections_model->sections($event_id);	
				$data["prices"] = $this->Prices_model->prices($event_id);

				if(!$data["event"]["convenience_charge"]) {
					$data["event"]["convenience_charge"] = 0;
				}
			}
			else {
				redirect(base_url());
			}
			$this->load->view('head');
			$this->load->view('header');
			$this->load->view('page-event-landing', $data);	
			$this->load->view('footer');
		}
	}

	function getEventsTitle() {
		$result = $this->Events_model->getEventsTitle();
		echo json_encode($result);
	}

	function getEventsByTitle() {
		$title = $this->input->post('event_long_title');
		$result = $this->Events_model->getEventsByTitle(urlencode($title));
		echo json_encode($result);
	}

	function getEventsByDate() {
		$date = $this->input->post('event_dates');
		$result = $this->Events_model->getEventsByDate($date);
		echo json_encode($result);
	}

	function getEventsDate() {
		$result = $this->Events_model->getEventsByVenue();
		echo json_encode($result);
	}
}

