<script>

    const month_names=["January","February","March","April","May","June","July","August","September","October","November","December"];
    const month_names_short=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
    var names_day=['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];

    $(document).ready(function() {
        getEventsLongTitle(); // QUICKBUY OPTION LONG TITLE 
        // getEventsLongTitleMobile(); // QUICKBUY OPTION LONG TITLE FOR MOBILE
        var isOpera = (!!window.opr && !!opr.addons) || !!window.opera || navigator.userAgent.indexOf(' OPR/') >= 0;
        var isFirefox = typeof InstallTrigger !== 'undefined';
        var isSafari = /constructor/i.test(window.HTMLElement) || (function (p) { return p.toString() === "[object SafariRemoteNotification]"; })(!window['safari'] || (typeof safari !== 'undefined' && safari.pushNotification));
        var isIE = /*@cc_on!@*/false || !!document.documentMode;
        var isEdge = !isIE && !!window.StyleMedia;
        var isChrome = !!window.chrome && (!!window.chrome.webstore || !!window.chrome.runtime);
        if(isIE === true) {
            alert('This browser is not supported');
            toastr.error('This browser is not supported',{timeOut: 1000,fadeOut: 1000})
        }
        else if(isSafari === true) {
            toastr.error('This browser is not supported',{timeOut: 1000,fadeOut: 1000})
        }

    });

    function showAccountMenu() {
        document.getElementById("js-account").click();
    }

    function getEventDate(date) {
        var d = new Date(date);
        var month =  d.getMonth();

        var eventDate = month_names[month] +" "+ d.getDate() +", "+ d.getFullYear();
        return eventDate;
    }

    function getEventDateShort(date) {
        var d = new Date(date);
        var month =  d.getMonth();

        var eventDate = month_names_short[month] +" "+ d.getDate() +", "+ d.getFullYear();
        return eventDate;
    }

    function getEventTime(date) {
        var d = new Date(date);
        if(d.getHours() > 12) {
            hours = d.getHours() - 12;
        }
        else {
            hours = d.getHours();
        }
        if(d.getMinutes() < 10) {
            minutes = "0" + d.getMinutes();
        }
        else {
          minutes = d.getMinutes();
        }
        if(d.getHours() > 11) {
            periods = "PM";
        }
        else {
            periods = "AM";
        }
        var eventTime = hours + ":" + minutes + " " + periods; 
        return eventTime;
    }

    function displayLoading() {
        if($("#loadingWhite").is(':visible')) {
            $("#loadingWhite").hide();
            $("body").removeAttr("style");
        } else {
            $("#loadingWhite").show();
            $("body").attr("style", "pointer-events:none;");
        }
    }



// ================ H E A D E R ============== 


    // -----change function-----

        $('#quickBuySelect').change(function() {
            var event_long_title = $('#quickBuySelect option:selected').attr("value");  
            var select = document.getElementById("quickBuyDateSelect");
            $.ajax({  
                url:  "<?php echo base_url('events/getEventsByTitle'); ?>",  
                method:"POST",  
                data:{event_long_title:event_long_title},  
                dataType:"json",  
                global: false,
                success:function(data) {  
                    var i;
                    $('#quickBuyDateSelect').find('option').remove().end();
                    for (i = 0; i < data.length; i++) {
                        eventDate = getEventDate(data[i].event_date_time);
                        eventTime = getEventTime(data[i].event_date_time);
               
                        var event_date = eventDate + " " + eventTime;
                        $("#quickBuyDateSelect").append("<option event_id='" + data[i].event_id + "'>" + event_date + "</option>");
                    }
                    $(document).ready(checkQuickBuyFields);
                    $("#quickBuyDateSelect").addClass("selected");
                    $(".viewport").addClass("selected");
                }  
            }); 
        });

        $('#quickBuySelect').change(function () {
            selected = $("option:selected", this).text();
            if (selected.length > 20) {
                var truncatedTitle = selected.substring(0,20);
                var elipsisTitle = truncatedTitle + "...";
                $('.viewport').val(elipsisTitle);
            } else {
                var elipsisTitle = selected;
                $('.viewport').val(elipsisTitle);
            }
        });  

        $('#quickBuySelectMobile').change(function() {
            var event_long_title = $('#quickBuySelectMobile option:selected').attr("value");  
            var select = document.getElementById("quickBuyDateSelectMobile");
            $.ajax({  
                url:  "<?php echo base_url('events/getEventsByTitle'); ?>",  
                method:"POST",  
                data:{event_long_title:event_long_title},  
                dataType:"json",  
                global: false,
                success:function(data) {  
                    var i;
                    $('#quickBuyDateSelectMobile').find('option').remove().end();
                    for (i = 0; i < data.length; i++) {
                        eventDate = getEventDate(data[i].event_date_time);
                        eventTime = getEventTime(data[i].event_date_time);
                        
                        var event_date = eventDate + " " + eventTime;
                        $("#quickBuyDateSelectMobile").append("<option event_id='" + data[i].event_id + "'>" + event_date + "</option>");
                    }
                    $(document).ready(checkQuickBuyFieldsMobile);
                    $("#quickBuyDateSelectMobile").addClass("selected");
                     $(".viewportMobile").addClass("selected");
                }  
            });
        });

        $('#quickBuySelectMobile').change(function () {
            selected = $("option:selected", this).text();
            if (selected.length > 38) {
                var truncatedTitle = selected.substring(0,38);
                var elipsisTitle = truncatedTitle + "...";
                $('.viewportMobile').val(elipsisTitle);
            } else {
                var elipsisTitle = selected;
                $('.viewportMobile').val(elipsisTitle);
            }
        }); 

    // -----change function-----


    // -----click function-----

        $("#quickBuySearchButton").click(function() {
            displayLoading();
            longtitle = $('#quickBuySelect').val();
            date = $('#quickBuySelect').val();

            if (longtitle === null || date === null || longtitle === "" || date === "") {
                toastr.error('Please complete all the fields',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkQuickBuyFields);
                    displayLoading();
                }, 500);
            } 
            else {
                var event_id = $("#quickBuyDateSelect option:selected").attr("event_id");
                setTimeout(function () {
                    window.location='<?php echo base_url("events/view") ?>'+'/'+event_id;
                }, 500);
            }
        });
        
        $("#quickBuySearchButtonMobile").click( function() {
            displayLoading();
            longtitle = $('#quickBuySelectMobile').val();
            date = $('#quickBuySelectMobile').val();

            if (longtitle === null || date === null || longtitle === "" || date === "") {
                toastr.error('Please complete all the fields',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkQuickBuyFieldsMobile);
                    displayLoading();
                }, 500);
            }
            else {
                var event_id = $("#quickBuyDateSelectMobile option:selected").attr("event_id");
                setTimeout(function () {
                    window.location='<?php echo base_url("events/view") ?>'+'/'+event_id;
                }, 500);
            }
        });

        $('#eventSearchButton').click(function() {
            setTimeout(function() { 
                $('input[id="eventSearchField"]').focus() 
            }, 500);
            setTimeout(function() { 
                $('input[id="eventSearchFieldMobile"]').focus() 
            }, 500);
        });

        $('#loginButton').click(function() {
            $("#loginModal").addClass("c-modal--is-close"); 
            $("#loginModal").removeClass("c-modal--is-open");
            displayLoading();

            username = $('#username').val();
            password = $('#password').val();

            if(username === "" || password === "") {
                toastr.error('Please complete all the fields',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkLogInFields);
                    $(document).ready(checkUsername);
                    $(document).ready(checkPassword);
                    $("#loginModal").removeClass("c-modal--is-close"); 
                    $("#loginModal").addClass("c-modal--is-open");
                    displayLoading();
                }, 500);   
            }
            else if(username.length < 6) {
                toastr.error('The username must be at least 6 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkLogInFields);
                    $(document).ready(checkUsername);
                    $("#loginModal").removeClass("c-modal--is-close"); 
                    $("#loginModal").addClass("c-modal--is-open");
                    displayLoading();
                }, 500);
            } 
            else if(username.length > 30) {
                toastr.error('The username must be less than 30 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkLogInFields);
                    $(document).ready(checkUsername);
                    $("#loginModal").removeClass("c-modal--is-close"); 
                    $("#loginModal").addClass("c-modal--is-open");
                    displayLoading();
                }, 500);
            } 
            else if(password.length < 6) {
                toastr.error('The password must be at least 6 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkLogInFields);
                    $(document).ready(checkPassword);
                    $("#loginModal").removeClass("c-modal--is-close"); 
                    $("#loginModal").addClass("c-modal--is-open");
                    displayLoading();
                }, 500);
            } 
            else if(password.length > 30) {
                toastr.error('The password must be less than 30 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkLogInFields);
                    $(document).ready(checkPassword);
                    $("#loginModal").removeClass("c-modal--is-close"); 
                    $("#loginModal").addClass("c-modal--is-open");
                    displayLoading();
                }, 500);
            } 
            else {
                $.ajax({
                    method : "POST",
                    url  : "<?php echo base_url(); ?>users/login",
                    dataType : "json",
                    global:false,
                    data : {
                        username:username,
                        password:password
                    },
                    success: function(response) {
                        if(response.success) {
                            toastr.success("You've logged in successfully",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                window.location.reload();
                            }, 1000);
                        }
                        else {
                            toastr.error('Invalid Username/Password combination',{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                $("#loginModal").removeClass("c-modal--is-close"); 
                                $("#loginModal").addClass("c-modal--is-open");
                                document.getElementById("username").style.borderColor = "red";
                                document.getElementById("password").style.borderColor = "red";
                                displayLoading();
                            }, 500);
                        }
                    }
                });
            }
        });

        $('#visiblePasswordButton').click(function(e) {
            x = document.getElementById("password");
            y = document.getElementById("visiblePasswordButton");
            if (x.type === "password") {
                x.type = "text";
                y.classList.add('js-password--hidden')
            } else {
                x.type = "password";
                y.classList.remove('js-password--hidden')
            }
        });

        $('#registerButton').click(function() {
            $("#loginModal").addClass("c-modal--is-close"); 
            $("#loginModal").removeClass("c-modal--is-open");
            displayLoading();
            setTimeout(function () { 
                window.location='<?php echo base_url("users/register") ?>'; 
            }, 1000);
        });

        $('#registerButton2').click(function() {
            $("#js-modal").addClass("c-modal--is-close"); 
            $("#js-modal").removeClass("c-modal--is-open");
            displayLoading();
            setTimeout(function () { 
                window.location='<?php echo base_url("users/register") ?>'; 
            }, 1000);
        });

        $("#searchEventButton").click(function() {
            displayLoading();
            var eventSearchField = $("#eventSearchField").val();
            if(eventSearchField === "") {
                toastr.error('The search field is required and cannot be empty',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    displayLoading();
                }, 500);
            }
            else if (!eventSearchField.match(/^[a-zA-Z0-9\s]+$/)) {
                toastr.error('The search field can only consist of alphabets and number',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    displayLoading();
                }, 500);
            }
            else {
                setTimeout(function () { 
                    window.location='<?php echo base_url("events/search") ?>'+'/'+eventSearchField;
                }, 1000);
            }
        });

        $("#searchEventButtonMobile").click( function() {
            displayLoading();
            var eventSearchField = $("#eventSearchFieldMobile").val();
            if(eventSearchField === "") {
                toastr.error('The search field is required and cannot be empty',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    displayLoading();
                }, 500);
            }
            else if (!eventSearchField.match(/^[a-zA-Z0-9\s]+$/)) {
                toastr.error('The search field can only consist of alphabets and number',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    displayLoading();
                }, 500);
            }
            else {
                setTimeout(function () { 
                    window.location='<?php echo base_url("events/search") ?>'+'/'+eventSearchField;
                }, 1000);
            }
        });

        $('#resetPasswordButton').click(function() {
            $("#confirmationPasswordModal").addClass("c-modal--is-close"); 
            $("#confirmationPasswordModal").removeClass("c-modal--is-open");
            displayLoading();

            resetUsername = $('#resetUsername').val();
            resetEmail = $('#resetEmail').val();
            var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;

            if(resetUsername === "" || resetEmail === "") {
                toastr.error('Please complete all the fields',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkResetUsername);
                    $(document).ready(checkResetEmail);
                    $(document).ready(checkResetFields); 
                    $("#confirmationPasswordModal").removeClass("c-modal--is-close"); 
                    $("#confirmationPasswordModal").addClass("c-modal--is-open");
                    displayLoading();
                }, 500);   
            }
            else if(resetUsername.length < 6) {
                toastr.error('The username must be at least 6 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkResetUsername);
                    $(document).ready(checkResetFields);
                    $("#confirmationPasswordModal").removeClass("c-modal--is-close"); 
                    $("#confirmationPasswordModal").addClass("c-modal--is-open");
                    displayLoading();
                }, 500);   
            } 
            else if(resetUsername.length > 30) {
                toastr.error('The username must be less than 30 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkResetUsername);
                    $(document).ready(checkResetFields);
                    $("#confirmationPasswordModal").removeClass("c-modal--is-close"); 
                    $("#confirmationPasswordModal").addClass("c-modal--is-open");
                    displayLoading();
                }, 500);
            } 
            else if(!filter.test(resetEmail)) {
                toastr.error('Invalid email address',{timeOut: 1000,fadeOut: 1000})
                displayLoading();
                setTimeout(function () {
                    $(document).ready(checkResetEmail);
                    $(document).ready(checkResetFields);
                    displayLoading();
                }, 500);
            }
            else {
                $.ajax({
                    method : "POST",
                    url  : "<?php echo base_url(); ?>users/forgotPassword",
                    dataType : "json",
                    global:false,
                    data : {
                        resetUsername:resetUsername,
                        resetEmail:resetEmail
                    },
                    success: function(response) {
                       if (response.match(/Invalid Username.*/)) {
                            toastr.error("Invalid Username/Email provided",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                $("#js-modal").removeClass("c-modal--is-close"); 
                                $("#js-modal").addClass("c-modal--is-open");
                                displayLoading();
                            }, 500);
                        }
                        else {
                            toastr.success("A reset link has been sent to your email. Please check your email for a reset link.",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                displayLoading();
                            }, 500);
                        }
                    }
                });
            }
        });

    // -----click function-----


    // -----function-----

        function getEventsLongTitle() {
            var select = document.getElementById("quickBuySelect");
            var select_mobile = document.getElementById("quickBuySelectMobile");

            $.ajax({  
                url:  "<?php echo base_url('events/getEventsTitle'); ?>",  
                method:"POST",  
                dataType:"json",
                global: false,  
                success:function(data) {
                    var i;
                    unique_title = [];
                    for (i = 0; i < data.length; i++) { 
                        if(unique_title.indexOf(data[i].event_long_title) == -1 ) {
                            
                            $("#quickBuySelect").append("<option event_id='" + data[i].event_id + "' value='"+ data[i].event_long_title +"'>" 
                                + data[i].event_long_title + "</option>");
                            $("#quickBuySelectMobile").append("<option event_id='" + data[i].event_id + "' value='"+ data[i].event_long_title +"'>" 
                                + data[i].event_long_title + "</option>");
                            unique_title.push(data[i].event_long_title);
                        }
                    }
                    // FOR SORTING
                    var options = $('select#quickBuySelect option:gt(0)');
                    var arr = options.map(function(_, o) {return {t: $(o).text(),v: o.value};}).get();
                    arr.sort(function(o1, o2) {return o1.t > o2.t ? 1 : o1.t < o2.t ? -1 : 0;});
                    options.each(function(i, o) {o.value = arr[i].v;$(o).text(arr[i].t);});

                    var optionsMobile = $('select#quickBuySelectMobile option:gt(0)');
                    var arrMobile = optionsMobile.map(function(_, o) {return {t: $(o).text(),v: o.value};}).get();
                    arrMobile.sort(function(o1, o2) {return o1.t > o2.t ? 1 : o1.t < o2.t ? -1 : 0;});
                    optionsMobile.each(function(i, o) {o.value = arr[i].v;$(o).text(arr[i].t);});
                }  
            })
        }

        function closeLoginModal() {
            seatSelect = $(".c-modal--login").attr("id");
            document.body.classList.remove('c-modal--body-lock');
            setTimeout(function () {
                $("#loginModal").removeClass("c-modal--is-open");  
                setTimeout(function () {
                    $("#loginModal").addClass("c-modal--is-close");  
                }, 200);
            }, 500);
        } 

        function profile() {
            $("#profile").addClass("is-active"); 
            $("#profileContent").addClass("is-active"); 
            $("#tickets").removeClass("is-active"); 
            $("#ticketsContent").removeClass("is-active"); 
            $("#reservations").removeClass("is-active"); 
            $("#reservationsContent").removeClass("is-active"); 
            $("#dataprivacy").removeClass("is-active"); 
            $("#dataprivacyContent").removeClass("is-active"); 
        }

        function tickets() {
            $("#tickets").addClass("is-active"); 
            $("#ticketsContent").addClass("is-active"); 
            $("#profile").removeClass("is-active"); 
            $("#profileContent").removeClass("is-active"); 
            $("#reservations").removeClass("is-active"); 
            $("#reservationsContent").removeClass("is-active"); 
            $("#dataprivacy").removeClass("is-active"); 
            $("#dataprivacyContent").removeClass("is-active"); 
        }

        function reservations() {
            $("#reservations").addClass("is-active"); 
            $("#reservationsContent").addClass("is-active"); 
            $("#profile").removeClass("is-active"); 
            $("#profileContent").removeClass("is-active"); 
            $("#tickets").removeClass("is-active"); 
            $("#ticketsContent").removeClass("is-active"); 
            $("#dataprivacy").removeClass("is-active"); 
            $("#dataprivacyContent").removeClass("is-active"); 
        }

        function dataprivacy() {
            $("#dataprivacy").addClass("is-active"); 
            $("#dataprivacyContent").addClass("is-active"); 
            $("#profile").removeClass("is-active"); 
            $("#profileContent").removeClass("is-active"); 
            $("#tickets").removeClass("is-active"); 
            $("#ticketsContent").removeClass("is-active"); 
            $("#reservations").removeClass("is-active"); 
            $("#reservationsContent").removeClass("is-active"); 
        }

        function checkQuickBuyFields() {
            longtitle = $('#quickBuySelect').val();
            date = $('#quickBuySelect').val();
            if (longtitle === "" || date === "") {
                $("#quickBuySearchButton").attr("disabled", true);
                $("#quickBuySearchButton").addClass("o-button--blue-disabled");
                $("#quickBuySearchButton").attr("Title", "Please complete all the fields")
            } else {
                $("#quickBuySearchButton").removeAttr("disabled");
                $("#quickBuySearchButton").removeClass("o-button--blue-disabled");
                $("#quickBuySearchButton").removeAttr("Title")
            }
        }

        function checkQuickBuyFieldsMobile() {
            longtitle = $('#quickBuySelectMobile').val();
            date = $('#quickBuySelectMobile').val();
            if (longtitle === "" || date === "") {
                $("#quickBuySearchButtonMobile").attr("disabled", true);
                $("#quickBuySearchButtonMobile").addClass("o-button--blue-disabled");
                $("#quickBuySearchButtonMobile").attr("Title", "Please complete all the fields")
            } else {
                $("#quickBuySearchButtonMobile").removeAttr("disabled");
                $("#quickBuySearchButtonMobile").removeClass("o-button--blue-disabled");
                $("#quickBuySearchButton").removeAttr("Title")
            }
        }

        function checkLogInFields() {
            username = $('#username').val();
            password = $('#password').val();
            if(username === "" || password === "") {
                $("#loginButton").attr("disabled", true);
                $("#loginButton").addClass("o-button--green-disabled");
                $("#loginButton").attr("Title", "Please complete all the fields");
            }
            else if(username.length < 6) {
                $("#loginButton").attr("disabled", true);
                $("#loginButton").addClass("o-button--green-disabled");
                $("#loginButton").attr("Title", "The username must be at least 6 characters long");
            }
             else if(username.length > 30) {
                $("#loginButton").attr("disabled", true);
                $("#loginButton").addClass("o-button--green-disabled");
                $("#loginButton").attr("Title", "The username must be less than 30 characters long");
            }
            else if(password.length < 6) {
                $("#loginButton").attr("disabled", true);
                $("#loginButton").addClass("o-button--green-disabled");
                $("#loginButton").attr("Title", "The password must be at least 6 characters long");
            }
             else if(password.length > 30) {
                $("#loginButton").attr("disabled", true);
                $("#loginButton").addClass("o-button--green-disabled");
                $("#loginButton").attr("Title", "The password must be less than 30 characters long");
            }
            else {
                $("#loginButton").removeAttr("disabled");
                $("#loginButton").removeClass("o-button--green-disabled");
                $("#loginButton").removeAttr("Title")
            }
        }

        function checkUsername() {
            username = $('#username').val();
            if(username === "") {
                $("#errorUsername").html("The username is required and cannot be empty");
                document.getElementById("username").style.borderColor = "red";
            } 
            else if(username.length < 6) {
                $("#errorUsername").html("The username must be at least 6 characters long");
                document.getElementById("username").style.borderColor = "red";
            } 
            else if(username.length > 30) {
                $("#errorUsername").html("The username must be less than 30 characters long");
                document.getElementById("username").style.borderColor = "red";
            } 
            else {
                $("#errorUsername").empty();
                document.getElementById("username").style.borderColor = "green";
            }
        }

        function checkPassword() {
            password = $('#password').val();
            if(password === "") {
                $("#errorPassword").html("The password is required and cannot be empty");
                document.getElementById("password").style.borderColor = "red";
            } 
            else if(password.length < 6) {
                $("#errorPassword").html("The password must be at least 6 characters long");
                document.getElementById("password").style.borderColor = "red";
            } 
            else if(password.length > 30) {
                $("#errorPassword").html("The password must be less than 30 characters long");
                document.getElementById("password").style.borderColor = "red";
            } 
            else {
                $("#errorPassword").empty();
                document.getElementById("password").style.borderColor = "green";
            }
        }

        function checkResetFields() {
            username = $('#resetUsername').val();
            email = $('#resetEmail').val();
            var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if(username === "" || email === "") {
                $("#resetPasswordButton").attr("disabled", true);
                $("#resetPasswordButton").addClass("o-button--green-disabled");
                $("#resetPasswordButton").attr("Title", "Please complete all the fields");
            } 
            else if(username.length < 6) {
                $("#resetPasswordButton").attr("disabled", true);
                $("#resetPasswordButton").addClass("o-button--green-disabled");
                $("#resetPasswordButton").attr("Title", "The username must be at least 6 characters long");
            }
             else if(username.length > 30) {
                $("#resetPasswordButton").attr("disabled", true);
                $("#resetPasswordButton").addClass("o-button--green-disabled");
                $("#resetPasswordButton").attr("Title", "The username must be less than 30 characters long");
            }
            else if(!filter.test(email)) {
                $("#resetPasswordButton").attr("disabled", true);
                $("#resetPasswordButton").addClass("o-button--green-disabled");
                $("#resetPasswordButton").attr("Title", "Invalid email address")
            }
            else {
                $("#resetPasswordButton").removeAttr("disabled");
                $("#resetPasswordButton").removeClass("o-button--green-disabled");
                $("#resetPasswordButton").removeAttr("Title")
            }
        }

        function checkResetUsername() {
            var username = $('#resetUsername').val();
            if(username === "") {
                $("#errorResetUsername").html("The username is required and cannot be empty");
                document.getElementById("resetUsername").style.borderColor = "red";
            } 
            else if(username.length < 6) {
                $("#errorResetUsername").html("The username must be at least 6 characters long");
                document.getElementById("resetUsername").style.borderColor = "red";
            } 
            else if(username.length > 30) {
                $("#errorResetUsername").html("The username must be less than 30 characters long");
                document.getElementById("resetUsername").style.borderColor = "red";
            } 
            else {
                $("#errorResetUsername").empty();
                document.getElementById("resetUsername").style.borderColor = "green";
            }
        }

        function checkResetEmail() {
            email = $('#resetEmail').val();
            var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if(email !== "") {
                if(!filter.test(email)) {
                    $("#errorResetEmail").html("Invalid email address");
                    document.getElementById("resetEmail").style.borderColor = "red";
                }
                else {
                    $("#errorResetEmail").empty();
                    document.getElementById("resetEmail").style.borderColor = "green";
                }
            } 
            else {
                $("#errorResetEmail").html("The email is required and cannot be empty");
                document.getElementById("resetEmail").style.borderColor = "red";
            }
        }
    
    // -----function-----


    // -----keycode function-----

        $("#eventSearchField").keypress(function(e) {
            if(e.keyCode===13) {
                e.preventDefault();
                document.getElementById("searchEventButton").click();
            } 
            else if (!((e.keyCode>=48&&e.keyCode<= 57)||(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=97&&e.keyCode<= 122))&&e.keyCode!=8&&e.keyCode!=32) {
                return false;
            }
        });

        $("#eventSearchFieldMobile").keypress(function(e) {
            if (e.keyCode===13) {
                e.preventDefault();
                document.getElementById("searchEventButton").click();
            }   
            else if (!((e.keyCode>=48&&e.keyCode<= 57)||(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=97&&e.keyCode<= 122))&&e.keyCode!=8&&e.keyCode!=32) {
                return false;
            }
        });

        $('#username').keypress(function(event) {
            if(event.keyCode === 13) {
                event.preventDefault();
                document.getElementById("loginButton").click();
            }
        });

        $('#password').keypress(function(event) {
            if(event.keyCode === 13) {
                event.preventDefault();
                document.getElementById("loginButton").click();
            }
        });

    // -----keycode function-----


    // -----keyup function-----

        $("#eventSearchField").keyup(function(e) {
            var string = $("#eventSearchField").val();
            if(string === "") {
                $("#searchEventButton").addClass("o-button--green-disabled"); 
                $("#searchEventButton").attr("disabled", true); 
                $("#searchEventButton").attr("title", "The search field is required and cannot be empty"); 
            }
            else {
                $("#searchEventButton").removeClass("o-button--green-disabled"); 
                $("#searchEventButton").removeAttr("disabled"); 
                $("#searchEventButton").removeAttr("title"); 
            }
        });

        $("#eventSearchFieldMobile").keyup(function(e) {
            var string = $("#eventSearchField").val();
            if(string === "") {
                $("#searchEventButton").addClass("o-button--green-disabled"); 
                $("#searchEventButton").attr("disabled", true); 
                $("#searchEventButton").attr("title", "The search field is required and cannot be empty");
            }
            else {
                $("#searchEventButton").removeClass("o-button--green-disabled"); 
                $("#searchEventButton").removeAttr("disabled"); 
                $("#searchEventButton").removeAttr("title"); 
            }
        });

        $('#username').keyup(function(event) {
            $(document).ready(checkUsername);
            $(document).ready(checkLogInFields);   
            var max_chars = 30;
            if ($(this).val().length >= max_chars) { 
                $(this).val($(this).val().substr(0, max_chars));
            }
        });

        $('#password').keyup(function(event) {
            $(document).ready(checkPassword);
            $(document).ready(checkLogInFields);
            var max_chars = 30;
            if ($(this).val().length >= max_chars) { 
                $(this).val($(this).val().substr(0, max_chars));
            }
        });

        $('#resetUsername').keyup(function(event) {
            $(document).ready(checkResetUsername);
            $(document).ready(checkResetFields);   
            var max_chars = 30;
            if ($(this).val().length >= max_chars) { 
                $(this).val($(this).val().substr(0, max_chars));
            }
        });

        $('#resetEmail').keyup(function(event) {
            $(document).ready(checkResetEmail);
            $(document).ready(checkResetFields);   
        });

    // -----keyup function-----


// ================ H E A D E R ==============/



//================ H O M E ==============


    // -----function----- 

        function skyjetValidation(form) {
            var oneway = $('#skyjetOneway').attr("class");
            skyjet = "https://skyjet.sqiva.com/app-ibe-skyjet-search_flight";
            var origin = form.origin.value;
            var destination = form.destination.value;
            var departure = form.departure.value;
            var returnd = form.return.value;
            var adult = form.adult.value;
            var child = form.child.value;
            var infant = form.infant.value;
            var currentDate = new Date();
            var depdate = new Date(departure);
            var retdate = new Date(returnd);


            var d = new Date(departure);
            var r = new Date(returnd);

            departureDate = d.getFullYear() + "" + ('0' + (d.getMonth()+1)).slice(-2) + "" + ('0' + d.getDate()).slice(-2);
            returnDate = r.getFullYear() + "" + ('0' + (r.getMonth()+1)).slice(-2) + "" + ('0' + r.getDate()).slice(-2);

            if(oneway.match(/o-trip--selected*/)) {
                return_flight = 0;
                if(origin === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Origin Airport',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(destination === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Destination Airport',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(departure === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Departure Date',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(depdate < currentDate) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Your departure date has past already',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                } 
                else if(infant > adult) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Adult passengers should be more than infant passengers',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                } 
                else {
                    var answer = confirm("You will be redirected to Skyjet Airlines website. Do you want to continue?");
                    parameters = "?return_flight=" + return_flight + "&org=" + origin + "&des=" + destination + "&dep_date=" + departureDate + "&pax_adult=" + adult + "&pax_infant=" + infant + "&pax_child=" + child + "&_ga=2.161920636.1914695555.1564463023-1044651235.1563843191"; 
                    url = skyjet + parameters;
                    $('#skyjetButton').attr('href', url);

                    if(answer == true) {
                        document.getElementById("skyjetButton").click();
                    }
                }
            } else {
                return_flight = 1;
                if(origin === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Origin Airport',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(destination === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Destination Airport',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(departure === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Departure Date',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(returnd === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Return Date',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(depdate < currentDate) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Your departure date has past already',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                } 
                else if(retdate < currentDate) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Your return date has past already',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(depdate > retdate) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Your return date is earlier than departure',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(infant > adult) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Adult passengers should be more than infant passengers',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                } 
                else {
                    var answer = confirm("You will be redirected to Skyjet Airlines website. Do you want to continue?");
                    parameters = "?return_flight=" + return_flight + "&org=" + origin + "&des=" + destination + "&dep_date=" + departureDate + "&ret_date=" + returnDate + "&pax_adult=" + adult + "&pax_infant=" + infant + "&pax_child=" + child + "&_ga=2.161920636.1914695555.1564463023-1044651235.1563843191"; 
                    url = skyjet + parameters;
                    $('#skyjetButton').attr('href', url);

                    if(answer == true) {
                        document.getElementById("skyjetButton").click();
                    }
                }
            }
        }

        function royalairValidation(form) {
            var oneway = $('#royalairOneway').attr("class");
            royalair = "http://ws.demo.awan.sqiva.com";
            var origin = form.royalairOrigin.value;
            var destination = form.royalairDestination.value;
            var departure = form.royalairDeparture.value;
            var returnd = form.royalairReturn.value;
            var adult = form.royalairAdult.value;
            var child = form.royalairChild.value;
            var infant = form.royalairInfant.value;
            var currentDate = new Date();
            var depdate = new Date(departure);
            var retdate = new Date(returnd);


            var d = new Date(departure);
            var r = new Date(returnd);

            departureDate = d.getFullYear() + "" + ('0' + (d.getMonth()+1)).slice(-2) + "" + ('0' + d.getDate()).slice(-2);
            returnDate = r.getFullYear() + "" + ('0' + (r.getMonth()+1)).slice(-2) + "" + ('0' + r.getDate()).slice(-2);

            if(oneway.match(/o-trip--selected*/)) {
                return_flight = 0;
                if(origin === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Origin Airport',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(destination === "destination") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Destination Airport',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(departure === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Departure Date',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(depdate < currentDate) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Your departure date has past already',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                } 
                else if(infant > adult) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Adult passengers should be more than infant passengers',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                } 
                else {
                    var answer = confirm("You will be redirected to Royal Air Airlines website. Do you want to continue?");
                    parameters = "/?&app=information&action=get_schedule_v2&org=" + origin +"&des=" + destination + "&flight_date=" + departureDate + "&return_flight=" + return_flight + "&ret_flight_date=" + returnDate; 
                    url = royalair + parameters;
                    $('#royalairButton').attr('href', url);

                    if(answer == true) {
                        document.getElementById("royalairButton").click();
                    }
                }
            } else {
                return_flight = 1;
                if(origin === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Origin Airport',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(destination === "destination") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Destination Airport',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(departure === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Departure Date',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(returnd === "") {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Please Select Return Date',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(depdate < currentDate) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Your departure date has past already',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                } 
                else if(retdate < currentDate) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Your return date has past already',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(depdate > retdate) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Your return date is earlier than departure',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                }
                else if(infant > adult) {
                    displayLoading();
                    setTimeout(function () {
                        displayLoading();
                        toastr.error('Adult passengers should be more than infant passengers',{timeOut: 1000,fadeOut: 1000})
                    }, 500);
                } 
                else {
                    var answer = confirm("You will be redirected to Royal Air Airlines website. Do you want to continue?");
                    parameters = "/?&app=information&action=get_schedule_v2&org=" + origin +"&des=" + destination + "&flight_date=" + departureDate + "&return_flight=" + return_flight + "&ret_flight_date=" + returnDate; 
                    url = royalair + parameters;
                    $('#royalairButton').attr('href', url);

                    if(answer == true) {
                        document.getElementById("royalairButton").click();
                    }
                }
            }
        }
    
        function getRoyalairOrigin() {
            var select = document.getElementById("royalairOrigin");
            $.ajax({  
                url:  "<?php echo base_url('flights/origin'); ?>",  
                method:"POST",  
                dataType:"json",  
                global: false,
                success:function(data) {
                    var myJSON = JSON.stringify(data);
                    var obj = JSON.parse(myJSON);
                    data = obj.origin;
                    for (i = 0; i < data.length; i++) { 
                        new_str = data[i][1].toLowerCase().replace(/\b[a-z]/g, function(txtVal) {
                            return txtVal.toUpperCase();
                        });
                        $("#royalairOrigin").append("<option value='"+ data[i][0] +"'>"+ new_str + " (" + data[i][0] + ")</option>");
                    }
                }  
            })
        }

        function getRoyalairDestination() {
            var select = document.getElementById("royalairDestination");
            $.ajax({  
                url:  "<?php echo base_url('flights/allDestination'); ?>",  
                method:"POST",  
                dataType:"json",  
                global: false,
                success:function(data) {
                    var myJSON = JSON.stringify(data);
                    var obj = JSON.parse(myJSON);
                    data = obj.destination;
                    for (i = 0; i < data.length; i++) { 
                        new_str = data[i][1].toLowerCase().replace(/\b[a-z]/g, function(txtVal) {
                            return txtVal.toUpperCase();
                        });
                        $("#royalairDestination").append("<option value='"+ data[i][0] +"'>"+ new_str + " (" + data[i][0] + ")</option>");
                    }
                }  
            })
        }

    // -----function----- 


    // -----click function----- 

        $('#buyTicketsButton').click(function() {
            displayLoading();
            var event_id = $('.glide__slide--active').attr("id");
            var base_url = "<?php echo base_url('events/view/'); ?>";
            var redirect = base_url + event_id;
            var url = "window.location='"+redirect+"'";
            $(this).attr("onclick", url)
            document.getElementById("buyTicketsButton").click();
        });

        $('#skyjetRoundtrip').click(function() {
            $(this).addClass("o-trip--selected");
            $('#skyjetOneway').removeClass("o-trip--selected");
            $('#return').show("o-trip--selected");
            $('#returnLabel').show("o-trip--selected");
        });

        $('#skyjetOneway').click(function() {
            $(this).addClass("o-trip--selected");
            $('#skyjetRoundtrip').removeClass("o-trip--selected");
            $('#return').hide("o-trip--selected");
            $('#returnLabel').hide("o-trip--selected");
        });

        $('#royalairRoundtrip').click(function() {
            $(this).addClass("o-trip--selected");
            $('#royalairOneway').removeClass("o-trip--selected");
            $('#royalairReturn').show("o-trip--selected");
            $('#royalairReturnLabel').show("o-trip--selected");
        });

        $('#royalairOneway').click(function() {
            $(this).addClass("o-trip--selected");
            $('#royalairRoundtrip').removeClass("o-trip--selected");
            $('#royalairReturn').hide("o-trip--selected");
            $('#royalairReturnLabel').hide("o-trip--selected");
        });

    // -----click function----- 


    // -----change function-----

        $("#origin").change(function () {
            switch($(this).val()) {
                case 'BSO':
                    $("#destination").html("<option value='' selected disabled>Select Destination</option><option value='MNL'>Manila, Domestic Terminal 4 (MNL)</option>");
                    $("#destination").val($("#destination option:eq(1)").val()).trigger('change');
                    $("#destination").addClass("selected");
                    break;
                case 'CGM':
                    $("#destination").html("<option value='' selected disabled>Select Destination</option><option value='MNL' selected>Manila, Domestic Terminal 4 (MNL)</option>");
                    $("#destination").val($("#destination option:eq(1)").val()).trigger('change');
                    $("#destination").addClass("selected");
                    break;
                case 'USU':
                    $("#destination").html("<option value='' selected disabled>Select Destination</option><option value='MNL' selected>Manila, Domestic Terminal 4 (MNL)</option>");
                    $("#destination").val($("#destination option:eq(1)").val()).trigger('change');
                    $("#destination").addClass("selected");
                    break;
                case 'MNL':
                    $("#destination").html("<option value='' selected disabled>Select Destination</option><option value='BSO' selected>Basco, Batanes (BSO)</option><option value='CGM'>Camiguin, Camiguin Airport (CGM)</option><option value='USU'>Coron Palawan, Busuanga, Francisco Reyes Airport (USU)</option><option value='SWL'>San Vicente, San Vicente Airport (SWL)</option>");
                    $("#destination").val($("#destination option:eq(1)").val()).trigger('change');
                    $("#destination").addClass("selected");
                    break;
                case 'SWL':
                    $("#destination").html("<option value='' selected disabled>Select Destination</option><option value='MNL'>Manila, Domestic Terminal 4 (MNL)</option>");
                    $("#destination").val($("#destination option:eq(1)").val()).trigger('change');
                    $("#destination").addClass("selected");
                    break;
                default:
                $("#destination").html("<option value='' selected disabled>Select Destination</option>");
            }
        });

        $('#royalairOrigin').change(function() {
            var origin = $('#royalairOrigin option:selected').attr("value");  
            $("#royalairDestination option[value!=destination]").hide();
            $.ajax({  
                url:  "<?php echo base_url('flights/destination'); ?>",  
                method:"POST",  
                dataType:"json",  
                global: false,
                success:function(data) {
                    var myJSON = JSON.stringify(data);
                    var object = JSON.parse(myJSON);
                    data = object.origin_destination;
                    for (i = 0; i < data.length; i++) { 
                        if(data[i][0] === origin) {
                            data2 = data[i][1];
                            var first = data2[0];
                            for (j = 0; j < data2.length; j++) {
                                $("#royalairDestination option[value = "+data2[j]+"]").show();
                                $("#royalairDestination").val($("#royalairDestination option[value="+first+"]").val()).trigger('change');
                                $("#royalairDestination").addClass("selected");
                            }
                        }                     
                    }
                }  
            })
        });

    // -----change function-----


//================ H O M E ==============



//================ R E G I S T R A T I O N ==============


    // -----click function-----

        $('#signupButton').click(function() {
            displayLoading();
            var fname = $('#reg_fname').val();
            var lname = $('#reg_lname').val();
            var mobile_number = $('#reg_mobile').val();
            var email = $('#reg_email').val();
            var username = $('#reg_username').val();
            var password = $('#reg_password').val();
            var re_password = $('#reg_repassword').val();
            var region = $('#reg_region').val();
            var city = $('#reg_city').val();
            var country = $('#reg_country').val();
            var dpa = $('#terms').val();
            var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            var response = grecaptcha.getResponse();
            

            if(fname === "" || lname === "" || mobile_number === "" || email === "" || username === "" || password === "" || re_password === "" || city === "" || country === "") {
                toastr.error('Please complete all the fields',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkRegisterFields);
                    $(document).ready(checkRegFname);
                    $(document).ready(checkRegLname);
                    $(document).ready(checkRegMobile);
                    $(document).ready(checkRegEmail);
                    $(document).ready(checkRegUsername);
                    $(document).ready(checkRegPassword);
                    $(document).ready(checkRegCity);
                    $(document).ready(checkRegCountry);
                    displayLoading();
                }, 500);
            }
            else if (!username.match(/^[a-zA-Z0-9._]*$/)) {
                toastr.error('The username can only consist of alphabets, number, dot and underscore',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkRegUsername);
                    $(document).ready(checkRegisterFields);
                    displayLoading();
                }, 500);
            }
            else if(username.length < 8) {
                toastr.error('The username must be at least 8 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkRegUsername);
                    $(document).ready(checkRegisterFields);
                    displayLoading();
               }, 500);
            }
            else if(username.length > 20) {
                toastr.error('The username must be less than 20 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkRegUsername);
                    $(document).ready(checkRegisterFields);
                    displayLoading();
               }, 500);
            }
            else if(password.match(/#.*/) || password.match(/\+.*/) || password.match(/&.*/) || password.match(/\*.*/) || password.match(/\(.*/)|| password.match(/\).*/)) {
                toastr.error('The password cannot consist of number and plus sign, ampersand, asterisk, left and right parenthesis',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkRegPassword);
                    $(document).ready(checkRegisterFields);
                    displayLoading();
                }, 500);
            }
            else if(password.length < 8) {
                toastr.error('The password must be at least 8 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkRegPassword);
                    $(document).ready(checkRegisterFields);
                    displayLoading();
               }, 500);
            }
            else if(password.length > 20) {
                toastr.error('The password must be less than 20 characters long',{timeOut: 1000,fadeOut: 1000})
               setTimeout(function () {
                    $(document).ready(checkRegPassword);
                    $(document).ready(checkRegisterFields);
                    displayLoading();
               }, 500);
            }
            else if(re_password !== password) {
                toastr.error("The password and its confirm are not the same",{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkRegPassword);
                    $(document).ready(checkRegisterFields);
                    displayLoading();
                }, 500);
            }
            else if(!filter.test(email)) {
                toastr.error('Invalid email address',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkRegisterFields);
                    $(document).ready(checkRegEmail);
                    displayLoading();
                }, 500);
            } 
            else if($('#terms').prop("checked") == false) {
                toastr.error("Please agree with terms and conditions",{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkRegisterFields);
                    displayLoading();
                }, 500);
            } 
            else if(response.length == 0) { 
                toastr.error("The captcha is required for validation",{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkRegisterFields);
                    displayLoading();
                }, 500);
            }
            else {
                $.ajax({
                    type : "POST",
                    url:  "<?php echo base_url('users/registration'); ?>",  
                    dataType : "text",
                    data : {
                        fname:fname,
                        lname:lname,
                        mobile_number:mobile_number,
                        email:email,
                        username:username,
                        password:password,
                        region:region,
                        city:city,
                        country:country,
                        dpa:dpa
                    },
                    success: function(response) {
                            // console.log(response);
                        if (response=="Registration Successful") {
                            toastr.success("You've signed up your account successfully!",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                window.location.href = "<?php echo base_url() ?>";
                            }, 1000);
                        }
                        else if(response.match(/Username Already Used*/)) {
                            toastr.error("Username Already Used",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                displayLoading();
                                $("#error_username").html("Username Already Used");
                                document.getElementById("reg_username").style.borderColor = "red";
                            }, 500);
                        }
                        else if(response.match(/Email Already Used*/)) {
                            toastr.error("Email Already Used",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                displayLoading();
                                $("#error_email").html("Email Already Used");
                                document.getElementById("reg_email").style.borderColor = "red";
                            }, 500);
                        }
                        else if(response.match(/Invalid Email Format*/)) {
                            toastr.error("Invalid Email Format",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                displayLoading();
                                $("#error_email").html("The input is not a valid email address");
                                document.getElementById("reg_email").style.borderColor = "red";
                            }, 500);
                        }
                        else if(response.match(/Mobile Number Already Used*/)) {
                            toastr.error("Mobile Number Already Used",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                displayLoading();
                                $("#error_mobile").html("Mobile Number Already Used");
                                document.getElementById("reg_mobile").style.borderColor = "red";
                            }, 500);
                        }
                        else {
                            toastr.error(response,{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                displayLoading();
                            }, 500);
                        }
                    }
                });
            }
        });

        $('#visibleRegPasswordButton').click(function() {
            x = document.getElementById("reg_password");
            y = document.getElementById("visibleRegPasswordButton");
            if (x.type === "password") {
                x.type = "text";
                y.classList.add('js-password--hidden')
            } else {
                x.type = "password";
                y.classList.remove('js-password--hidden')
            }
        });

        $('#visibleRegRePasswordButton').click(function() {
            x = document.getElementById("reg_repassword");
            y = document.getElementById("visibleRegRePasswordButton");
            if (x.type === "password") {
                x.type = "text";
                y.classList.add('js-password--hidden')
            } else {
                x.type = "password";
                y.classList.remove('js-password--hidden')
            }
        });

        $('#consents').click(function() {
            $(document).ready(checkRegisterFields);
        });

        $('#terms').click(function() {
            $(document).ready(checkRegisterFields);
        });

        $("#reg_mobile").bind("contextmenu", function(e) {
            e.preventDefault();
        });

    // -----click function-----
    

    // -----change function-----

        $('select#reg_country').change(function() {
            var k;
            var index = this.value;
            var key = country_arr.indexOf(index);

            $('select#reg_city').find('option').not(':first').remove().end();

            if(index === "Philippines") {
                $('#reg_region').prop('disabled', false);

                for (k=0; k < region_arr[key].length; k++) {
                    $("select#reg_region").append("<option value='"+ region_arr[key][k] +"'>" + region_arr[key][k] + "</option>");
                }
                var options = $('select#reg_region option:gt(0)');
                var arr = options.map(function(_, o) {return {t: $(o).text(),v: o.value};}).get();
                arr.sort(function(o1, o2) {return o1.t > o2.t ? 1 : o1.t < o2.t ? -1 : 0;});
                options.each(function(i, o) {o.value = arr[i].v;$(o).text(arr[i].t);});
            } else {
                $('select#reg_region').find('option').not(':first').remove().end();
                $('#reg_region').prop('disabled', 'disabled');
                for (k=0; k < city_arr[key].length; k++) {
                   $("select#reg_city").append("<option value='"+ city_arr[key][k] +"'>" + city_arr[key][k] + "</option>");
                }
            }
        });

        $('select#reg_country').change(function() {
            var j;
            var index = this.value;
            var key = country_arr.indexOf(index);
            length = country_code_arr[key].length;

            $("#reg_mobile").val(country_code_arr[key]);
            $("#reg_mobile").attr("value", country_code_arr[key]);
            $("#reg_mobile").attr("length", length);
        });

        $("#reg_mobile").on("keydown", function(e) {
            length = $(this).attr("length");
            if ((e.keyCode == 8 && $('#reg_mobile').is(":focus") && $('#reg_mobile').val().length <= length) || ($(this).get(0).selectionStart === 0 && (e.keyCode < 35 || e.keyCode > 40))) {
                e.preventDefault();
            }
        });

        $('select#reg_region').change(function() {
            var l;
            var ind = this.value;

            $('select#reg_city').find('option').not(':first').remove().end();

            for (l=0; l < city_reg_arr[ind].length; l++) {
                $("select#reg_city").append("<option value='"+ city_reg_arr[ind][l] +"'>" + city_reg_arr[ind][l] + "</option>");
            }
        });

        $('#reg_country').change(function() {
            $(document).ready(checkRegCountry);
            $(document).ready(checkRegisterFields);
        });

        $('#reg_region').change(function() {
            $(document).ready(checkRegRegion);
            $(document).ready(checkRegisterFields);
        });

        $('#reg_city').change(function() {
            $(document).ready(checkRegCity);
            $(document).ready(checkRegisterFields);
        });

    // -----change function-----


    // -----function-----

        function nameCase(string) {
           var splitStr = string.toLowerCase().split(' ');
           for (var i = 0; i < splitStr.length; i++) {
               splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);     
           }
           return splitStr.join(' '); 
        }

        function showAllCountry() {
            var i=0;
            for (i=0; i < country_arr.length; i++) {
                if (i!=0) {
                    $("select#reg_country").append("<option value='"+ country_arr[i] +"'>" + country_arr[i] + "</option>");
                }
            }
        }

        var correctCaptchaSignup = function(response) {
            $("#signupButton").removeClass("o-button--green-disabled");
            $("#signupButton").removeAttr("disabled");
        };

        function checkRegisterFields() {
            var fname = $('#reg_fname').val();
            var lname = $('#reg_lname').val();
            var mobile_number = $('#reg_mobile').val();
            var email = $('#reg_email').val();
            var username = $('#reg_username').val();
            var password = $('#reg_password').val();
            var re_password = $('#reg_repassword').val();
            var region = $('#reg_region').val();
            var city = $('#reg_city').val();
            var country = $('#reg_country').val();
            var dpa = $('#terms').val();
            var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            var response = grecaptcha.getResponse();

            if(fname === "" || lname === "" || mobile_number === "" || email === "" || username === "" || password === "" || re_password === "" || city === "" || country === "") {
                $("#signupButton").attr("disabled", true);
                $("#signupButton").addClass("o-button--green-disabled");
                $("#signupButton").attr("Title", "Please complete all the fields");
            }
            else if (!username.match(/^[a-zA-Z0-9._]*$/)) {
                $("#signupButton").attr("disabled", true);
                $("#signupButton").addClass("o-button--green-disabled");
                $("#signupButton").attr("Title", "The username can only consist of alphabets, number, dot and underscore");
            }
            else if(username.length < 8) {
                $("#signupButton").attr("disabled", true);
                $("#signupButton").addClass("o-button--green-disabled");
                $("#signupButton").attr("Title", "The username must be at least 8 characters long");
            }
            else if(username.length > 20) {
                $("#signupButton").attr("disabled", true);
                $("#signupButton").addClass("o-button--green-disabled");
                $("#signupButton").attr("Title", "The username must be less than 20 characters long");
            }
            else if(password.match(/#.*/) || password.match(/\+.*/) || password.match(/&.*/) || password.match(/\*.*/) || password.match(/\(.*/)|| password.match(/\).*/)) {
                $("#signupButton").attr("disabled", true);
                $("#signupButton").addClass("o-button--green-disabled");
                $("#signupButton").attr("Title", "The password cannot consist of number and plus sign, ampersand, asterisk, left and right parenthesis");
            }
            else if(password.length < 8) {
                $("#signupButton").attr("disabled", true);
                $("#signupButton").addClass("o-button--green-disabled");
                $("#signupButton").attr("Title", "The password must be at least 8 characters long");
            }
            else if(password.length > 20) {
                $("#signupButton").attr("disabled", true);
                $("#signupButton").addClass("o-button--green-disabled");
                $("#signupButton").attr("Title", "The password must be less than 20 characters long");
            }
            else if(re_password !== password) {
                $("#signupButton").attr("disabled", true);
                $("#signupButton").addClass("o-button--green-disabled");
                $("#signupButton").attr("Title", "The password and its confirm are not the same");
            }
            else if(!filter.test(email)) {
                $("#signupButton").attr("disabled", true);
                $("#signupButton").addClass("o-button--green-disabled");
                $("#signupButton").attr("Title", "Invalid email address");
            } 
            else if($('#terms').prop("checked") == false) {
                $("#signupButton").attr("disabled", true);
                $("#signupButton").addClass("o-button--green-disabled");
                $("#signupButton").attr("Title", "Please agree with Terms & Conditions");
            } 
            else if(response.length == 0) { 
                $("#signupButton").attr("disabled", true);
                $("#signupButton").addClass("o-button--green-disabled");
                $("#signupButton").attr("Title", "The captcha is required for validation");
            }
            else {
                $("#signupButton").removeAttr("disabled");
                $("#signupButton").removeClass("o-button--green-disabled");
                $("#signupButton").removeAttr("Title")
            }
        }

        function checkRegUsername() {
            var username = $('#reg_username').val();
            if(username === "") {
                $("#error_username").html("The username is required and cannot be empty");
                document.getElementById("reg_username").style.borderColor = "red";
            } 
            else if(username.length < 8) {
                $("#error_username").html("The username must be at least 8 characters long");
                document.getElementById("reg_username").style.borderColor = "red";
            }
            else if(username.length > 20) {
                $("#error_username").html("The username must be less than 20 characters long");
                document.getElementById("reg_username").style.borderColor = "red";
            }
            else if (!username.match(/^[a-zA-Z0-9._]*$/)) {
                $("#error_username").html("The username can only consist of alphabets, number, dot and underscore");
                document.getElementById("reg_username").style.borderColor = "red";
            }
            else {
                $("#error_username").empty();
                document.getElementById("reg_username").style.borderColor = "green";
            }
        }

        function checkRegPassword() {
            var password = $('#reg_password').val();
            var repassword = $('#reg_repassword').val();
            if(password === "") {
                $("#error_repassword").empty();
                $("#error_password").html("The password is required and cannot be empty");
                document.getElementById("reg_password").style.borderColor = "red";
                document.getElementById("reg_repassword").style.borderColor = "red";
            } 
            else if(password.length < 8) {
                $("#error_repassword").empty();
                $("#error_password").html("The password must be at least 8 characters long");
                document.getElementById("reg_password").style.borderColor = "red";
                document.getElementById("reg_repassword").style.borderColor = "red";
            }
            else if(password.length > 20) {
                $("#error_repassword").empty();
                $("#error_password").html("The password must be less than 20 characters long");
                document.getElementById("reg_password").style.borderColor = "red";
                document.getElementById("reg_repassword").style.borderColor = "red";
            }
            else if(password.match(/#.*/) || password.match(/\+.*/) || password.match(/&.*/) || password.match(/\*.*/) || password.match(/\(.*/)|| password.match(/\).*/)) {
                $("#error_repassword").empty();
                $("#error_password").html("The password cannot consist of number and plus sign, ampersand, asterisk, left and right parenthesis");
                document.getElementById("reg_password").style.borderColor = "red";
                document.getElementById("reg_repassword").style.borderColor = "red";
            }
            else if(password !== repassword) {
                $("#error_password").empty();
                $("#error_repassword").html("The password and its confirm are not the same");
                document.getElementById("reg_password").style.borderColor = "red";
                document.getElementById("reg_repassword").style.borderColor = "red";
            }
            else {
                $("#error_repassword").empty();
                $("#error_password").empty();
                document.getElementById("reg_password").style.borderColor = "green";
                document.getElementById("reg_repassword").style.borderColor = "green";
            }
        }

        function checkRegFname() {
            var fname = $('#reg_fname').val();
            if(fname === "") {
                $("#error_fname").html("The first name is required and cannot be empty");
                document.getElementById("reg_fname").style.borderColor = "red";
            } 
            else {
                $("#error_fname").empty();
                document.getElementById("reg_fname").style.borderColor = "green";
            }
        }

        function checkRegLname() {
            var lname = $('#reg_lname').val();
            if(lname === "") {
                $("#error_lname").html("The last name is required and cannot be empty");
                document.getElementById("reg_lname").style.borderColor = "red";
            } 
            else {
                $("#error_lname").empty();
                document.getElementById("reg_lname").style.borderColor = "green";
            }
        }

        function checkRegEmail() {
            var email = $('#reg_email').val();
            var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if(email !== "") {
                if(!filter.test(email)) {
                    $("#error_email").html("Invalid email address");
                    document.getElementById("reg_email").style.borderColor = "red";
                }
                else {
                    $("#error_email").empty();
                    document.getElementById("reg_email").style.borderColor = "green";
                }
            } 
            else {
                $("#error_email").html("The email is required and cannot be empty");
                document.getElementById("reg_email").style.borderColor = "red";
            }
        }

        function checkRegMobile() {
            var mobile = $('#reg_mobile').val();
            var country = $('#reg_country').val();
            var maxLength = 12;
            if(mobile !== "") {
                if(country === "Philippines") {
                    if(mobile.length === maxLength) {
                        $("#error_mobile").empty();
                        document.getElementById("reg_mobile").style.borderColor = "green";
                    }
                    else {
                        $("#error_mobile").html("The mobile is not a valid mobile number");
                        document.getElementById("reg_mobile").style.borderColor = "red";
                    }
                }
                else {
                    $("#error_mobile").empty();
                    document.getElementById("reg_mobile").style.borderColor = "green";
                }
            } 
            else {
                $("#error_mobile").html("The mobile number is required and connot be empty");
                document.getElementById("reg_mobile").style.borderColor = "red";
            }
        }

        function checkRegCountry() {
            var country = $('#reg_country').val();
            if(country === "" || country === null) {
                $("#error_country").html("The country is required and cannot be empty");
                document.getElementById("reg_country").style.borderColor = "red";
            } 
            else {
                $("#error_country").empty();
                document.getElementById("reg_country").style.borderColor = "green";
            }

            if(country !== "Philippines") {
                $("#error_region").empty();
                document.getElementById('reg_region').style.removeProperty('border-color');
            }
        }

        function checkRegRegion() {
            var region = $('#reg_region').val();
            if(region === "" || region === null) {
                $("#error_region").html("The region is required and cannot be empty");
                document.getElementById("reg_region").style.borderColor = "red";
            } 
            else {
                $("#error_region").empty();
                document.getElementById("reg_region").style.borderColor = "green";
            }
        }

        function checkRegCity() {
            var city = $('#reg_city').val();
            if(city === "" || city === null) {
                $("#error_city").html("The city is required and cannot be empty");
                document.getElementById("reg_city").style.borderColor = "red";
            } 
            else {
                $("#error_city").empty();
                document.getElementById("reg_city").style.borderColor = "green";
            }
        }

    // -----function-----
    

    // -----keycode function-----

        $("#reg_username").keypress(function(e) {
            if(e.keyCode==9) {
                e.preventDefault();
                $('input[id="reg_password"]').focus()
            }
            else if (!((e.keyCode>=48&&e.keyCode<= 57)||(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=97&&e.keyCode<= 122)||e.keyCode==95||e.keyCode==46)) {
                return false;
            }
        });

        $('#reg_password').keypress(function(event) {
            if(e.keyCode==9) {
                e.preventDefault();
                $('input[id="reg_repassword"]').focus()
            }
            else if((event.keyCode>=40&&event.keyCode<=43)||event.keyCode===35||event.keyCode===38) {
                event.preventDefault();
            }
        });

        $('#reg_repassword').keypress(function(event) {
            if((event.keyCode>=40&&event.keyCode<=43)||event.keyCode===35||event.keyCode===38) {
                event.preventDefault();
            }
        });

        $("#reg_fname").keypress(function(e) {
            if (!((e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=97&&e.keyCode<= 122))&&e.keyCode!=8&&e.keyCode!=32) {
                return false;
            }
        });

        $("#reg_lname").keypress(function(e) {
            if (!((e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=97&&e.keyCode<= 122))&&e.keyCode!=8&&e.keyCode!=32) {
                return false;
            }
        });

        $("#reg_email").keypress(function(e) {
            if (e.keyCode===32) {
                return false;
            }
        });

        $("#reg_mobile").keypress(function(e) {
            if (!((e.keyCode>=48&&e.keyCode<= 57)||(e.keyCode>=65&&e.keyCode<=90))) {
                return false;
            }
        });

    // -----keycode function-----


    // -----keyup function-----

        $('#reg_username').keyup(function() {
            $(document).ready(checkRegUsername);
            $(document).ready(checkRegisterFields);
            var max_chars = 20;
            if ($(this).val().length >= max_chars) { 
                $(this).val($(this).val().substr(0, max_chars));
            }
        });

        $('#reg_password').keyup(function() {
            $(document).ready(checkRegPassword);
            $(document).ready(checkRegisterFields);
            var max_chars = 20;
            if ($(this).val().length >= max_chars) { 
                $(this).val($(this).val().substr(0, max_chars));
            }
        });

        $('#reg_repassword').keyup(function() {
            $(document).ready(checkRegPassword);
            $(document).ready(checkRegisterFields);
            var max_chars = 20;
            if ($(this).val().length >= max_chars) { 
                $(this).val($(this).val().substr(0, max_chars));
            }
        });

        $('#reg_fname').keyup(function() {
            $(document).ready(checkRegFname);
            $(document).ready(checkRegisterFields);
            string = $(this).val();
            $(this).val(nameCase(string));
        });

        $('#reg_lname').keyup(function() {
            $(document).ready(checkRegLname);
            $(document).ready(checkRegisterFields);
            string = $(this).val();
            $(this).val(nameCase(string));
        });

        $('#reg_email').keyup(function() {
            $(document).ready(checkRegEmail);
            $(document).ready(checkRegisterFields);
            string = $(this).val();
            var email = string.toLowerCase();
            $(this).val(email);
        });

        $('#reg_mobile').keyup(function() {
            $(document).ready(checkRegMobile);
            $(document).ready(checkRegisterFields);
            var max_chars = 12;
            if ($(this).val().length >= max_chars) { 
                $(this).val($(this).val().substr(0, max_chars));
            }
        });

    // -----keyup function-----


    // -----array-----

        var country_arr = new Array("", "Afghanistan", "Albania", "Algeria", "American Samoa", "Angola", "Anguilla", "Antartica", "Antigua and Barbuda", "Argentina", "Armenia", "Aruba", "Ashmore and Cartier Island", "Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", "Benin", "Bermuda", "Bhutan", "Bolivia", "Bosnia and Herzegovina", "Botswana", "Brazil", "British Virgin Islands", "Brunei", "Bulgaria", "Burkina Faso", "Burma", "Burundi", "Cambodia", "Cameroon", "Canada", "Cape Verde", "Cayman Islands", "Central African Republic", "Chad", "Chile", "China", "Christmas Island", "Clipperton Island", "Cocos (Keeling) Islands", "Colombia", "Comoros", "Congo, Democratic Republic of the", "Congo, Republic of the", "Cook Islands", "Costa Rica", "Cote d'Ivoire", "Croatia", "Cuba", "Cyprus", "Czeck Republic", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "Ecuador", "Egypt", "El Salvador", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia", "Europa Island", "Falkland Islands (Islas Malvinas)", "Faroe Islands", "Fiji", "Finland", "France", "French Guiana", "French Polynesia", "French Southern and Antarctic Lands", "Gabon", "Gambia, The", "Gaza Strip", "Georgia", "Germany", "Ghana", "Gibraltar", "Glorioso Islands", "Greece", "Greenland", "Grenada", "Guadeloupe", "Guam", "Guatemala", "Guernsey", "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Heard Island and McDonald Islands", "Holy See (Vatican City)", "Honduras", "Hong Kong", "Howland Island", "Hungary", "Iceland", "India", "Indonesia", "Iran", "Iraq", "Ireland", "Ireland, Northern", "Israel", "Italy", "Jamaica", "Jan Mayen", "Japan", "Jarvis Island", "Jersey", "Johnston Atoll", "Jordan", "Juan de Nova Island", "Kazakhstan", "Kenya", "Kiribati", "Korea, North", "Korea, South", "Kuwait", "Kyrgyzstan", "Laos", "Latvia", "Lebanon", "Lesotho", "Liberia", "Libya", "Liechtenstein", "Lithuania", "Luxembourg", "Macau", "Macedonia, Former Yugoslav Republic of", "Madagascar", "Malawi", "Malaysia", "Maldives", "Mali", "Malta", "Man, Isle of", "Marshall Islands", "Martinique", "Mauritania", "Mauritius", "Mayotte", "Mexico", "Micronesia, Federated States of", "Midway Islands", "Moldova", "Monaco", "Mongolia", "Montserrat", "Morocco", "Mozambique", "Namibia", "Nauru", "Nepal", "Netherlands", "Netherlands Antilles", "New Caledonia", "New Zealand", "Nicaragua", "Niger", "Nigeria", "Niue", "Norfolk Island", "Northern Mariana Islands", "Norway", "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Pitcaim Islands", "Poland", "Portugal", "Puerto Rico", "Qatar", "Reunion", "Romainia", "Russia", "Rwanda", "Saint Helena", "Saint Kitts and Nevis", "Saint Lucia", "Saint Pierre and Miquelon", "Saint Vincent and the Grenadines", "Samoa", "San Marino", "Sao Tome and Principe", "Saudi Arabia", "Scotland", "Senegal", "Seychelles", "Sierra Leone", "Singapore", "Slovakia", "Slovenia", "Solomon Islands", "Somalia", "South Africa", "South Georgia and South Sandwich Islands", "Spain", "Spratly Islands", "Sri Lanka", "Sudan", "Suriname", "Svalbard", "Swaziland", "Sweden", "Switzerland", "Syria", "Taiwan", "Tajikistan", "Tanzania", "Thailand", "Tobago", "Toga", "Tokelau", "Tonga", "Trinidad", "Tunisia", "Turkey", "Turkmenistan", "Tuvalu", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "Uruguay", "USA", "Uzbekistan", "Vanuatu", "Venezuela", "Vietnam", "Virgin Islands", "Wales", "Wallis and Futuna", "West Bank", "Western Sahara", "Yemen", "Yugoslavia", "Zambia", "Zimbabwe");

        var city_arr = new Array();
        city_arr[0]=[""];
        city_arr[1]=["Badakhshan","Badghis","Baghlan","Balkh","Bamian","Farah","Faryab","Ghazni","Ghowr","Helmand","Herat","Jowzjan","Kabol","Kandahar","Kapisa","Konar","Kondoz","Laghman","Lowgar","Nangarhar","Nimruz","Oruzgan","Paktia","Paktika","Parvan","Samangan","Sar-e Pol","Takhar","Vardak","Zabol"];
        city_arr[2]=["Berat","Bulqize","Delvine","Devoll (Bilisht)","Diber (Peshkopi)","Durres","Elbasan","Fier","Gjirokaster","Gramsh","Has (Krume)","Kavaje","Kolonje (Erseke)","Korce","Kruje","Kucove","Kukes","Kurbin","Lezhe","Librazhd","Lushnje","Malesi e Madhe (Koplik)","Mallakaster (Ballsh)","Mat (Burrel)","Mirdite (Rreshen)","Peqin","Permet","Pogradec","Puke","Sarande","Shkoder","Skrapar (Corovode)","Tepelene","Tirane (Tirana)","Tirane (Tirana)","Tropoje (Bajram Curri)","Vlore"];
        city_arr[3]=["Adrar","Ain Defla","Ain Temouchent","Alger","Annaba","Batna","Bechar","Bejaia","Biskra","Blida","Bordj Bou Arreridj","Bouira","Boumerdes","Chlef","Constantine","Djelfa","El Bayadh","El Oued","El Tarf","Ghardaia","Guelma","Illizi","Jijel","Khenchela","Laghouat","M'Sila","Mascara","Medea","Mila","Mostaganem","Naama","Oran","Ouargla","Oum el Bouaghi","Relizane","Saida","Setif","Sidi Bel Abbes","Skikda","Souk Ahras","Tamanghasset","Tebessa","Tiaret","Tindouf","Tipaza","Tissemsilt","Tizi Ouzou","Tlemcen"];
        city_arr[4]=["Eastern","Manu'a","Rose Island","Swains Island","Western"];
        city_arr[5]=["Andorra la Vella","Bengo","Benguela","Bie","Cabinda","Canillo","Cuando Cubango","Cuanza Norte","Cuanza Sul","Cunene","Encamp","Escaldes-Engordany","Huambo","Huila","La Massana","Luanda","Lunda Norte","Lunda Sul","Malanje","Moxico","Namibe","Ordino","Sant Julia de Loria","Uige","Zaire"];
        city_arr[6]=["Anguilla"];
        city_arr[7]=["Antartica"];
        city_arr[8]=["Barbuda","Redonda","Saint George","Saint John","Saint Mary","Saint Paul","Saint Peter","Saint Philip"];
        city_arr[9]=["Antartica e Islas del Atlantico Sur","Buenos Aires","Buenos Aires Capital Federal","Catamarca","Chaco","Chubut","Cordoba","Corrientes","Entre Rios","Formosa","Jujuy","La Pampa","La Rioja","Mendoza","Misiones","Neuquen","Rio Negro","Salta","San Juan","San Luis","Santa Cruz","Santa Fe","Santiago del Estero","Tierra del Fuego","Tucuman"];
        city_arr[10]=["Aragatsotn","Ararat","Armavir","Geghark'unik'","Kotayk'","Lorri","Shirak","Syunik'","Tavush","Vayots' Dzor","Yerevan"];
        city_arr[11]=["Aruba"];
        city_arr[12]=["Ashmore and Cartier Island"];
        city_arr[13]=["Australian Capital Territory","New South Wales","Northern Territory","Queensland","South Australia","Tasmania","Victoria","Western Australia"];
        city_arr[14]=["Burgenland","Kaernten","Niederoesterreich","Oberoesterreich","Salzburg","Steiermark","Tirol","Vorarlberg","Wien"];
        city_arr[15]=["Abseron Rayonu","Agcabadi Rayonu","Agdam Rayonu","Agdas Rayonu","Agstafa Rayonu","Agsu Rayonu","Ali Bayramli Sahari","Astara Rayonu","Baki Sahari","Balakan Rayonu","Barda Rayonu","Beylaqan Rayonu","Bilasuvar Rayonu","Cabrayil Rayonu","Calilabad Rayonu","Daskasan Rayonu","Davaci Rayonu","Fuzuli Rayonu","Gadabay Rayonu","Ganca Sahari","Goranboy Rayonu","Goycay Rayonu","Haciqabul Rayonu","Imisli Rayonu","Ismayilli Rayonu","Kalbacar Rayonu","Kurdamir Rayonu","Lacin Rayonu","Lankaran Rayonu","Lankaran Sahari","Lerik Rayonu","Masalli Rayonu","Mingacevir Sahari","Naftalan Sahari","Naxcivan Muxtar Respublikasi","Neftcala Rayonu","Oguz Rayonu","Qabala Rayonu","Qax Rayonu","Qazax Rayonu","Qobustan Rayonu","Quba Rayonu","Qubadli Rayonu","Qusar Rayonu","Saatli Rayonu","Sabirabad Rayonu","Saki Rayonu","Saki Sahari","Salyan Rayonu","Samaxi Rayonu","Samkir Rayonu","Samux Rayonu","Siyazan Rayonu","Sumqayit Sahari","Susa Rayonu","Susa Sahari","Tartar Rayonu","Tovuz Rayonu","Ucar Rayonu","Xacmaz Rayonu","Xankandi Sahari","Xanlar Rayonu","Xizi Rayonu","Xocali Rayonu","Xocavand Rayonu","Yardimli Rayonu","Yevlax Rayonu","Yevlax Sahari","Zangilan Rayonu","Zaqatala Rayonu","Zardab Rayonu"];
        city_arr[16]=["Acklins and Crooked Islands","Bimini","Cat Island","Exuma","Freeport","Fresh Creek","Governor's Harbour","Green Turtle Cay","Harbour Island","High Rock","Inagua","Kemps Bay","Long Island","Marsh Harbour","Mayaguana","New Providence","Nicholls Town and Berry Islands","Ragged Island","Rock Sound","San Salvador and Rum Cay","Sandy Point"];
        city_arr[17]=["Al Hadd","Al Manamah","Al Mintaqah al Gharbiyah","Al Mintaqah al Wusta","Al Mintaqah ash Shamaliyah","Al Muharraq","Ar Rifa' wa al Mintaqah al Janubiyah","Jidd Hafs","Juzur Hawar","Madinat 'Isa","Madinat Hamad","Sitrah"];
        city_arr[18]=["Barguna","Barisal","Bhola","Jhalokati","Patuakhali","Pirojpur","Bandarban","Brahmanbaria","Chandpur","Chittagong","Comilla","Cox's Bazar","Feni","Khagrachari","Lakshmipur","Noakhali","Rangamati","Dhaka","Faridpur","Gazipur","Gopalganj","Jamalpur","Kishoreganj","Madaripur","Manikganj","Munshiganj","Mymensingh","Narayanganj","Narsingdi","Netrokona","Rajbari","Shariatpur","Sherpur","Tangail","Bagerhat","Chuadanga","Jessore","Jhenaidah","Khulna","Kushtia","Magura","Meherpur","Narail","Satkhira","Bogra","Dinajpur","Gaibandha","Jaipurhat","Kurigram","Lalmonirhat","Naogaon","Natore","Nawabganj","Nilphamari","Pabna","Panchagarh","Rajshahi","Rangpur","Sirajganj","Thakurgaon","Habiganj","Maulvi bazar","Sunamganj","Sylhet"];
        city_arr[19]=["Bridgetown","Christ Church","Saint Andrew","Saint George","Saint James","Saint John","Saint Joseph","Saint Lucy","Saint Michael","Saint Peter","Saint Philip","Saint Thomas"];
        city_arr[20]=["Brestskaya (Brest)","Homyel'skaya (Homyel')","Horad Minsk","Hrodzyenskaya (Hrodna)","Mahilyowskaya (Mahilyow)","Minskaya","Vitsyebskaya (Vitsyebsk)"];
        city_arr[21]=["Antwerpen","Brabant Wallon","Brussels Capitol Region","Hainaut","Liege","Limburg","Luxembourg","Namur","Oost-Vlaanderen","Vlaams Brabant","West-Vlaanderen"];
        city_arr[22]=["Belize","Cayo","Corozal","Orange Walk","Stann Creek","Toledo"];
        city_arr[23]=["Alibori","Atakora","Atlantique","Borgou","Collines","Couffo","Donga","Littoral","Mono","Oueme","Plateau","Zou"];
        city_arr[24]=["Devonshire","Hamilton","Hamilton","Paget","Pembroke","Saint George","Saint Georges","Sandys","Smiths","Southampton","Warwick"];
        city_arr[25]=["Bumthang","Chhukha","Chirang","Daga","Geylegphug","Ha","Lhuntshi","Mongar","Paro","Pemagatsel","Punakha","Samchi","Samdrup Jongkhar","Shemgang","Tashigang","Thimphu","Tongsa","Wangdi Phodrang"];
        city_arr[26]=["Beni","Chuquisaca","Cochabamba","La Paz","Oruro","Pando","Potosi","Santa Cruz","Tarija"];
        city_arr[27]=["Federation of Bosnia and Herzegovina","Republika Srpska"];
        city_arr[28]=["Central","Chobe","Francistown","Gaborone","Ghanzi","Kgalagadi","Kgatleng","Kweneng","Lobatse","Ngamiland","North-East","Selebi-Pikwe","South-East","Southern"];
        city_arr[29]=["Acre","Alagoas","Amapa","Amazonas","Bahia","Ceara","Distrito Federal","Espirito Santo","Goias","Maranhao","Mato Grosso","Mato Grosso do Sul","Minas Gerais","Para","Paraiba","Parana","Pernambuco","Piaui","Rio de Janeiro","Rio Grande do Norte","Rio Grande do Sul","Rondonia","Roraima","Santa Catarina","Sao Paulo","Sergipe","Tocantins"];
        city_arr[30]=["Anegada","Jost Van Dyke","Tortola","Virgin Gorda"];
        city_arr[31]=["Belait","Brunei and Muara","Temburong","Tutong"];
        city_arr[32]=["Blagoevgrad","Burgas","Dobrich","Gabrovo","Khaskovo","Kurdzhali","Kyustendil","Lovech","Montana","Pazardzhik","Pernik","Pleven","Plovdiv","Razgrad","Ruse","Shumen","Silistra","Sliven","Smolyan","Sofiya","Sofiya-Grad","Stara Zagora","Turgovishte","Varna","Veliko Turnovo","Vidin","Vratsa","Yambol"];
        city_arr[33]=["Bale","Bam","Banwa","Bazega","Bougouriba","Boulgou","Boulkiemde","Comoe","Ganzourgou","Gnagna","Gourma","Houet","Ioba","Kadiogo","Kenedougou","Komandjari","Kompienga","Kossi","Koupelogo","Kouritenga","Kourweogo","Leraba","Loroum","Mouhoun","Nahouri","Namentenga","Naumbiel","Nayala","Oubritenga","Oudalan","Passore","Poni","Samentenga","Sanguie","Seno","Sissili","Soum","Sourou","Tapoa","Tuy","Yagha","Yatenga","Ziro","Zondomo","Zoundweogo"];
        city_arr[34]=["Ayeyarwady","Bago","Chin State","Kachin State","Kayah State","Kayin State","Magway","Mandalay","Mon State","Rakhine State","Sagaing","Shan State","Tanintharyi","Yangon"];
        city_arr[35]=["Bubanza","Bujumbura","Bururi","Cankuzo","Cibitoke","Gitega","Karuzi","Kayanza","Kirundo","Makamba","Muramvya","Muyinga","Mwaro","Ngozi","Rutana","Ruyigi"];
        city_arr[36]=["Banteay Mean Cheay","Batdambang","Kampong Cham","Kampong Chhnang","Kampong Spoe","Kampong Thum","Kampot","Kandal","Kaoh Kong","Keb","Kracheh","Mondol Kiri","Otdar Mean Cheay","Pailin","Phnum Penh","Pouthisat","Preah Seihanu (Sihanoukville)","Preah Vihear","Prey Veng","Rotanah Kiri","Siem Reab","Stoeng Treng","Svay Rieng","Takev"];
        city_arr[37]=["Adamaoua","Centre","Est","Extreme-Nord","Littoral","Nord","Nord-Ouest","Ouest","Sud","Sud-Ouest"];
        city_arr[38]=["Alberta","British Columbia","Manitoba","New Brunswick","Newfoundland","Northwest Territories","Nova Scotia","Nunavut","Ontario","Prince Edward Island","Quebec","Saskatchewan","Yukon Territory"];
        city_arr[39]=["Boa Vista","Brava","Maio","Mosteiros","Paul","Porto Novo","Praia","Ribeira Grande","Sal","Santa Catarina","Santa Cruz","Sao Domingos","Sao Filipe","Sao Nicolau","Sao Vicente","Tarrafal"];
        city_arr[40]=["Creek","Eastern","Midland","South Town","Spot Bay","Stake Bay","West End","Western"];
        city_arr[41]=["Bamingui-Bangoran","Bangui","Basse-Kotto","Gribingui","Haut-Mbomou","Haute-Kotto","Haute-Sangha","Kemo-Gribingui","Lobaye","Mbomou","Nana-Mambere","Ombella-Mpoko","Ouaka","Ouham","Ouham-Pende","Sangha","Vakaga"];
        city_arr[42]=["Batha","Biltine","Borkou-Ennedi-Tibesti","Chari-Baguirmi","Guera","Kanem","Lac","Logone Occidental","Logone Oriental","Mayo-Kebbi","Moyen-Chari","Ouaddai","Salamat","Tandjile"];
        city_arr[43]=["Aisen del General Carlos Ibanez del Campo","Antofagasta","Araucania","Atacama","Bio-Bio","Coquimbo","Libertador General Bernardo O'Higgins","Los Lagos","Magallanes y de la Antartica Chilena","Maule","Region Metropolitana (Santiago)","Tarapaca","Valparaiso"];
        city_arr[44]=["Anhui","Beijing","Chongqing","Fujian","Gansu","Guangdong","Guangxi","Guizhou","Hainan","Hebei","Heilongjiang","Henan","Hubei","Hunan","Jiangsu","Jiangxi","Jilin","Liaoning","Nei Mongol","Ningxia","Qinghai","Shaanxi","Shandong","Shanghai","Shanxi","Sichuan","Tianjin","Xinjiang","Xizang (Tibet)","Yunnan","Zhejiang"];
        city_arr[45]=["Christmas Island"];
        city_arr[46]=["Clipperton Island"];
        city_arr[47]=["Direction Island","Home Island","Horsburgh Island","North Keeling Island","South Island","West Island"];
        city_arr[48]=["Amazonas","Antioquia","Arauca","Atlantico","Bolivar","Boyaca","Caldas","Caqueta","Casanare","Cauca","Cesar","Choco","Cordoba","Cundinamarca","Distrito Capital de Santa Fe de Bogota","Guainia","Guaviare","Huila","La Guajira","Magdalena","Meta","Narino","Norte de Santander","Putumayo","Quindio","Risaralda","San Andres y Providencia","Santander","Sucre","Tolima","Valle del Cauca","Vaupes","Vichada"];
        // <!-- -->
        city_arr[49]=["Anjouan (Nzwani)","Domoni","Fomboni","Grande Comore (Njazidja)","Moheli (Mwali)","Moroni","Moutsamoudou"];
        city_arr[50]=["Bandundu","Bas-Congo","Equateur","Kasai-Occidental","Kasai-Oriental","Katanga","Kinshasa","Maniema","Nord-Kivu","Orientale","Sud-Kivu"];
        city_arr[51]=["Bouenza","Brazzaville","Cuvette","Kouilou","Lekoumou","Likouala","Niari","Plateaux","Pool","Sangha"];
        city_arr[52]=["Aitutaki","Atiu","Avarua","Mangaia","Manihiki","Manuae","Mauke","Mitiaro","Nassau Island","Palmerston","Penrhyn","Pukapuka","Rakahanga","Rarotonga","Suwarrow","Takutea"];
        city_arr[53]=["Alajuela","Cartago","Guanacaste","Heredia","Limon","Puntarenas","San Jose"];
        city_arr[54]=["Abengourou","Abidjan","Aboisso","Adiake'","Adzope","Agboville","Agnibilekrou","Ale'pe'","Bangolo","Beoumi","Biankouma","Bocanda","Bondoukou","Bongouanou","Bouafle","Bouake","Bouna","Boundiali","Dabakala","Dabon","Daloa","Danane","Daoukro","Dimbokro","Divo","Duekoue","Ferkessedougou","Gagnoa","Grand Bassam","Grand-Lahou","Guiglo","Issia","Jacqueville","Katiola","Korhogo","Lakota","Man","Mankono","Mbahiakro","Odienne","Oume","Sakassou","San-Pedro","Sassandra","Seguela","Sinfra","Soubre","Tabou","Tanda","Tiassale","Tiebissou","Tingrela","Touba","Toulepleu","Toumodi","Vavoua","Yamoussoukro","Zuenoula"];
        city_arr[55]=["Bjelovarsko-Bilogorska Zupanija","Brodsko-Posavska Zupanija","Dubrovacko-Neretvanska Zupanija","Istarska Zupanija","Karlovacka Zupanija","Koprivnicko-Krizevacka Zupanija","Krapinsko-Zagorska Zupanija","Licko-Senjska Zupanija","Medimurska Zupanija","Osjecko-Baranjska Zupanija","Pozesko-Slavonska Zupanija","Primorsko-Goranska Zupanija","Sibensko-Kninska Zupanija","Sisacko-Moslavacka Zupanija","Splitsko-Dalmatinska Zupanija","Varazdinska Zupanija","Viroviticko-Podravska Zupanija","Vukovarsko-Srijemska Zupanija","Zadarska Zupanija","Zagreb","Zagrebacka Zupanija"];
        city_arr[56]=["Camaguey","Ciego de Avila","Cienfuegos","Ciudad de La Habana","Granma","Guantanamo","Holguin","Isla de la Juventud","La Habana","Las Tunas","Matanzas","Pinar del Rio","Sancti Spiritus","Santiago de Cuba","Villa Clara"];
        city_arr[57]=["Famagusta","Kyrenia","Larnaca","Limassol","Nicosia","Paphos"];
        city_arr[58]=["Brnensky","Budejovicky","Jihlavsky","Karlovarsky","Kralovehradecky","Liberecky","Olomoucky","Ostravsky","Pardubicky","Plzensky","Praha","Stredocesky","Ustecky","Zlinsky"];
        city_arr[59]=["Arhus","Bornholm","Fredericksberg","Frederiksborg","Fyn","Kobenhavn","Kobenhavns","Nordjylland","Ribe","Ringkobing","Roskilde","Sonderjylland","Storstrom","Vejle","Vestsjalland","Viborg"];
        city_arr[60]=["'Ali Sabih","Dikhil","Djibouti","Obock","Tadjoura"];
        city_arr[61]=["Saint Andrew","Saint David","Saint George","Saint John","Saint Joseph","Saint Luke","Saint Mark","Saint Patrick","Saint Paul","Saint Peter"];
        city_arr[62]=["Azua","Baoruco","Barahona","Dajabon","Distrito Nacional","Duarte","El Seibo","Elias Pina","Espaillat","Hato Mayor","Independencia","La Altagracia","La Romana","La Vega","Maria Trinidad Sanchez","Monsenor Nouel","Monte Cristi","Monte Plata","Pedernales","Peravia","Puerto Plata","Salcedo","Samana","San Cristobal","San Juan","San Pedro de Macoris","Sanchez Ramirez","Santiago","Santiago Rodriguez","Valverde"];
        // <!-- -->
        city_arr[63]=["Azuay","Bolivar","Canar","Carchi","Chimborazo","Cotopaxi","El Oro","Esmeraldas","Galapagos","Guayas","Imbabura","Loja","Los Rios","Manabi","Morona-Santiago","Napo","Orellana","Pastaza","Pichincha","Sucumbios","Tungurahua","Zamora-Chinchipe"];
        city_arr[64]=["Ad Daqahliyah","Al Bahr al Ahmar","Al Buhayrah","Al Fayyum","Al Gharbiyah","Al Iskandariyah","Al Isma'iliyah","Al Jizah","Al Minufiyah","Al Minya","Al Qahirah","Al Qalyubiyah","Al Wadi al Jadid","As Suways","Ash Sharqiyah","Aswan","Asyut","Bani Suwayf","Bur Sa'id","Dumyat","Janub Sina'","Kafr ash Shaykh","Matruh","Qina","Shamal Sina'","Suhaj"];
        city_arr[65]=["Ahuachapan","Cabanas","Chalatenango","Cuscatlan","La Libertad","La Paz","La Union","Morazan","San Miguel","San Salvador","San Vicente","Santa Ana","Sonsonate","Usulutan"];
        city_arr[66]=["Annobon","Bioko Norte","Bioko Sur","Centro Sur","Kie-Ntem","Litoral","Wele-Nzas"];
        city_arr[67]=["Akale Guzay","Barka","Denkel","Hamasen","Sahil","Semhar","Senhit","Seraye"];
        city_arr[68]=["Harjumaa (Tallinn)","Hiiumaa (Kardla)","Ida-Virumaa (Johvi)","Jarvamaa (Paide)","Jogevamaa (Jogeva)","Laane-Virumaa (Rakvere)","Laanemaa (Haapsalu)","Parnumaa (Parnu)","Polvamaa (Polva)","Raplamaa (Rapla)","Saaremaa (Kuessaare)","Tartumaa (Tartu)","Valgamaa (Valga)","Viljandimaa (Viljandi)","Vorumaa (Voru)"];
        city_arr[69]=["Adis Abeba (Addis Ababa)","Afar","Amara","Dire Dawa","Gambela Hizboch","Hareri Hizb","Oromiya","Sumale","Tigray","YeDebub Biheroch Bihereseboch na Hizboch"];
        city_arr[70]=["Europa Island"];
        city_arr[71]=["Falkland Islands (Islas Malvinas)"];
        city_arr[72]=["Bordoy","Eysturoy","Mykines","Sandoy","Skuvoy","Streymoy","Suduroy","Tvoroyri","Vagar"];
        city_arr[73]=["Central","Eastern","Northern","Rotuma","Western"];
        city_arr[74]=["Aland","Etela-Suomen Laani","Ita-Suomen Laani","Lansi-Suomen Laani","Lappi","Oulun Laani"];
        city_arr[75]=["Alsace","Aquitaine","Auvergne","Basse-Normandie","Bourgogne","Bretagne","Centre","Champagne-Ardenne","Corse","Franche-Comte","Haute-Normandie","Ile-de-France","Languedoc-Roussillon","Limousin","Lorraine","Midi-Pyrenees","Nord-Pas-de-Calais","Pays de la Loire","Picardie","Poitou-Charentes","Provence-Alpes-Cote d'Azur","Rhone-Alpes"];
        city_arr[76]=["French Guiana"];
        city_arr[77]=["Archipel des Marquises","Archipel des Tuamotu","Archipel des Tubuai","Iles du Vent","Iles Sous-le-Vent"];
        city_arr[78]=["Adelie Land","Ile Crozet","Iles Kerguelen","Iles Saint-Paul et Amsterdam"];
        city_arr[79]=["Estuaire","Haut-Ogooue","Moyen-Ogooue","Ngounie","Nyanga","Ogooue-Ivindo","Ogooue-Lolo","Ogooue-Maritime","Woleu-Ntem"];
        city_arr[80]=["Banjul","Central River","Lower River","North Bank","Upper River","Western"];
        city_arr[81]=["Gaza Strip"];
        city_arr[82]=["Abashis","Abkhazia or Ap'khazet'is Avtonomiuri Respublika (Sokhumi)","Adigenis","Ajaria or Acharis Avtonomiuri Respublika (Bat'umi)","Akhalgoris","Akhalk'alak'is","Akhalts'ikhis","Akhmetis","Ambrolauris","Aspindzis","Baghdat'is","Bolnisis","Borjomis","Ch'khorotsqus","Ch'okhatauris","Chiat'ura","Dedop'listsqaros","Dmanisis","Dushet'is","Gardabanis","Gori","Goris","Gurjaanis","Javis","K'arelis","K'ut'aisi","Kaspis","Kharagaulis","Khashuris","Khobis","Khonis","Lagodekhis","Lanch'khut'is","Lentekhis","Marneulis","Martvilis","Mestiis","Mts'khet'is","Ninotsmindis","Onis","Ozurget'is","P'ot'i","Qazbegis","Qvarlis","Rust'avi","Sach'kheris","Sagarejos","Samtrediis","Senakis","Sighnaghis","T'bilisi","T'elavis","T'erjolis","T'et'ritsqaros","T'ianet'is","Tqibuli","Ts'ageris","Tsalenjikhis","Tsalkis","Tsqaltubo","Vanis","Zestap'onis","Zugdidi","Zugdidis"];
        city_arr[83]=["Baden-Wuerttemberg","Bayern","Berlin","Brandenburg","Bremen","Hamburg","Hessen","Mecklenburg-Vorpommern","Niedersachsen","Nordrhein-Westfalen","Rheinland-Pfalz","Saarland","Sachsen","Sachsen-Anhalt","Schleswig-Holstein","Thueringen"];
        city_arr[84]=["Ashanti","Brong-Ahafo","Central","Eastern","Greater Accra","Northern","Upper East","Upper West","Volta","Western"];
        city_arr[85]=["Gibraltar"];
        city_arr[86]=["Ile du Lys","Ile Glorieuse"];
        city_arr[87]=["Aitolia kai Akarnania","Akhaia","Argolis","Arkadhia","Arta","Attiki","Ayion Oros (Mt. Athos)","Dhodhekanisos","Drama","Evritania","Evros","Evvoia","Florina","Fokis","Fthiotis","Grevena","Ilia","Imathia","Ioannina","Irakleion","Kardhitsa","Kastoria","Kavala","Kefallinia","Kerkyra","Khalkidhiki","Khania","Khios","Kikladhes","Kilkis","Korinthia","Kozani","Lakonia","Larisa","Lasithi","Lesvos","Levkas","Magnisia","Messinia","Pella","Pieria","Preveza","Rethimni","Rodhopi","Samos","Serrai","Thesprotia","Thessaloniki","Trikala","Voiotia","Xanthi","Zakinthos"];
        city_arr[88]=["Avannaa (Nordgronland)","Kitaa (Vestgronland)","Tunu (Ostgronland)"];
        city_arr[89]=["Carriacou and Petit Martinique","Saint Andrew","Saint David","Saint George","Saint John","Saint Mark","Saint Patrick"];
        city_arr[90]=["Basse-Terre","Grande-Terre","Iles de la Petite Terre","Iles des Saintes","Marie-Galante"];
        city_arr[91]=["Guam"];
        city_arr[92]=["Alta Verapaz","Baja Verapaz","Chimaltenango","Chiquimula","El Progreso","Escuintla","Guatemala","Huehuetenango","Izabal","Jalapa","Jutiapa","Peten","Quetzaltenango","Quiche","Retalhuleu","Sacatepequez","San Marcos","Santa Rosa","Solola","Suchitepequez","Totonicapan","Zacapa"];
        city_arr[93]=["Castel","Forest","St. Andrew","St. Martin","St. Peter Port","St. Pierre du Bois","St. Sampson","St. Saviour","Torteval","Vale"];
        city_arr[94]=["Beyla","Boffa","Boke","Conakry","Coyah","Dabola","Dalaba","Dinguiraye","Dubreka","Faranah","Forecariah","Fria","Gaoual","Gueckedou","Kankan","Kerouane","Kindia","Kissidougou","Koubia","Koundara","Kouroussa","Labe","Lelouma","Lola","Macenta","Mali","Mamou","Mandiana","Nzerekore","Pita","Siguiri","Telimele","Tougue","Yomou"];
        city_arr[95]=["Bafata","Biombo","Bissau","Bolama-Bijagos","Cacheu","Gabu","Oio","Quinara","Tombali"];
        city_arr[96]=["Barima-Waini","Cuyuni-Mazaruni","Demerara-Mahaica","East Berbice-Corentyne","Essequibo Islands-West Demerara","Mahaica-Berbice","Pomeroon-Supenaam","Potaro-Siparuni","Upper Demerara-Berbice","Upper Takutu-Upper Essequibo"];
        city_arr[97]=["Artibonite","Centre","Grand'Anse","Nord","Nord-Est","Nord-Ouest","Ouest","Sud","Sud-Est"];
        city_arr[98]=["Heard Island and McDonald Islands"];
        city_arr[99]=["Holy See (Vatican City)"];
        city_arr[100]=["Atlantida","Choluteca","Colon","Comayagua","Copan","Cortes","El Paraiso","Francisco Morazan","Gracias a Dios","Intibuca","Islas de la Bahia","La Paz","Lempira","Ocotepeque","Olancho","Santa Barbara","Valle","Yoro"];
        city_arr[101]=["Hong Kong"];
        city_arr[102]=["Howland Island"];
        city_arr[103]=["Bacs-Kiskun","Baranya","Bekes","Bekescsaba","Borsod-Abauj-Zemplen","Budapest","Csongrad","Debrecen","Dunaujvaros","Eger","Fejer","Gyor","Gyor-Moson-Sopron","Hajdu-Bihar","Heves","Hodmezovasarhely","Jasz-Nagykun-Szolnok","Kaposvar","Kecskemet","Komarom-Esztergom","Miskolc","Nagykanizsa","Nograd","Nyiregyhaza","Pecs","Pest","Somogy","Sopron","Szabolcs-Szatmar-Bereg","Szeged","Szekesfehervar","Szolnok","Szombathely","Tatabanya","Tolna","Vas","Veszprem","Veszprem","Zala","Zalaegerszeg"];
        city_arr[104]=["Akranes","Akureyri","Arnessysla","Austur-Bardhastrandarsysla","Austur-Hunavatnssysla","Austur-Skaftafellssysla","Borgarfjardharsysla","Dalasysla","Eyjafjardharsysla","Gullbringusysla","Hafnarfjordhur","Husavik","Isafjordhur","Keflavik","Kjosarsysla","Kopavogur","Myrasysla","Neskaupstadhur","Nordhur-Isafjardharsysla","Nordhur-Mulasys-la","Nordhur-Thingeyjarsysla","Olafsfjordhur","Rangarvallasysla","Reykjavik","Saudharkrokur","Seydhisfjordhur","Siglufjordhur","Skagafjardharsysla","Snaefellsnes-og Hnappadalssysla","Strandasysla","Sudhur-Mulasysla","Sudhur-Thingeyjarsysla","Vesttmannaeyjar","Vestur-Bardhastrandarsysla","Vestur-Hunavatnssysla","Vestur-Isafjardharsysla","Vestur-Skaftafellssysla"];
        city_arr[105]=["Andaman and Nicobar Islands","Andhra Pradesh","Arunachal Pradesh","Assam","Bihar","Chandigarh","Chhattisgarh","Dadra and Nagar Haveli","Daman and Diu","Delhi","Goa","Gujarat","Haryana","Himachal Pradesh","Jammu and Kashmir","Jharkhand","Karnataka","Kerala","Lakshadweep","Madhya Pradesh","Maharashtra","Manipur","Meghalaya","Mizoram","Nagaland","Orissa","Pondicherry","Punjab","Rajasthan","Sikkim","Tamil Nadu","Tripura","Uttar Pradesh","Uttaranchal","West Bengal"];
        city_arr[106]=["Aceh","Bali","Banten","Bengkulu","East Timor","Gorontalo","Irian Jaya","Jakarta Raya","Jambi","Jawa Barat","Jawa Tengah","Jawa Timur","Kalimantan Barat","Kalimantan Selatan","Kalimantan Tengah","Kalimantan Timur","Kepulauan Bangka Belitung","Lampung","Maluku","Maluku Utara","Nusa Tenggara Barat","Nusa Tenggara Timur","Riau","Sulawesi Selatan","Sulawesi Tengah","Sulawesi Tenggara","Sulawesi Utara","Sumatera Barat","Sumatera Selatan","Sumatera Utara","Yogyakarta"];
        city_arr[107]=["Ardabil","Azarbayjan-e Gharbi","Azarbayjan-e Sharqi","Bushehr","Chahar Mahall va Bakhtiari","Esfahan","Fars","Gilan","Golestan","Hamadan","Hormozgan","Ilam","Kerman","Kermanshah","Khorasan","Khuzestan","Kohgiluyeh va Buyer Ahmad","Kordestan","Lorestan","Markazi","Mazandaran","Qazvin","Qom","Semnan","Sistan va Baluchestan","Tehran","Yazd","Zanjan"];
        city_arr[108]=["Al Anbar","Al Basrah","Al Muthanna","Al Qadisiyah","An Najaf","Arbil","As Sulaymaniyah","At Ta'mim","Babil","Baghdad","Dahuk","Dhi Qar","Diyala","Karbala'","Maysan","Ninawa","Salah ad Din","Wasit"];
        city_arr[109]=["Carlow","Cavan","Clare","Cork","Donegal","Dublin","Galway","Kerry","Kildare","Kilkenny","Laois","Leitrim","Limerick","Longford","Louth","Mayo","Meath","Monaghan","Offaly","Roscommon","Sligo","Tipperary","Waterford","Westmeath","Wexford","Wicklow"];
        city_arr[110]=["Antrim","Ards","Armagh","Ballymena","Ballymoney","Banbridge","Belfast","Carrickfergus","Castlereagh","Coleraine","Cookstown","Craigavon","Derry","Down","Dungannon","Fermanagh","Larne","Limavady","Lisburn","Magherafelt","Moyle","Newry and Mourne","Newtownabbey","North Down","Omagh","Strabane"];
        city_arr[111]=["Central","Haifa","Jerusalem","Northern","Southern","Tel Aviv"];
        city_arr[112]=["Abruzzi","Basilicata","Calabria","Campania","Emilia-Romagna","Friuli-Venezia Giulia","Lazio","Liguria","Lombardia","Marche","Molise","Piemonte","Puglia","Sardegna","Sicilia","Toscana","Trentino-Alto Adige","Umbria","Valle d'Aosta","Veneto"];
        city_arr[113]=["Clarendon","Hanover","Kingston","Manchester","Portland","Saint Andrew","Saint Ann","Saint Catherine","Saint Elizabeth","Saint James","Saint Mary","Saint Thomas","Trelawny","Westmoreland"];
        city_arr[114]=["Jan Mayen"];
        city_arr[115]=["Aichi","Akita","Aomori","Chiba","Ehime","Fukui","Fukuoka","Fukushima","Gifu","Gumma","Hiroshima","Hokkaido","Hyogo","Ibaraki","Ishikawa","Iwate","Kagawa","Kagoshima","Kanagawa","Kochi","Kumamoto","Kyoto","Mie","Miyagi","Miyazaki","Nagano","Nagasaki","Nara","Niigata","Oita","Okayama","Okinawa","Osaka","Saga","Saitama","Shiga","Shimane","Shizuoka","Tochigi","Tokushima","Tokyo","Tottori","Toyama","Wakayama","Yamagata","Yamaguchi","Yamanashi"];
        city_arr[116]=["Jarvis Island"];
        city_arr[117]=["Jersey"];
        city_arr[118]=["Johnston Atoll"];
        city_arr[119]=["'Amman","Ajlun","Al 'Aqabah","Al Balqa'","Al Karak","Al Mafraq","At Tafilah","Az Zarqa'","Irbid","Jarash","Ma'an","Madaba"];
        city_arr[120]=["Juan de Nova Island"];
        city_arr[121]=["Almaty","Aqmola","Aqtobe","Astana","Atyrau","Batys Qazaqstan","Bayqongyr","Mangghystau","Ongtustik Qazaqstan","Pavlodar","Qaraghandy","Qostanay","Qyzylorda","Shyghys Qazaqstan","Soltustik Qazaqstan","Zhambyl"];
        city_arr[122]=["Central","Coast","Eastern","Nairobi Area","North Eastern","Nyanza","Rift Valley","Western"];
        city_arr[123]=["Abaiang","Abemama","Aranuka","Arorae","Banaba","Banaba","Beru","Butaritari","Central Gilberts","Gilbert Islands","Kanton","Kiritimati","Kuria","Line Islands","Line Islands","Maiana","Makin","Marakei","Nikunau","Nonouti","Northern Gilberts","Onotoa","Phoenix Islands","Southern Gilberts","Tabiteuea","Tabuaeran","Tamana","Tarawa","Tarawa","Teraina"];
        city_arr[124]=["Chagang-do (Chagang Province)","Hamgyong-bukto (North Hamgyong Province)","Hamgyong-namdo (South Hamgyong Province)","Hwanghae-bukto (North Hwanghae Province)","Hwanghae-namdo (South Hwanghae Province)","Kaesong-si (Kaesong City)","Kangwon-do (Kangwon Province)","Namp'o-si (Namp'o City)","P'yongan-bukto (North P'yongan Province)","P'yongan-namdo (South P'yongan Province)","P'yongyang-si (P'yongyang City)","Yanggang-do (Yanggang Province)"];
        city_arr[125]=["Ch'ungch'ong-bukto","Ch'ungch'ong-namdo","Cheju-do","Cholla-bukto","Cholla-namdo","Inch'on-gwangyoksi","Kangwon-do","Kwangju-gwangyoksi","Kyonggi-do","Kyongsang-bukto","Kyongsang-namdo","Pusan-gwangyoksi","Soul-t'ukpyolsi","Taegu-gwangyoksi","Taejon-gwangyoksi","Ulsan-gwangyoksi"];
        city_arr[126]=["Al 'Asimah","Al Ahmadi","Al Farwaniyah","Al Jahra'","Hawalli"];
        city_arr[127]=["Batken Oblasty","Bishkek Shaary","Chuy Oblasty (Bishkek)","Jalal-Abad Oblasty","Naryn Oblasty","Osh Oblasty","Talas Oblasty","Ysyk-Kol Oblasty (Karakol)"];
        city_arr[128]=["Attapu","Bokeo","Bolikhamxai","Champasak","Houaphan","Khammouan","Louangnamtha","Louangphabang","Oudomxai","Phongsali","Salavan","Savannakhet","Viangchan","Viangchan","Xaignabouli","Xaisomboun","Xekong","Xiangkhoang"];
        city_arr[129]=["Aizkraukles Rajons","Aluksnes Rajons","Balvu Rajons","Bauskas Rajons","Cesu Rajons","Daugavpils","Daugavpils Rajons","Dobeles Rajons","Gulbenes Rajons","Jekabpils Rajons","Jelgava","Jelgavas Rajons","Jurmala","Kraslavas Rajons","Kuldigas Rajons","Leipaja","Liepajas Rajons","Limbazu Rajons","Ludzas Rajons","Madonas Rajons","Ogres Rajons","Preilu Rajons","Rezekne","Rezeknes Rajons","Riga","Rigas Rajons","Saldus Rajons","Talsu Rajons","Tukuma Rajons","Valkas Rajons","Valmieras Rajons","Ventspils","Ventspils Rajons"];
        city_arr[130]=["Beyrouth","Ech Chimal","Ej Jnoub","El Bekaa","Jabal Loubnane"];
        city_arr[131]=["Berea","Butha-Buthe","Leribe","Mafeteng","Maseru","Mohales Hoek","Mokhotlong","Qacha's Nek","Quthing","Thaba-Tseka"];
        city_arr[132]=["Bomi","Bong","Grand Bassa","Grand Cape Mount","Grand Gedeh","Grand Kru","Lofa","Margibi","Maryland","Montserrado","Nimba","River Cess","Sinoe"];
        city_arr[133]=["Ajdabiya","Al 'Aziziyah","Al Fatih","Al Jabal al Akhdar","Al Jufrah","Al Khums","Al Kufrah","An Nuqat al Khams","Ash Shati'","Awbari","Az Zawiyah","Banghazi","Darnah","Ghadamis","Gharyan","Misratah","Murzuq","Sabha","Sawfajjin","Surt","Tarabulus","Tarhunah","Tubruq","Yafran","Zlitan"];
        city_arr[134]=["Balzers","Eschen","Gamprin","Mauren","Planken","Ruggell","Schaan","Schellenberg","Triesen","Triesenberg","Vaduz"];
        city_arr[135]=["Akmenes Rajonas","Alytaus Rajonas","Alytus","Anyksciu Rajonas","Birstonas","Birzu Rajonas","Druskininkai","Ignalinos Rajonas","Jonavos Rajonas","Joniskio Rajonas","Jurbarko Rajonas","Kaisiadoriu Rajonas","Kaunas","Kauno Rajonas","Kedainiu Rajonas","Kelmes Rajonas","Klaipeda","Klaipedos Rajonas","Kretingos Rajonas","Kupiskio Rajonas","Lazdiju Rajonas","Marijampole","Marijampoles Rajonas","Mazeikiu Rajonas","Moletu Rajonas","Neringa Pakruojo Rajonas","Palanga","Panevezio Rajonas","Panevezys","Pasvalio Rajonas","Plunges Rajonas","Prienu Rajonas","Radviliskio Rajonas","Raseiniu Rajonas","Rokiskio Rajonas","Sakiu Rajonas","Salcininku Rajonas","Siauliai","Siauliu Rajonas","Silales Rajonas","Silutes Rajonas","Sirvintu Rajonas","Skuodo Rajonas","Svencioniu Rajonas","Taurages Rajonas","Telsiu Rajonas","Traku Rajonas","Ukmerges Rajonas","Utenos Rajonas","Varenos Rajonas","Vilkaviskio Rajonas","Vilniaus Rajonas","Vilnius","Zarasu Rajonas"];
        city_arr[136]=["Diekirch","Grevenmacher","Luxembourg"];
        city_arr[137]=["Macau"];
        city_arr[138]=["Aracinovo","Bac","Belcista","Berovo","Bistrica","Bitola","Blatec","Bogdanci","Bogomila","Bogovinje","Bosilovo","Brvenica","Cair (Skopje)","Capari","Caska","Cegrane","Centar (Skopje)","Centar Zupa","Cesinovo","Cucer-Sandevo","Debar","Delcevo","Delogozdi","Demir Hisar","Demir Kapija","Dobrusevo","Dolna Banjica","Dolneni","Dorce Petrov (Skopje)","Drugovo","Dzepciste","Gazi Baba (Skopje)","Gevgelija","Gostivar","Gradsko","Ilinden","Izvor","Jegunovce","Kamenjane","Karbinci","Karpos (Skopje)","Kavadarci","Kicevo","Kisela Voda (Skopje)","Klecevce","Kocani","Konce","Kondovo","Konopiste","Kosel","Kratovo","Kriva Palanka","Krivogastani","Krusevo","Kuklis","Kukurecani","Kumanovo","Labunista","Lipkovo","Lozovo","Lukovo","Makedonska Kamenica","Makedonski Brod","Mavrovi Anovi","Meseista","Miravci","Mogila","Murtino","Negotino","Negotino-Poloska","Novaci","Novo Selo","Oblesevo","Ohrid","Orasac","Orizari","Oslomej","Pehcevo","Petrovec","Plasnia","Podares","Prilep","Probistip","Radovis","Rankovce","Resen","Rosoman","Rostusa","Samokov","Saraj","Sipkovica","Sopiste","Sopotnika","Srbinovo","Star Dojran","Staravina","Staro Nagoricane","Stip","Struga","Strumica","Studenicani","Suto Orizari (Skopje)","Sveti Nikole","Tearce","Tetovo","Topolcani","Valandovo","Vasilevo","Veles","Velesta","Vevcani","Vinica","Vitoliste","Vranestica","Vrapciste","Vratnica","Vrutok","Zajas","Zelenikovo","Zileno","Zitose","Zletovo","Zrnovci"];
        city_arr[139]=["Antananarivo","Antsiranana","Fianarantsoa","Mahajanga","Toamasina","Toliara"];
        city_arr[140]=["Balaka","Blantyre","Chikwawa","Chiradzulu","Chitipa","Dedza","Dowa","Karonga","Kasungu","Likoma","Lilongwe","Machinga (Kasupe)","Mangochi","Mchinji","Mulanje","Mwanza","Mzimba","Nkhata Bay","Nkhotakota","Nsanje","Ntcheu","Ntchisi","Phalombe","Rumphi","Salima","Thyolo","Zomba"];
        city_arr[141]=["Johor","Kedah","Kelantan","Labuan","Melaka","Negeri Sembilan","Pahang","Perak","Perlis","Pulau Pinang","Sabah","Sarawak","Selangor","Terengganu","Wilayah Persekutuan"];
        city_arr[142]=["Alifu","Baa","Dhaalu","Faafu","Gaafu Alifu","Gaafu Dhaalu","Gnaviyani","Haa Alifu","Haa Dhaalu","Kaafu","Laamu","Lhaviyani","Maale","Meemu","Noonu","Raa","Seenu","Shaviyani","Thaa","Vaavu"];
        city_arr[143]=["Gao","Kayes","Kidal","Koulikoro","Mopti","Segou","Sikasso","Tombouctou"];
        city_arr[144]=["Valletta"];
        city_arr[145]=["Man, Isle of"];
        city_arr[146]=["Ailinginae","Ailinglaplap","Ailuk","Arno","Aur","Bikar","Bikini","Bokak","Ebon","Enewetak","Erikub","Jabat","Jaluit","Jemo","Kili","Kwajalein","Lae","Lib","Likiep","Majuro","Maloelap","Mejit","Mili","Namorik","Namu","Rongelap","Rongrik","Toke","Ujae","Ujelang","Utirik","Wotho","Wotje"];
        city_arr[147]=["Martinique"];
        city_arr[148]=["Adrar","Assaba","Brakna","Dakhlet Nouadhibou","Gorgol","Guidimaka","Hodh Ech Chargui","Hodh El Gharbi","Inchiri","Nouakchott","Tagant","Tiris Zemmour","Trarza"];
        city_arr[149]=["Agalega Islands","Black River","Cargados Carajos Shoals","Flacq","Grand Port","Moka","Pamplemousses","Plaines Wilhems","Port Louis","Riviere du Rempart","Rodrigues","Savanne"];
        city_arr[150]=["Mayotte"];
        city_arr[151]=["Aguascalientes","Baja California","Baja California Sur","Campeche","Chiapas","Chihuahua","Coahuila de Zaragoza","Colima","Distrito Federal","Durango","Guanajuato","Guerrero","Hidalgo","Jalisco","Mexico","Michoacan de Ocampo","Morelos","Nayarit","Nuevo Leon","Oaxaca","Puebla","Queretaro de Arteaga","Quintana Roo","San Luis Potosi","Sinaloa","Sonora","Tabasco","Tamaulipas","Tlaxcala","Veracruz-Llave","Yucatan","Zacatecas"];
        city_arr[152]=["Chuuk (Truk)","Kosrae","Pohnpei","Yap"];
        city_arr[153]=["Midway Islands"];
        city_arr[154]=["Balti","Cahul","Chisinau","Chisinau","Dubasari","Edinet","Gagauzia","Lapusna","Orhei","Soroca","Tighina","Ungheni"];
        city_arr[155]=["Fontvieille","La Condamine","Monaco-Ville","Monte-Carlo"];
        city_arr[156]=["Arhangay","Bayan-Olgiy","Bayanhongor","Bulgan","Darhan","Dornod","Dornogovi","Dundgovi","Dzavhan","Erdenet","Govi-Altay","Hentiy","Hovd","Hovsgol","Omnogovi","Ovorhangay","Selenge","Suhbaatar","Tov","Ulaanbaatar","Uvs"];
        city_arr[157]=["Saint Anthony","Saint Georges","Saint Peter's"];
        city_arr[158]=["Agadir","Al Hoceima","Azilal","Ben Slimane","Beni Mellal","Boulemane","Casablanca","Chaouen","El Jadida","El Kelaa des Srarhna","Er Rachidia","Essaouira","Fes","Figuig","Guelmim","Ifrane","Kenitra","Khemisset","Khenifra","Khouribga","Laayoune","Larache","Marrakech","Meknes","Nador","Ouarzazate","Oujda","Rabat-Sale","Safi","Settat","Sidi Kacem","Tan-Tan","Tanger","Taounate","Taroudannt","Tata","Taza","Tetouan","Tiznit"];
        city_arr[159]=["Cabo Delgado","Gaza","Inhambane","Manica","Maputo","Nampula","Niassa","Sofala","Tete","Zambezia"];
        city_arr[160]=["Caprivi","Erongo","Hardap","Karas","Khomas","Kunene","Ohangwena","Okavango","Omaheke","Omusati","Oshana","Oshikoto","Otjozondjupa"];
        city_arr[161]=["Aiwo","Anabar","Anetan","Anibare","Baiti","Boe","Buada","Denigomodu","Ewa","Ijuw","Meneng","Nibok","Uaboe","Yaren"];
        city_arr[162]=["Bagmati","Bheri","Dhawalagiri","Gandaki","Janakpur","Karnali","Kosi","Lumbini","Mahakali","Mechi","Narayani","Rapti","Sagarmatha","Seti"];
        city_arr[163]=["Drenthe","Flevoland","Friesland","Gelderland","Groningen","Limburg","Noord-Brabant","Noord-Holland","Overijssel","Utrecht","Zeeland","Zuid-Holland"];
        city_arr[164]=["Netherlands Antilles"];
        city_arr[165]=["Iles Loyaute","Nord","Sud"];
        city_arr[166]=["Akaroa","Amuri","Ashburton","Bay of Islands","Bruce","Buller","Chatham Islands","Cheviot","Clifton","Clutha","Cook","Dannevirke","Egmont","Eketahuna","Ellesmere","Eltham","Eyre","Featherston","Franklin","Golden Bay","Great Barrier Island","Grey","Hauraki Plains","Hawera","Hawke's Bay","Heathcote","Hikurangi","Hobson","Hokianga","Horowhenua","Hurunui","Hutt","Inangahua","Inglewood","Kaikoura","Kairanga","Kiwitea","Lake","Mackenzie","Malvern","Manaia","Manawatu","Mangonui","Maniototo","Marlborough","Masterton","Matamata","Mount Herbert","Ohinemuri","Opotiki","Oroua","Otamatea","Otorohanga","Oxford","Pahiatua","Paparua","Patea","Piako","Pohangina","Raglan","Rangiora","Rangitikei","Rodney","Rotorua","Runanga","Saint Kilda","Silverpeaks","Southland","Stewart Island","Stratford","Strathallan","Taranaki","Taumarunui","Taupo","Tauranga","Thames-Coromandel","Tuapeka","Vincent","Waiapu","Waiheke","Waihemo","Waikato","Waikohu","Waimairi","Waimarino","Waimate","Waimate West","Waimea","Waipa","Waipawa","Waipukurau","Wairarapa South","Wairewa","Wairoa","Waitaki","Waitomo","Waitotara","Wallace","Wanganui","Waverley","Westland","Whakatane","Whangarei","Whangaroa","Woodville"];
        city_arr[167]=["Atlantico Norte","Atlantico Sur","Boaco","Carazo","Chinandega","Chontales","Esteli","Granada","Jinotega","Leon","Madriz","Managua","Masaya","Matagalpa","Nueva Segovia","Rio San Juan","Rivas"];
        city_arr[168]=["Agadez","Diffa","Dosso","Maradi","Niamey","Tahoua","Tillaberi","Zinder"];
        city_arr[169]=["Abia","Abuja Federal Capital Territory","Adamawa","Akwa Ibom","Anambra","Bauchi","Bayelsa","Benue","Borno","Cross River","Delta","Ebonyi","Edo","Ekiti","Enugu","Gombe","Imo","Jigawa","Kaduna","Kano","Katsina","Kebbi","Kogi","Kwara","Lagos","Nassarawa","Niger","Ogun","Ondo","Osun","Oyo","Plateau","Rivers","Sokoto","Taraba","Yobe","Zamfara"];
        city_arr[170]=["Niue"];
        city_arr[171]=["Norfolk Island"];
        city_arr[172]=["Northern Islands","Rota","Saipan","Tinian"];
        city_arr[173]=["Akershus","Aust-Agder","Buskerud","Finnmark","Hedmark","Hordaland","More og Romsdal","Nord-Trondelag","Nordland","Oppland","Oslo","Ostfold","Rogaland","Sogn og Fjordane","Sor-Trondelag","Telemark","Troms","Vest-Agder","Vestfold"];
        city_arr[174]=["Ad Dakhiliyah","Al Batinah","Al Wusta","Ash Sharqiyah","Az Zahirah","Masqat","Musandam","Zufar"];
        city_arr[175]=["Balochistan","Federally Administered Tribal Areas","Islamabad Capital Territory","North-West Frontier Province","Punjab","Sindh"];
        city_arr[176]=["Aimeliik","Airai","Angaur","Hatobohei","Kayangel","Koror","Melekeok","Ngaraard","Ngarchelong","Ngardmau","Ngatpang","Ngchesar","Ngeremlengui","Ngiwal","Palau Island","Peleliu","Sonsoral","Tobi"];
        city_arr[177]=["Bocas del Toro","Chiriqui","Cocle","Colon","Darien","Herrera","Los Santos","Panama","San Blas","Veraguas"];
        city_arr[178]=["Bougainville","Central","Chimbu","East New Britain","East Sepik","Eastern Highlands","Enga","Gulf","Madang","Manus","Milne Bay","Morobe","National Capital","New Ireland","Northern","Sandaun","Southern Highlands","West New Britain","Western","Western Highlands"];
        city_arr[179]=["Alto Paraguay","Alto Parana","Amambay","Asuncion (city)","Boqueron","Caaguazu","Caazapa","Canindeyu","Central","Concepcion","Cordillera","Guaira","Itapua","Misiones","Neembucu","Paraguari","Presidente Hayes","San Pedro"];
        city_arr[180]=["Amazonas","Ancash","Apurimac","Arequipa","Ayacucho","Cajamarca","Callao","Cusco","Huancavelica","Huanuco","Ica","Junin","La Libertad","Lambayeque","Lima","Loreto","Madre de Dios","Moquegua","Pasco","Piura","Puno","San Martin","Tacna","Tumbes","Ucayali"];
        city_arr[181]=["Abra","Agusan del Norte","Agusan del Sur","Aklan","Albay","Angeles","Antique","Aurora","Bacolod","Bago","Baguio","Bais","Basilan","Basilan City","Bataan","Batanes","Batangas","Batangas City","Benguet","Bohol","Bukidnon","Bulacan","Butuan","Cabanatuan","Cadiz","Cagayan","Cagayan de Oro","Calbayog","Caloocan","Camarines Norte","Camarines Sur","Camiguin","Canlaon","Capiz","Catanduanes","Cavite","Cavite City","Cebu","Cebu City","Cotabato","Dagupan","Danao","Dapitan","Davao City Davao","Davao del Sur","Davao Oriental","Dipolog","Dumaguete","Eastern Samar","General Santos","Gingoog","Ifugao","Iligan","Ilocos Norte","Ilocos Sur","Iloilo","Iloilo City","Iriga","Isabela","Kalinga-Apayao","La Carlota","La Union","Laguna","Lanao del Norte","Lanao del Sur","Laoag","Lapu-Lapu","Legaspi","Leyte","Lipa","Lucena","Maguindanao","Makati City","Mandaluyong City","Mandaue","Manila","Marawi","Marikina City","Marinduque","Masbate","Mindoro Occidental","Mindoro Oriental","Misamis Occidental","Misamis Oriental","Mountain Province","Muntinlupa","Naga","Negros Occidental","Negros Oriental","North Cotabato","Northern Samar","Nueva Ecija","Nueva Vizcaya","Olongapo","Ormoc","Oroquieta","Ozamis","Pagadian","Palawan","Palayan","Pampanga","Pangasinan","Paranaque","Pasay","Pasig City","Puerto Princesa","Quezon","Quezon City","Quirino","Rizal","Romblon","Roxas","Samar","San Carlos (in Negros Occidental)","San Carlos (in Pangasinan)","San Jose","San Pablo","Silay","Siquijor","Sorsogon","South Cotabato","Southern Leyte","Sultan Kudarat","Sulu","Surigao","Surigao del Norte","Surigao del Sur","Tacloban","Tagaytay","Tagbilaran","Tangub","Tarlac","Tawitawi","Toledo","Trece Martires","Zambales","Zamboanga","Zamboanga del Norte","Zamboanga del Sur"];
        city_arr[182]=["Pitcaim Islands"];
        city_arr[183]=["Dolnoslaskie","Kujawsko-Pomorskie","Lodzkie","Lubelskie","Lubuskie","Malopolskie","Mazowieckie","Opolskie","Podkarpackie","Podlaskie","Pomorskie","Slaskie","Swietokrzyskie","Warminsko-Mazurskie","Wielkopolskie","Zachodniopomorskie"];
        city_arr[184]=["Acores (Azores)","Aveiro","Beja","Braga","Braganca","Castelo Branco","Coimbra","Evora","Faro","Guarda","Leiria","Lisboa","Madeira","Portalegre","Porto","Santarem","Setubal","Viana do Castelo","Vila Real","Viseu"];
        city_arr[185]=["Adjuntas","Aguada","Aguadilla","Aguas Buenas","Aibonito","Anasco","Arecibo","Arroyo","Barceloneta","Barranquitas","Bayamon","Cabo Rojo","Caguas","Camuy","Canovanas","Carolina","Catano","Cayey","Ceiba","Ciales","Cidra","Coamo","Comerio","Corozal","Culebra","Dorado","Fajardo","Florida","Guanica","Guayama","Guayanilla","Guaynabo","Gurabo","Hatillo","Hormigueros","Humacao","Isabela","Jayuya","Juana Diaz","Juncos","Lajas","Lares","Las Marias","Las Piedras","Loiza","Luquillo","Manati","Maricao","Maunabo","Mayaguez","Moca","Morovis","Naguabo","Naranjito","Orocovis","Patillas","Penuelas","Ponce","Quebradillas","Rincon","Rio Grande","Sabana Grande","Salinas","San German","San Juan","San Lorenzo","San Sebastian","Santa Isabel","Toa Alta","Toa Baja","Trujillo Alto","Utuado","Vega Alta","Vega Baja","Vieques","Villalba","Yabucoa","Yauco"];
        city_arr[186]=["Ad Dawhah","Al Ghuwayriyah","Al Jumayliyah","Al Khawr","Al Wakrah","Ar Rayyan","Jarayan al Batinah","Madinat ash Shamal","Umm Salal"];
        city_arr[187]=["Reunion"];
        city_arr[188]=["Alba","Arad","Arges","Bacau","Bihor","Bistrita-Nasaud","Botosani","Braila","Brasov","Bucuresti","Buzau","Calarasi","Caras-Severin","Cluj","Constanta","Covasna","Dimbovita","Dolj","Galati","Giurgiu","Gorj","Harghita","Hunedoara","Ialomita","Iasi","Maramures","Mehedinti","Mures","Neamt","Olt","Prahova","Salaj","Satu Mare","Sibiu","Suceava","Teleorman","Timis","Tulcea","Vaslui","Vilcea","Vrancea"];
        city_arr[189]=["Adygeya (Maykop)","Aginskiy Buryatskiy (Aginskoye)","Altay (Gorno-Altaysk)","Altayskiy (Barnaul)","Amurskaya (Blagoveshchensk)","Arkhangel'skaya","Astrakhanskaya","Bashkortostan (Ufa)","Belgorodskaya","Bryanskaya","Buryatiya (Ulan-Ude)","Chechnya (Groznyy)","Chelyabinskaya","Chitinskaya","Chukotskiy (Anadyr')","Chuvashiya (Cheboksary)","Dagestan (Makhachkala)","Evenkiyskiy (Tura)","Ingushetiya (Nazran')","Irkutskaya","Ivanovskaya","Kabardino-Balkariya (Nal'chik)","Kaliningradskaya","Kalmykiya (Elista)","Kaluzhskaya","Kamchatskaya (Petropavlovsk-Kamchatskiy)","Karachayevo-Cherkesiya (Cherkessk)","Kareliya (Petrozavodsk)","Kemerovskaya","Khabarovskiy","Khakasiya (Abakan)","Khanty-Mansiyskiy (Khanty-Mansiysk)","Kirovskaya","Komi (Syktyvkar)","Komi-Permyatskiy (Kudymkar)","Koryakskiy (Palana)","Kostromskaya","Krasnodarskiy","Krasnoyarskiy","Kurganskaya","Kurskaya","Leningradskaya","Lipetskaya","Magadanskaya","Mariy-El (Yoshkar-Ola)","Mordoviya (Saransk)","Moskovskaya","Moskva (Moscow)","Murmanskaya","Nenetskiy (Nar'yan-Mar)","Nizhegorodskaya","Novgorodskaya","Novosibirskaya","Omskaya","Orenburgskaya","Orlovskaya (Orel)","Penzenskaya","Permskaya","Primorskiy (Vladivostok)","Pskovskaya","Rostovskaya","Ryazanskaya","Sakha (Yakutsk)","Sakhalinskaya (Yuzhno-Sakhalinsk)","Samarskaya","Sankt-Peterburg (Saint Petersburg)","Saratovskaya","Severnaya Osetiya-Alaniya [North Ossetia] (Vladikavkaz)","Smolenskaya","Stavropol'skiy","Sverdlovskaya (Yekaterinburg)","Tambovskaya","Tatarstan (Kazan')","Taymyrskiy (Dudinka)","Tomskaya","Tul'skaya","Tverskaya","Tyumenskaya","Tyva (Kyzyl)","Udmurtiya (Izhevsk)","Ul'yanovskaya","Ust'-Ordynskiy Buryatskiy (Ust'-Ordynskiy)","Vladimirskaya","Volgogradskaya","Vologodskaya","Voronezhskaya","Yamalo-Nenetskiy (Salekhard)","Yaroslavskaya","Yevreyskaya"];
        city_arr[190]=["Butare","Byumba","Cyangugu","Gikongoro","Gisenyi","Gitarama","Kibungo","Kibuye","Kigali Rurale","Kigali-ville","Ruhengeri","Umutara"];
        city_arr[191]=["Ascension","Saint Helena","Tristan da Cunha"];
        city_arr[192]=["Christ Church Nichola Town","Saint Anne Sandy Point","Saint George Basseterre","Saint George Gingerland","Saint James Windward","Saint John Capisterre","Saint John Figtree","Saint Mary Cayon","Saint Paul Capisterre","Saint Paul Charlestown","Saint Peter Basseterre","Saint Thomas Lowland","Saint Thomas Middle Island","Trinity Palmetto Point"];
        city_arr[193]=["Anse-la-Raye","Castries","Choiseul","Dauphin","Dennery","Gros Islet","Laborie","Micoud","Praslin","Soufriere","Vieux Fort"];
        city_arr[194]=["Miquelon","Saint Pierre"];
        city_arr[195]=["Charlotte","Grenadines","Saint Andrew","Saint David","Saint George","Saint Patrick"];
        city_arr[196]=["A'ana","Aiga-i-le-Tai","Atua","Fa'asaleleaga","Gaga'emauga","Gagaifomauga","Palauli","Satupa'itea","Tuamasaga","Va'a-o-Fonoti","Vaisigano"];
        city_arr[197]=["Acquaviva","Borgo Maggiore","Chiesanuova","Domagnano","Faetano","Fiorentino","Monte Giardino","San Marino","Serravalle"];
        city_arr[198]=["Principe","Sao Tome"];
        city_arr[199]=["'Asir","Al Bahah","Al Hudud ash Shamaliyah","Al Jawf","Al Madinah","Al Qasim","Ar Riyad","Ash Sharqiyah (Eastern Province)","Ha'il","Jizan","Makkah","Najran","Tabuk"];
        city_arr[200]=["Aberdeen City","Aberdeenshire","Angus","Argyll and Bute","City of Edinburgh","Clackmannanshire","Dumfries and Galloway","Dundee City","East Ayrshire","East Dunbartonshire","East Lothian","East Renfrewshire","Eilean Siar (Western Isles)","Falkirk","Fife","Glasgow City","Highland","Inverclyde","Midlothian","Moray","North Ayrshire","North Lanarkshire","Orkney Islands","Perth and Kinross","Renfrewshire","Shetland Islands","South Ayrshire","South Lanarkshire","Stirling","The Scottish Borders","West Dunbartonshire","West Lothian"];
        city_arr[201]=["Dakar","Diourbel","Fatick","Kaolack","Kolda","Louga","Saint-Louis","Tambacounda","Thies","Ziguinchor"];
        city_arr[202]=["Anse aux Pins","Anse Boileau","Anse Etoile","Anse Louis","Anse Royale","Baie Lazare","Baie Sainte Anne","Beau Vallon","Bel Air","Bel Ombre","Cascade","Glacis","Grand' Anse (on Mahe)","Grand' Anse (on Praslin)","La Digue","La Riviere Anglaise","Mont Buxton","Mont Fleuri","Plaisance","Pointe La Rue","Port Glaud","Saint Louis","Takamaka"];
        city_arr[203]=["Eastern","Northern","Southern","Western"];
        city_arr[204]=["Singapore"];
        city_arr[205]=["Banskobystricky","Bratislavsky","Kosicky","Nitriansky","Presovsky","Trenciansky","Trnavsky","Zilinsky"];
        city_arr[206]=["Ajdovscina","Beltinci","Bled","Bohinj","Borovnica","Bovec","Brda","Brezice","Brezovica","Cankova-Tisina","Celje","Cerklje na Gorenjskem","Cerknica","Cerkno","Crensovci","Crna na Koroskem","Crnomelj","Destrnik-Trnovska Vas","Divaca","Dobrepolje","Dobrova-Horjul-Polhov Gradec","Dol pri Ljubljani","Domzale","Dornava","Dravograd","Duplek","Gorenja Vas-Poljane","Gorisnica","Gornja Radgona","Gornji Grad","Gornji Petrovci","Grosuplje","Hodos Salovci","Hrastnik","Hrpelje-Kozina","Idrija","Ig","Ilirska Bistrica","Ivancna Gorica","Izola","Jesenice","Jursinci","Kamnik","Kanal","Kidricevo","Kobarid","Kobilje","Kocevje","Komen","Koper","Kozje","Kranj","Kranjska Gora","Krsko","Kungota","Kuzma","Lasko","Lenart","Lendava","Litija","Ljubljana","Ljubno","Ljutomer","Logatec","Loska Dolina","Loski Potok","Luce","Lukovica","Majsperk","Maribor","Medvode","Menges","Metlika","Mezica","Miren-Kostanjevica","Mislinja","Moravce","Moravske Toplice","Mozirje","Murska Sobota","Muta","Naklo","Nazarje","Nova Gorica","Novo Mesto","Odranci","Ormoz","Osilnica","Pesnica","Piran","Pivka","Podcetrtek","Podvelka-Ribnica","Postojna","Preddvor","Ptuj","Puconci","Race-Fram","Radece","Radenci","Radlje ob Dravi","Radovljica","Ravne-Prevalje","Ribnica","Rogasevci","Rogaska Slatina","Rogatec","Ruse","Semic","Sencur","Sentilj","Sentjernej","Sentjur pri Celju","Sevnica","Sezana","Skocjan","Skofja Loka","Skofljica","Slovenj Gradec","Slovenska Bistrica","Slovenske Konjice","Smarje pri Jelsah","Smartno ob Paki","Sostanj","Starse","Store","Sveti Jurij","Tolmin","Trbovlje","Trebnje","Trzic","Turnisce","Velenje","Velike Lasce","Videm","Vipava","Vitanje","Vodice","Vojnik","Vrhnika","Vuzenica","Zagorje ob Savi","Zalec","Zavrc","Zelezniki","Ziri","Zrece"];
        city_arr[207]=["Bellona","Central","Choiseul (Lauru)","Guadalcanal","Honiara","Isabel","Makira","Malaita","Rennell","Temotu","Western"];
        city_arr[208]=["Awdal","Bakool","Banaadir","Bari","Bay","Galguduud","Gedo","Hiiraan","Jubbada Dhexe","Jubbada Hoose","Mudug","Nugaal","Sanaag","Shabeellaha Dhexe","Shabeellaha Hoose","Sool","Togdheer","Woqooyi Galbeed"];
        city_arr[209]=["Eastern Cape","Free State","Gauteng","KwaZulu-Natal","Mpumalanga","North-West","Northern Cape","Northern Province","Western Cape"];
        city_arr[210]=["Bird Island","Bristol Island","Clerke Rocks","Montagu Island","Saunders Island","South Georgia","Southern Thule","Traversay Islands"];
        city_arr[211]=["Andalucia","Aragon","Asturias","Baleares (Balearic Islands)","Canarias (Canary Islands)","Cantabria","Castilla y Leon","Castilla-La Mancha","Cataluna","Ceuta","Communidad Valencian","Extremadura","Galicia","Islas Chafarinas","La Rioja","Madrid","Melilla","Murcia","Navarra","Pais Vasco (Basque Country)","Penon de Alhucemas","Penon de Velez de la Gomera"];
        city_arr[212]=["Spratly Islands"];
        city_arr[213]=["Central","Eastern","North Central","North Eastern","North Western","Northern","Sabaragamuwa","Southern","Uva","Western"];
        city_arr[214]=["A'ali an Nil","Al Bahr al Ahmar","Al Buhayrat","Al Jazirah","Al Khartum","Al Qadarif","Al Wahdah","An Nil al Abyad","An Nil al Azraq","Ash Shamaliyah","Bahr al Jabal","Gharb al Istiwa'iyah","Gharb Bahr al Ghazal","Gharb Darfur","Gharb Kurdufan","Janub Darfur","Janub Kurdufan","Junqali","Kassala","Nahr an Nil","Shamal Bahr al Ghazal","Shamal Darfur","Shamal Kurdufan","Sharq al Istiwa'iyah","Sinnar","Warab"];
        city_arr[215]=["Brokopondo","Commewijne","Coronie","Marowijne","Nickerie","Para","Paramaribo","Saramacca","Sipaliwini","Wanica"];
        city_arr[216]=["Barentsoya","Bjornoya","Edgeoya","Hopen","Kvitoya","Nordaustandet","Prins Karls Forland","Spitsbergen"];
        city_arr[217]=["Hhohho","Lubombo","Manzini","Shiselweni"];
        city_arr[218]=["Blekinge","Dalarnas","Gavleborgs","Gotlands","Hallands","Jamtlands","Jonkopings","Kalmar","Kronobergs","Norrbottens","Orebro","Ostergotlands","Skane","Sodermanlands","Stockholms","Uppsala","Varmlands","Vasterbottens","Vasternorrlands","Vastmanlands","Vastra Gotalands"];
        city_arr[219]=["Aargau","Ausser-Rhoden","Basel-Landschaft","Basel-Stadt","Bern","Fribourg","Geneve","Glarus","Graubunden","Inner-Rhoden","Jura","Luzern","Neuchatel","Nidwalden","Obwalden","Sankt Gallen","Schaffhausen","Schwyz","Solothurn","Thurgau","Ticino","Uri","Valais","Vaud","Zug","Zurich"];
        city_arr[220]=["Al Hasakah","Al Ladhiqiyah","Al Qunaytirah","Ar Raqqah","As Suwayda'","Dar'a","Dayr az Zawr","Dimashq","Halab","Hamah","Hims","Idlib","Rif Dimashq","Tartus"];
        city_arr[221]=["Chang-hua","Chi-lung","Chia-i","Chia-i","Chung-hsing-hsin-ts'un","Hsin-chu","Hsin-chu","Hua-lien","I-lan","Kao-hsiung","Kao-hsiung","Miao-li","Nan-t'ou","P'eng-hu","P'ing-tung","T'ai-chung","T'ai-chung","T'ai-nan","T'ai-nan","T'ai-pei","T'ai-pei","T'ai-tung","T'ao-yuan","Yun-lin"];
        city_arr[222]=["Viloyati Khatlon","Viloyati Leninobod","Viloyati Mukhtori Kuhistoni Badakhshon"];
        city_arr[223]=["Arusha","Dar es Salaam","Dodoma","Iringa","Kagera","Kigoma","Kilimanjaro","Lindi","Mara","Mbeya","Morogoro","Mtwara","Mwanza","Pemba North","Pemba South","Pwani","Rukwa","Ruvuma","Shinyanga","Singida","Tabora","Tanga","Zanzibar Central/South","Zanzibar North","Zanzibar Urban/West"];
        city_arr[224]=["Amnat Charoen","Ang Thong","Buriram","Chachoengsao","Chai Nat","Chaiyaphum","Chanthaburi","Chiang Mai","Chiang Rai","Chon Buri","Chumphon","Kalasin","Kamphaeng Phet","Kanchanaburi","Khon Kaen","Krabi","Krung Thep Mahanakhon (Bangkok)","Lampang","Lamphun","Loei","Lop Buri","Mae Hong Son","Maha Sarakham","Mukdahan","Nakhon Nayok","Nakhon Pathom","Nakhon Phanom","Nakhon Ratchasima","Nakhon Sawan","Nakhon Si Thammarat","Nan","Narathiwat","Nong Bua Lamphu","Nong Khai","Nonthaburi","Pathum Thani","Pattani","Phangnga","Phatthalung","Phayao","Phetchabun","Phetchaburi","Phichit","Phitsanulok","Phra Nakhon Si Ayutthaya","Phrae","Phuket","Prachin Buri","Prachuap Khiri Khan","Ranong","Ratchaburi","Rayong","Roi Et","Sa Kaeo","Sakon Nakhon","Samut Prakan","Samut Sakhon","Samut Songkhram","Sara Buri","Satun","Sing Buri","Sisaket","Songkhla","Sukhothai","Suphan Buri","Surat Thani","Surin","Tak","Trang","Trat","Ubon Ratchathani","Udon Thani","Uthai Thani","Uttaradit","Yala","Yasothon"];
        city_arr[225]=["Tobago"];
        city_arr[226]=["De La Kara","Des Plateaux","Des Savanes","Du Centre","Maritime"];
        city_arr[227]=["Atafu","Fakaofo","Nukunonu"];
        city_arr[228]=["Ha'apai","Tongatapu","Vava'u"];
        city_arr[229]=["Arima","Caroni","Mayaro","Nariva","Port-of-Spain","Saint Andrew","Saint David","Saint George","Saint Patrick","San Fernando","Victoria"];
        city_arr[230]=["Ariana","Beja","Ben Arous","Bizerte","El Kef","Gabes","Gafsa","Jendouba","Kairouan","Kasserine","Kebili","Mahdia","Medenine","Monastir","Nabeul","Sfax","Sidi Bou Zid","Siliana","Sousse","Tataouine","Tozeur","Tunis","Zaghouan"];
        city_arr[231]=["Adana","Adiyaman","Afyon","Agri","Aksaray","Amasya","Ankara","Antalya","Ardahan","Artvin","Aydin","Balikesir","Bartin","Batman","Bayburt","Bilecik","Bingol","Bitlis","Bolu","Burdur","Bursa","Canakkale","Cankiri","Corum","Denizli","Diyarbakir","Duzce","Edirne","Elazig","Erzincan","Erzurum","Eskisehir","Gaziantep","Giresun","Gumushane","Hakkari","Hatay","Icel","Igdir","Isparta","Istanbul","Izmir","Kahramanmaras","Karabuk","Karaman","Kars","Kastamonu","Kayseri","Kilis","Kirikkale","Kirklareli","Kirsehir","Kocaeli","Konya","Kutahya","Malatya","Manisa","Mardin","Mugla","Mus","Nevsehir","Nigde","Ordu","Osmaniye","Rize","Sakarya","Samsun","Sanliurfa","Siirt","Sinop","Sirnak","Sivas","Tekirdag","Tokat","Trabzon","Tunceli","Usak","Van","Yalova","Yozgat","Zonguldak"];
        city_arr[232]=["Ahal Welayaty","Balkan Welayaty","Dashhowuz Welayaty","Lebap Welayaty","Mary Welayaty"];
        city_arr[233]=["Tuvalu"];
        city_arr[234]=["Adjumani","Apac","Arua","Bugiri","Bundibugyo","Bushenyi","Busia","Gulu","Hoima","Iganga","Jinja","Kabale","Kabarole","Kalangala","Kampala","Kamuli","Kapchorwa","Kasese","Katakwi","Kibale","Kiboga","Kisoro","Kitgum","Kotido","Kumi","Lira","Luwero","Masaka","Masindi","Mbale","Mbarara","Moroto","Moyo","Mpigi","Mubende","Mukono","Nakasongola","Nebbi","Ntungamo","Pallisa","Rakai","Rukungiri","Sembabule","Soroti","Tororo"];
        city_arr[235]=["Avtonomna Respublika Krym (Simferopol')","Cherkas'ka (Cherkasy)","Chernihivs'ka (Chernihiv)","Chernivets'ka (Chernivtsi)","Dnipropetrovs'ka (Dnipropetrovs'k)","Donets'ka (Donets'k)","Ivano-Frankivs'ka (Ivano-Frankivs'k)","Kharkivs'ka (Kharkiv)","Khersons'ka (Kherson)","Khmel'nyts'ka (Khmel'nyts'kyy)","Kirovohrads'ka (Kirovohrad)","Kyyiv","Kyyivs'ka (Kiev)","L'vivs'ka (L'viv)","Luhans'ka (Luhans'k)","Mykolayivs'ka (Mykolayiv)","Odes'ka (Odesa)","Poltavs'ka (Poltava)","Rivnens'ka (Rivne)","Sevastopol'","Sums'ka (Sumy)","Ternopil's'ka (Ternopil')","Vinnyts'ka (Vinnytsya)","Volyns'ka (Luts'k)","Zakarpats'ka (Uzhhorod)","Zaporiz'ka (Zaporizhzhya)","Zhytomyrs'ka (Zhytomyr)"];
        city_arr[236]=["'Ajman","Abu Zaby (Abu Dhabi)","Al Fujayrah","Ash Shariqah (Sharjah)","Dubayy (Dubai)","Ra's al Khaymah","Umm al Qaywayn"];
        city_arr[237]=["Barking and Dagenham","Barnet","Barnsley","Bath and North East Somerset","Bedfordshire","Bexley","Birmingham","Blackburn with Darwen","Blackpool","Bolton","Bournemouth","Bracknell Forest","Bradford","Brent","Brighton and Hove","Bromley","Buckinghamshire","Bury","Calderdale","Cambridgeshire","Camden","Cheshire","City of Bristol","City of Kingston upon Hull","City of London","Cornwall","Coventry","Croydon","Cumbria","Darlington","Derby","Derbyshire","Devon","Doncaster","Dorset","Dudley","Durham","Ealing","East Riding of Yorkshire","East Sussex","Enfield","Essex","Gateshead","Gloucestershire","Greenwich","Hackney","Halton","Hammersmith and Fulham","Hampshire","Haringey","Harrow","Hartlepool","Havering","Herefordshire","Hertfordshire","Hillingdon","Hounslow","Isle of Wight","Islington","Kensington and Chelsea","Kent","Kingston upon Thames","Kirklees","Knowsley","Lambeth","Lancashire","Leeds","Leicester","Leicestershire","Lewisham","Lincolnshire","Liverpool","Luton","Manchester","Medway","Merton","Middlesbrough","Milton Keynes","Newcastle upon Tyne","Newham","Norfolk","North East Lincolnshire","North Lincolnshire","North Somerset","North Tyneside","North Yorkshire","Northamptonshire","Northumberland","Nottingham","Nottinghamshire","Oldham","Oxfordshire","Peterborough","Plymouth","Poole","Portsmouth","Reading","Redbridge","Redcar and Cleveland","Richmond upon Thames","Rochdale","Rotherham","Rutland","Salford","Sandwell","Sefton","Sheffield","Shropshire","Slough","Solihull","Somerset","South Gloucestershire","South Tyneside","Southampton","Southend-on-Sea","Southwark","St. Helens","Staffordshire","Stockport","Stockton-on-Tees","Stoke-on-Trent","Suffolk","Sunderland","Surrey","Sutton","Swindon","Tameside","Telford and Wrekin","Thurrock","Torbay","Tower Hamlets","Trafford","Wakefield","Walsall","Waltham Forest","Wandsworth","Warrington","Warwickshire","West Berkshire","West Sussex","Westminster","Wigan","Wiltshire","Windsor and Maidenhead","Wirral","Wokingham","Wolverhampton","Worcestershire","York"];
        city_arr[238]=["Artigas","Canelones","Cerro Largo","Colonia","Durazno","Flores","Florida","Lavalleja","Maldonado","Montevideo","Paysandu","Rio Negro","Rivera","Rocha","Salto","San Jose","Soriano","Tacuarembo","Treinta y Tres"];
        city_arr[239]=["Alabama","Alaska","Arizona","Arkansas","California","Colorado","Connecticut","Delaware","District of Columbia","Florida","Georgia","Hawaii","Idaho","Illinois","Indiana","Iowa","Kansas","Kentucky","Louisiana","Maine","Maryland","Massachusetts","Michigan","Minnesota","Mississippi","Missouri","Montana","Nebraska","Nevada","New Hampshire","New Jersey","New Mexico","New York","North Carolina","North Dakota","Ohio","Oklahoma","Oregon","Pennsylvania","Rhode Island","South Carolina","South Dakota","Tennessee","Texas","Utah","Vermont","Virginia","Washington","West Virginia","Wisconsin","Wyoming"];
        city_arr[240]=["Andijon Wiloyati","Bukhoro Wiloyati","Farghona Wiloyati","Jizzakh Wiloyati","Khorazm Wiloyati (Urganch)","Namangan Wiloyati","Nawoiy Wiloyati","Qashqadaryo Wiloyati (Qarshi)","Qoraqalpoghiston (Nukus)","Samarqand Wiloyati","Sirdaryo Wiloyati (Guliston)","Surkhondaryo Wiloyati (Termiz)","Toshkent Shahri","Toshkent Wiloyati"];
        city_arr[241]=["Malampa","Penama","Sanma","Shefa","Tafea","Torba"];
        city_arr[242]=["Amazonas","Anzoategui","Apure","Aragua","Barinas","Bolivar","Carabobo","Cojedes","Delta Amacuro","Dependencias Federales","Distrito Federal","Falcon","Guarico","Lara","Merida","Miranda","Monagas","Nueva Esparta","Portuguesa","Sucre","Tachira","Trujillo","Vargas","Yaracuy","Zulia"];
        city_arr[243]=["An Giang","Ba Ria-Vung Tau","Bac Giang","Bac Kan","Bac Lieu","Bac Ninh","Ben Tre","Binh Dinh","Binh Duong","Binh Phuoc","Binh Thuan","Ca Mau","Can Tho","Cao Bang","Da Nang","Dac Lak","Dong Nai","Dong Thap","Gia Lai","Ha Giang","Ha Nam","Ha Noi","Ha Tay","Ha Tinh","Hai Duong","Hai Phong","Ho Chi Minh","Hoa Binh","Hung Yen","Khanh Hoa","Kien Giang","Kon Tum","Lai Chau","Lam Dong","Lang Son","Lao Cai","Long An","Nam Dinh","Nghe An","Ninh Binh","Ninh Thuan","Phu Tho","Phu Yen","Quang Binh","Quang Nam","Quang Ngai","Quang Ninh","Quang Tri","Soc Trang","Son La","Tay Ninh","Thai Binh","Thai Nguyen","Thanh Hoa","Thua Thien-Hue","Tien Giang","Tra Vinh","Tuyen Quang","Vinh Long","Vinh Phuc","Yen Bai"];
        city_arr[244]=["Saint Croix","Saint John","Saint Thomas"];
        city_arr[245]=["Blaenau Gwent","Bridgend","Caerphilly","Cardiff","Carmarthenshire","Ceredigion","Conwy","Denbighshire","Flintshire","Gwynedd","Isle of Anglesey","Merthyr Tydfil","Monmouthshire","Neath Port Talbot","Newport","Pembrokeshire","Powys","Rhondda Cynon Taff","Swansea","The Vale of Glamorgan","Torfaen","Wrexham"];
        city_arr[246]=["Alo","Sigave","Wallis"];
        city_arr[247]=["West Bank"];
        city_arr[248]=["Western Sahara"];
        city_arr[249]=["'Adan","'Ataq","Abyan","Al Bayda'","Al Hudaydah","Al Jawf","Al Mahrah","Al Mahwit","Dhamar","Hadhramawt","Hajjah","Ibb","Lahij","Ma'rib","Sa'dah","San'a'","Ta'izz"];
        city_arr[250]=["Kosovo","Montenegro","Serbia","Vojvodina"];
        city_arr[251]=["Central","Copperbelt","Eastern","Luapula","Lusaka","North-Western","Northern","Southern","Western"];
        city_arr[252]=["Bulawayo","Harare","ManicalandMashonaland Central","Mashonaland East","Mashonaland West","Masvingo","Matabeleland North","Matabeleland South","Midlands"];

        var country_code_arr = new Array("","93","355","213","1684","244","1264","672","1268","54","374","297","0","61","43","994","1242","973","880","1264","375","32","501","229","1441","975","591","387","267","55","1284","673","359","226","95","257","855","237","1","238","1345","236","235","56","86","61","0","61","57","269","243","242","682","506","0","385","53","357","420","45","253","1767","1809","593","20","503","240","291","372","251","0","500","298","679","358","33","594","689","0","241","220","970","995","49","233","350","0","30","299","1473","590","1671","502","0","224","245","592","509","0","39","504","852","0","36","354","91","62","98","964","353", "0","972","39","1876","0","81","0","0","0","962","0","7","254","686","850","82","965","996","856","371","961","266","231","218","423","370","352","853","389","261","265","60", "960","223","356","44","692","596","222","230","262","52","691","0","373","377","976","1664","212","258","264","674","977","31","599","687","64","505","227","234","683","672","1670","47","968","92","680","507","675","595","51","63","870","48","351","1","974","262","40","7","250","290","1869","1758","508","1784","685","378","239","966","0","221","248","232","65","421","386","677","252","27","0","34","0","94","249","597","0","268","46","41","963","886","992","255","66","1868","228","690","676","1868","216","90","993","688","256","380","971","44","598","1","998","678","58","84","1340","0","681","970","0","967","0","260","263");

        var region_arr = new Array();
        region_arr[181]=["Bangsamoro Autonomous Region", "Bicol Region", "Cagayan Valley", "Caraga Region", "Central Luzon", "Central Visayas", "Cordillera Administrative Region", "Davao Region", "Eastern Visayas", "Ilocos Region", "National Capital Region", "Northern Mindanao", "SOCCSKSARGEN", "Southern Tagalog Mainland",  "Western Visayas", "Zamboanga Peninsula"];

        var city_reg_arr = new Array(); 
        city_reg_arr["Bangsamoro Autonomous Region"]=["Cotabato", "Lamitan", "Marawi"];
        city_reg_arr["Bicol Region"]=["Iriga", "Legaspi", "Ligao", "Masbate", "Naga", "Sorsogon", "Tabaco"];
        city_reg_arr["Cagayan Valley"]=["Cauayan", "Ilagan", "Santiago", "Tuguegarao"];
        city_reg_arr["Caraga Region"]=["Bayugan", "Bislig", "Butuan", "Cabadbaran", "Surigao", "Tandag"];
        city_reg_arr["Central Luzon"]=["Angeles", "Olongapo"];
        city_reg_arr["Central Visayas"]=["Bais", "Bayawan", "Bogo", "Canlaon", "Carcar", "Cebu", "Danao", "Dumaguete", "Guihulngan", "Lapu-Lapu", "Mandaue", "Naga", "Tagbilaran", "Talisay", "Tanjay", "Toledo",];
        city_reg_arr["Cordillera Administrative Region"]=["Baguio", "Tabuk"];
        city_reg_arr["Davao Region"]=["Davao", "Digos", "Mati", "Panabo", "Samal", "Tagum"];
        city_reg_arr["Eastern Visayas"]=["Baybay", "Borongan", "Calbayog", "Catbalogan", "Maasin", "Ormoc", "Tacloban"];
        city_reg_arr["Ilocos Region"]=["Alaminos", "Batac", "Candon", "Dagupan", "Laoag", "San Carlos", "San Fernando", "Urdaneta", "Vigan"];
        city_reg_arr["National Capital Region"]=["Caloocan", "Las Pinas", "Makati", "Malabon", "Mandaluyong", "Manila", "Marikina", "Muntinlupa", "Navotas", "Paranaque", "Pasay", "Pasig", "Quezon", "San Juan", "Taguig", "Valenzuela",];
        city_reg_arr["Northern Mindanao"]=["Cagayan de Oro", "El Salvador", "Gingoog", "Iligan", "Malaybalay", "Oroquieta", "Ozamiz", "Tangub", "Valencia"];
        city_reg_arr["SOCCSKSARGEN"]=["General Santos", "Kidapawan", "Koronadal", "Tacurong"];
        city_reg_arr["Southern Tagalog Mainland"]=["Antipolo", "Bacoor", "Batangas", "Binan", "Cabuyao", "Calamba", "Cavite", "Dasmariñas", "General Trias", "Imus", "Lipa", "Lucena", "San Pablo", "San Pedro", "Santa Rosa", "Tagaytay", "Tanauan", "Tayabas", "Trece Martires"];
        city_reg_arr["Western Visayas"]=["Bacolod", "Bago", "Cadiz", "Escalante", "Himamaylan", "Iloilo", "Kabankalan", "La Carlota", "Passi", "Roxas", "Sagay", "San Carlos", "Silay", "Sipalay", "Talisay", "Victorias"];
        city_reg_arr["Zamboanga Peninsula"]=["Dapitan", "Dipolog", "Isabela", "Pagadian", "Zamboanga"];

    // -----array-----
    

//================ R E G I S T R A T I O N ==============



//================ P R O F I L E ==============


    // -----click function-----
    
        $('#proceedPasswordButton').click(function(e) {
            document.body.classList.remove('c-modal--body-lock');
            $("#confirmationPasswordModal").addClass("c-modal--is-close"); 
            $("#confirmationPasswordModal").removeClass("c-modal--is-open");
            displayLoading();

            userPassword = $("#userPassword").val();
            confirmationPassword = $("#confirmationPassword").val();

            if(confirmationPassword === "") {
                toastr.error('Please complete all the fields',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkConfirmationPasswordField);
                    $("#confirmationPasswordModal").removeClass("c-modal--is-close"); 
                    $("#confirmationPasswordModal").addClass("c-modal--is-open");
                    displayLoading();
                }, 500);
            }
            else if(userPassword === confirmationPassword) {
                setTimeout(function () {
                    $("#form-password").removeClass("is-disabled");
                    $("#form-confirmationPasswordModal").removeClass("is-disabled");
                    $("#newPassword").removeAttr("disabled");
                    $("#newRePassword").removeAttr("disabled");
                    $("#cancelButton").removeAttr("disabled");
                    $("#cancelButton").removeAttr("style");
                    displayLoading();
                }, 500);
            } 
            else {
                toastr.error('The password is incorrect',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $("#newPassword").attr("disabled", true);
                    $("#newRePassword").attr("disabled", true);
                    $("#form-password").addClass("is-disabled");
                    $("#form-confirmationPasswordModal").addClass("is-disabled");
                    $("#confirmationPasswordModal").removeClass("c-modal--is-close"); 
                    $("#confirmationPasswordModal").addClass("c-modal--is-open");
                    displayLoading();
                    $("#errorConfirmationPassword").html("The password is incorrect");
                    document.getElementById("confirmationPassword").style.borderColor = "red";
                }, 500);
            }
        });

        $('#changePasswordButton').click(function() {
            displayLoading();

            newPassword = $('#newPassword').val();
            newRePassword = $('#newRePassword').val();
            
            if(newPassword === "" || newRePassword === "") {
                toastr.error('Please complete all the fields',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkChangePassword);
                    displayLoading();
                }, 500);
            }
            else if(newPassword.length < 8) {
                toastr.error('The password must be at least 8 characters long',{timeOut: 1000,fadeOut: 1000})
               setTimeout(function () {
                   $(document).ready(checkChangePassword);
                   displayLoading();
               }, 500);
            }
            else if(newPassword.length > 20) {
                toastr.error('The password must be less than 20 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                   $(document).ready(checkChangePassword);
                   displayLoading();
               }, 500);
            }
            else if(newPassword.match(/#.*/) || newPassword.match(/\+.*/) || newPassword.match(/&.*/) || newPassword.match(/\*.*/) || newPassword.match(/\(.*/)|| newPassword.match(/\).*/)) {
                toastr.error('The password cannot consist of number and plus sign, ampersand, asterisk, left and right parenthesis',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkChangePassword);
                    displayLoading();
                }, 500);
            }
            else if(newPassword !== newRePassword) {
                toastr.error('The password and its confirm are not the same',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkChangePassword);
                    displayLoading();
                }, 500);
            }
            else {
                $.ajax({
                    method : "POST",
                    url  : "<?php echo base_url(); ?>users/changePassword",
                    dataType : "json",
                    global: false,
                    data : {
                        newPassword:newPassword
                    },
                    success: function(response) {
                        if (response.match(/Password Updated Succesfully*/)) {
                            toastr.success("Password Updated Succesfully",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                window.location.href = "<?php echo base_url() ?>";
                            }, 1000);
                        }
                        else {
                            toastr.error(response,{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                displayLoading();
                            }, 500);
                        }
                    }
                });
            }
        });

        $('#cancelButton').click(function() {
            displayLoading();
            setTimeout(function () {
                $("#form-password").addClass("is-disabled");
                $("#form-confirmationPasswordModal").addClass("is-disabled");
                $("#newPassword").addClass("disabled");
                $("#newRePassword").addClass("disabled");
                $("#cancelButton").attr("disabled", true);
                $("#cancelButton").attr("style", "pointer-events:none");
                displayLoading();
            }, 500);
        });

        $('#visiblePassButton').click(function(e) {
            x = document.getElementById("newPassword");
            y = document.getElementById("visiblePassButton");
            if (x.type === "password") {
                x.type = "text";
                y.classList.add('js-password--hidden')
            } else {
                x.type = "password";
                y.classList.remove('js-password--hidden')
            }
        });

        $('#visibleRePassButton').click(function(e) {
            x = document.getElementById("newRePassword");
            y = document.getElementById("visibleRePassButton");
            if (x.type === "password") {
                x.type = "text";
                y.classList.add('js-password--hidden')
            } else {
                x.type = "password";
                y.classList.remove('js-password--hidden')
            }
        });


        $('#reserveTicketsButton').click(function(e) {
            displayLoading();
            var response = grecaptcha.getResponse(),
            paymentCode = $('#paymentCode').val();
            if(response.length == 0) { 
                $(document).ready(checkPaymentCodeFields);
                toastr.error("The captcha is required for validation" ,{timeOut: 1000,fadeOut: 1000})
                displayLoading();
            }
            else if (paymentCode === "") {
                $(document).ready(checkPaymentCodeFields);
                toastr.error("The promo code is required and cannot be empty" ,{timeOut: 1000,fadeOut: 1000})
                displayLoading();
            }
            else {
                $.ajax({
                    method : "POST",
                    url  : "<?php echo base_url(); ?>transactions/checkReservedTicket",
                    dataType : "json",
                    global:false,
                    data : {
                        paymentCode:paymentCode
                    },
                    success: function(data) {
                        if(!$.trim(data)) {   
                            toastr.error("The input is not a valid payment code",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                               $("#errorPaymentCode").html("The input is not a valid payment code");
                               document.getElementById("paymentCode").style.borderColor = "red";
                               displayLoading();
                           }, 500);
                        }
                        else {
                            for (i = 0; i < data.length; i++) {
                                var date = getEventDate(data[i].transaction_date)
                                console.log(data[i])
                                $("#reservationPage").removeClass("is-active");
                                $("#reservationPage2").addClass("is-active");
                                $("#reservationData").append('<li><div>'+data[i].event_title+'</div><div><span class="o-date">'+getEventDate(data[i].transaction_date)+'</span></div><div><button class="o-button o-button--green" onclick="checkOut('+data[i].transaction_id+')"> Checkout </button></div><li>');
                                $("#reservationDate").html(date);
                                $("#reservationTitle").html(data[i].event_title);
                                   displayLoading();
                            }
                        }
                    }
                });
            }
        }); 
        
    // -----click function-----
    

    // -----keycode function-----

        $('#confirmationPassword').keypress(function(event) {
            if(event.keyCode === 13) {
                event.preventDefault();
                document.getElementById("proceedPasswordButton").click();
            } 
        });

        $('#newPassword').keypress(function(event) {
            if((event.keyCode>=40&&event.keyCode<=43)||event.keyCode===35||event.keyCode===38) {
                event.preventDefault();
            }
        });

        $('#newRePassword').keypress(function(event) {
            if((event.keyCode>=40&&event.keyCode<=43)||event.keyCode===35||event.keyCode===38) {
                event.preventDefault();
            }
        });

    // -----keycode function-----
    

    // -----keyup function-----

        $("#confirmationPassword").keyup(function() {
            confirmationPassword = $(this).val();
            if(confirmationPassword === "") {
                $("#proceedPasswordButton").addClass("o-button--green-disabled");
                $("#proceedPasswordButton").attr("disabled", true);
                $("#proceedPasswordButton").attr("Title", "Enter your password");
                $("#errorConfirmationPassword").html("The password is required and cannot be empty");
                document.getElementById("confirmationPassword").style.borderColor = "red";
            } else {
                $("#proceedPasswordButton").removeClass("o-button--green-disabled");
                $("#proceedPasswordButton").removeAttr("disabled");
                $("#proceedPasswordButton").removeAttr("Title");
                $("#errorConfirmationPassword").empty();
                document.getElementById("confirmationPassword").style.borderColor = "green";
                document.getElementById("confirmationPassword").style.borderColor = "green";
            }
        });

        $('#newPassword').keyup(function(event) {
            $(document).ready(checkChangePassword);
            var max_chars = 20;
            if ($(this).val().length >= max_chars) { 
                $(this).val($(this).val().substr(0, max_chars));
            }
        });


        $('#newRePassword').keyup(function(event) {
            $(document).ready(checkChangePassword);
            var max_chars = 20;
            if ($(this).val().length >= max_chars) { 
                $(this).val($(this).val().substr(0, max_chars));
            }
        });

        $('#paymentCode').keyup(function(event) {
            $(document).ready(checkPaymentCodeFields);
            var paymentCode = $(this).val();

            if(paymentCode === "") {
                $("#errorPaymentCode").html("The payment code is required and cannot be empty");
                document.getElementById("paymentCode").style.borderColor = "red";
            } else {
                $("#errorPaymentCode").empty();
                document.getElementById("paymentCode").style.borderColor = "green";
            }
        });

    // -----keyup function-----


    // -----function-----

        function formatNumber(num) {
            var num = parseFloat(num),
            parts = num.toFixed(2).split("."),
            num = parts[0].replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,") + 
                (parts[1] ? "." + parts[1] : "");

            return num;
        }

        function compressArray(original) {
            var compressed = [];
            var copy = original;
         
            for (var i = 0; i < original.length; i++) {
                var quantity = 0;    
                var total_amount = 0;
                for (var w = 0; w < copy.length; w++) {
                    if (original[i].section_name == copy[w].section_name) {
                        quantity++;
                        total_amount += parseInt(original[i].ticket_price);
                    }
                }
                if (quantity > 0) {
                    var a = new Object();
                    a.price_name = original[i].price_name;
                    a.section_name = original[i].section_name;
                    a.ticket_price = total_amount;
                    a.count = quantity;
                    compressed.push(a);
                }
            }
            return compressed;
        };

        function checkOut(transaction_id) {
            displayLoading();
            $.ajax({
                method : "POST",
                url  : "<?php echo base_url(); ?>transactions/availReservedTicket",
                dataType : "json",
                global: false,
                data : {
                    transaction_id:transaction_id
                },
                success: function(data) {
                    var unique_title = [],
                    total_ticket_price = 0, 
                    online_fee = 0,
                    count = 0; 
                    if(!$.trim(data)) {   
                        toastr.error(response,{timeOut: 1000,fadeOut: 1000})
                        setTimeout(function () {
                           $("#errorPaymentCode").html(response);
                           document.getElementById("paymentCode").style.borderColor = "red";
                           displayLoading();
                       }, 500);
                    }
                    else {
                        for (i = 0; i < data.length; i++) {
                            $("#reservationPage2").removeClass("is-active");
                            $("#remarksContent").addClass("is-active");
                            $("#reservationPage3").addClass("is-active");
                            $("#reservationPage4").addClass("is-active");
                            $("#reservationList").append('<li><div>'+data[i].price_name+'</div><div>'+data[i].section_name+'</div><div> <span class="">Price</span>&#8369;&nbsp;'+formatNumber(data[i].ticket_price)+'</div></li>');

                            total_ticket_price += parseInt(data[i].ticket_price);
                            online_fee += parseInt(data[i].online_fee);
                            total_amount = parseInt(total_ticket_price) + parseInt(online_fee)
                            count = count + 1;

                            $("#reservationQuantity").html(count+" x &#8369;&nbsp;"+formatNumber(data[i].online_fee));
                        }

                        $("#reservationOnlineFee").after("&#8369;&nbsp;"+formatNumber(online_fee));
                        $("#reservationTotalAmount").html("&#8369;&nbsp;"+formatNumber(total_amount));
                        var newArray = compressArray(data);

                        for (i = 0; i < newArray.length; i++) {
                            if(unique_title.indexOf(newArray[i].section_name) == -1 ) {
                                $("#reservationSummary li:eq(0)").before('<li><div>'+newArray[i].price_name+'</div><div>'+newArray[i].count+' x '+newArray[i].section_name+'</div><div><span class="">Price</span>&#8369;&nbsp;'+formatNumber(newArray[i].ticket_price)+'</div></li>');
                                unique_title.push(newArray[i].section_name);
                            }
                        }
                        displayLoading();
                    }
                }
            });
        }

        var correctCaptcha = function(response) {
            $(document).ready(checkPaymentCodeFields);
        };

        function checkConfirmationPasswordField() {
            if(confirmationPassword === "") {
                $("#proceedPasswordButton").addClass("o-button--green-disabled");
                $("#proceedPasswordButton").attr("disabled", true);
                $("#proceedPasswordButton").attr("Title", "Enter your password");
                $("#errorConfirmationPassword").html("The password is required and cannot be empty");
                document.getElementById("confirmationPassword").style.borderColor = "red";
            } else {
                $("#proceedPasswordButton").removeClass("o-button--green-disabled");
                $("#proceedPasswordButton").removeAttr("disabled");
                $("#proceedPasswordButton").removeAttr("Title");
                $("#errorConfirmationPassword").empty();
                document.getElementById("confirmationPassword").style.borderColor = "green";
                document.getElementById("confirmationPassword").style.borderColor = "green";
            }
        }

        function checkChangePassword() {
            var newPassword = $('#newPassword').val();
            var newRePassword = $('#newRePassword').val();
            if(newPassword === "") {
                $("#errorNewPassword").html("The password is required and cannot be empty");
                $("#errorRePassword").empty();
                document.getElementById("newPassword").style.borderColor = "red";
                document.getElementById("newRePassword").style.borderColor = "red";
                $("#changePasswordButton").attr("disabled", true);
                $("#changePasswordButton").addClass("o-button--green-disabled");
            } 
            else if(newPassword.length < 8) {
                $("#errorNewPassword").html("The password must be at least 8 characters long");
                $("#errorRePassword").empty();
                document.getElementById("newPassword").style.borderColor = "red";
                document.getElementById("newRePassword").style.borderColor = "red";
                $("#changePasswordButton").attr("disabled", true);
                $("#changePasswordButton").addClass("o-button--green-disabled");
            }
            else if(newPassword.length > 20) {
                $("#errorNewPassword").html("The password must be less than 20 characters long");
                $("#errorRePassword").empty();
                document.getElementById("newPassword").style.borderColor = "red";
                document.getElementById("newRePassword").style.borderColor = "red";
                $("#changePasswordButton").attr("disabled", true);
                $("#changePasswordButton").addClass("o-button--green-disabled");
            }
            else if(newPassword.match(/#.*/) || newPassword.match(/\+.*/) || newPassword.match(/&.*/) || newPassword.match(/\*.*/) || newPassword.match(/\(.*/)|| newPassword.match(/\).*/)) {
                $("#errorNewPassword").html("The password cannot consist of number and plus sign, ampersand, asterisk, left and right parenthesis");
                $("#errorRePassword").empty();
                document.getElementById("newPassword").style.borderColor = "red";
                document.getElementById("newRePassword").style.borderColor = "red";
                $("#changePasswordButton").attr("disabled", true);
                $("#changePasswordButton").addClass("o-button--green-disabled");
            }
            else if(newPassword.length < 6) {
                $("#errorNewPassword").html("The password must be at least 6 characters long");
                $("#errorRePassword").empty();
                document.getElementById("newPassword").style.borderColor = "red";
                document.getElementById("newRePassword").style.borderColor = "red";
                $("#changePasswordButton").attr("disabled", true);
                $("#changePasswordButton").addClass("o-button--green-disabled");
            }
            else if(newPassword !== newRePassword) {
                $("#errorNewPassword").empty();
                $("#errorRePassword").html("The password and its confirm are not the same");
                document.getElementById("newRePassword").style.borderColor = "red";
                document.getElementById("newPassword").style.borderColor = "red";
                $("#changePasswordButton").attr("disabled", true);
                $("#changePasswordButton").addClass("o-button--green-disabled");
            }
            else {
                $("#errorRePassword").empty();
                $("#errorNewPassword").empty();
                document.getElementById("newRePassword").style.borderColor = "green";
                document.getElementById("newPassword").style.borderColor = "green";
                $("#changePasswordButton").removeAttr("disabled");
                $("#changePasswordButton").removeClass("o-button--green-disabled");
            }
        }

        function checkPaymentCodeFields() {
            var paymentCode = $('#paymentCode').val(),
            response = grecaptcha.getResponse();

            if(paymentCode === "") {
                $("#reserveTicketsButton").attr("disabled", true);
                $("#reserveTicketsButton").addClass("o-button--green-disabled");
                $("#reserveTicketsButton").attr("Title", "The payment code is required and cannot be empty");
            } 
            else if(response.length == 0) { 
                $("#reserveTicketsButton").attr("disabled", true);
                $("#reserveTicketsButton").addClass("o-button--green-disabled");
                $("#reserveTicketsButton").attr("Title", "The captcha is required for validation");
            }
            else {
                $("#errorPaymentCode").empty();
                document.getElementById("paymentCode").style.borderColor = "green";
                $("#reserveTicketsButton").removeAttr("disabled");
                $("#reserveTicketsButton").removeClass("o-button--green-disabled");
                $("#reserveTicketsButton").removeAttr("Title");
            }
        }

    // -----function-----


//================ P R O F I L E ==============



//================ L I S T I N G ==============


    // -----click function-----

        $('.js-prev').click(function() {  
            id_cur = $(".js-page.is-active").attr('id');
            id_prev = parseInt(id_cur) - 1;
            if(id_prev > 0) {
                var x = document.getElementById(id_cur).previousElementSibling.innerHTML;
                $("#"+id_cur).removeClass("is-active");
                $("#"+x).addClass("is-active");
            }
            $('.event_li').hide();
            pagination();
        });

        $('.js-next').click(function() {  
            id_cur = $(".js-page.is-active").attr('id');
            id_next = parseInt(id_cur) + 1;
            max = $(".is-maximum").html();
            if(id_next <= max) {
                var x = document.getElementById(id_cur).nextElementSibling.innerHTML;
                $("#"+id_cur).removeClass("is-active");
                $("#"+x).addClass("is-active");
            }
            $('.event_li').hide();
            pagination();
        });

    // -----click function-----

    // -----change function-----

        $('#eventsFilterMonth').change(function() {  
            eventsFilterMonth = $(this).val();
            var ids = $('.event_li').map(function() {
                id = $('.event_li').attr('id');
                $('.event_li').hide();
                $('.event_li#'+eventsFilterMonth).show();
            });
            if($(".event_li").is(":visible")) {
                $('#no_record').hide();
            } else {
                $('#no_record').show();
            }
        }); 

        $('#eventsFilterShow').change(function() {  
            $('#no_record').hide();
            $('.js-pagination').find('.js-page').remove().end();
            $(".event_li").removeAttr("style");
            eventsFilterShow = $(this).val();
            $(".event_li").slice(eventsFilterShow).attr("style", "display:none");
            pagination();
            pagination_num();
        });

    // -----change function-----


    // -----function-----

        function triggerShow() {
            $("#eventsFilterShow").val($("#eventsFilterShow option:eq(0)").val()).trigger('change');
            $("#eventsFilterShow").addClass("selected");
        }

    // -----function-----


    // -----keyup function-----

        $("#search_event").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            var a = $("#event_ul li").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });

            if($(".event_li").is(":visible")) {
                $('#no_record').hide();
            } else {
                $('#no_record').show();
            }
        });

    // -----keyup function-----
 

//================ L I S T I N G ==============

    

//================ F O O T E R ==============


    function subscribeButton() {
        displayLoading();
        email = $('#emailSubscribe').val();
        var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;

        if(email === "") {
            toastr.error('The email address is required and cannot be empty',{timeOut: 1000,fadeOut: 1000})
            setTimeout(function () {
                displayLoading();
            }, 500);
        }
        else if(!filter.test(email)) {
            toastr.error('Invalid email address',{timeOut: 1000,fadeOut: 1000})
            setTimeout(function () {
                displayLoading();
            }, 500);
        }
        else {
            setTimeout(function () {
                displayLoading();
            }, 500);
        }
    }

    function whowerare() {
        $("#whoweare").addClass("is-active"); 
        $("#whoweareContent").addClass("is-active"); 
        $("#missionvision").removeClass("is-active"); 
        $("#missionvisionContent").removeClass("is-active"); 
    }

    function missionvision() {
        $("#missionvision").addClass("is-active"); 
        $("#missionvisionContent").addClass("is-active"); 
        $("#whoweare").removeClass("is-active"); 
        $("#whoweareContent").removeClass("is-active"); 
    }

    function terms() {
        $("#terms").addClass("is-active"); 
        $("#termsContent").addClass("is-active");
        $("#privacy").removeClass("is-active"); 
        $("#privacyContent").removeClass("is-active"); 
    }

    function privacy() {
        $("#privacy").addClass("is-active"); 
        $("#privacyContent").addClass("is-active"); 
        $("#terms").removeClass("is-active"); 
        $("#termsContent").removeClass("is-active"); 
    }


//================ F O O T E R ==============



//================ C O N T A C T ==============


    // -----click function-----

        $('#customerCareButton').click(function() {
            displayLoading();
            fullname = $('#fullname').val();
            email = $('#emailaddress').val();
            subject = $('#subject').val();
            message = $('#message').val();
            var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;

            if(fullname === "" || email === "" || subject === "" || message === "") {
                toastr.error('Please complete all the fields',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    displayLoading();
               }, 500);
            } else if(!filter.test(email)) {
                toastr.error('The input is not a valid email address',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    displayLoading();
                }, 500);
            } 
            else {
                $.ajax({
                    method : "POST",
                    url  : "<?php echo base_url(); ?>contact/feedback",
                    dataType : "json",
                    global: false,
                    data : {
                        fullname:fullname,
                        email:email,
                        subject:subject,
                        message:message
                    },
                    success: function(response) {
                        if(response.match(/Success*/)) {
                            toastr.success("Thank you for your suggestion",{timeOut: 1000,fadeOut: 1000})
                            $('#fullname').val("");
                            $('#email').val("");
                            $('#subject').val("");
                            $('#message').val("");
                            setTimeout(function () {
                                displayLoading();
                            }, 500);
                            setTimeout(function () {
                                window.location.href = "<?php echo base_url() ?>";
                            }, 1000);
                        }
                        else {
                            toastr.error(response,{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                displayLoading();
                            }, 500);
                        }
                    }
                });
            }
        });

    // -----click function-----

    
    // -----change function-----

        $('#subject').change(function() {
            $(document).ready(checkContactFields);
        });

    // -----change function-----


    // -----keycode function-----

        $("#fullname").keypress(function(e) {
            if (!((e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=97&&e.keyCode<= 122))&&e.keyCode!=8&&e.keyCode!=32) {
                return false;
            }
        });

    // -----keycode function-----


    // -----keyup function-----

        $('#fullname').keyup(function() {
            $(document).ready(checkContactFields);
            string = $(this).val();
            $(this).val(nameCase(string));
        });

        $('#emailaddress').keyup(function() {
            email = $('#emailaddress').val();
            var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;

            if(!filter.test(email)) {
                $("#error_email2").html("The input is not a valid email address");
            } else {
                $("#error_email2").empty();
                $(document).ready(checkContactFields);
            }
        });

        $('#message').keyup(function() {
            $(document).ready(checkContactFields);
        });

    // -----keyup function-----


    // -----validation-----

        function checkContactFields() {
            fullname = $('#fullname').val();
            email = $('#emailaddress').val();
            subject = $('#subject').val();
            message = $('#message').val();
            var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if(fullname === "" || email === "" || subject === "" || message === "") {
                $("#customerCareButton").attr("disabled", true);
                $("#customerCareButton").addClass("o-button--green-disabled");
                $("#customerCareButton").attr("Title", "Please complete all the fields")
            } else if(!filter.test(email)){
                $("#customerCareButton").attr("disabled", true);
                $("#customerCareButton").addClass("o-button--green-disabled");
                $("#customerCareButton").attr("Title", "Invalid email address")
            } else {
                $("#customerCareButton").removeAttr("disabled");
                $("#customerCareButton").removeClass("o-button--green-disabled");
                $("#customerCareButton").attr("Title", "")
            }
        }

    // -----validation-----
   

//================ C O N T A C T ==============



//================ C A L E N D A R ==============
   

    // -----click function-----

        $("#next").click( function() {
            displayLoading();
            setTimeout(function () {
                displayLoading();
            }, 2000);
            month = $('#month').html();
            year = $('#year').html();
            $( "#c-calendar__month" ).empty();
            if(month === "11") {
                month = 0;
                year = parseInt(year) + 1;
            }
            else {
                month = parseInt(month) + 1;
            }

            getMonth = parseInt(month) + 1;

            createCalendar(month,year);
            getEventsDate(getMonth, year);
            pastMonthYear();
        });

        $("#previous").click( function() {
            displayLoading();
            setTimeout(function () {
                displayLoading();
            }, 2000);
            month = $('#month').html();
            year = $('#year').html();
            $("#c-calendar__month").empty();

            if(month === "0") {
                month = 11;
                year = parseInt(year) - 1;
            }
            else {
                month = parseInt(month) - 1;
            }

            getMonth = parseInt(month) + 1;

            createCalendar(month,year);
            getEventsDate(getMonth, year);
            pastMonthYear();
        });

        $("#date-picker").click( function() {
            month = $('#month_mobile').html();
            year = $('#year_mobile').html();
            getEventsDate(month, year);
        });

    // -----click function-----


    // -----function-----

        function showCalendar() {
            var date_today = new Date();
            var day = date_today.getDate();
            var month = date_today.getMonth();
            var month_num = month + 1;
            var year = date_today.getFullYear();
            createCalendar(month, year);

            getMonth = parseInt(month) + 1;

            $.when( getEventInfo(year+"-"+month_num+"-"+day) ).done(function() {
                getEventsDate(getMonth, year);
            });
        }

        function createCalendar(month, year) {
            var today = new Date();
            let startMonth  = (new Date(year, month)).getDay();
            let numDays = 32 - new Date(year, month, 32).getDate();
            let renderNum = 1;
            monthAndYear = document.getElementById("monthAndYear");
            let tableBody = document.getElementById("c-calendar__month");
            let renderMonth = document.getElementById("month");
            let renderYear = document.getElementById("year");
            month_num = parseInt(month) + 1;

            for(i=0; i<6; i++) {
                let row = document.createElement("div");
                row.className = "c-calendar__month-week";
                for(c=0; c<7; c++){
                    if(i===0 && c<startMonth) {
                        let td = document.createElement("div");
                        td.className = "c-calendar__month-day";
                        td.classList.add("empty");
                        row.append(td);
                    }
                    else if(renderNum > numDays) {
                        break;
                    }
                    else {
                        let td = document.createElement("div");
                        td.className = "c-calendar__month-day";
                        td.id = year+"-"+month_num+"-"+renderNum;
                        td.textContent = renderNum;
                        row.append(td);
                        renderNum++;
                        let id = new Date(year+"-"+month_num+"-"+renderNum);
                    }
                }
                tableBody.append(row);
                var month_name = month_names[month];
                $('#year').html(year);
                $('#year_mobile').html(year);
                $('#month_name').html(month_name);
                $('#month').html(month);
                $('#month_mobile').html(month + 1);
                $('#datecalendar').html(month_name + " " +year);
            }
            disabledPastDates();
        }

        function addOnclick() {
            var date = $(this).attr("id");
            getEventInfo(date);
        }

        function addOnclickMobile(eventsDate) {
            getEventInfoMobile(eventsDate);
        }

        function getEventInfo(event_dates) {
            $(".is-selected").removeClass("is-selected")
            $(".c-calendar__event").hide();

            var mydate = new Date(event_dates);
            var date = mydate.getDate();
            var day = mydate.getDay();
            var month = mydate.getMonth();
            var year = mydate.getFullYear();
            
            var month_name = month_names_short[month];
            var day_name =  names_day[day];
          
            $('#date_display').html(month_name+" "+date+", "+year);
            $('#day_display').html(day_name);
            $('#'+event_dates).addClass("is-selected");
            $('#mobile'+event_dates).addClass("is-selected");

            if ($("."+event_dates)[0]){
                $(".no-event-for-this-day").hide();
                $("."+event_dates).show();
                $(".c-calendar__event-list").removeClass("c-calendar__event-list--no-events");
            } else {
                $(".no-event-for-this-day").show();
                $(".c-calendar__event-list").addClass("c-calendar__event-list--no-events");
            }
        }

         function getEventInfoMobile(event_dates) {
            $(".is-selected").removeClass("is-selected")
            $(".c-calendar__event").hide();

            var mydate = new Date(event_dates);
            var date = mydate.getDate();
            var day = mydate.getDay();
            var month = mydate.getMonth();
            var year = mydate.getFullYear();
            
            var month_name = month_names_short[month];
            var day_name =  names_day[day];
            
            $('#date_display').html(month_name+" "+date+", "+year);
            $('#day_display').html(day_name);
            $('#'+event_dates).addClass("is-selected");
            $('#mobile'+event_dates).addClass("is-selected");


            if ($("."+event_dates)[0]){
                $(".no-event-for-this-day").hide();
                $("."+event_dates).show();
                $(".c-calendar__event-list").removeClass("c-calendar__event-list--no-events");
            } else {
                $(".no-event-for-this-day").show();
                $(".c-calendar__event-list").addClass("c-calendar__event-list--no-events");
            }
        }

        function getEventsDate(month, year) {
            $(".c-calendar__event").remove();
            $.ajax({  
                url:  "<?php echo base_url('events/getEventsDate'); ?>",  
                method:"POST",  
                data:{month:month,year:year},  
                dataType:"json",  
                global: false,
                success:function(data) {  
                    var i;
                    for (i = 0; i < data.length; i++) {
                        var d = new Date(data[i].event_date_time);
                        date = d.getDate();
                        month = d.getMonth() + 1;
                        year = d.getFullYear();
                        id = year + "-" + month + "-" + date;
                        $('#mobile'+id).addClass("is-event-day");
                        $('#'+id).addClass("active-event");

                        var venue_name = data[i].event_venue_name;

                        if(venue_name.length > 58) {
                            var venueName = venue_name.substring(0,55),
                            event_venue_name = venueName + "...";

                        } else {
                            var event_venue_name = venue_name;
                        }
                        
                        $("#c-calendar__event-list").addClass("is-active");
                        $("#c-calendar__event-list").append("<div class='c-calendar__event "+id+"' style='display:none;'><h2 class='h2'>"+data[i].event_long_title+"</h2><span id='firstText'>"+event_venue_name+"</span><br><span class='c-calendar__event-time'>"+getEventTime(data[i].event_date_time)+"</span><button class='o-button o-button--green o-button--green-small' id='viewEventButton' onclick='event_listing("+data[i].event_id+")'>View</button></div>");
                    }
                }
            });
        }

        function disabledPastDates() {
            var ids = $('.c-calendar__month-day').map(function() {
                return $(this).attr('id');
            });
            for (i = 0; i < ids.length; i++) {
                var date_id = new Date(ids[i]);
                var date_today = new Date();
                var date_yesterday = new Date();
                date_yesterday.setDate(date_today.getDate()-1);
                if(date_id < date_yesterday) {
                    $('#'+ids[i]).addClass("is-disabled");
                } else {
                    document.getElementById(ids[i]).addEventListener("click", addOnclick);
                }
            }
        }

    // -----function-----


//================ C A L E N D A R ==============



//================ O U T L E T S ==============


    $("#search_cinema").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        var a = $("#sco_ul li").filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
        });

        if($("#sco_ul li").is(":visible")) {
            $('#noCinemaRecord').hide();
        } else {
            $('#noCinemaRecord').show();
        }
    });

    $("#search_smstore").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        var a = $("#sso_ul li").filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
        });

        if($("#sso_ul li").is(":visible")) {
            $('#noSMRecord').hide();
        } else {
            $('#noSMRecord').show();
        }
    });


//================ O U T L E T S =============



//================ R E S E T ==============


    // -----click function-----

        $('#updatePasswordButton').click(function() {
            displayLoading();

            var newPassword = $('#resetNewPassword').val();
            var newRePassword = $('#resetNewRePassword').val();
            var resetKey = $('#resetUpdateKey').val();
            var username = $('#resetUpdateUsername').val();

            if(newPassword === "" || newRePassword === "") {
                toastr.error('Please complete all the fields',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkResetPassword);
                    displayLoading();
                }, 500);
            }
            else if(newPassword.length < 8) {
                toastr.error('The password must be at least 8 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkResetPassword);
                    displayLoading();
                }, 500);
            }
            else if(newPassword.length > 20) {
                toastr.error('The password must be less than 20 characters long',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkResetPassword);
                    displayLoading();
                }, 500);
            }
            else if(newPassword.match(/#.*/) || newPassword.match(/\+.*/) || newPassword.match(/&.*/) || newPassword.match(/\*.*/) || newPassword.match(/\(.*/)|| newPassword.match(/\).*/)) {
                toastr.error('The password cannot consist of number and plus sign, ampersand, asterisk, left and right parenthesis',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkResetPassword);
                    displayLoading();
                }, 500);
            }
            else if(newPassword !==  newRePassword) {
                toastr.error('The password and its confirm are not the same',{timeOut: 1000,fadeOut: 1000})
                setTimeout(function () {
                    $(document).ready(checkResetPassword);
                    displayLoading();
                }, 500);
            }
            else {
                $.ajax({
                    method : "POST",
                    url  : "<?php echo base_url(); ?>users/updatePassword",
                    dataType : "json",
                    global:false,
                    data : {
                        newPassword:newPassword,
                        resetKey:resetKey,
                        username:username
                    },
                    success: function(response) {
                        if (response.match(/Password Updated Succesfully*/)) {
                            toastr.success("Password Updated Succesfully",{timeOut: 1000,fadeOut: 1000})
                            displayLoading();
                            setTimeout(function () {
                                $("#loginModal").addClass("c-modal--is-open");  
                                $("#loginModal").removeClass("c-modal--is-close");
                            },500);
                        }
                        else if (response.match(/Invalid Username*/)) {
                            toastr.error("Invalid Username",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                displayLoading();
                            },500);
                        }
                        else if (response.match(/Invalid reset key*/)) {
                            toastr.error("Invalid reset key",{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                displayLoading();
                            },500);
                        }
                        else {
                            toastr.error(response,{timeOut: 1000,fadeOut: 1000})
                            setTimeout(function () {
                                displayLoading();
                            }, 500);
                        }
                    }
                });
            }
        });

        $('#visibleNewPassword').click(function(e) {
            x = document.getElementById("resetNewPassword");
            y = document.getElementById("visibleNewPassword");
            if (x.type === "password") {
                x.type = "text";
                y.classList.add('js-password--hidden')
            } else {
                x.type = "password";
                y.classList.remove('js-password--hidden')
            }
        });

        $('#visibleNewRePassword').click(function(e) {
            x = document.getElementById("resetNewRePassword");
            y = document.getElementById("visibleNewRePassword");
            if (x.type === "password") {
                x.type = "text";
                y.classList.add('js-password--hidden')
            } else {
                x.type = "password";
                y.classList.remove('js-password--hidden')
            }
        });

    // -----click function-----


    // -----keycode function-----

        $('#resetNewPassword').keypress(function(event) {
            if((event.keyCode>=40&&event.keyCode<=43)||event.keyCode===35||event.keyCode===38) {
                event.preventDefault();
            }
        });

        $('#resetNewPassword').keydown(function(e){
            if(e.keyCode==9) {
                e.preventDefault();
                $('input[id="resetNewRePassword"]').focus()
            }
        });

        $('#resetNewRePassword').keypress(function(event) {
            if((event.keyCode>=40&&event.keyCode<=43)||event.keyCode===35||event.keyCode===38) {
                event.preventDefault();
            }
        });

    // -----keycode function-----


    // -----keyup function-----

        $('#resetNewPassword').keyup(function(event) {
            $(document).ready(checkResetPassword);
            var max_chars = 20;
            if ($(this).val().length >= max_chars) { 
                $(this).val($(this).val().substr(0, max_chars));
            }
        });

        $('#resetNewRePassword').keyup(function(event) {
            $(document).ready(checkResetPassword);
            var max_chars = 20;
            if ($(this).val().length >= max_chars) { 
                $(this).val($(this).val().substr(0, max_chars));
            }
        });

    // -----keyup function-----


    // -----validation-----

        function checkResetPassword() {
            var resetNewPassword = $('#resetNewPassword').val();
            var resetNewRePassword = $('#resetNewRePassword').val();
            if(resetNewPassword === "") {
                $("#errorResetNewPassword").html("The password is required and cannot be empty");
                $("#errorResetNewRePassword").empty();
                document.getElementById("resetNewPassword").style.borderColor = "red";
                document.getElementById("resetNewRePassword").style.borderColor = "red";
                $("#updatePasswordButton").attr("disabled", true);
                $("#updatePasswordButton").addClass("o-button--green-disabled");
            } 
            else if(resetNewPassword.length < 8) {
                $("#errorResetNewPassword").html("The password must be at least 8 characters long");
                $("#errorResetNewRePassword").empty();
                document.getElementById("resetNewPassword").style.borderColor = "red";
                document.getElementById("resetNewRePassword").style.borderColor = "red";
                $("#updatePasswordButton").attr("disabled", true);
                $("#updatePasswordButton").addClass("o-button--green-disabled");
            }
            else if(resetNewPassword.length > 20) {
                $("#errorResetNewPassword").html("The password must be less than 20 characters long");
                $("#errorResetNewRePassword").empty();
                document.getElementById("resetNewPassword").style.borderColor = "red";
                document.getElementById("resetNewRePassword").style.borderColor = "red";
                $("#updatePasswordButton").attr("disabled", true);
                $("#updatePasswordButton").addClass("o-button--green-disabled");
            }
            else if(resetNewPassword.match(/#.*/) || resetNewPassword.match(/\+.*/) || resetNewPassword.match(/&.*/) || resetNewPassword.match(/\*.*/) || resetNewPassword.match(/\(.*/)|| resetNewPassword.match(/\).*/)) {
                $("#errorResetNewPassword").html("The password cannot consist of number and plus sign, ampersand, asterisk, left and right parenthesis");
                $("#errorResetNewRePassword").empty();
                document.getElementById("resetNewPassword").style.borderColor = "red";
                document.getElementById("resetNewRePassword").style.borderColor = "red";
                $("#updatePasswordButton").attr("disabled", true);
                $("#updatePasswordButton").addClass("o-button--green-disabled");
            }
            else if(resetNewPassword !== resetNewRePassword) {
                $("#errorResetNewPassword").empty();
                $("#errorResetNewRePassword").html("The password and its confirm are not the same");
                document.getElementById("resetNewPassword").style.borderColor = "red";
                document.getElementById("resetNewRePassword").style.borderColor = "red";
                $("#changePasswordButton").attr("disabled", true);
                $("#changePasswordButton").addClass("o-button--green-disabled");
            }
            else {
                $("#errorResetNewPassword").empty();
                $("#errorResetNewRePassword").empty();
                document.getElementById("resetNewPassword").style.borderColor = "green";
                document.getElementById("resetNewRePassword").style.borderColor = "green";
                $("#updatePasswordButton").removeAttr("disabled");
                $("#updatePasswordButton").removeClass("o-button--green-disabled");
            }
        }

    // -----validation-----


//================ R E S E T ==============



//================ E V E N T L A N D I N G ==============


    function event_listing(event_id) {
        window.location='<?php echo base_url("events/view") ?>'+'/'+event_id;
    }

    function showAllDates() {
        document.getElementById("availableDates").classList.toggle("show");
    }

    function getDateEventsByLongTitle() {
        var event_long_title = $('#event_long_title').val();  
        $.ajax({  
            url:  "<?php echo base_url('events/getEventsByTitle'); ?>",  
            method:"POST",  
            data:{event_long_title:event_long_title},  
            dataType:"json",  
            global:false,
            success:function(data) {  
                length = data.length;
                for (i = 0; i < data.length; i++) {
                    event_date = getEventDateShort(data[i].event_date_time);
                    event_time = getEventTime(data[i].event_date_time);

                    $("#date_time_ul").append("<div class='c-custom-select__option' event_id='" + data[i].event_id + "' onclick='displayLoading();event_listing("+data[i].event_id+")'><span class='date' id='" + data[i].event_id + "'>"+ event_date +"</span><span class='time' id=''>"+ event_time +"</span></div>");

                    if(length > 4) {
                        $(".dropdown-content").attr("style", "height: 300px;overflow-y: scroll;");
                    }
                }
                if(length > 1) {
                    $("#multipleDatesText").show();
                    $("#multipleDates").show();
                } else {
                    $("#oneDate").show();
                    $(".c-custom-select").attr("style", "background-color: #13B997;");
                }
            }  
        });  
    }

    function unavailableTickets() {
        $("select#events_section option").filter( "[available='0']" ).attr( 'disabled', 'disabled' );
    }

    function decreaseQuantity(row){
        value = $(".quantity.row"+row).val();
        fvalue = parseInt(value) - 1;
        val = minmax(fvalue, 1, 10);
        $(".quantity.row"+row).val(val);
        checkTransactionFields(row);
    }

    function increaseQuantity(row){
        value = $(".quantity.row"+row).val();
        fvalue = parseInt(value) + 1;
        val = minmax(fvalue, 1, 10);
        $(".quantity.row"+row).val(val);
        checkTransactionFields(row);
    }

    function minmax(value, min, max) {
        if(parseInt(value) < 1 || isNaN(value)) 
            return 1; 
        else if(parseInt(value) > 10) 
            return 10; 
        else return value;
    }


//================ E V E N T L A N D I N G ==============



//================ T R A N S A C T I O N S ==============


    $('.addTicketsButton').click(function() {
        displayLoading();
        event_id = $(this).attr("event_id");
        event_long_title = $("#event_long_title").val();
        row = $(this).attr("row");
        section_type = $(this).attr("section_type");
        events_section = $(".events_section.row"+row).val();
        section_id = $(".events_section.row"+row +" option:selected").attr("section_id");
        price_id = $(".events_section.row"+row +" option:selected").attr("price_id");
        ticket_type_id = $(".events_section.row"+row +" option:selected").attr("ticket_type_id");
        qty = $(".quantity.row"+row).val();

        if(qty <= 0) {
            toastr.error('No quantity provided',{timeOut: 1000,fadeOut: 1000})
            setTimeout(function () {
                $(document).ready(checkTransactionFields(row));
                displayLoading();
            }, 500);
        } else if (events_section === "" || events_section === null){
            toastr.error('No section selected',{timeOut: 1000,fadeOut: 1000})
            setTimeout(function () {
                $(document).ready(checkTransactionFields(row));
                displayLoading();
            }, 500);
        } else {
            $.ajax({
                type : "POST",
                url:  "<?php echo base_url('transactions/checkPromo'); ?>",  
                dataType : "text",
                global:false,
                data : {
                    event_id:event_id
                },
                success: function(response) {
                    var result = $(response).find("result").text();
                    if(result === "1") {
                        setTimeout(function () {
                            $("#promoModal").addClass("c-modal--is-open");  
                            $("#promoModal").removeClass("c-modal--is-close");
                        },500);
                    } else {
                        if(event_long_title.match(/3OTH SEAGAMES.*/)) {
                            addTicketFunctionSegame(event_id, row, section_type, price_id, ticket_type_id, qty);
                        }
                        else {
                            addTicketFunction(event_id, row, section_type, price_id, ticket_type_id, qty);
                        }
                    }
                }
            });
        }
    });

    function addTicketFunction(event_id, row, section_type, price_id, ticket_type_id, qty) {
        $.ajax({
            type : "POST",
            url:  "<?php echo base_url('transactions/addTickets'); ?>",  
            dataType : "text",
            data : {
                event_id:event_id,
                section_type:section_type,
                section_id:section_id,
                price_id:price_id,
                ticket_type_id:ticket_type_id,
                qty:qty
            },
            success: function(response) {
                if (response==="<root><result>Success</result><qty>ALL</qty></root>") {
                    $.when( refreshSelectedSeats() ).done(function() {
                        toastr.success("Successfully added",{timeOut: 1000,fadeOut: 1000})
                    });
                }
                else if(response.match(/ER:06:21.*/)) {
                    toastr.error("You have exceeded the number of tickets allowed for this event",{timeOut: 1000,fadeOut: 1000})
                }
                else if(response==="expired") {
                    toastr.error('Session Expired',{timeOut: 1000,fadeOut: 1000})
                    setTimeout(function () {
                        window.location.reload();
                    }, 500);
                }
                else {
                    $.when( refreshSelectedSeats() ).done(function() {
                        var result = $(response).find("qty").text();
                        toastr.error("You have exceeded the number of tickets allowed for this event. Selected ticket will be reduced to "+result+" ticket/s",{timeOut: 1000,fadeOut: 1000})
                    });
                }
            }
        }); 
    }

    // function addTicketFunctionSegame(event_id, row, section_type, price_id, ticket_type_id, qty) {
    //     var total_amount = $("#total_amount_ticket").val(),
    //     promo_modal = $("#checkSeagamePromo").val();

    //     $.ajax({
    //         type : "POST",
    //         url:  "<?php echo base_url('transactions/addTickets'); ?>",  
    //         dataType : "text",
    //         data : {
    //             event_id:event_id,
    //             section_type:section_type,
    //             section_id:section_id,
    //             price_id:price_id,
    //             ticket_type_id:ticket_type_id,
    //             qty:qty
    //         },
    //         success: function(response) {
    //             console.log(total_amount);
    //             if (response==="<root><result>Success</result><qty>ALL</qty></root>") {
    //                 $.when( refreshSelectedSeats() ).done(function() {
    //                     toastr.success("Successfully added",{timeOut: 1000,fadeOut: 1000})
    //                     if(total_amount >= 1000) {
    //                         if(promoModal !== "1") {
    //                             setTimeout(function () {
    //                                 $("#seagamePromoModal").addClass("c-modal--is-open");
    //                                 $("#seagamePromoModal").removeClass("c-modal--is-close");
    //                             }, 1000);
    //                         } else {
    //                             checkTotalAmount();
    //                         }
    //                     } 
    //                 });
    //             }
    //             else if(response.match(/ER:06:21.*/)) {
    //                 toastr.error("You have exceeded the number of tickets allowed for this event",{timeOut: 1000,fadeOut: 1000})
    //             }
    //             else if(response==="expired") {
    //                 toastr.error('Session Expired',{timeOut: 1000,fadeOut: 1000})
    //                 setTimeout(function () {
    //                     window.location.reload();
    //                 }, 500);
    //             }
    //             else {
    //                 $.when( refreshSelectedSeats() ).done(function() {
    //                     var result = $(response).find("qty").text();
    //                     toastr.error("You have exceeded the number of tickets allowed for this event. Selected ticket will be reduced to "+result+" ticket/s",{timeOut: 1000,fadeOut: 1000})
    //                     if(total_amount > 1000) {
    //                         if(promoModal !== "1") {
    //                             setTimeout(function () {
    //                                 $("#seagamePromoModal").addClass("c-modal--is-open");
    //                                 $("#seagamePromoModal").removeClass("c-modal--is-close");
    //                             }, 1000);
    //                         } else {
    //                             checkTotalAmount();
    //                         }
    //                     }
    //                 });
    //             }
    //         }
    //     }); 
    // }

    // UNSELECTED TICKETS CLICK FUNCTION
    function unselectedTickets(ticket_id, section_id) {
        var event_long_title = $("#event_long_title").val(); 
        displayLoading();
        
        $.ajax({
            type : "POST",
            url:  "<?php echo base_url('transactions/unselectedTickets'); ?>",  
            dataType : "text",
            data : {
                ticket_id:ticket_id,
                section_id:section_id
            },
            success: function(response) {
                if (response==='{"result":"Success"}') {
                    // if(event_long_title.match(/3OTH SEAGAMES.*/)) {
                    //     $.when( refreshSelectedSeats() ).done(function() {
                    //         toastr.success("Successfully removed",{timeOut: 1000,fadeOut: 1000})
                    //         checkTotalAmount();
                    //     });
                    // }
                    // else {
                        $.when( refreshSelectedSeats() ).done(function() {
                            toastr.success("Successfully removed",{timeOut: 1000,fadeOut: 1000})
                        });
                    // }
                }
                else if(response==='{"result":"No seat unselected"}') {
                    toastr.error('No seat unselected',{timeOut: 1000,fadeOut: 1000})
                }
                else if(response==="expired") {
                    toastr.error('Session Expired',{timeOut: 1000,fadeOut: 1000})
                    setTimeout(function () {
                        window.location.reload();
                    }, 500);
                }
                else {
                    $.when( refreshSelectedSeats() ).done(function() {
                        toastr.error(response,{timeOut: 1000,fadeOut: 1000})
                    });
                }
            }
        });
    }








    $('#proceedPromoButton').click(function() {
        promo_code = $("#promoCode").val();
        if(promo_code === "") {
            setTimeout(function () {
                $("#promoModal").removeClass("c-modal--is-open");  
                $("#promoModal").addClass("c-modal--is-close");
                displayLoading();
                setTimeout(function () {
                    $("#proceedPromoButton").attr("disabled", true);
                    $("#proceedPromoButton").addClass("o-button--green-disabled");
                    document.getElementById("promoCode").style.borderColor = "red";
                    $("#errorPromoCode").html("The promo code is required and cannot be empty");
                    $("#promoModal").addClass("c-modal--is-open");  
                    $("#promoModal").removeClass("c-modal--is-close");
                    toastr.error("The promo code is required and cannot be empty",{timeOut: 1000,fadeOut: 1000})
                    displayLoading();
                }, 1000);
            }, 500);
        } else {
            $("#errorPromoCode").empty();
            document.getElementById("promoCode").style.borderColor = "green";
            $.ajax({
                type : "POST",
                url:  "<?php echo base_url('transactions/availPromo'); ?>",  
                dataType : "text",
                data : {
                    event_id:event_id,
                    price_id:price_id,
                    promo_code:promo_code
                },
                success: function(response) {
                    // console.log(response);
                    var result = $(response).find("result").text();
                    if(result === "Invalid") {
                        setTimeout(function () {
                            $("#promoModal").removeClass("c-modal--is-open");  
                            $("#promoModal").addClass("c-modal--is-close");
                            displayLoading();
                            setTimeout(function () {
                                $("#promoModal").addClass("c-modal--is-open");  
                                $("#promoModal").removeClass("c-modal--is-close");
                                toastr.error("The input is not a valid promo code",{timeOut: 1000,fadeOut: 1000})
                                $("#errorPromoCode").html("The input is not a valid promo code");
                                document.getElementById("promoCode").style.borderColor = "red";
                                displayLoading();
                            }, 1000);
                        }, 500);
                    } else {
                        var ticketTypeID = $(response).find("ticket_type_id").text();
                        setTimeout(function () {
                            $("#errorPromoCode").empty();
                            document.getElementById("promoCode").style.borderColor = "green";
                            $("#promoModal").removeClass("c-modal--is-open");  
                            $("#promoModal").addClass("c-modal--is-close");
                            displayLoading();
                            setTimeout(function () {
                                addTicketFunction(event_id, row, section_type, price_id, ticketTypeID, qty)
                            }, 1000);
                        },500);
                    }
                }
            });
        }
    });

    $('#skipPromoButton').click(function() {
        document.body.classList.remove('c-modal--body-lock');
        setTimeout(function () {
            $("#promoModal").removeClass("c-modal--is-open");  
            $("#promoModal").addClass("c-modal--is-close");  
            displayLoading();
            addTicketFunction(event_id, row, section_type, price_id, ticket_type_id, qty)
        }, 500);
    });

   


    $('#promoCode').keypress(function(event) {
        if(event.keyCode === 13) {
            event.preventDefault();
            document.getElementById("proceedPromoButton").click();
        }
    });

    $('#promoCode').keyup(function(event) {
        promoCode = $(this).val();
        if(promoCode === "") {
            $("#errorPromoCode").html("The promo code is required and cannot be empty");
            document.getElementById("promoCode").style.borderColor = "red";
            $("#proceedPromoButton").attr("disabled", true);
            $("#proceedPromoButton").addClass("o-button--green-disabled");
        } else {
            $("#errorPromoCode").empty();
            document.getElementById("promoCode").style.borderColor = "green";
            $("#proceedPromoButton").removeAttr("disabled");
            $("#proceedPromoButton").removeClass("o-button--green-disabled");
        }
    });

    $('.selectSeatsButton').click(function() {
        displayLoading();
        row = $(this).attr("row");
        event_id = $(this).attr("event_id");
        events_section = $(".events_section.row"+row).val();
        price_id = $(".events_section.row"+row +" option:selected").attr("price_id");
        price = $(".events_section.row"+row +" option:selected").attr("price");
        section_id = $(".events_section.row"+row +" option:selected").attr("section_id");
        ticket_type_id = "1";

        if(events_section === "" || events_section === null) {
            setTimeout(function () {
                $(document).ready(checkTransactionFields(row));
                toastr.error('No section selected.',{timeOut: 1000,fadeOut: 1000})
                displayLoading();
            }, 500);
        } else {
            $.ajax({
                type : "POST",
                url:  "<?php echo base_url('transactions/checkPromo'); ?>",  
                dataType : "text",
                data : {
                    event_id:event_id
                },
                success: function(response) {
                    // console.log(response);
                    var result = $(response).find("result").text();
                    if(result === "1") {
                        setTimeout(function () {
                            $("#promoModal2").addClass("c-modal--is-open");  
                            $("#promoModal2").removeClass("c-modal--is-close");
                            displayLoading();
                        },500);
                    } 
                    else {
                        selectSeatFunction(event_id, price, section_id, ticket_type_id)
                    }
                }
            });
        }
    });

    $('#proceedPromoButton2').click(function() {
        promo_code = $("#promoCode2").val();
        if(promo_code === "") {
            setTimeout(function () {
                $("#promoModal2").removeClass("c-modal--is-open");  
                $("#promoModal2").addClass("c-modal--is-close");
                displayLoading();
                setTimeout(function () {
                    $("#proceedPromoButton2").attr("disabled", true);
                    $("#proceedPromoButton2").addClass("o-button--green-disabled");
                    document.getElementById("promoCode2").style.borderColor = "red";
                    $("#errorPromoCode2").html("The promo code is required and cannot be empty");
                    $("#promoModal2").addClass("c-modal--is-open");  
                    $("#promoModal2").removeClass("c-modal--is-close");
                    toastr.error("The promo code is required and cannot be empty",{timeOut: 1000,fadeOut: 1000})
                    displayLoading();
                }, 1000);
            }, 500);
        } else {
            $("#errorPromoCode2").empty();
            document.getElementById("promoCode2").style.borderColor = "green";
            $.ajax({
                type : "POST",
                url:  "<?php echo base_url('transactions/availPromo'); ?>",  
                dataType : "text",
                data : {
                    event_id:event_id,
                    price_id:price_id,
                    promo_code:promo_code
                },
                success: function(response) {
                    // console.log(response);
                    var result = $(response).find("result").text();
                    if(result === "Invalid") {
                        setTimeout(function () {
                            $("#promoModal2").removeClass("c-modal--is-open");  
                            $("#promoModal2").addClass("c-modal--is-close");
                            displayLoading();
                            setTimeout(function () {
                                $("#promoModal2").addClass("c-modal--is-open");  
                                $("#promoModal2").removeClass("c-modal--is-close");
                                toastr.error("The input is not a valid promo code",{timeOut: 1000,fadeOut: 1000})
                                $("#errorPromoCode2").html("The input is not a valid promo code");
                                document.getElementById("promoCode2").style.borderColor = "red";
                                displayLoading();
                            }, 1000);
                        }, 500);
                    } else {
                        var ticketTypeID = $(response).find("ticket_type_id").text();
                        var discountType = $(response).find("ticket_type_discount").text();
                        var discountPercent = $(response).find("ticket_type_discount_type").text();
                        totalprice = parseInt(price);
                        totalpercent = parseInt(discountType);
                        if(discountPercent === "Percentage") {
                            int_price = (totalprice/100)*totalpercent;
                            final_price = totalprice - parseInt(int_price);
                        } else if(discountPercent === "Amount") {
                            final_price = totalprice - totalpercent;
                        } else {
                            final_price = totalprice;
                        }
                        setTimeout(function () {
                            $("#errorPromoCode2").empty();
                            document.getElementById("promoCode2").style.borderColor = "green";
                            $("#promoModal2").removeClass("c-modal--is-open");  
                            $("#promoModal2").addClass("c-modal--is-close");
                            $("#promoCode2").val("");
                            displayLoading();
                            setTimeout(function () {
                                selectSeatFunction(event_id, final_price, section_id, ticketTypeID)
                            }, 1000);
                        },500);
                    }
                }
            });
        }
    });

    $('#skipPromoButton2').click(function() {
        document.body.classList.remove('c-modal--body-lock');
        setTimeout(function () {
            $("#promoModal2").removeClass("c-modal--is-open");  
            $("#promoModal2").addClass("c-modal--is-close");  
            displayLoading();
            setTimeout(function () {
                selectSeatFunction(event_id, price, section_id, "1")
            }, 1000);
        }, 500);
    });

    function selectSeatFunction(event_id, final_price, section_id, ticket_type_id) {
        price = final_price;
        $.ajax({
            type : "POST",
            url:  "<?php echo base_url('transactions/getSeats'); ?>",  
            dataType : "text",
            data : {
                event_id:event_id,
                section_id:section_id,
                price:price
           },
            success: function(response) {
                if(response==="expired") {
                    setTimeout(function () {
                        toastr.error('Session Expired',{timeOut: 1000,fadeOut: 1000})
                        displayLoading();
                    }, 500);
                    setTimeout(function () {window.location.reload();}, 1000);
                } else {
                    $("body").addClass("c-modal--body-lock");  
                    setTimeout(function () {
                        $("#seatSelect").removeClass("c-modal--is-close"); 
                        displayLoading();
                        $("#seatSelect").addClass("c-modal--is-open");  
                        // $(".thisisnull"p).attr("style", "display:none");
                    }, 500);
                    $("#js-seats").html(response);
                    $("#selectSeatsInfo").attr("eventid", event_id);
                    $("#selectSeatsInfo").attr("sectionid", section_id);
                    $("#selectSeatsInfo").attr("priceid", price_id);
                    $("#selectSeatsInfo").attr("ticket_type_id", ticket_type_id);
                }
            }
        });
    }

    $('#promoCode2').keypress(function(event) {
        if(event.keyCode === 13) {
            event.preventDefault();
            document.getElementById("proceedPromoButton2").click();
        }
    });

    $('#promoCode2').keyup(function(event) {
        promoCode = $(this).val();
        if(promoCode === "") {
            $("#errorPromoCode2").html("The promo code is required and cannot be empty");
            document.getElementById("promoCode2").style.borderColor = "red";
            $("#proceedPromoButton2").attr("disabled", true);
            $("#proceedPromoButton2").addClass("o-button--green-disabled");
        } else {
            $("#errorPromoCode2").empty();
            document.getElementById("promoCode2").style.borderColor = "green";
            $("#proceedPromoButton2").removeAttr("disabled");
            $("#proceedPromoButton2").removeClass("o-button--green-disabled");
        }
    });

    // GET SEATS CLICK FUNCTION
    $('.events_section').change(function() {
        row = $(this).attr("row");
        $(document).ready(checkTransactionFields(row));
    });

    

    // CHECKBOX CONSENT VALIDATION
    function checkConsent() {
        if($('#consentCheckbox').prop("checked") == false) {
            $("#checkout").attr("disabled", true);
            $("#checkout").addClass("o-button--green-disabled");
            $("#checkout").attr("Title", "Please read and check the full Terms & Conditions and Data Privacy Policy");
        } else {
            $("#checkout").removeAttr("disabled");
            $("#checkout").removeClass("o-button--green-disabled")
            $("#checkout").removeAttr("Title");
        }
    }

    // CONSENT CLICK FUNCTION
    $('#consentCheckbox').click(function() {
        $(document).ready(checkConsent);
    });

    // SECTION SELECT VALIDATION
    function checkTransactionFields(row) {
        var quantity = $('.quantity.row'+row).val();
        var section_selected = $('.events_section.row'+row).val();
        if (section_selected === "" || section_selected === null) {
            $(".addTicketsButton.row"+row).attr("disabled", true);
            $(".addTicketsButton.row"+row).addClass("o-button--green-disabled")
            $(".addTicketsButton.row"+row).attr("Title", "Select Section")
            $(".selectSeatsButton.row"+row).attr("disabled", true);
            $(".selectSeatsButton.row"+row).addClass("o-button--blue-disabled")
            $(".selectSeatsButton.row"+row).attr("Title", "Select Section");
        } else {
            $(".selectSeatsButton.row"+row).removeAttr("disabled");
            $(".selectSeatsButton.row"+row).removeClass("o-button--blue-disabled")
            $(".selectSeatsButton.row"+row).attr("Title", "")
            $(".addTicketsButton.row"+row).removeAttr("disabled");
            $(".addTicketsButton.row"+row).removeClass("o-button--green-disabled")
            $(".addTicketsButton.row"+row).attr("Title", "");
        }
    }

    // QUANTITY KEY UP FUNCTION
    $('.quantity').keyup(function() {
        var row = $(this).attr("row");
        checkTransactionFields(row);
    });

    // QUANTITY KEY UP FUNCTION
    $('#seagamesProceedPromoButton').click(function() {
        var event_id = $("#event_id").val(),
        ticket_type = 29;
        $("#seagamePromoModal").removeClass("c-modal--is-open");
        $("#seagamePromoModal").addClass("c-modal--is-close");
        displayLoading();
        
        $.ajax({
            type : "POST",
            url:  "<?php echo base_url('transactions/updateTicketType'); ?>",  
            dataType : "text",
            data : {
                event_id:event_id,
                ticket_type:ticket_type
            },
            success: function(response) {    
                refreshSelectedSeats();
                $("#checkSeagamePromo").val("1");
            }
        });
    });

    // ADD SEATS CLICK FUNCTION
    $('#addSeatsButton').click(function() {
        var title = $("#event_long_title").val(); 
        event_id = $("#selectSeatsInfo").attr("eventid");
        section_id = $("#selectSeatsInfo").attr("sectionid");
        price_id = $("#selectSeatsInfo").attr("priceid");
        ticket_type_id = $("#selectSeatsInfo").attr("ticket_type_id");
        seat = $("#selectSeatsInfo").attr("seat");

        var seats = $(".thisisavailable").map(function () {
            return $(this).attr('seat');
        }).get().join(',');

        if(seats === "") {
            setTimeout(function () {
                document.body.classList.remove('c-modal--body-lock');
                $("#seatSelect").removeClass("c-modal--is-open");  
                $("#seatSelect").addClass("c-modal--is-close");
                displayLoading();
                setTimeout(function () {
                    $("#seatSelect").addClass("c-modal--is-open");  
                    $("#seatSelect").removeClass("c-modal--is-close");
                    toastr.error("No seats selected!",{timeOut: 1000,fadeOut: 1000})
                    displayLoading();
                }, 1000);
            }, 500);
        }
        else {
            $.ajax({
                type : "POST",
                url:  "<?php echo base_url('transactions/addSeats'); ?>",  
                dataType : "json",
                data : {
                    event_id:event_id,
                    section_id:section_id,
                    price_id:price_id,
                    ticket_type_id:ticket_type_id,
                    seats:seats
                },
                success: function(response) {
                    // console.log(response);
                    if(response==="expired") {
                        setTimeout(function () {
                            document.body.classList.remove('c-modal--body-lock');
                            $("#seatSelect").removeClass("c-modal--is-open");  
                            $("#seatSelect").addClass("c-modal--is-close");
                            displayLoading();
                            setTimeout(function () {
                                toastr.error('Session Expired',{timeOut: 1000,fadeOut: 1000})
                                displayLoading();
                            }, 500);
                        }, 250);
                        setTimeout(function () {window.location.reload();}, 1000);
                    }
                    else if (response.match(/<success>.*/)) {
                        if(title.match(/3OTH SEAGAMES.*/)) {
                            document.body.classList.remove('c-modal--body-lock');
                            setTimeout(function () {
                                $("#seatSelect").addClass("c-modal--is-close");
                                displayLoading();
                                $("#seatSelect").removeClass("c-modal--is-open");
                                setTimeout(function () {
                                    refreshSelectedSeats();  
                                }, 500);
                             }, 250);

                            $.when( refreshSelectedSeats() ).done(function() {
                                setTimeout(function() { 
                                    toastr.success("Successfully added",{timeOut: 1000,fadeOut: 1000})
                                    setTimeout(function() { 
                                        checkTransactions();
                                        checkTotalAmount();
                                    }, 2000);
                                }, 1500);
                            });
                        }
                        else {
                            document.body.classList.remove('c-modal--body-lock');
                            setTimeout(function () {
                                $("#seatSelect").addClass("c-modal--is-close");
                                displayLoading();
                                $("#seatSelect").removeClass("c-modal--is-open");
                                setTimeout(function () {
                                    refreshSelectedSeats();  
                                }, 500);
                             }, 250);

                            $.when( refreshSelectedSeats() ).done(function() {
                                setTimeout(function() { 
                                    toastr.success("Successfully added",{timeOut: 1000,fadeOut: 1000})
                                    setTimeout(function() { 
                                        checkTransactions();
                                        displayLoading();
                                        $('html, body').animate({
                                            scrollTop: $("#div_transactions").offset().top
                                        }, 800);
                                    }, 2000);
                                }, 1500);
                            });
                        }
                    } 
                    else if(response.match(/ER:06:21.*/)) {
                        setTimeout(function () {
                            document.body.classList.remove('c-modal--body-lock');
                            $("#seatSelect").removeClass("c-modal--is-open");  
                            $("#seatSelect").addClass("c-modal--is-close");
                            displayLoading();
                            setTimeout(function () {
                                $("#seatSelect").addClass("c-modal--is-open");  
                                $("#seatSelect").removeClass("c-modal--is-close");
                                toastr.error("You have exceeded the number of tickets allowed for this event",{timeOut: 1000,fadeOut: 1000})
                                displayLoading();
                            }, 1000);
                        }, 500);
                    } 
                    else if(response.match(/<failed>.*/)) {
                        setTimeout(function () {
                            document.body.classList.remove('c-modal--body-lock');
                            $("#seatSelect").removeClass("c-modal--is-open");  
                            $("#seatSelect").addClass("c-modal--is-close");
                            displayLoading();
                            setTimeout(function () {
                                $("#seatSelect").addClass("c-modal--is-open");  
                                $("#seatSelect").removeClass("c-modal--is-close");
                                toastr.error("Failed!",{timeOut: 1000,fadeOut: 1000})
                                displayLoading();
                            }, 1000);
                        }, 500);
                    } 
                    else {
                        setTimeout(function () {
                            document.body.classList.remove('c-modal--body-lock');
                            $("#seatSelect").removeClass("c-modal--is-open");  
                            $("#seatSelect").addClass("c-modal--is-close");
                            displayLoading();
                            setTimeout(function () {
                                $("#seatSelect").addClass("c-modal--is-open");  
                                $("#seatSelect").removeClass("c-modal--is-close");
                                toastr.error(response,{timeOut: 1000,fadeOut: 1000})
                                displayLoading();
                            }, 1000);
                        }, 500);
                    }
                }
            });
        }
    });

    // ADD SEATS CLICK FUNCTION
    $('#addSeatsButtonMobile').click(function() {
        var title = $("#event_long_title").val(); 
        event_id = $("#selectSeatsInfo").attr("eventid");
        section_id = $("#selectSeatsInfo").attr("sectionid");
        price_id = $("#selectSeatsInfo").attr("priceid");
        ticket_type_id = $("#selectSeatsInfo").attr("ticket_type_id");
        seat = $("#selectSeatsInfo").attr("seat");

        var seats = $(".thisisavailable").map(function () {
            return $(this).attr('seat');
        }).get().join(',');

        if(seats === "") {
            setTimeout(function () {
                document.body.classList.remove('c-modal--body-lock');
                $("#seatSelect").removeClass("c-modal--is-open");  
                $("#seatSelect").addClass("c-modal--is-close");
                displayLoading();
                setTimeout(function () {
                    $("#seatSelect").addClass("c-modal--is-open");  
                    $("#seatSelect").removeClass("c-modal--is-close");
                    toastr.error("No seats selected!",{timeOut: 1000,fadeOut: 1000})
                    displayLoading();
                }, 1000);
            }, 500);
        }
        else {
            $.ajax({
                type : "POST",
                url:  "<?php echo base_url('transactions/addSeats'); ?>",  
                dataType : "json",
                data : {
                    event_id:event_id,
                    section_id:section_id,
                    price_id:price_id,
                    ticket_type_id:ticket_type_id,
                    seats:seats
                },
                success: function(response) {
                    // console.log(response);
                    if(response==="expired") {
                        setTimeout(function () {
                            document.body.classList.remove('c-modal--body-lock');
                            $("#seatSelect").removeClass("c-modal--is-open");  
                            $("#seatSelect").addClass("c-modal--is-close");
                            displayLoading();
                            setTimeout(function () {
                                toastr.error('Session Expired',{timeOut: 1000,fadeOut: 1000})
                                displayLoading();
                            }, 500);
                        }, 250);
                        setTimeout(function () {window.location.reload();}, 1000);
                    }
                    else if (response.match(/<success>.*/)) {
                        if(title.match(/3OTH SEAGAMES.*/)) {
                            document.body.classList.remove('c-modal--body-lock');
                            setTimeout(function () {
                                $("#seatSelect").addClass("c-modal--is-close");
                                displayLoading();
                                $("#seatSelect").removeClass("c-modal--is-open");
                                setTimeout(function () {
                                    refreshSelectedSeats();  
                                }, 500);
                             }, 250);

                            $.when( refreshSelectedSeats() ).done(function() {
                                setTimeout(function() { 
                                    toastr.success("Successfully added",{timeOut: 1000,fadeOut: 1000})
                                    setTimeout(function() { 
                                        checkTransactions();
                                        checkTotalAmount();
                                    }, 2000);
                                }, 1500);
                            });
                        }
                        else {
                            document.body.classList.remove('c-modal--body-lock');
                            setTimeout(function () {
                                $("#seatSelect").addClass("c-modal--is-close");
                                displayLoading();
                                $("#seatSelect").removeClass("c-modal--is-open");
                                setTimeout(function () {
                                    refreshSelectedSeats();  
                                }, 500);
                             }, 250);

                            $.when( refreshSelectedSeats() ).done(function() {
                                setTimeout(function() { 
                                    toastr.success("Successfully added",{timeOut: 1000,fadeOut: 1000})
                                    setTimeout(function() { 
                                        checkTransactions();
                                        displayLoading();
                                        $('html, body').animate({
                                            scrollTop: $("#div_transactions").offset().top
                                        }, 800);
                                    }, 2000);
                                }, 1500);
                            });
                        }
                    } 
                    else if(response.match(/ER:06:21.*/)) {
                        setTimeout(function () {
                            document.body.classList.remove('c-modal--body-lock');
                            $("#seatSelect").removeClass("c-modal--is-open");  
                            $("#seatSelect").addClass("c-modal--is-close");
                            displayLoading();
                            setTimeout(function () {
                                $("#seatSelect").addClass("c-modal--is-open");  
                                $("#seatSelect").removeClass("c-modal--is-close");
                                toastr.error("You have exceeded the number of tickets allowed for this event",{timeOut: 1000,fadeOut: 1000})
                                displayLoading();
                            }, 1000);
                        }, 500);
                    } 
                    else if(response.match(/<failed>.*/)) {
                        setTimeout(function () {
                            document.body.classList.remove('c-modal--body-lock');
                            $("#seatSelect").removeClass("c-modal--is-open");  
                            $("#seatSelect").addClass("c-modal--is-close");
                            displayLoading();
                            setTimeout(function () {
                                $("#seatSelect").addClass("c-modal--is-open");  
                                $("#seatSelect").removeClass("c-modal--is-close");
                                toastr.error("Failed!",{timeOut: 1000,fadeOut: 1000})
                                displayLoading();
                            }, 1000);
                        }, 500);
                    } 
                    else {
                        setTimeout(function () {
                            document.body.classList.remove('c-modal--body-lock');
                            $("#seatSelect").removeClass("c-modal--is-open");  
                            $("#seatSelect").addClass("c-modal--is-close");
                            displayLoading();
                            setTimeout(function () {
                                $("#seatSelect").addClass("c-modal--is-open");  
                                $("#seatSelect").removeClass("c-modal--is-close");
                                toastr.error(response,{timeOut: 1000,fadeOut: 1000})
                                displayLoading();
                            }, 1000);
                        }, 500);
                    }
                }
            });
        }
    });
    
    function checkTransactions() {
        if ($('#selected_tickets_ul li').length == 0) {
            $(".c-event__terms").attr("style", "display:none");
            $("#div_terms").attr("style", "display:none");
        }
        else {
            $(".c-event__terms").removeAttr("style");
            $("#div_terms").removeAttr("style");
        }
    }

    function refreshSelectedSeats() {
        $("#div_transactions").load(location.href + " #div_transactions");
        checkTransactions();
    }

    function closeSeagamePromoModal() {
        document.body.classList.remove('c-modal--body-lock');
        $("#seagamePromoModal").removeClass("c-modal--is-open");  
        $("#seagamePromoModal").addClass("c-modal--is-close");  
    } 


//================ T R A N S A C T I O N S ==============

</script>
