<!DOCTYPE html>
<html lang="en">
<body>
    <?php 
        $ids = array_column($events, 'event_long_title');
        $ids = array_unique($ids);
        $array = array_filter($events, function ($key, $value) use ($ids) {
            return in_array($value, array_keys($ids));
        }, ARRAY_FILTER_USE_BOTH);
        $arr = array_values($array);
        $category = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
    ?>
    <div class="c-list">
        <div class="o-content-wrap">
            <div class="c-list__header c-list__header--option-4">
                <div class="c-list__header-col">
                    <h1 class="h1 h1--title"><?php if($category === "smvenue") { echo "SM Venues"; } else if($category === "arena") { echo "SM MOA Arena"; } else if($category === "othervenue") { echo "Other Venues"; } else if($category === "artsscience") { echo "Arts & Science"; } else if($category === "performingarts") { echo "Performing Arts"; } else if($category === "hoteltravel") { echo "Hotel & Travel"; } else { echo $category; } ?>
                    </h1>
                    <div class="o-field-wrap">
                        <label for="" class="o-label o-label--option-2">Select Month</label>
                        <select class="o-input-dropdown o-input-dropdown--option-2 o-input-dropdown--long" id="eventsFilterMonth"> 
                            <option value="" selected disabled hidden></option>
                            <option value="January">January</option>
                            <option value="February">February</option>
                            <option value="March">March</option>
                            <option value="April">April</option>
                            <option value="May">May</option>
                            <option value="June">June</option>
                            <option value="July">July</option>
                            <option value="August">August</option>
                            <option value="September">September</option>
                            <option value="October">October</option>
                            <option value="November">November</option>
                            <option value="December">December</option>
                        </select>
                    </div>
                </div>
                <div class="c-list__header-col c-list__header-col--2col">
                    <div class="o-field-wrap">
                        <label for="" class="o-label o-label--option-2">Show</label>
                        <select name="" class="o-input-dropdown o-input-dropdown--option-2" id="eventsFilterShow" onchange="filterMonth()">
                            <option value="10">10</option>
                            <option value="20">20</option>
                            <option value="30">30</option>
                            <option value="40">40</option>
                            <option value="50">50</option>
                            <option value="60">60</option>
                            <option value="70">70</option>
                            <option value="80">80</option>
                            <option value="90">90</option>
                        </select>
                    </div>
                    <div class="o-field-wrap">
                        <label for="" class="o-label o-label--option-2">Filter by</label>
                        <input type="text" class="o-input-field o-input-field--long" id="search_event">
                        <!-- <select name="" id="" class="o-input-dropdown o-input-dropdown--option-2 o-input-dropdown--long">
                            <option value="f1" selected="selected" >Filter 1</option>
                            <option value="f2">Filter 2</option>
                            <option value="f3">Filter 3</option>
                            <option value="f4">Filter 4</option>
                        </select> -->
                    </div>
                    <!-- <div class="o-input-group o-input-group--small o-form__col">
                    <span class="o-label">Mobile Phone</span>
                    <input type="number" class="o-input-field" placeholder="Enter your mobile number">
                </div> -->
                </div>
            </div>
            <div  id="event_listing_based_date">
                  <ul class="c-list__items c-list__items--listings" id="event_ul">
                    <?php 
                    if(empty($array)) {
                        echo '<li id="no_record1">No matching records found</li>';
                    }
                    else {
                        foreach ($array as $event) {
                            $date_time = $event['event_date_time'];
                            $month = date("F",strtotime($date_time));?>
                            <li id="<?php echo $month ?>" class="event_li" event_id="<?php echo $event['event_id']; ?>">
                                
                                <div><?php echo $event['event_long_title']?></div>
                                <?php 
                                    $b = [];
                                    foreach($events as $key => $value){
                                        if($value['event_long_title']==$event['event_long_title']){
                                         $b[]=$value['event_date_time'];
                                        }
                                    }
                                    $count = count($b);
                                    $min = min($b);
                                    $minMonth = date("M",strtotime($min));
                                    $minDate = date("d",strtotime($min));
                                    $minYear = date("Y",strtotime($min));
                                    $minDate = $minMonth . " " . $minDate . ", " . $minYear;
                                    if($count > 1) {
                                        $max = max($b);
                                        $maxMonth = date("M",strtotime($max));
                                        $maxDate = date("d",strtotime($max));
                                        $maxYear = date("Y",strtotime($max));
                                        $maxDate = $maxMonth . " " . $maxDate . ", " . $maxYear;
                                        $date = $minDate . " - " . $maxDate;
                                    } else {
                                        $date = $minDate;
                                    }
                                ?>
                                <div>
                                    <span class="o-date"><?php echo $date?></span>
                                </div>
                                <div><?php echo $event['event_venue_name']?></div>
                                <?php $event_id = $event['event_id']; ?>
                                <button class="o-button o-button--green o-button--green-small" onclick="displayLoading(); window.location='<?php echo base_url("events/view/$event_id") ?>'">Buy Tickets</button>
                            </li><?php
                        } ?>
                    <?php }  ?>
                    <li id="no_record" style="display:none">No matching records found</li>
                    <li style="display:none"></li>
                </ul>
            </div>
            <ul class="c-pagination js-pagination" id="pagination">
                <li class="js-prev">Previous</li>
                <li class="js-next">Next</li>
            </ul>
        </div>
    </div>

    <?php 
        // echo "<pre>";
        // print_r($events);
       foreach ($arr as $key => $value){
          $arr[$key]  = preg_replace("/[^a-zA-Z0-9\s-]/", "", $value);
       }
    ?>

    <script>
        $(document).ready(function() {
            triggerShow();
        });

        function triggerShow() {
            $("#eventsFilterShow").val($("#eventsFilterShow option:eq(4)").val()).trigger('change');
            $("#eventsFilterShow").addClass("selected");
        }

        function eventsListArray(filter_month) {
            var original_array = JSON.parse('<?php echo JSON_encode($arr);?>'),
                new_array = [];

            if(filter_month !== null) {
                for (i = 0; i < original_array.length; i++) { 
                    var date = getEventMonth(original_array[i].event_date_time);

                    if(date === filter_month) {
                        a = new Object();
                        a.event_id          =   original_array[i].event_id;
                        new_array.push(a);
                    } 
                }
            }
            else {
                new_array = original_array;
            }

            return new_array;
        }
    </script>
</body>
</html>