<!DOCTYPE html>
<html lang="en">
<body>
    <?php 
        $date_time = $event['event_date_time'];
        $script = $event['event_scripts'];
        $event_parent = $event['event_parent'];
        $max_ticket = $event['event_max_ticket'];
        $month = date("F",strtotime($date_time));
        $date = date("d",strtotime($date_time));
        $year = date("Y",strtotime($date_time));
        $hour = date("H",strtotime($date_time));
        $minute = date("i",strtotime($date_time));
        
        if($hour > 12) {
            $hours = $hour - 12;
        }
        else {
            $hours = $hour;
        }
        if($hour > 11) {
            $period = 'PM';
        }
        else {
            $period = 'AM';
        }
        $event_date = $month . " " . $date . ", " . $year;
        $event_time = $hours . ":" . $minute . " " . $period;
    ?>
    <input type="hidden" name="" id="event_long_title" value="<?php echo $event['event_long_title'];?>">
    <input type="hidden" name="" id="event_id" value="<?php echo $event['event_id'];?>">
    <input type="hidden" name="" id="event_title" value="<?php echo $event['event_title'];?>">
    <div class="c-event-banner">
        <div class="o-content-wrap">
            <div class="o-image-wrap">
                <img src="<?php echo $event['event_image'];?>" alt="">
            </div>
            <div class="c-event-banner__details-row c-event-banner__details-row--mob-flr">
                <h1 class="h1 h1--title"><?php echo $event['event_title'];?></h1>
                <h3 class="h3 h3--option-1"><?php echo $event['venue_name'];?></h3>
            </div>
            <div class="c-event-banner__details">
                <div class="c-event-banner__details-row">
                    <h1 class="h1 h1--title"><?php echo $event['event_title'];?></h1>
                    <h3 class="h3 h3--option-1"><?php echo $event['venue_name'];?></h3>
                </div>
                <div class="c-event-banner__details-row">
                    <div class="c-custom-select">
                        <?php if($event_parent == "0") {?>
                        <div class="c-custom-select__option c-custom-select__option--one" event_id="<?php echo $event_date; ?>">
                            <span class="date"><?php echo $event_date; ?></span>
                            <span class="time"><?php echo $event_time;?></span>
                        </div><?php } else {?> 
                        <p class="p--medium">Select preferred date:</p>
                        <div class="c-custom-select__option c-custom-select__option--selected" onclick="showAllDates()" event_id="<?php echo $event_date; ?>">
                            <span class="date"><?php echo $event_date; ?></span>
                            <span class="time"><?php echo $event_time;?></span>
                        </div><?php } ?>
                        <div class="dropdown-content" id="availableDates">
                            <ul id="date_time_ul">
                                   
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <button class="o-button--text js-change js-modal-button">Show Details</button> 
            <div class="c-event-banner__description">
                <h1 class="h1">ABOUT</h1>
                <p>
                   <?php echo $event['event_title'];?>
                </p>
                <p>
                    <?php echo $event['event_description'];?>
                </p>
            </div>
        </div>
    </div>
    
    <div class="c-event">
        <div class="o-content-wrap">
            <div class="o-col">
                <h1 class="h1 h1--uppercase h1--border-bottom">Seat Plan</h1>
                <div class="o-image-wrap js-modal__trigger" data-target="imagepop">
                    <img src="<?php echo $event['seatplan_image'];?>" alt="">
                    <!-- <img src="http://lorempixel.com/output/nature-q-c-640-480-2.jpg" alt=""> -->
                </div>
                <h1 class="h1 h1--uppercase o-info__button js-modal-button">NOTICE TO ALL ONLINE CUSTOMERS</h1>
                <div class="o-text-wrap">
                    <h1 class="h1 h1--uppercase">NOTICE TO ALL ONLINE CUSTOMERS</h1>
                    <p class="p"><strong>Guidelines for Online Ticket Purchase.</strong> </p>
                    <p class="p">To protect all users from fraud and unintended misuse of credit cards, please note that the following should ALL bear the SAME NAME when buying tickets online:</p>
                    <ol class="ol--number">
                        <li>SM Tickets user account.</li>
                        <li>Credit card to be used.</li>
                        <li>1 valid ID to be presented for redemption.</li>
                    </ol>
                    <p class="p">Ticket redemption through a representative is NOT allowed. Only the cardholder who transacted online can redeem the ticket. To avoid any inconvenience, we request our patrons to comply with the above 
                        guidelines. The safety and security of our customers is always our top priority. By proceeding to payment, you agree with the above redemption process. Price is inclusive of standard ticket charges.</p>
                    <p class="p"><strong>Price is inclusive of standard ticket charges.</strong></p>
                </div>
            </div>
            <div class="o-col">
                <div class="c-list">
                    <h1 class="h1 h1--uppercase h1--border-bottom">Tickets</h1>
                    <div class="c-list__header c-list__header--option-1">
                        <div class="c-list__header-col">Location</div>
                        <div class="c-list__header-col"><?php if(isset($_SESSION['accessCode'])) { echo "Section"; }?></div>
                        <div class="c-list__header-col">Price</div>
                        <div class="c-list__header-col"><?php if(isset($_SESSION['accessCode'])) { echo "Quantity"; }?></div>  
                        
                    </div>
                    <div class="c-list__items c-list__items--option-1 c-list__items--zebra-odd">
                        <ul>
                            <?php
                            if(array_key_exists("price_name",$prices)) {     
                                $prices = array($prices);
                            }   
                            $itemIDs = 0;
                            foreach($prices as $price) {
                            $itemIDs++;?> 
                            <li>
                                <div><?php echo $price['price_name'] ?></div>
                                <?php 
                                if(isset($_SESSION['accessCode'])) { ?>                                    
                                    <div>
                                        <select row="<?php echo $itemIDs; ?>" class="o-input-dropdown events_section row<?php echo $itemIDs; ?>" id="events_section" name="events_section" onchange="checkTransactionFields(<?php echo $itemIDs ?>)">
                                            <option selected disabled>Select Section</option>
                                    <?php 
                                    foreach($price["sections"] as $sections_id) {
                                        if(!is_array($sections_id)){
                                            $sections_id = array($sections_id);
                                        }

                                        foreach($sections_id as $section_id) {
                                            if(array_key_exists("section_id",$sections)) {      
                                                $sections = array($sections);
                                            }
                                            foreach($sections as $section) {
                                               if($section["section_id"] == $section_id) {
                                                    $section_name = $section["section_name"];
                                                    $section_type = $section["section_type"];
                                                    $section_available = $section["section_available"];

                                                    if($section_available == "0") {
                                                        echo "
                                                        <option available='0' class='section_dropdown' section_id='".$section_id."' section_type='".$section_type."'section_name='".$section_name."' available='".$section_available."' event_id='".$event['event_id']."' price_id='".$price['price_id']."' ticket_type_id=1 row='".$itemIDs."' price='".$price['price_amount']."'>
                                                            ".$section_name." --unavailable
                                                        </option>";
                                                    } 
                                                    else {
                                                        echo "
                                                        <option class='section_dropdown' section_id='".$section_id."' section_type='".$section_type."'section_name='".$section_name."' available='".$section_available."' event_id='".$event['event_id']."' price_id='".$price['price_id']."' ticket_type_id=1 row='".$itemIDs."' price='".$price['price_amount']."'>
                                                            ".$section_name." 
                                                        </option>";
                                                    }   
                                                }
                                            }   
                                        } 
                                    }?>
                                        </select>
                                    </div>
                                <?php }
                                else { echo "<div></div>";} ?>
                                <div> <span class="">Price</span><?php echo '&#8369;&nbsp;'.number_format($price['price_amount'],2) ?></div>
                                <?php 
                                if(isset($_SESSION['accessCode'])) {
                                    $reserved_seats = "Reserved";

                                    if(stripos($section_type, $reserved_seats) !== FALSE){
                                        echo'
                                        <div>
                                            <button class="o-button--blue-disabled o-button o-button--blue o-button--blue-small js-modal__trigger selectSeatsButton row'.$itemIDs.'" data-target="seatselect" row="'.$itemIDs.'" id="select_seats" event_id="'.$event['event_id'].'" ticket_type_id="1" section_type="'.$section_type.'" disabled title="Select Section">Select Seats</button>
                                        </div>
                                        ';
                                    }
                                    else {
                                        echo'
                                        <div>
                                            <div class="c-seat-counter">
                                                <button class="o-button o-button--blue o-button--counter js-decrease"></button>
                                                <input type="text" value="1" class="js-count quantity row'.$itemIDs.'" row="'.$itemIDs.'">
                                                <button class="o-button o-button--blue o-button--counter js-increase"></button>
                                                <button class="o-button--green-disabled o-button o-button--green o-button--green-small js-add-seat addTicketsButton row'.$itemIDs.'" row="'.$itemIDs.'" event_id="'.$event['event_id'].'" ticket_type_id="1" section_type="'.$section_type.'" disabled title="Select Section">ADD
                                                </button>
                                            </div>
                                        </div>
                                        ';
                                    }
                                }
                                else {
                                    echo "<div></div>";
                                }?>
                            </li><?php
                            } ?>
                        </ul>
                    </div>
                </div>
                <?php if(isset($_SESSION['accessCode'])) { ?>
                <div id="div_transactions">
                    <?php if(!empty($transactions)) { ?>
                        <div class="c-list">
                            <h1 class="h1 h1--uppercase h1--border-bottom">Selected Tickets</h1>
                            <div class="c-list__header c-list__header--option-2">
                                <div class="c-list__header-col">Location</div>
                                <div class="c-list__header-col">Section</div>
                                <div class="c-list__header-col">Price</div>
                            </div>
                            <div class="c-list__items c-list__items--option-2 c-list__items--zebra-odd" id="selected_seats_div">
                                <ul id="selected_tickets_ul">
                                    <?php 
                                    $Seating_tickts = "Free Seating";
                                     // echo "<pre>"; print_r($transactions);
                                    if(array_key_exists("ticket_id",$transactions)) {     
                                        $transactions = array($transactions);
                                    }   

                                    $ticket_array = array_column($transactions, 'ticket_id');
                                    $list = implode(",",$ticket_array);
                                    foreach ($transactions as $transaction) { ;?>
                                    <li>
                                        <input type="hidden" id="ticket_id" value="<?php echo $list ?>">
                                        <div><?php echo $transaction['price_name'] ?></div>
                                        <div><?php echo $transaction['section_name'];
                                        if(stripos($transaction['ticket_seat'], $Seating_tickts) === FALSE && $transaction['ticket_row'] != "0") { echo "(" . $transaction['ticket_row'] . "/" . $transaction['ticket_seat'] .")"; }?>
                                        </div>
                                        <div>
                                            <span class=''>Price</span>
                                            <?php echo '&#8369;&nbsp;'.number_format($transaction['ticket_price'],2) ?>
                                        </div>
                                        <div>
                                            <button class='o-button' onclick='unselectedTickets("<?php echo $transaction['ticket_id'] ?>", "<?php echo $transaction['section_id'] ?>")'></button> 
                                        </div>
                                    </li><?php }?>
                                </ul>
                            </div>
                        </div>
                    <?php } ?>
                    <?php if(!empty($transactions)) { ?>
                        <div class="c-list">
                            <h1 class="h1 h1--uppercase h1--border-bottom">Order Summary</h1>
                            <div class="c-list__header c-list__header--option-3">
                                <div class="c-list__header-row">
                                    <?php echo $event['event_title'];?>
                                </div>
                                <div class="c-list__header-row">
                                   <?php echo $event_date. '  ' . $event_time;?>
                                </div>
                            </div>
                            <div class="c-list__items c-list__items--option-3 c-list__items--zebra-odd">
                                <ul id="summary_tickets_ul">
                                    <?php  
                                    $totalPrice=0;
                                    foreach($transactions as $k) {
                                        $totalPrice=$totalPrice+$k['ticket_price'];
                                    }
                                    $newarray=array();
                                    foreach($transactions as $k) {
                                        if(!in_array($k['section_name'], $newarray)) {
                                            array_push($newarray, $k['section_name']);
                                        }
                                    }

                                    $finalArray=array();
                                    foreach($newarray as $k) {
                                        $amount=0;
                                        $count=0;
                                        foreach($transactions as $l) {
                                            if($l['section_name']==$k) {
                                                $count++;
                                                $amount=$amount+$l['ticket_price'];
                                                $p=array('section_name'=>$l['section_name'], 'price_name'=>$l['price_name'], 'ticket_price'=>$l['ticket_price'] , 'amount'=>$amount ,'count'=>$count);
                                            }
                                        }
                                        array_push($finalArray, $p);
                                    }
                                    foreach($finalArray as $k){
                                        ?>      
                                        <li>
                                            <div><?php echo $k['price_name'] ?></div>
                                            <div>
                                                <?php echo $k['count'] ?>
                                                x
                                                
                                                <?php echo $k['section_name'] ?> 
                                                (
                                                    <?php echo '&#8369;&nbsp;'.number_format($k['ticket_price'],2) ?>
                                                )
                                            </div>
                                            <div>
                                                <span class="">Price</span>
                                                <?php echo '&#8369;&nbsp;'.number_format($k['amount'],2) ?>
                                            </div>
                                        </li>
                                    <?php } ?>                                      
                                   <?php 
                                    $count = 0;
                                    // $occurences = count($transactions);
                                    foreach($transactions as $transaction) {
                                        $count = $count+1;
                                        $total_amount_ticket = array_sum(array_column($transactions,'ticket_price')); }?>
                                        <li>
                                            <div>Online Fee</div>
                                            <div>
                                                <input type="hidden" id="count" value="<?php echo $count ?>">
                                                <?php echo $count . " x " . " &#8369;&nbsp;" .number_format($event['convenience_charge'],2);?>
                                            </div>
                                            <div>
                                                <span class="">Price</span>
                                                <?php $total_convenience = (int)$count * (int)$event['convenience_charge']; 
                                                echo "&#8369;&nbsp;" .number_format($total_convenience,2); ?>
                                            </div>
                                        </li>
                                    <li>
                                        <div>Total Ticket Price</div>
                                        <div>  
                                            <?php $total_amount = (int)$total_amount_ticket + (int)$total_convenience;
                                            echo '&#8369;&nbsp;'.number_format($total_amount,2); ?>
                                            <input type="hidden" id="total_amount" value="<?php echo number_format($total_amount, 2, '', ''); ?>">
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <?php } ?>
                <?php if(isset($_SESSION['accessCode'])) { ?>
                <div class="c-event__terms">
                    <p class="p">Before proceeding to payment, please read the full Terms & Conditions and Data Privacy Policy:</p>
                    <div class="">
                        <label class="container o-input-checkbox">
                            <input type="checkbox" id="consentCheckbox">
                            <span class="checkmark"></span>
                        </label>
                    <p class="p"> I agree to the <a href="<?php echo base_url() ?>terms#5">Terms & Conditions</a> and <a href="<?php echo base_url() ?>terms#2">Data Privacy Policy</a>.</p>
                    </div>
                    <div class="">
                        <label class="container o-input-checkbox">
                            <input type="checkbox">
                            <span class="checkmark"></span>
                        </label>
                    <p class="p"> I consent to receive information about SM Lifestyle Entertainment, Inc.'s products and services, promotional offers, contests, newsletters or other activities that may be of interest to me. I understand that SM Lifestyle Entertainment, Inc. will respect my wishes if I elect not to receive future correspondence about these activities. With each communication I receive, I will have the opportunity to indicate if I do not want to receive future communications.</p>
                    </div>
                <div id="div_terms">
                    </div>
                    <?php } ?><?php if(isset($_SESSION['accessCode'])) { ?>
                    <button style="float:right" class="o-button o-button--green o-button--green-disabled" id="checkout" disabled title="Please read and check the full Terms & Conditions and Data Privacy Policy">Proceed to Payment</button><?php } ?>
                    <!-- onclick="window.location='<?php echo base_url() ?>transactions/success'" -->
                </div>
            </div>
        </div>
    </div>

    <!-- MODAL EXAMPLE -->
    <div id="js-modal" class="c-modal c-modal--promo c-modal--is-close" data-modal="promo">
        <div class="c-modal-container">
            <div class="c-modal__content ">
                <div class="c-modal__desc">
                    <div class="c-modal__close"></div>
                    <div class="c-modal__step">
                        <div class="c-modal__title">
                            <h1 class="h1 h1--title">BDO PROMO</h1>
                        </div>
                        <p>Avail and enjoy <b> 15% discount</b> on your ticket through BDO Credit Card</p>
                        <button class="o-button o-button--green">Yes, I will use my BDO Card</button>
                        <a href="javascript:void(0)" class="o-button o-button--text">No, not this time.</a>
                    </div>
                    <div class="c-modal__step is-active">
                        <div class="c-modal__title">
                            <h1 class="h1 h1--title">ENTER PROMO CODE</h1>
                        </div>
                        <div class="o-input-group">
                            <span class="o-label">Promo Code</span>
                            <input class="o-input-field" placeholder="Enter promo code">
                            <span class="o-error">Invalid promo code</span>
                        </div>
                        <button class="o-button o-button--green">Proceed</button>
                        <a href="javascript:void(0)" class="o-button o-button--text">Skip this step</a>
                    </div>
                    <div class="c-modal__step ">
                        <div class="c-modal__title">
                            <h1 class="h1 h1--title">PROMO CODE</h1>
                        </div>
                        <p>You have availed 10% discount. Enjoy!</p>
                        <button class="o-button o-button--green">Proceed</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="js-modal" class="c-modal c-modal--imagepop c-modal--is-close " data-modal="imagepop">
        <div class="c-modal-container">
            <div class="c-modal__content ">
                <div class="c-modal__desc">
                    <div class="c-modal__close"></div>
                    <div id="js-modal__imagepop">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- MODAL EXAMPLE -->
    <div id="seatSelect" class="c-modal c-modal--seatselect c-modal--is-close" data-modal="seatselect" modal="seatSelect">
        <div class="c-modal-container" >
            <div class="c-modal__content c-modal__content--security">
                <div class="c-modal__head c-modal__head--seats">
                    <div class="c-modal__title">
                        <h1 class="h1 h1--title">Select your seat/s</h1>
                    </div>
                    <div class="c-modal__close"></div>
                </div>
                <div class="c-modal__desc">
                    <div class="c-seats__info-row c-seats__info-row-mobile">
                        <div class="">
                            <span class="c-seats__slot c-seats__slot--taken"></span>Taken
                        </div>
                        <div class="">
                            <span class="c-seats__slot c-seats__slot--selected"></span>  Selected
                        </div>
                        <div class="">
                            <span class="c-seats__slot c-seats__slot--available-legend"></span>  Available
                        </div>
                    </div>
                    <div id="js-seats" class="c-seats">
                     
  
 
						
                    </div>
                    <div class="c-seats__info">
                        <div class="c-seats__info-row">
                            <div class="">
                                <span class="c-seats__slot c-seats__slot--taken"></span>  Seats taken
                            </div>
                            <div class="">
                                <span class="c-seats__slot c-seats__slot--selected"></span>  Seats selected
                            </div>
                            <div class="">
                                <span class="c-seats__slot c-seats__slot--available-legend"></span>  Seats available
                            </div>
                        </div>
                        <div class="c-seats__info-row--2col">
                            <div class="">
                                <h2 class="h2">Number of seats</h2>
                                <span id="js-seat-count">0</span>
                            </div>
                            <div class="">
                                <div class="">
                                    <h2 class="h2">Amount</h2>
                                    <span id="js-amount">&#8369;&nbsp; 0.00</span>
                                </div>
                                <div class="">
                                    <h2 class="h2">Total Amount</h2>
                                    <span id="js-total-amount">&#8369;&nbsp; 0.00</span>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" id="selectSeatsInfo" ticket_type_id="1">
                        <button class="o-button o-button--green o-button--green-disabled" id="addSeatsButton" disabled>Confirm Seats</button>
                    </div>
                    <div class="c-seats__info c-seats__info-mobile">
                        <div class="c-seats__info-row">
                            <h2 class="h2">Total Amount</h2>
                            <span id="js-total-amount">Php 0.00</span>
                        </div>
                        <button class="o-button o-button--green o-button--green-disabled" id="js-seat-counter-button" disabled>Confirm Seats</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            getDateEventsByLongTitle(); // GET DATE EVENTS FOR LANDING OPTIONS
            unavailableTickets();  // UNAVAILABLE TICKETS
            checkTransactions(); // CHECK TRANSACTIONS
        });
    </script>
</body>
</html>