<?php
class Users_model extends CI_Model {

	public function accountActivation($username, $reg_key) {
		$data = array(
			'username' => $username,
			'reg_key' => $reg_key 
		);

		$result = $this->Parser_model->parse_post("api_accountActivation", $data);

		return $result;
	}

	public function userInfo($username) {
		$parameters = "?";

		if($username) {
			$parameters = "?username=" . $username;
		}

		$result = $this->Parser_model->parse_get("api_userInfo", $parameters);

		return $result;
	}

	public function userTransactions($customer_id) {
		$parameters = "?";

		if($customer_id) {
			$parameters = "?customerid=" . $customer_id;
		}

		$arr = $this->Parser_model->parse_get("api_userTransaction", $parameters);

		if(array_key_exists("trans_info",$arr)) {
			$trans_info = $arr['trans_info'];
			if(!array_key_exists(0,$trans_info)) {
				$trans_info = array($trans_info);
			}
		}
		else {
			$trans_info = array();
		}

		return $trans_info;
	}

	function userVoucher($transID) {
		$file_name = "voucher.pdf";
		$voucher = $this->config->item("api_voucher");
		$url =  $voucher . "/" . $transID . "/" . $_SESSION['accessCode'] . "/voucher.pdf";

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST'
			),
		);

		$context  = stream_context_create($options);

		$content = @file_get_contents($url, false, $context);

		if($content === false || $content === "" || empty($content)) {
			header("Location:" . base_url() . "users/disconnection" );
		}
		else if($content !== "invalid access") {
			header('Content-Type: application/octet-stream');
			header("Content-Transfer-Encoding: Binary"); 
			header("Content-disposition: attachment; filename=\"".$file_name."\""); 
			readfile($content);
			echo $content;
		}
		else {
			header("Location:" . base_url() . "/users/profile" );
		}
	}

	
	function userEticket($transID) {
		$file_name = "eticket.pdf";
		$voucher = $this->config->item("api_eticket");
		$url =  $voucher . "/" . $transID . "/" . $_SESSION['accessCode'];
		
		
		// die($url);
		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST'
			),
		);

		$context  = stream_context_create($options);

		$content = @file_get_contents($url, false, $context);

		if($content === false || $content === "" || empty($content)) {
			header("Location:" . base_url() . "users/disconnection" );
		}
		else if($content !== "invalid access") {
			header('Content-Type: application/octet-stream');
			header("Content-Transfer-Encoding: Binary"); 
			header("Content-disposition: attachment; filename=\"".$file_name."\""); 
			readfile($content);
			echo $content;
		}
		else {
			header("Location:" . base_url() . "/users/profile" );
		}
	}

	function userActicket($transID) {
		$file_name = "accesscodes.pdf";
		$voucher = $this->config->item("api_acticket");
		$url =  $voucher . "/" . $transID . "/" . $_SESSION['accessCode'];
		
		 
		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST'
			),
		);

		$context  = stream_context_create($options);

		$content = @file_get_contents($url, false, $context);

		if($content === false || $content === "" || empty($content)) {
			header("Location:" . base_url() . "users/disconnection" );
		}
		else if($content !== "invalid access") {
			header('Content-Type: application/octet-stream');
			header("Content-Transfer-Encoding: Binary"); 
			header("Content-disposition: attachment; filename=\"".$file_name."\""); 
			readfile($content);
			echo $content;
		}
		else {
			header("Location:" . base_url() . "/users/profile" );
		}
	}
	
	function officialReceipt($transID) {
		$file_name = "official_receipt_$transID.pdf";
		$voucher = $this->config->item("api_or");
		$url =  $voucher . "/" . $transID;
		
		 
		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST'
			),
		);

		$context  = stream_context_create($options);

		$content = @file_get_contents($url, false, $context);

		if($content === false || $content === "" || empty($content)) {
			header("Location:" . base_url() . "users/disconnection" );
		}
		else if($content !== "invalid access") {
			header('Content-Type: application/octet-stream');
			header("Content-Transfer-Encoding: Binary"); 
			header("Content-disposition: attachment; filename=\"".$file_name."\""); 
			readfile($content);
			echo $content;
		}
		else {
			header("Location:" . base_url() . "/users/profile" );
		}
	}

	
}