<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Parser_model extends CI_Model {

	function dpa($url_config=false, $parameters=false) {
		$url_i = $this->config->item($url_config);

		$url = $url_i . "/" . $_SESSION['username'];

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($parameters)
			),
		);

		$context  = stream_context_create($options);
		$result = @file_get_contents($url, false, $context);

		if($result === false) {
			redirect(base_url('users/failed'));
		} else {
			return $result;
		}
	}
	
	function parse_get($url_config=false, $parameters=false) {
		$url_i = $this->config->item($url_config);

		$url = $url_i . $parameters;
		
		$xml = @simplexml_load_file($url);
		if (false === $xml) {
			if($url_config === "api_getEventsTitle" || $url_config === "api_login" || $url_config === "api_getEventsByTitle") {
				return array("errorCode" => "ER:12:10", "errorMessage" => "An unknown error occurred");
			} else {
				redirect(base_url('users/failed'));
			}
		}
		else {
			$arr = json_decode( json_encode($xml) , 1);
			return $arr;
		}
	}

	function parse_post($url_config=false, $parameters=false) {
		$url = $this->config->item($url_config);

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($parameters)
			),
		);

		$context  = stream_context_create($options);
		$result = @file_get_contents($url, false, $context);

		if($result === false) {
			if($url_config === "api_login" || $url_config === "api_feedback" || $url_config === "api_addTickets" || $url_config === "api_addSeats" || $url_config === "api_checkPromo" || $url_config === "api_availPromo" || $url_config === "api_updateTicketType" || $url_config === "api_forgotPassword" || $url_config === "api_changePassword" || $url_config === "api_updatePassword") {
				return array("errorCode" => "ER:12:10", "errorMessage" => "An unknown error occurred");
			} else {
				redirect(base_url('users/failed'));
			}
		} else {
			return $result;
		}
	}

	function parse_post_xml($url_config=false, $parameters=false) {
		$url = $this->config->item($url_config);

		if($parameters == "") {
			$options = array(
				'http' => array(
					'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
					'method'  => 'POST'
				),
			);

		} else {
			$options = array(
				'http' => array(
					'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
					'method'  => 'POST',
					'content' => http_build_query($parameters)
				),
			);
		}

		
		$context  = stream_context_create($options);
		$result = @file_get_contents($url, false, $context);

		if($result === false) {
			if($url_config === "api_getEventsDate" || $url_config === "checkReservedTicket" || $url_config === "api_availReservedTicket" || $url_config === "api_unselectedTickets" || $url_config === "api_unselectedSections") {
				return array("errorCode" => "ER:12:10", "errorMessage" => "An unknown error occurred");
			} 
			else if($url_config === "api_paymentDone") {
				// redirect(base_url("transactions/process"));
				redirect(base_url("transactions/success"));
			}
			else {
				redirect(base_url("users/failed"));
			}
		} else {
			$validate_xml = $this->validateXML($result);

			if($validate_xml == "1") {
				$xml = new SimpleXMLElement($result);

				$arr =  json_decode( json_encode($xml) , 1);

				return $arr;
			}
			else {
				redirect(base_url("users/failed"));
			}
		}
	}

	function validateXML($xml) {
	    libxml_use_internal_errors( true );
	     
	    $doc = new DOMDocument('1.0', 'utf-8');
	     
	    $doc->loadXML( $xml );
	     
	    $errors = libxml_get_errors();
	     
	    return empty( $errors );
	}

	function response_logs($url , $data){
		
		$url = $this->config->item($url);

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);

		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
		
		
	}
	
	// $options = array(
	// 	"ssl"=>array(
	//         "verify_peer"=>false,
	//         "verify_peer_name"=>false
	//     ),
	// 	'http' => array(
	// 		'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
	// 		'method'  => 'POST',
	// 		'content' => http_build_query($data)
	// 	),
	// );
}