<?php
class Events_model extends CI_Model {

	function getEventsTitle() {
		$arr = $this->Parser_model->parse_get("api_getEventsTitle");

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else if(array_key_exists("errorCode",$arr)) {
			$event_array = $arr;
		}
		else {
			$event_array = array();
		}
		
		return $event_array;
	}

	function getFeaturedEvents() {
		$arr = $this->Parser_model->parse_get("api_getFeaturedEvents");

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}

		return $event_array;
	}

	public function getEventsByVenue() {
		$arr = $this->Parser_model->parse_get("api_getEventsByVenue");

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}

		return $event_array;
	}

	public function getEventsDate($data) {
		$arr = $this->Parser_model->parse_post_xml("api_getEventsDate", $data);
	
		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else if(array_key_exists("errorCode",$arr)) {
			$event_array = $arr;
		}
		else {
			$event_array = array();
		}

		return $event_array;
	}

	public function getEventsByVenueCategory($data) {
		$arr = $this->Parser_model->parse_post_xml("api_getEventsByVenue", $data);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}

		return $event_array;
	}

	public function getEventsByVenueCategoryAll($data) {
		$arr = $this->Parser_model->parse_post_xml("api_getEventsByVenueAll", $data);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}

		return $event_array;
	}


	public function getEventsByCategory($data) {
		$arr = $this->Parser_model->parse_post_xml("api_getEventsByCategory", $data);
		
		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}

		return $event_array;
	}

	public function getEventsByKey($data) {
		$arr = $this->Parser_model->parse_post_xml("api_getEventsByKey", $data);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];

			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else {
			$event_array = array();
		}

		return $event_array;
	}

	function getEventsByID($event_id) {
		$parameters = "?";

		if($event_id) {
			$parameters = "?eventid=" . $event_id;
		}

		$arr = $this->Parser_model->parse_get("api_getEventsById", $parameters);

				
		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
		}
		else {
			$event_array = array();
		}

		return $event_array;
	}

	public function getEventsByTitle($title) {
		$parameters = "?";

		if($title) {
			$parameters = "?eventlongtitle=" . $title;
		}

		$arr = $this->Parser_model->parse_get("api_getEventsByTitle", $parameters);

		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
			if(!array_key_exists(0,$event_array)) {
				$event_array = array($event_array);
			}
		}
		else if(array_key_exists("errorCode",$arr)) {
			$event_array = $arr;
		}
		else {
			$event_array = array();
		}

		return $event_array;
	}

	function getEventsByCluster($cluster) {
		$data = array(
			'cluster' => $cluster
		);

		$arr = $this->Parser_model->parse_post_xml("api_getEventsByCluster", $data);


		if(array_key_exists("event_info",$arr)) {
			$events_array = $arr['event_info'];
			if(!array_key_exists(0,$events_array)) {
				$events_array = array($events_array);
			}
		}
		else {
			$events_array = array();
		}
		
		return $events_array;
	}

	function getDisneyEvents() {
		$arr = $this->Parser_model->parse_post_xml("api_getDisneyEvents");

		if(array_key_exists("event_info",$arr)) {
			$events_array = $arr['event_info'];
			if(!array_key_exists(0,$events_array)) {
				$events_array = array($events_array);
			}
		}
		else {
			$events_array = array();
		}
		return $events_array;
	}
	function checkCustomer($event_id, $customer_id) {

		$data = array(
			   'customer_id' 	=> $customer_id,
			   'event_id' 		=> $event_id
		);

		$arr = $this->Parser_model->parse_post("api_checkCustomer", $data);
		
		return $arr;
	}
 
	function getMovies($data = false) {
		
		
		$arr = $this->Parser_model->parse_post_xml("api_get_movies",$data);

		if(array_key_exists("event_info",$arr)) {
			$events_array = $arr['event_info'];
			if(!array_key_exists(0,$events_array)) {
				$events_array = array($events_array);
			}
		}
		else {
			$events_array = array();
		}
		return $events_array;
	}

	function getMallMovies() {
		$arr = $this->Parser_model->parse_post_xml("api_get_mall_movies");

		if(array_key_exists("event_info",$arr)) {
			$events_array = $arr['event_info'];
			if(!array_key_exists(0,$events_array)) {
				$events_array = array($events_array);
			}
		}
		else {
			$events_array = array();
		}
		return $events_array;
	}

	 
	function getLandingEvents($data = false) {
		
		
		$arr = $this->Parser_model->parse_post_xml("api_get_landing_events",$data);

		if(array_key_exists("event_info",$arr)) {
			$events_array = $arr['event_info'];
			if(!array_key_exists(0,$events_array)) {
				$events_array = array($events_array);
			}
		}
		else {
			$events_array = array();
		}
		return $events_array;
	}

	function getCodeByEvent($event_id=false){
		$parameters = "?";

		if($event_id) {
			$parameters = "?eventid=" . $event_id;
		}

		$arr = $this->Parser_model->parse_get("api_getCodeByEvent", $parameters);

				
		if(array_key_exists("event_info",$arr)) {
			$event_array = $arr['event_info'];
		}
		else {
			$event_array = array();
		}

		return $event_array;
	}

}