<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends CI_Controller {

	// public function __construct() {
	// 	parent::__construct();
	// 	echo "<!DOCTYPE html>";
	// }

	function index() {
		$this->profile();
	}

	function profile() {
		$this->load->helper('captcha');
		if(isset($_SESSION['accessCode'])) {
			
			// numeric random number for captcha
			$random_number = substr(number_format(time() * rand(),0,'',''),0,6);
			// setting up captcha config
			$vals = array(
				 'word' => $random_number,
				 'img_path' => './captcha_images/',
				 'img_url' => base_url().'captcha_images/',
				 'img_width' => 140,
				 'img_height' => 32,
				 'expiration' => 7200
				);
			$result['captcha'] = create_captcha($vals);
			$this->session->set_userdata('captchaR',$result['captcha']['word']);


			$username = $_SESSION['username'];
			$id = $_SESSION['customer_id']; 
			$result['user_info'] = $this->Users_model->userInfo($username);
			$result['user_transactions'] = $this->Users_model->userTransactions($id);

			echo "<!DOCTYPE html>";
			$this->load->view('head');
			$this->load->view('header');
			$this->load->view('page-account', $result);
			$this->load->view('footer');
		}
		else {
			redirect(base_url());
		}
	}

	function profile2() {
		echo "<!DOCTYPE html>";

		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-account--resview2');
		$this->load->view('footer');
	}

	function profile3() {
		echo "<!DOCTYPE html>";

		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-account--resview3');
		$this->load->view('footer');
	}

	function register() {
		
 		if(!isset($_SESSION['accessCode'])) {
			echo "<!DOCTYPE html>";

			$this->load->view('head');
			$this->load->view('header');
			
			//for emws event
			if($this->session->userdata('token') != null){ 
				$this->load->view('page-register-ewms'); 
			}else{ 
				$this->load->view('page-register'); 
			} 
			
			$this->load->view('footer');
		}
		else {
			redirect(base_url());
		}
	} 

	function resetPassword($reset_key=false, $username=false) {
		$reset_key = $this->input->get_post('rs');
		$username = $this->input->get_post('username');

		if(!isset($_SESSION['accessCode'])) {
			$result['users'] = array(
				'reset_key' => $reset_key,
				'username' => $username
			);

			echo "<!DOCTYPE html>";
			$this->load->view('head');
			$this->load->view('header');
			$this->load->view('page-reset-password', $result);
			$this->load->view('footer');
		}
		else {
			redirect(base_url());
		}
	} 

	function registration() {
		
 		$customer_firstname = $this->input->post('fname');
		$customer_lastname = $this->input->post('lname');
		$customer_mobile_number = $this->input->post('mobile_number');
		$customer_email = $this->input->post('email');
		$customer_username = $this->input->post('username');
		$customer_password = $this->input->post('password');
		$customer_region = $this->input->post('region');
		$customer_city = $this->input->post('city');
		$customer_country = $this->input->post('country'); 
		$dpa = $this->input->post('dpa'); 
		$token = $this->input->post('token'); //ewms


		$url = $this->config->item('api_registration');
		$data = array(
			'fname' => $customer_firstname,
		   	'lname' => $customer_lastname,
		   	'mobile_number' => $customer_mobile_number,
		   	'email' => $customer_email,
		   	'username' => $customer_username,
		   	'password' => $customer_password,
		   	'region' => $customer_region,
		   	'city' => $customer_city,
		   	'country' => $customer_country,
		   	'dpa' => $dpa,
			'token' => $token

		);

		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		$context  = stream_context_create($options);
		$result = file_get_contents($url, false, $context);
	
		echo $result;
	} 

	function login() {
		$username = $this->input->post('username');
	    $password = $this->input->post('password');
		$partycode = "SMTICKETS";

	    $parameters = "?";

	    // if($username) {
	    	// $parameters = "?username=" . $username . "&password=" . $password . "&partycode=" . $partycode;
	    // }
		
		$data = array(
    		'username' => $username,
    	   	'password' => $password,
    	   	'partycode' => $partycode
    	);
	    
	    $result = $this->Parser_model->parse_post("api_login", $data);
		$xml = new SimpleXMLElement($result);
		$result = json_decode( json_encode($xml) , 1);
		 
	   	if(array_key_exists("accessCode",$result)) {
	    	$accessCode = $result["accessCode"];
	    	$dateTimeActivated = $result["dateTimeActivated"];
	    	$expiration =  $result["expiration"];
	    	$smsActive = $result["smsActive"];
	    	$email =  $result["email"];
	    	$customer_id = $result["customer_id"];
	    	$fname = $result["customer_fname"];
	    	$this->session->set_userdata('accessCode', $accessCode);
	    	$this->session->set_userdata('username', $username);
	    	$this->session->set_userdata('password', $password);
	    	$this->session->set_userdata('email', $email);
	    	$this->session->set_userdata('dateTimeActivated', $dateTimeActivated);
	    	$this->session->set_userdata('smsActive', $smsActive);
	    	$this->session->set_userdata('customer_id', $customer_id);
	    	$this->session->set_userdata('fname', $fname);
	    	$this->session->set_userdata('logged-in', 'logged-in');
			$msg = "You've logged in successfully";
	    }
	    else if(array_key_exists("errorCode",$result)) {
	    	$msg = $result;
	    }
	    
	    echo json_encode($msg);
	} 

	function forgotPassword() {
		$username = $this->input->post('resetUsername');
	    $email = $this->input->post('resetEmail');
    	$reset_url = base_url('users/resetPassword');

        $data = array(
    		'username' => $username,
    	   	'email' => $email,
    	   	'reset_url' => $reset_url
    	);

	    $result = $this->Parser_model->parse_post("api_forgotPassword", $data);

	    echo json_encode($result);
	} 

	function changePassword() {
	    $newPassword = $this->input->post('newPassword');

	    $data = array(
			'username' => $_SESSION["username"],
		   	'new_pass' => $newPassword,
		   	'old_pass' => $_SESSION["password"]
		);

	    $result = $this->Parser_model->parse_post("api_changePassword", $data);

		$this->session->set_userdata('password', $newPassword);

	    echo json_encode($result);
	} 

	function updatePassword() {
	    $reset_key = $this->input->post('resetKey');
	    $username = $this->input->post('username');
	    $newPassword = $this->input->post('newPassword');

	    $data = array(
			'new_pass' => $newPassword,
		   	'reset_key' => $reset_key,
		   	'username' => $username
		);

	    $result = $this->Parser_model->parse_post("api_updatePassword", $data);
	    
	    $this->session->set_userdata('password', $newPassword);

	    echo json_encode($result);
	}

	function logout() {
		$this->session->unset_userdata('accessCode');
		$this->session->unset_userdata('username');
		$this->session->unset_userdata('password');
		$this->session->unset_userdata('email');
		$this->session->unset_userdata('dateTimeActivated');
		$this->session->unset_userdata('smsActive');
		$this->session->unset_userdata('customer_id');
		$this->session->unset_userdata('logged-in');
		$this->session->sess_destroy();
		// $this->session->set_userdata('logged-in', 'logged-out');
		redirect(base_url());
	} 

	function resendEmailVerification() {
		$email = $this->input->post('email');

        $data = array('email' => $email);

	    $result = $this->Parser_model->parse_post("api_resendEmailVerification", $data);

	    echo json_encode($result);
	} 

	function voucher($transID) {
	    $result = $this->Users_model->userVoucher($transID);
		echo $result;
	}

	function failed() {
		echo "<!DOCTYPE html>";
	    $this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-failed');
		$this->load->view('footer');
	}

	function disconnection() {
		echo "<!DOCTYPE html>";
	    $this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-disconnection-profile');
		$this->load->view('footer');
	}

	function activation($username=false, $reg_key=false) {
		$result = $this->Users_model->accountActivation($username, $reg_key);

		if(stripos($result, "success") !== FALSE){
			echo "<!DOCTYPE html>";
		    $this->load->view('head');
			$this->load->view('header');
			$this->load->view('page-account-activation-success');
			$this->load->view('footer');
		} else {
			echo "<!DOCTYPE html>";
		    $this->load->view('head');
			$this->load->view('header');
			$this->load->view('page-account-activation-failed');
			$this->load->view('footer');
		}
	}

	
	function eticket($transID) {
		ini_set('user_agent',$this->agent->agent_string());
	    $result = $this->Users_model->userEticket($transID);
		echo $result;
	}

	function acticket($transID) {
		ini_set('user_agent',$this->agent->agent_string());
	    $result = $this->Users_model->userActicket($transID);
		echo $result;
	}
	
	function official_receipt($transID) {
	    $result = $this->Users_model->officialReceipt($transID);
		echo $result;
	}

	
}