<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Transactions extends CI_Controller {
	
	public function __construct() {
		parent::__construct();

		$this->load->model('helper_model', 'helper');
		if(!isset($_SESSION['accessCode'])) {
			$result = array("errorCode" => "ER:12:11", "errorMessage" => "Session Expired");
			echo json_encode($result);
			die();
		} 
	}

	function success() {
		$result['event_id'] = $this->input->get_post('event_id');
		$result['events'] = $this->Events_model->getEventsByVenue();
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-purchase-status-success', $result);
		$this->load->view('footer');
	}

	function failed() {
		$result['events'] = $this->input->get_post('event_id');

		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-purchase-status-failed', $result);
		$this->load->view('footer');
	} 

	function processing() {
		$result['events'] = $this->input->get_post('event_id');

		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-purchase-status-processing', $result);
		$this->load->view('footer');
	} 

	function failed_() {
		$result['events'] = $this->input->get_post('event_id');

		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-purchase-status', $result);
		$this->load->view('footer');
	} 

	function addTickets() {
		$event_id = $this->input->post('event_id');
		$section_type = $this->input->post('section_type');
		$section_id = $this->input->post('section_id');
		$price_id = $this->input->post('price_id');
		$ticket_type_id = $this->input->post('ticket_type_id');
		$qty = $this->input->post('qty');

		$data = array(
			'event_id' => $event_id,
			'section_type' => $section_type,
		   	'section_id' => $section_id,
		   	'price_id' => $price_id,
		   	'ticket_type_id' => $ticket_type_id,
		   	'session_id' => $_SESSION['accessCode'],
		   	'qty' => $qty
		);

		$result = $this->Parser_model->parse_post("api_addTickets", $data);
		
		echo json_encode($result);
	}

	function addSeats() {
		$event_id = $this->input->post('event_id');
		$section_id = $this->input->post('section_id');
		$price_id = $this->input->post('price_id');
		$ticket_type_id = $this->input->post('ticket_type_id');
		$seats = $this->input->post('seats');
		$array = explode(",",$seats);
		$str = serialize($array);

		$data = array(
			'event_id' => $event_id,
		   	'section_id' => $section_id,
		   	'price_id' => $price_id,
		   	'ticket_type_id' => $ticket_type_id,
		   	'session_id' => $_SESSION['accessCode'],
		   	'seats' => $str
		);
		$result = $this->Parser_model->parse_post("api_addSeats", $data);
		
		echo json_encode($result);
	}

	function checkPromo() {
		$event_id = $this->input->post('event_id');
		$price_id = $this->input->post('price_id');

		$data = array(
			'event_id' => $event_id,
			'price_id' => $price_id
		);

		$result = $this->Parser_model->parse_post("api_checkPromo", $data);
		
		echo json_encode($result);
	}

	function availPromo() {
		$event_id = $this->input->post('event_id');
		$price_id = $this->input->post('price_id');
		$promo_code = $this->input->post('promo_code');

		$data = array(
			'event_id' => $event_id,
			'price_id' => $price_id,
			'qr_code' => $promo_code
		);

		$result = $this->Parser_model->parse_post("api_availPromo", $data);
		
		if($result != "<root><result>Invalid</result></root>") {
			$promo_code_1 = $promo_code . "/" . $event_id;
 			$this->session->set_userdata('qr_code' . $event_id, $promo_code_1);

		}

		echo json_encode($result);
	}

	function getSeats() {
		$event_id = $this->input->post('event_id');
		$section_id = $this->input->post('section_id');
		$price = $this->input->post('price');
		$info = $this->Sections_model->getSectionSeats($section_id,$event_id);

		$maxCol = $info[0]['maxCol'];
		$maxRow = $info[0]['maxRow'];
		

		$newArray = array();


		// echo "<pre>";
		// print_r($info);

		
		



		if(!empty($info[0]['seatlist']['seat'])) {
			// COLUMN AISLES

			$column_aisles = array('column_aisles' => $info[0]['column_aisles']);

			foreach ($column_aisles['column_aisles'] as $c_arr) {

				if(!is_array($c_arr)) {
					$c_arr = array($c_arr);
				} 
				
				$column_aisles_array =  array('aisle' => $c_arr);
			}

			$column_aisles_count = count($column_aisles_array['aisle']);

			for ($i=0; $i < $column_aisles_count; $i++) { 
				foreach ($info[0]['seatlist']['seat'] as $key => $seats) {
					$seat = explode('|', $seats);
					$row = $seat[0];
					$column = $seat[1];
					$sys_row = $seat[2];
					$sys_col = $seat[3];

					if($sys_col == $column_aisles_array['aisle'][$i]) {
						$info[0]['seatlist']['seat'][$key] = $seats."|c";
					}
				}
			}		


			// echo "<pre>";
			// print_r($info[0]['seatlist']['seat']);
			// die();












			// ARRAY

			$seat_list_array = array();
			$count = 0;
			$count_1 = 0;

		    foreach ($info[0]['seatlist']['seat'] as $seats) {
		        $exists = 0;
		        $i=0;

		        $seat = explode("|", $seats);
		        $row 	= $seat[0];
		        $column = $seat[1];
				$row_name = $seat[2];
				$column_name = $seat[3];

				$seat_name = $row_name.$column_name;
				$seat_rows = preg_replace('/[^0-9]/', '', $seat[0]);
				$seat_column = preg_replace('/[^0-9]/', '', $seat[1]);
				$seat_details = $seat[0]."|".$seat[1]."|".$seat[2]."|".$seat[3];

				$seat_status = true;
				if($seat[5]=="0") {
					$seat_status = false;
				}

				$disabled_status = false;
				if($seat[4]=="1") {
					$disabled_status = true;
					$seat_status = false;
				}

				$column_status = false;
				if(isset($seat[6])) {
					if($seat[6]=="c") {
						$column_status = true;
					}
				}

		        foreach ($seat_list_array as $key2 => $value2) {
		            if($row_name == $value2['row']) 
		            { 
		            	$seat_list_array[$key2]['column'][] = array('seat_name'=>$seat_name, 'price'=>$price, 'seat'=>$seat_details, 'isAvailable'=>$seat_status, 'isDisabled'=>$disabled_status, 'isColumn'=>$column_status);
		            	$exists = 1;
		            	
		            }
		            $i++;
		            $count_1 = $count_1 + 1;
		        }

		        if( $exists == 0 ){
		            $seat_list_array[$i]['row'] = $row_name;
		            $seat_list_array[$i]['column'][] =array('seat_name'=>$seat_name, 'price'=>$price, 'seat'=>$seat_details, 'isAvailable'=>$seat_status, 'isDisabled'=>$disabled_status, 'isColumn'=>$column_status);
		        }
		        $count = $count + 1;
		    }   


		    // echo "<pre>";
		    // print_r($seat_list_array);
















		    // ROW AISLES
		    
		    $row_aisles = array('row_aisles' => $info[0]['row_aisles']);

		    foreach ($row_aisles['row_aisles'] as $r_arr) {

		    	if(!is_array($r_arr)) {
		    		$r_arr = array($r_arr);
		    	} 
		    	
		    	$row_aisles_array =  array('aisle' => $r_arr);
		    }

		    $row_aisles_count = count($row_aisles_array['aisle']);


		    for ($x = 0; $x < $row_aisles_count; $x++) { 
		    	$aisle_row = $row_aisles_array['aisle'][$x];
		    	
		    	for ($i=0; $i < $maxRow; $i++) { 

		    		$seat_row = $seat_list_array[$i]['row'];

		    		if($seat_row == $aisle_row) {
		    			for($y = 0; $y < $maxCol; $y++) {
		    				// $seat_list_array[$i]['column'][$y]['isRow'] = 1;
		    				$seat_list_array[$i]['isRow'] = true;
		    			} 
		    		} 
		    	}
		    }


		    // echo "<pre>";
		    // print_r($seat_list_array);












		    // STAGE

		    if($info[0]['stage'] == "Left") {
		    	$stage = 1;
		    }
		    else if($info[0]['stage'] == "Right") {
		    	$stage = 3;
		    }
		    else {
		    	$stage = 2;
		    }

		    $firstArray[] = array('stage-pos'=>$stage,"max-col"=>$info[0]['maxCol'],"max-row"=>$info[0]['maxRow'], "column"=>array());

		    $data = array_merge($firstArray, $seat_list_array);

			$data['seats']= json_encode($data);
		} else {
			$data = "NO SEATPLAN AVAILABLE";
		}
		

	    // echo "<pre>";
	    // print_r($data);





		$this->load->view('seats',$data);
	}

	function unselectedTickets() {
		$ticket_id = $this->input->post('ticket_id');
		$section_id = $this->input->post('section_id');

		$data = array(
			'ticket_id' => $ticket_id,
		   	'section_id' => $section_id
		);

		$result = $this->Parser_model->parse_post_xml("api_unselectedTickets", $data);

		echo json_encode($result);
	}

	function unselectedSections() {
		$event_id = $this->input->post('event_id');
		$section_id = $this->input->post('section_id');

		$data = array(
			'event_id' => $event_id,
		   	'section_id' => $section_id,
		   	'session_id' => $_SESSION['accessCode']
		);

		$result = $this->Parser_model->parse_post_xml("api_unselectedSections", $data);

		echo json_encode($result);
	}
	
	
	function payment_request() {
		
		 
		if(isset($_POST['dpa_checkbox'])){
			$dpa_status = serialize($_POST['dpa_checkbox']);
			
			$data = array( 
			   	'dpa' => $dpa_status
			);
			
			$result = $this->Parser_model->dpa("api_dpa", $data);
			 
		}
		  

		$status = $this->input->post('reserved_status');
		$username = $_SESSION["username"];
		$email = $_SESSION["email"];
		$event_id = $this->input->post('event_id');
		$event_title = $this->input->post('event_title');
		$total_amount = $this->input->post('total_amount');
		$ticket_array = $this->input->post('ticket_array');
		$qty = $this->input->post('count');
		$ticket_type_id = $this->input->post('ticket_type_id');
		$payment_type = $this->input->post('payment_type');

		if(isset($_SESSION['qr_code' . $event_id])) {
			$promo_code = explode("/", $_SESSION['qr_code' . $event_id]);
			$event_id_1 = $promo_code[1];
			if($event_id_1 === $event_id) {
				$qr_code = $promo_code[0];
			} else {
				$qr_code = "";
			}
		}

		// if(isset($_SESSION['ticket_type_id'])) {
		// 	$ticket_type = explode("/", $_SESSION['ticket_type_id']);
		// 	$event_id_2 = $ticket_type[1];
		// 	if($event_id_2 === $event_id) {
		// 		$ticket_type_id = $ticket_type[0];
		// 	} else {
		// 		$ticket_type_id = 1;
		// 	}
		// }

		// echo "<pre>";
		// print_r($_SESSION);
		// die(); 
		//11683 Nov 29-Dec 2 Wavy Baby  
		if($event_id == 1168333333){
			if($payment_type != 60){
				redirect('transactions/failed_?event_id='.$event_id);
				die();
			}
		}
		
		if($event_id == 11683 && in_array($this->input->post('price_id'), [60361,60362,60388])){ //wavy baby
			if($payment_type != 60){
				redirect('transactions/failed_?event_id='.$event_id);
				die();
			}
		}
		
		
		$trans_date = date("Y-m-d h:i:s");
		$prod_desc = $event_title . "|" . $qty . "|". $trans_date ."|". $ticket_array;
		$totalamount = number_format($total_amount, 2, '', '');

		if(isset($_POST['reserved_status'], $_POST['accessCode'])) {
			$data = array(
				'event_id' => $event_id,
			   	'session_id' => $_POST['accessCode'],
			   	'accesscode' => $_SESSION['accessCode']
			);

			
			

			$arr = $this->Parser_model->parse_post_xml("api_purchase_reserved", $data);
		}
		else {
			if($total_amount != $_SESSION[$event_id."total_amount"]) {
				redirect('transactions/failed_?event_id='.$event_id);
			} 
			else if($ticket_array != $_SESSION[$event_id."ticket_array"]) {
				redirect('transactions/failed_?event_id='.$event_id);
			} 
			else if($qty != $_SESSION[$event_id."count"]) {
				redirect('transactions/failed_?event_id='.$event_id);
			} else {
				if(isset($_SESSION['qr_code' . $event_id])) {
					$data = array(
						'event_id' => $event_id,
					   	'session_id' => $_SESSION['accessCode'],
						'ticket_array' => $ticket_array,
					   	'qr_code' => $qr_code
					);
				} else {
					$data = array(
						'event_id' => $event_id,
						'ticket_array' => $ticket_array,
					   	'session_id' => $_SESSION['accessCode']
					);
				}

				$arr = $this->Parser_model->parse_post_xml("api_purchase", $data);
			}
		}

		if(array_key_exists("trans_info",$arr)) {

			unset($_SESSION['qr_code' . $event_id]);
			//unset($_SESSION['ticket_type_id']);
			$ref = $arr['trans_info']['referenceNumber'];
			
			//PAYMAYA
			if($payment_type == 60){
				$this->paymaya_checkout($ref,$payment_type);
				die();
			}
			
			
			$params['amount'] = $total_amount;
 			$x =  $this->helper->getMerchantDetails($params); 
			$data['merchant_code'] = $x['merchantCode'];
			// $data['merchant_key'] = $x['merchantKey']; 
			
			//IPAY88
			$data['url'] = $this->config->item('ipay_url'); 
			
			// $prod_desc = $event_title . "|" . $qty . "|". $trans_date ."|". $t_id;
			$data['event_id'] = $event_id;
			$data['payment_id'] = $payment_type; 
			$data['paycode'] = 'IPAY';
			$data['currency'] = 'PHP';
			$data['prod_desc'] = $prod_desc;
			$data['refno'] = $ref;
			$data['username'] = $username; 
			$data['email'] = $email; 
			$data['contact'] = 'xxxxxxxxxxx';
			$data['remark'] = '';
			$data['total_amount'] = number_format($total_amount, 2, '.', '');
			$data['signature'] = $this->_prep_signature($x['merchantKey'], $data['merchant_code'], $ref, $totalamount, $data['currency']);
			
			$this->load->view('payment_request', $data);
		} else {
			redirect('transactions/failed_?event_id='.$event_id);
		}
	}
	
	function response_ipay($paycode = false, $event_id = false) {
		$merchantcode = $this->input->post('MerchantCode');
		$payment_id = $this->input->post('PaymentId');
		$referenceNumber = $this->input->post('RefNo');
		$amount = $this->input->post('Amount');
		$currency = $this->input->post('Currency');
		$remark = $this->input->post('Remark');
		$transid = $this->input->post('TransId');
		$authcode = $this->input->post('AuthCode');
		$status = $this->input->post('Status');
		$errdesc = $this->input->post('ErrDesc');
		$signature = $this->input->post('Signature');
		$ThreeDFlag = $this->input->post('ThreeDFlag');
		 
		$params['amount'] = round($amount, 0); 
		$x = $this->helper->getMerchantDetails($params);  
		$merchant_key = $x['merchantKey']; 
		
		
		$total_amount = number_format($this->input->post('Amount'), 2, '', '');
		$sig = $this->prep_signature($merchant_key, $merchantcode, $payment_id, $referenceNumber, $total_amount, $currency, $status);
		
		//check signature
	  	if($sig != $signature){ 
			redirect('transactions/failed?event_id='.$event_id);
 		}
 		else {
			if ($status == 1) {

				if($payment_id == 1){$paycode = 'IPAY';}
				if($payment_id == 3){$paycode = 'GCSH';}
				if($payment_id == 38){$paycode = 'GRAB';}
				
				$data = array(
					'referencenumber' => $referenceNumber,
					'paycode' => $paycode,
					'amount' => $total_amount
				);

				$arr = $this->Parser_model->parse_post_xml("api_paymentDone", $data);
				
				//add logs 
				$data = array(
					'referencenumber' => $referenceNumber,
					'paycode' => $paycode,
					'amount' => $amount,
					'type' => 'front',
					'status' => $status
				);
				
				$this->Parser_model->response_logs("api_log_response", $data);
				
				 
				 
				 
				if($event_id == 9704 && $this->session->userdata('token') != null){ //EWMS
				 
				
				$tickets = $this->session->userdata('9704ticket_array');
				$totalamount = $this->session->userdata('9704total_amount');
				$tix_count = count(explode(",",$tickets));
				
				$category = '';
				if($totalamount / $tix_count == 1650){
					 
					$category = 'EARLY BIRD ONLINE PASS';
				}
				$transaction_id = explode("-", $referenceNumber);
				$ewms_data = array(
					'customer_id' => $this->session->userdata('token'), //$this->session->userdata('token')
					'transaction_id' => $transaction_id[1],
					'ticket_id' => $tickets,
					'amount' => $totalamount,
					'category' => $category,
					'transaction_date' => date("Y-m-d"),
					 
					
				);
				
			 
				$this->ewms($ewms_data);
				
			
			}
			
			
				redirect('transactions/success?event_id='.$event_id);
			}
			else{
				redirect('transactions/failed?event_id='.$event_id);
			}
		}
	}
		 
	function prep_signature($merchant_key, $merchant_code, $payment_id, $ref_no, $total_amount, $currency, $status) {
 		return base64_encode(sha1($merchant_key . $merchant_code . $payment_id . $ref_no . $total_amount . $currency . $status, true));
	}
	 
	function _prep_signature($merchant_key, $merchant_code, $ref_no,$total_amount, $currency) {
		return base64_encode(sha1($merchant_key. $merchant_code . $ref_no . $total_amount . $currency, true));
	}
 
	function checkReservedTicket() {
		$result = [];
	    $payment_code = $this->input->post('paymentCode');
		if(!$payment_code || !$this->input->post('captcha')) die(json_encode($result));
		
		if ($this->check_captcha($this->input->post('captcha'))){
			 
		}else { 			  
			
			echo json_encode($result);
			$this->session->unset_userdata('captchaR');
			die();
		}
		
		
	    $data = array(
			'reservation_code' => $payment_code,
			'session_id' => $_SESSION['accessCode']
		);

	    $result = $this->Transactions_model->checkReservedTicket($data);

	    echo json_encode($result);
	} 

	function availReservedTicket() {
	   
		$result = [];
 		$transaction_id = $this->input->post('transaction_id');
		if(!$transaction_id || !$this->input->post('captcha')) die(json_encode($result));
		
		if ($this->check_captcha($this->input->post('captcha'))){
			 
		}else { 			  
			
			echo json_encode($result);
			$this->session->unset_userdata('captchaR');
			die();
		}
		
	    $data = array(
			'referencenumber' => $transaction_id,
			'session_id' => $_SESSION['accessCode']

		);

	    $result = $this->Transactions_model->availReservedTicket($data);

	    echo json_encode($result);
	} 

	function updateTicketType() {
	    $event_id = $this->input->post('event_id');
	    $ticket_type = $this->input->post('ticket_type');
	    $charge = $this->input->post('charge');

	    if(isset($_SESSION[$event_id."total_amount"])) {
	    	$total_charge = (int)$charge * (int)$_SESSION[$event_id."count"];
	    	$total_amount = (int)$_SESSION[$event_id."total_amount"] - (int)$total_charge;
	    	$total_amount_discount = (int)$total_amount * 0.1;
	    	$i_total_amount = (int)$total_amount - (int)$total_amount_discount;
	    	$f_total = (int)$i_total_amount + (int)$total_charge;
	    }

	    $data = array(
			'event_id' => $event_id,
			'session_id' => $_SESSION['accessCode'],
			'ticket_type' => $ticket_type
		);

	    $result = $this->Parser_model->parse_post("api_updateTicketType", $data);

	    if(is_array($result)) {
  			$ticket_type_id = $ticket_type . "/" . $event_id;
  			$this->session->set_userdata('ticket_type_id', $ticket_type_id);
  		}

	    echo json_encode($f_total);
	} 

		
	//COKE
	function payment_request_coke() {
		$event_id = $this->input->post('event_id');

		// if(isset($_SESSION['agree_coke'])) {
			// unset($_SESSION['agree_coke']);
			
			if(isset($_POST['dpa_checkbox'])) {
				$dpa_status = 1;
			} else {
				$dpa_status = 0;
			}

			$result = $this->Parser_model->dpa("api_dpa", $dpa_status);

			$status = $this->input->post('reserved_status');
			$username = $_SESSION["username"];
			$email = $_SESSION["email"];
			$event_title = $this->input->post('event_title');
			$total_amount = $this->input->post('total_amount');
			$ticket_array = $this->input->post('ticket_array');
			$qty = $this->input->post('count');
			$ticket_type_id = $this->input->post('ticket_type_id');

			if(isset($_SESSION['qr_code' . $event_id])) {
				$promo_code = explode("/", $_SESSION['qr_code' . $event_id]);
				$event_id_1 = $promo_code[1];
				if($event_id_1 === $event_id) {
					$qr_code = $promo_code[0];
				} else {
					$qr_code = "";
				}
			}

			$trans_date = date("Y-m-d h:i:s");
			$prod_desc = $event_title . "|" . $qty . "|". $trans_date ."|". $ticket_array;
			$totalamount = number_format($total_amount, 2, '', '');

			if(isset($_POST['reserved_status'], $_POST['accessCode'])) {
				$data = array(
					'event_id' => $event_id,
				   	'session_id' => $_POST['accessCode'],
				   	'accesscode' => $_SESSION['accessCode']
				);

				$arr = $this->Parser_model->parse_post_xml("api_purchase_reserved", $data);
			}
			else {
				if($total_amount != $_SESSION[$event_id."total_amount"]) {
					redirect('transactions/failed?event_id='.$event_id);
				} 
				else if($ticket_array != $_SESSION[$event_id."ticket_array"]) {
					redirect('transactions/failed?event_id='.$event_id);
				} 
				else if($qty != $_SESSION[$event_id."count"]) {
					redirect('transactions/failed?event_id='.$event_id);
				} else {
					if(isset($_SESSION['qr_code' . $event_id])) {
						$data = array(
							'event_id' => $event_id,
						   	'session_id' => $_SESSION['accessCode'],
							'ticket_array' => $ticket_array,
						   	'qr_code' => $qr_code
						);
					} else {
						$data = array(
							'event_id' => $event_id,
							'ticket_array' => $ticket_array,
						   	'session_id' => $_SESSION['accessCode']
						);
					}
					
					$arr = $this->Parser_model->parse_post_xml("api_purchase", $data);

					if(array_key_exists("trans_info",$arr)) {
						
						//finalize transaction	
						$total_amount = number_format($total_amount, 2, '', '');
						$referenceNumber = $arr['trans_info']['referenceNumber'];

						$data = array(
							'referencenumber' => $referenceNumber,
							'paycode' => 'IPAY',
							'amount' => $total_amount
						);
						
						sleep(1);
						$result = $this->Parser_model->parse_post_xml("api_paymentDoneCoke", $data);

						if(array_key_exists("trans_info",$arr)) {
							redirect('transactions/success');
						} else {
							redirect('transactions/failed?event_id='.$event_id);
						}
					} else {
						redirect('transactions/failed?event_id='.$event_id);
					}
				}
			}
		// } else {
			// redirect(base_url());
		// }
	}

	function checkCoke() {
		$event_id = $this->input->post('event_id');

		$data = array(
			'event_id' 		=> $event_id,
		   	'customer_id' 	=> $_SESSION['customer_id']
		);

		$arr = $this->Parser_model->parse_post("api_checkCoke", $data);
		
		echo json_encode($arr);
	}

	function checkWinner() {
		$data = array(
		   	'customer_id' 	=> $_SESSION['customer_id']
		);

		$arr = $this->Parser_model->parse_post("api_checkWinner", $data);
		
		echo json_encode($arr);
	}

	function agreeCoke() {
		$event_id = $this->input->post('event_id');

		$this->session->set_userdata('agree_coke', '1');

		echo "SUCCESS";
	}

	function ewms($data ){ 	
		
	 
		$options = array(
			'http' => array(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data)
			),
		);
		 

		
		$context  = stream_context_create($options);
		$result = @file_get_contents('https://ewms-philippines.com/apiv1/ticket_transaction.php', false, $context);
 		//echo $result;
	}

	
	//PAYMAYA
	function paymaya_checkout($referenceNumber ,$payment_type){
		
				
		$trans_date = date("Y-m-d h:i:s");
		  
		$totalAmount['value'] = $_POST['total_amount'];
		$totalAmount['currency'] = 'PHP';
		
		$buyer['firstName'] = $_SESSION['fname'];
 		$buyer['contact']['email'] = $_SESSION['email'];
		
		$items[0]['name'] = $_POST['event_title'];
		$items[0]['quantity'] = $_POST['count'];
		$items[0]['description'] =  $trans_date ."|". $_POST['ticket_array'];
		$items[0]['totalAmount']['value'] = $_POST['total_amount'];
		
		$redirectUrl['success'] = base_url() . 'transactions/paymaya_success/'.$_POST['event_id'] . '/' . $referenceNumber;
		$redirectUrl['failure'] = base_url() . 'transactions/failed?event_id=' .$_POST['event_id'];
		$redirectUrl['cancel'] = base_url() . 'transactions/failed?event_id='. $_POST['event_id'];
		
 		$data = array (
		  'totalAmount' => $totalAmount,
		  'buyer' => $buyer,
		  'items' => $items,
		  'redirectUrl' => $redirectUrl,
		  'requestReferenceNumber' => $referenceNumber 
		);

		// echo '<pre>';
		// print_r($data);
		// echo '</pre>';
		
		// die();
		//sandbox 
		//cGstclBpeWVJOEtncFFnNWNOc2ZneXpkY0N1aEJFRjlhaFZTeGxmak1lbFZ4bjo=
	
		 
		
		//prod
		//cGstTUsyR29HaVJiUWJnWFZSQ1F5cFBXSjl6ZWFvNGliSDkwMWU3ano3TlBkMzo=
		
		$curl = curl_init();

		curl_setopt_array($curl, array(
		  // CURLOPT_URL => 'https://pg-sandbox.paymaya.com/checkout/v1/checkouts',
		  CURLOPT_URL => $this->config->item('maya_url') . 'checkout/v1/checkouts',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		  CURLOPT_POSTFIELDS => json_encode($data),
		  CURLOPT_HTTPHEADER => array(
			'Authorization: Basic ' . $this->config->item('maya_pk'),
			'Content-Type: application/json'
		  ),
		));

		$response = curl_exec($curl);

		curl_close($curl);
 		$response = json_decode($response);
		
		// echo '<pre>';
		// print_r($response);
		// die();
		//log
		// $transaction_id = explode("-", $referenceNumber);
		// $post_data = array(
			// 'trans_id' => $transaction_id[1],
			// 'reference' => $response->checkoutId,
			// 'details' => serialize(array('n/a'))
		// );

		// $result = $this->Parser_model->parse_post("api_add_transaction_logs", $post_data);
		
 		
		header('Location: '.$response->redirectUrl);
		die();
		
		

	}
	
	function paymaya_success($event_id = false,$referenceNumber = false) {
		 
		if(!$event_id ||!$referenceNumber){
			
			redirect('transactions/failed?event_id='.$event_id);
			die();
		}
		 
	 
		//check payment status  
		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $this->config->item('maya_url') . 'payments/v1/payment-rrns/' . $referenceNumber,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => array(
			'Authorization: Basic ' . $this->config->item('maya_sk'),
		  ),
		));

		$response = curl_exec($curl);

		curl_close($curl);
 		
		$response = json_decode($response);
		 
		
		$isPaid = 0;
		$total_amount = 0;
		foreach($response as $x){
			if($x->isPaid == 1){
				$isPaid = 1;
			}
			$total_amount = $amount = $x->amount;
		}
		
 		$total_amount = number_format($total_amount, 2, '', '');
			 
			
		if($isPaid == 1){
			$paycode = 'PAYO';
			//logs 
			$logs = array(
				'referencenumber' => $referenceNumber,
				'paycode' => $paycode,
				'amount' => $amount,
				'type' => 'front',
				'status' => 1
			);
			
			$this->Parser_model->response_logs("api_log_response", $logs);
			
			
			$data = array(
				'referencenumber' => $referenceNumber,
				'paycode' => $paycode, //paymaya code
				'amount' => $total_amount
			);
			
			 
			$arr = $this->Parser_model->parse_post_xml("api_paymentDone", $data);
			
			redirect('transactions/success?event_id='.$event_id);
		}else{
			
			redirect('transactions/failed?event_id='.$event_id);
		}	 
		 
		   // echo '<pre>';
		// print_r($response);
		// print_r($data);
		// print_r($arr);
		 
	}
	
	 	
	public function check_captcha($str){
		$word = $this->session->userdata('captchaR');
		if(strcmp(strtoupper($str),strtoupper($word)) == 0){
		  return true;
		}
		else{
		  return false;
		}

	}
	  	
}