<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ipay extends CI_Controller {
	
	function backend_response($paycode = false, $merchant_key = false) {
		
		$merchantcode = $this->input->post('MerchantCode');
		$payment_id = $this->input->post('PaymentId');
		$referenceNumber = $this->input->post('RefNo');
		$amount = $this->input->post('Amount');
		$currency = $this->input->post('Currency');
		$remark = $this->input->post('Remark');
		$transid = $this->input->post('TransId');
		$authcode = $this->input->post('AuthCode');
		$status = $this->input->post('Status');
		$errdesc = $this->input->post('ErrDesc');
		$signature = $this->input->post('Signature');
		$ThreeDFlag = $this->input->post('ThreeDFlag');
		 
		if(!$merchant_key ){
			// redirect('transactions/failed');
			die();
		} 
			
		$total_amount = number_format($this->input->post('Amount'), 2, '', '');
		$sig = $this->prep_signature($merchant_key, $merchantcode, $payment_id, $referenceNumber, $total_amount, $currency, $status);
		
		//check signature
	  	if($sig != $signature){ 
			// redirect('transactions/failed');
			die();
 		}
 		else {
			if ($status == 1) {
					
				$data = array(
					'referencenumber' => $referenceNumber,
					'paycode' => 'IPAY',
					'amount' => $total_amount
				);

				$url = $this->config->item("api_paymentDone");

				$options = array(
					'http' => array(
						'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
						'method'  => 'POST',
						'content' => http_build_query($data)
					),
				);

				$context  = stream_context_create($options);
				$result = file_get_contents($url, false, $context);

				echo "RECEIVEOK";

				// if(array_key_exists("trans_info",$arr)) {
					// redirect('transactions/success');

				// } else {
					// redirect('transactions/failed');
					// die();
				// }
			}
			else{
				// redirect('transactions/failed');
				die();
			}
		}
	}

	function prep_signature($merchant_key, $merchant_code, $payment_id, $ref_no, $total_amount, $currency, $status) {
 		return base64_encode(sha1($merchant_key . $merchant_code . $payment_id . $ref_no . $total_amount . $currency . $status, true));
	}
}