<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Events extends CI_Controller {

	public function __construct() {
		parent::__construct();
		// echo "<!DOCTYPE html>";
		// header('Location: https://smtickets.com/maintenance/');
	}

	function index() {
		$this->home();
	}

	function home() {
		$result['events'] = $this->Events_model->getEventsByVenue();
		// $result['images'] = $this->Events_model->getFeaturedEvents();
		$events = $result['events'];
		$venues = array();
		$sorted_events = array();
		$sorted_venues = array();
		$result['images'] = array();
		if(isset($events)) {
			foreach($events as $x) {
				$arena['event_id'] = $x['event_id'];
				$arena['event_title'] = $x['event_title'];
				$arena['event_long_title'] = $x['event_long_title'];
				$arena['event_date_time'] = $x['event_date_time'];
				$arena['event_venue_category'] = $x['event_venue_category'];
				$arena['event_venue_name'] = $x['event_venue_name'];
				$arena['event_image'] = $x['event_image'];
				$arena['event_image_1'] = $x['event_image_1'];
				$arena['other_event_date_time'] = $x['other_event_date_time'];
				$venues[$x['event_id']] = $arena;
				$sorted_events = unserialize($x['event_ids']);
			}
		}
		
		foreach($sorted_events as $key=>$value){
			$sorted_venues[$key] = array();
			$eventids = explode(',',$value);
			foreach($eventids as $x){
				
				if(isset($venues[$x])){
					$sorted_venues[$key][] = $venues[$x];
				}
				
				 
			}
		}
		
		if(isset($sorted_venues['Carousel'])){
			
			$result['images'] = $sorted_venues['Carousel'];
		}
 		 
	  
		$result['venues'] = $sorted_venues;

		// Create a new CSRF token.
		if (! isset($_SESSION['csrf_token'])) {
			$_SESSION['csrf_token'] = base64_encode(openssl_random_pseudo_bytes(32));
		}

		echo "<!DOCTYPE html>";
 		$this->load->view('head');
		$this->load->view('header', $result);
		$this->load->view('main-slider', $result); 
		$this->load->view('page-home');
		$this->load->view('footer');
	}

	function listing($venue_category=false) {
		if ($venue_category == "") {
			redirect('events');
		}

		if($venue_category === "arena") {
			$venue_category = "MOA Arena";
		} else if ($venue_category === "smvenue") {
			$venue_category = "SM Venue";
		} else if ($venue_category === "othervenue") {
			$venue_category = "Other Venue";
		} else {
			$venue_category;
		}

		$data = array(
			'venue_category' => $venue_category
		);

		$result['events'] = $this->Events_model->getEventsByVenueCategoryAll($data);

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-event-listing', $result);
		$this->load->view('footer');
	} 

	function category($category=false) {
		if ($category == "") {
			redirect('events');
		}

		$data = array(
			'category' => $category
		);

		$result['events'] = $this->Events_model->getEventsByCategory($data);

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-event-listing', $result);
		$this->load->view('footer');
	} 

	function search($key=false) {
		$key_search = str_replace('%20', ' ', $key);

		if($key == "") {
			redirect('events');
		}

		$data = array(
			'match' => $key_search
		);

		$result["result"] = $this->Events_model->getEventsByKey($data);

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-search-results', $result);
		$this->load->view('footer');
	}

	function calendar() {
		// $result['events'] = $this->Events_model->getEventsDate();
		// $this->load->view('page-calendar', $result);
		echo "<!DOCTYPE html>";
		$this->load->view('page-calendar');
	}

	function view($event_id=0,$referrer = false) {
		if($event_id == "") {
			redirect('events');
		}
		if(!empty($_POST) && $event_id = '9704'){ //ewms
		 
		
			$ewms = array(
					'username'  => $_POST['username'],
					'password'  => $_POST['password'],
					'firstname'  => $_POST['firstname'],
					'lastname' => $_POST['lastname'],
					'email' => $_POST['email'],
					'country' => $_POST['country'],
					'mobile' => $_POST['mobile'],
					'region' => $_POST['region'],
					'city' => $_POST['city'],
					'token' => $_POST['token']
			);

			 $this->session->set_userdata($ewms);
		}
		
		
		if($event_id == 'kidzania') {
			$event_id = 5645;
		}
		
		
		if($event_id == '9505') {
			redirect('events/bowlingandskating');
		}
		
		
		if($event_id == '9700') {
			redirect('events/virtualtours');
		}
		
		
		if($event_id == 'email') {
			redirect("terms/dpa");
		}
		
		if($event_id == '9034') {
			redirect("events/miloonlinelessson");
		}
		
		
		
		$data['referrer'] = $referrer;
		
		$data['hot_events'] = "";
		if ($event_id=="undefined") {
			redirect('events');
		}
		else {
			$data["event"] = $this->Events_model->getEventsByID($event_id);
			$event_with_code = $this->Events_model->getCodeByEvent($event_id);
			if(count($event_with_code) > 0){
				$data['event_with_code'] = $event_with_code;
			}
			$bundle_event = array(4446,5301,4137,5165); 
			
			if(in_array($event_id,$bundle_event)) {
				$data['bundle'] = 1;
			}
			else {
				$data['bundle'] = 0;
			}
			
			$data['pixel_events_v2'] = array(5485); 
			
			if($data["event"]) {
				if(isset($_SESSION['accessCode'])) {
					$parameters = array(
						'event_id' => $event_id,
					   	'session_id' => $_SESSION['accessCode']
					);
					$data["transactions"] = $this->Transactions_model->getSelectedTickets($parameters);
				}
				$sections = $this->Sections_model->sections($event_id);	
				$data['prices'] = $this->Prices_model->prices($event_id);

			 
					
				if(!isset($sections[0])){ 
					$sections2[0] = $sections; 
					
				}else{
					$sections2 = $sections;
				}
				
				 
				$sections_arr = [];
				foreach($sections2 as $x){
					
					$sections_arr[$x['section_id']]['section_name'] = $x['section_name'];
					$sections_arr[$x['section_id']]['section_type'] = $x['section_type'];
					$sections_arr[$x['section_id']]['section_available'] = $x['section_available'];
				}
				$data['sections'] = $sections_arr;
				
			 
				 
				 
				
				$data['success_trans'] = 0;
				if(isset($_SESSION['customer_id'])) {
					$id = $_SESSION['customer_id'];
 					// $data["pending"] = $this->Events_model->getPendingTrans($event_id,$id);
					$user_transactions = $this->Users_model->userTransactions($id);	//check all success trans for this event
					$data['success_trans'] = 0;
					if(count($user_transactions)> 0){
						foreach($user_transactions as $x){ 
							if($x['event_id'] == $event_id){
								$data['success_trans'] = 1;
							}
						}
						
					}
						// die(count($user_transactions));
						// echo count($user_transactions);
					// echo '<pre>';
					// print_r($user_transactions);
					// die();
				}

				$data["trans_per_customer"] = '0';
				if(isset($_SESSION['customer_id'])) {
					$id = $_SESSION['customer_id'];
					$data["trans_per_customer"] = $this->Events_model->checkCustomer($event_id,$id);
				}
			
				if(!$data["event"]["convenience_charge"]) {
					$data["event"]["convenience_charge"] = 0;
				}
			}
			else {
				redirect(base_url());
			}
			
			
			$url = $this->config->item("api_base") . "v1/transaction/update_availability/" . $event_id; 
			$xml = file_get_contents($url); //To update availability
			

			echo "<!DOCTYPE html>";
			$this->load->view('head');
			$this->load->view('header');
			$this->load->view('page-event-landing', $data);	
			$this->load->view('footer');
		}
	}

	function getEventsTitle() {
 		$result = $this->Events_model->getEventsTitle();
		echo json_encode($result);
	}

	function getEventsByTitle() {
		$title = $this->input->get_post('event_long_title');
		$result = $this->Events_model->getEventsByTitle(urlencode($title));
		echo json_encode($result);
	}

	function getEventsDate() {
		$month = $this->input->post('month');
		$year = $this->input->post('year');

		$data = array(
			'month' => $month,
			'year' => $year
		);

		$result = $this->Events_model->getEventsDate($data);
		echo json_encode($result);
	}

	function seagames() {
		$result['mevents'] = $this->Events_model->getEventsByCluster("manila");
		$result['cevents'] = $this->Events_model->getEventsByCluster("clark");
		$result['sevents'] = $this->Events_model->getEventsByCluster("subic");
		$result['oevents'] = $this->Events_model->getEventsByCluster("others");
		
		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-seagames', $result);
		$this->load->view('footer');
	}

	function disney() {
		$result['events'] = $this->Events_model->getDisneyEvents();

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-disney', $result);
		$this->load->view('footer');
	}
	
	function redirect_seagames(){
		redirect('events/seagames');
	}

	function redirect_disney(){
		redirect('events/disney');
	}

	
	function redirect_cinema(){
		redirect('events/drive_in_cinema');
	}
	function drive_in_cinema() {
		$result['events'] = $this->Events_model->getMovies();

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-cinema', $result);
		$this->load->view('footer');
	}
	
	function redirect_skyranch(){
		redirect('events/skyranch');
	}

	function skyranch() {
		$result['bagiuo_events'] = $this->Events_model->getEventsByCluster("baguio");
		$result['pampanga_events'] = $this->Events_model->getEventsByCluster("pampanga");
		$result['tagaytay_events'] = $this->Events_model->getEventsByCluster("tagaytay");
 		
		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-skyranch', $result);
		$this->load->view('footer');
	}

	function smbythebay() {
		$result['manila_events'] = $this->Events_model->getEventsByCluster("manila");
		
		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-smbythebay', $result);
		$this->load->view('footer');
	}

	function redirect_lipa(){
		redirect('events/the_outlets_outdoor_cinema');
	}
	function the_outlets_outdoor_cinema() {
		$data['category'] = 'lipa';
		$result['events'] = $this->Events_model->getMovies($data);

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-cinema-lipa', $result);
		$this->load->view('footer');
	}
	
	function redirect_smcinema(){
		
		redirect('events/smcinema');
	}
	
	function smcinema() {
		$result['mevents'] = $this->Events_model->getMallMovies(); 
		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-smcinema', $result);
		$this->load->view('footer');
	}

	function redirect_ccpxsmoa(){
		
		redirect('events/ccpxsmoa');
	}
	
	function ccpxsmoa() {
		$data['notice'] = '';
		$data['code'] = '1';
		$data['events'] = $this->Events_model->getLandingEvents($data);
		
		$data['image1'] = "https://images1.smtickets.com/v3/resources/images/marketing/Nutcracker_Tuloy_ang_Pasko2020_1350x450.jpg";
		$data['image2'] = "https://images1.smtickets.com/v3/resources/images/marketing/Nutcracker_Tuloy_ang_Pasko2020_640x900.jpg";

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-landing', $data);
		$this->load->view('footer');
	}
	
	function bowlingandskating() {
		$data['notice'] = '';
		$data['code'] = '2';
		$data['events'] = $this->Events_model->getLandingEvents($data);
		
		$data['image1'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_03022021_1.jpg";
		$data['image2'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_portrait_03022021_1.jpg";

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-landing', $data);
		$this->load->view('footer');
	}
	
	  
	function virtualtours() {
		$data['notice'] = '';
		$data['code'] = '4';
		$data['events'] = $this->Events_model->getLandingEvents($data);
		
		$data['image1'] = "https://images1.smtickets.com/images/carousel_22032021095509.jpg";
		$data['image2'] = "https://images1.smtickets.com/images/portrait_22032021095625.jpg";

		$data['notice'] = "When you can’t physically travel, but want a chance to learn, reach out and connect with a new destination, Virtual guided tours are the perfect option . <br><br>
			You and  your family /friends/colleagues can join this real time interactive online  tour experience from  the comfort  of your home .<br><br>
			<span style='font-weight: bold;font-style: italic;'>The world  is  your oyster</span>";

 		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-landing', $data);
		$this->load->view('footer');
	}
	
	function miloonlinelessson() {
		$data['notice'] = '';
		$data['code'] = '5';
		$data['events'] = $this->Events_model->getLandingEvents($data);
		
		$data['image1'] = "https://images1.smtickets.com/images/carousel_20102021122640.jpg"; //landscape
		$data['image2'] = "https://images1.smtickets.com/images/portrait_07102021102504.jpg";

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-landing', $data);
		$this->load->view('footer');
	}
	
	function lany2022() {
		$data['notice'] = '';
		$data['code'] = 'lany';
		$data['events'] = $this->Events_model->getLandingEvents($data);
		
		$data['image1'] = "https://images1.smtickets.com/images/carousel_16062022162909.jpg"; //landscape
		$data['image2'] = "https://images1.smtickets.com/images/portrait_16062022095852.jpg";

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-landing', $data);
		$this->load->view('footer');
	}
	
	function affwomenschampionship2022manila() {
		$data['notice'] = '';
		$data['code'] = 'aff';
		$data['events'] = $this->Events_model->getLandingEvents($data);
		
		$data['image1'] = "https://images1.smtickets.com/images/carousel_01072022120546.jpg"; //landscape
		$data['image2'] = "https://images1.smtickets.com/images/portrait_01072022143214.jpg";

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-landing', $data);
		$this->load->view('footer');
	}
	
	function horanghae() {
		$data['notice'] = '';
		$data['code'] = 'seven';
		$data['events'] = $this->Events_model->getLandingEvents($data);
		
		$data['image1'] = "https://images1.smtickets.com/images/carousel_04072022130415.jpg"; //landscape
		$data['image2'] = "https://images1.smtickets.com/images/portrait_04072022130414.jpg";

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-landing', $data);
		$this->load->view('footer');
	}
	
	function bootlegbeatles() {
		$data['notice'] = '';
		$data['code'] = 'beatles';
		$data['events'] = $this->Events_model->getLandingEvents($data);
		
		$data['image1'] = "https://images1.smtickets.com/images/carousel_18072022123744.jpg"; //landscape
		$data['image2'] = "https://images1.smtickets.com/images/portrait_18072022123744.JPG";

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-landing', $data);
		$this->load->view('footer');
	}
	
	function planeshakers() {
		$data['notice'] = '';
		$data['code'] = 'planeshakers';
		$data['events'] = $this->Events_model->getLandingEvents($data);
		
		$data['image1'] = "https://images1.smtickets.com/images/carousel_26072022123402.jpg"; //landscape
		$data['image2'] = "https://images1.smtickets.com/images/portrait_26072022123402.jpg";

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-landing', $data);
		$this->load->view('footer');
	}
	
	function cinemalaya() {
		$data['notice'] = '';
		$data['code'] = 'cinemalaya';
		$data['events'] = $this->Events_model->getLandingEvents($data);
		
		$data['image1'] = "https://images1.smtickets.com/images/carousel_28072022171416.jpg"; //landscape
		$data['image2'] = "https://images1.smtickets.com/images/portrait_28072022171416.jpg";

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-landing', $data);
		$this->load->view('footer');
	}
	
	function landing($code = false) {
		$data['notice'] = '';
		$data['code'] = $code;
		$data['events'] = $events = $this->Events_model->getLandingEvents($data);
		
		// echo '<pre>';
		// print_r($data['events']);
		// die();
		$data['image1'] = $events[0]['image_landscape']; //landscape
		$data['image2'] =  $events[0]['image_portrait'];

		echo "<!DOCTYPE html>";
		$this->load->view('head');
		$this->load->view('header');
		$this->load->view('page-landing', $data);
		$this->load->view('footer');
	}
	 
	
}

