<?php
defined('BASEPATH') OR exit('No direct script access allowed');
	class Contact extends CI_Controller {
		
		public function __construct() {
		parent::__construct();

		$this->load->helper('url');
		$this->load->helper('form');
		$this->load->helper('captcha');
		$this->load->library('form_validation');
	}
	

		function index() {
			$this->home();
		}

		function home() {
			echo "<!DOCTYPE html>";
			// numeric random number for captcha
			  $random_number = substr(number_format(time() * rand(),0,'',''),0,6);
			  // setting up captcha config
			  $vals = array(
					 'word' => $random_number,
					 'img_path' => './captcha_images/',
					 'img_url' => base_url().'captcha_images/',
					 'img_width' => 140,
					 'img_height' => 32,
					 'expiration' => 7200
					);
			  $data['captcha'] = create_captcha($vals);
			  $this->session->set_userdata('captchaWord',$data['captcha']['word']);
			  
			$this->load->view('head');
			$this->load->view('header');
			$this->load->view('page-customer-care',$data);
			$this->load->view('footer');
		}

		function feedback() {
			$fullname = $this->input->post('fullname');
		    $email = $this->input->post('email');
		    $subject = $this->input->post('subject');
		    $message = $this->input->post('message');
 
		    $data = array(
				'name' => $fullname,
			   	'subject' => $subject,
			   	'message' => $message,
			   	'email' => $email
			);
			
			 
			if ($this->check_captcha($this->input->post('captcha'))){
				$result = $this->Parser_model->parse_post("api_feedback", $data); 
				echo 1;
 			    
			}else { 			  
				echo 0;
 			}
			
			
		   
		}
	 
		public function check_captcha($str){
			$word = $this->session->userdata('captchaWord');
			if(strcmp(strtoupper($str),strtoupper($word)) == 0){
			  return true;
			}
			else{
 			  return false;
			}
		
		}
		
	}
?>