<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Backend extends CI_Controller {
	
	public function __construct() {
		parent::__construct();
		
		$this->load->model('helper_model', 'helper');
  
	}
	
	function response_ipay($paycode = false) {
		
		$merchantcode = $this->input->post('MerchantCode');
		$payment_id = $this->input->post('PaymentId');
		$referenceNumber = $this->input->post('RefNo');
		$amount = $this->input->post('Amount');
		$currency = $this->input->post('Currency');
		$remark = $this->input->post('Remark');
		$transid = $this->input->post('TransId');
		$authcode = $this->input->post('AuthCode');
		$status = $this->input->post('Status');
		$errdesc = $this->input->post('ErrDesc');
		$signature = $this->input->post('Signature');
		$ThreeDFlag = $this->input->post('ThreeDFlag');
		 
		$params['amount'] = round($amount, 0); 
		$x = $this->helper->getMerchantDetails($params);  
		$merchant_key = $x['merchantKey']; 	 
			
		$total_amount = number_format($this->input->post('Amount'), 2, '', '');
		$sig = $this->prep_signature($merchant_key, $merchantcode, $payment_id, $referenceNumber, $total_amount, $currency, $status);
		
		//check signature
	  	if($sig != $signature){ 
			die();
 		}
 		else {
			if ($status == 1) {
				
				sleep(1);// add delay  
				
				//process payment
				if($payment_id == 1){$paycode = 'IPAY';}
				if($payment_id == 3){$paycode = 'GCSH';}
				if($payment_id == 38){$paycode = 'GRAB';}
				
				
				$data = array(
					'referencenumber' => $referenceNumber,
					'paycode' => $paycode,
					'amount' => $total_amount
				);

				$url = $this->config->item("api_paymentDone");

				$options = array(
					'http' => array(
						'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
						'method'  => 'POST',
						'content' => http_build_query($data)
					),
				);

				$context  = stream_context_create($options);
				$result = file_get_contents($url, false, $context);
				
				//logs 
				$data = array(
					'referencenumber' => $referenceNumber,
					'paycode' => $paycode,
					'amount' => $amount,
					'type' => 'back',
					'status' => $status
				);
				
				$this->Parser_model->response_logs("api_log_response", $data);
				
				 
				echo "RECEIVEOK";
			}
			else{
				die();
			}
		}
	}

	function prep_signature($merchant_key, $merchant_code, $payment_id, $ref_no, $total_amount, $currency, $status) {
 		return base64_encode(sha1($merchant_key . $merchant_code . $payment_id . $ref_no . $total_amount . $currency . $status, true));
	}


	function response_paypal()  {
		$entityBody = file_get_contents('php://input');
		$array_details = json_decode($entityBody, true);

		$referenceNumber = $array_details['resource']['invoice_number'];
		$totalAmount 	 = $array_details['resource']['amount']['total'];
		$totalAmount 	 = preg_replace("/\./","",$totalAmount);
		$status 		 = $array_details['status'];
		$transac_status  = $array_details['resource']['state'];

		if($transac_status === "completed") {
			$data = array(
				'referencenumber' => $referenceNumber,
				'paycode' => 'IPAY',
				'amount' => $totalAmount
			);

			$url = $this->config->item("api_paymentDone");
			
			$options = array(
				'http' => array(
					'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
					'method'  => 'POST',
					'content' => http_build_query($data)
				),
			);

			$context  = stream_context_create($options);
			$result = @file_get_contents($url, false, $context);
		}
	}
}