<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'events';
$route['404_override'] = 'Custom404';
$route['translate_uri_dashes'] = FALSE;
$route['events/view/8262'] = 'events/redirect_seagames';
//$route['events/view/7810'] = 'events/redirect_seagames';
//$route['events/view/7811'] = 'events/redirect_seagames';
$route['events/view/8489'] = 'events/redirect_disney';

$route['events/view/8885'] = 'events/view/8870'; //bottoms up 

$route['events/view/9029'] = 'events/redirect_cinema';
$route['sm-drive-in-cinema'] = 'events/drive_in_cinema'; //drive in cinema 

$route['events/view/8890'] = 'events/view/8883'; //clark 

$route['events/view/9062'] = 'events/redirect_skyranch'; //skyranh
$route['events/view/9229'] = 'events/redirect_lipa';
$route['events/view/9153'] = 'events/redirect_smcinema';
$route['events/view/9582'] = 'events/redirect_ccpxsmoa';


//$route['events/view/11095'] = '/';
$route['justinbieberworldtourph2022'] = 'events/view/11095';
// $route['events/view/8927'] = '/';
// $route['events/billieglobepromo'] = 'events/view/8927';


//$api_base = "https://aws-api.smtickets.com/prodAPI/";
$api_base = "http://localhost:8080/prodAPI/";
//$api_base = "http://localhost:8080/prodAPI/";
$routes = file_get_contents($api_base . "v1/data/routes");
 
$routes = json_decode($routes, false);
 
if(!empty($routes)){
	
	foreach($routes as $x){
		$url_explode = explode("/",$x->route_slug);
		if(isset($url_explode[0]) && isset($url_explode[1]) && isset($url_explode[2]) && $url_explode[0]=="events" && $url_explode[1]=="view"){
			//event/view/ID
			$route[$x->route_slug] = $x->route_url;
			//event/view/ID/(:any)
			$route[$x->route_slug.'/(:any)'] = $x->route_url;
			//event/view/ID(:any)
			$route[$x->route_slug.'(:any)'] = $x->route_url;
		}else{
			$route[$x->route_slug] = $x->route_url;
		}
	}
	
}