<?php 

  // $url = 'https://10.141.23.46:22633/'; 
 $url = BASE_URL();

// include pdf libraries
require(APPPATH.'/libraries/lib_pdf/fpdf/fpdf.php');

class PDF extends fpdf
{
	var $width_col_r = 220;
	//Page header
	

	//********************************* STYLES ******************************************
	
	function LINE_1($x1,$y1,$x2,$y2,$color=false,$width=false){	
		if($width){
			$this->SetLineWidth($width);
		}
		if($color){
			if(!isset($color['g'])){
				$color['g'] = 0;
			}
			if(!isset($color['b'])){
				$color['b'] = 0;
			}
			$this->SetDrawColor($color['r'], $color['g'], $color['b']);
		}
		$this->Line($x1,$y1,$x2,$y2);
	}
	
	function RECT_1($x1,$y1,$w,$h,$width=false){	
		if($width){
			$this->SetLineWidth($width);
		}
		$this->Rect($x1,$y1,$w,$h);
	}
	
	function Header_EventTitle($text,$x,$y,$align=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',28);
		$this->SetTextColor(0, 0, 0);
		$this->SetFillColor(255,255,255);
		// $this->SetTextColor(255, 255, 255);
		// $this->SetFillColor(95,95,95);
		if(!$align){
			$align = 'L';
		}
		$this->MultiCell(286,28,$text,'',$align,true);	
	}
	
	function Header_Section($text,$x,$y,$align=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',40);
		$this->SetTextColor(0, 0, 0);
		$this->SetFillColor(255,255,255);
		// $this->SetTextColor(255, 255, 255);
		// $this->SetFillColor(95,95,95);
		if(!$align){
			$align = 'L';
		}
		$this->MultiCell(286,40,$text,'',$align,true);	
	}
	
	function Header_QueueNumber($text,$x,$y,$align=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',120);
		$this->SetTextColor(0, 0, 0);
		$this->SetFillColor(255,255,255);
		// $this->SetTextColor(255, 255, 255);
		// $this->SetFillColor(95,95,95);
		if(!$align){
			$align = 'C';
		}
		$this->MultiCell(286,120,$text,'',$align,true);	
	}
	
	function Text_EventDate($text,$x,$y,$align=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','',20);
		$this->SetTextColor(0, 0, 0);
		$this->SetFillColor(255,255,255);
		// $this->SetTextColor(255, 255, 255);
		// $this->SetFillColor(95,95,95);
		if(!$align){
			$align = 'L';
		}
		$this->MultiCell(286,20,$text,'',$align,true);	
	}
	
	function Text_TransDetails($text,$x,$y,$align=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',20);
		$this->SetTextColor(0, 0, 0);
		$this->SetFillColor(255,255,255);
		// $this->SetTextColor(255, 255, 255);
		// $this->SetFillColor(95,95,95);
		if(!$align){
			$align = 'L';
		}
		$this->MultiCell(286,20,$text,'',$align,true);	
	}
	
	function Text_Disclaimer($text,$x,$y,$align=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','',9);
		$this->SetTextColor(0, 0, 0);
		$this->SetFillColor(255,255,255);
		// $this->SetTextColor(255, 255, 255);
		// $this->SetFillColor(95,95,95);
		if(!$align){
			$align = 'J';
		}
		// $this->MultiCell(552,9,$text,'',$align,true);	
		$this->MultiCell(276,9,$text,'',$align,true);	
	}
	
	//*************************************************************************************

	function Header()
	{

	// voucher
	// $this->SetTextColor(95, 95, 95);
	// $this->SetXY(165,37);
	// $this->SetFont('Arial','B',25);
	// $this->Cell(100,20,'CLAIM TICKET VOUCHER',0,0,'C');
	
	//Logo

	// $this->Image('resources/images/logo.jpg',480,10,100);
	
	
	
	}
	
	//Page footer
	function Footer()
	{
		$this->SetTextColor(0, 0, 0);
		//Position at 1.5 cm from bottom
		$this->SetY(-15);
		//Arial italic 8
		$this->SetFont('Arial','I',8);
		//Page number
		// $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
		
	}


}

//Instantiation of inherited class
$pdf=new PDF('P', 'pt', 'Letter');
$pdf->AliasNbPages();
$pdf->SetAutoPageBreak(true,0);	

$pdf->AddPage('P','Letter');
		
	
	
	
	$y = 20;
	//Event Title
	$event_title = "SAMPLE EVENT TITLE MANILA AND MANILA";
	$pdf->Header_EventTitle($event_title,20,$y);
	$y += (ceil(($pdf->GetStringWidth($event_title) / 286)) * 28);
		
	//Event Date
	$pdf->Text_EventDate("SEPTEMBER 30, 2017",20,$y);
		
	//Transaction Details
	$y = 130;
	$pdf->Text_TransDetails("Transaction ID",20,$y);
	$y += 20;
	$pdf->Text_TransDetails("Ticket ID",20,$y);
	$y += 30;
	$pdf->Header_Section("10K SUPERSTAR",20,$y,'L');
	
	$y = 110;
	$number = sprintf("%04d", 9999);
	$pdf->Header_QueueNumber($number,306,$y);	
	$pdf->RECT_1(306,75,286,181,1);
	
	$text = "-	This queueing number should be presented together with the event ticket to be validated upon entry to the venue.";
	$pdf->Text_Disclaimer($text,25,266);
	
	$text = "-	VIP Hi-Touch ticket holders must check-in at the Help Desk near Coral Way entrance from 2:00 pm onwards to claim their wrist tag prior to queuing.";
	$pdf->Text_Disclaimer($text,25,284);
	
	$text = "-	VIP Standing sections are only open to adults and minors 13 to 17 years old. Minors must be accompanied by a ticket bearing parent / guardian in the same section (1:1 ratio). Parents / guardians will be responsible for their kids' safety at all times.";
	$pdf->Text_Disclaimer($text,25,311);
	
	$text = "-	Minors without parents/guardians must check-in at the Help Desk with their parent / legal guardian and accomplish a waiver of release for minors prior to queuing. Waivers will be available at the Help Desk.";
	$pdf->Text_Disclaimer($text,25,347);
	
	$text = "-	Pregnant women and patrons with medical condition/s are not allowed in the VIP Standing Section.";
	$pdf->Text_Disclaimer($text,311,266);
	
	$text = "-	Valid School ID/Govt. IDs are required to be presented upon entry.";
	$pdf->Text_Disclaimer($text,311,284);
	
	$text = "-	If you have accessibility needs, please approach any venue representative prior to queuing and you will be assisted as necessary.";
	$pdf->Text_Disclaimer($text,311,302);
	
	$text = "-	The artist, promoter, ticketing company, venue or any other affiliated parties are not responsible for outdated or inaccurate information provided by the consumer at the time of purchase which may result in undelivered product or information.";
	$pdf->Text_Disclaimer($text,311,329);
	
	$text = "-	Priority queuing vouchers are not for sale and non-transferable.";
	$pdf->Text_Disclaimer($text,311,365);
	
	$text = "-	All times are subject to change without prior notice.";
	$pdf->Text_Disclaimer($text,311,374);
	
	$pdf->RECT_1(20,261,572,125,1);
	
	// Line in the middle of the document
	$pdf->LINE_1(0,396,612,396,array("r"=>0),1);
	
	$pdf->Image(FCPATH.'resources/images/sm-tickets-footer_1.png',442,10,150,0,"PNG");
$pdf->Output();
$pdf->Close();










